/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.subtab;

import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;

public class ImportedClassDeclarationsPanel
extends JPanel {
    private SWRLRuleEngine ruleEngine;
    private ImportedClasseDeclarationsModel importedClassesModel;
    private JTable table;

    public ImportedClassDeclarationsPanel(SWRLRuleEngine sWRLRuleEngine) {
        this.ruleEngine = sWRLRuleEngine;
        this.importedClassesModel = new ImportedClasseDeclarationsModel();
        this.table = new JTable(this.importedClassesModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.add("Center", jScrollPane);
    }

    public void validate() {
        this.importedClassesModel.fireTableDataChanged();
        super.validate();
    }

    private class ImportedClasseDeclarationsModel
    extends AbstractTableModel {
        private ImportedClasseDeclarationsModel() {
        }

        public int getRowCount() {
            return ImportedClassDeclarationsPanel.this.ruleEngine.getNumberOfImportedOWLClasses();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "Imported OWL Classes";
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n < 0 || n >= this.getRowCount()) {
                string = new String("OUT OF BOUNDS");
            } else {
                String string2 = ImportedClassDeclarationsPanel.this.ruleEngine.getImportedOWLClasses().toArray(new OWLClassReference[0])[n].getURI();
                string = ImportedClassDeclarationsPanel.this.ruleEngine.uri2PrefixedName(string2);
            }
            return string;
        }
    }
}

