/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.subtab;

import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ControlPanel
extends JPanel {
    private String ruleEngineName;

    public ControlPanel(SWRLRuleEngine sWRLRuleEngine, String string, String string2) {
        this.ruleEngineName = string2;
        this.setLayout(new BorderLayout());
        JTextArea jTextArea = this.createTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(900, 300));
        this.add("Center", jScrollPane);
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = this.createButton("OWL+SWRL->" + string2, "Translate SWRL rules and relevant OWL knowledge to rule engine", new ImportActionListener(sWRLRuleEngine, jTextArea, this));
        jPanel.add(jButton);
        jButton = this.createButton("Run " + string2, "Run the rule engine", new RunActionListener(sWRLRuleEngine, jTextArea, this));
        jPanel.add(jButton);
        jButton = this.createButton(string2 + "->OWL", "Translate asserted rule engine knowledge to OWL knowledge", new ExportActionListener(sWRLRuleEngine, jTextArea, this));
        jPanel.add(jButton);
        this.add("South", jPanel);
        jTextArea.append("Using the " + string2 + " rule engine, version " + sWRLRuleEngine.getTargetRuleEngineVersion() + ".\n");
        jTextArea.append("Press the \"OWL+SWRL->" + string2 + "\" button to transfer SWRL rules and relevant OWL knowledge to the rule engine.\n");
        jTextArea.append("Press the \"Run " + string2 + "\" button to run the rule engine.\n");
        jTextArea.append("Press the \"" + string2 + "->OWL\" button to transfer the inferred rule engine knowledge to OWL knowledge.\n\n");
        jTextArea.append("IMPORTANT: A significant limitation of the current implementation is that it does not represent all OWL\n");
        jTextArea.append("axioms when transferring knowledge from an OWL ontology to a rule engine. The exceptions are\n");
        jTextArea.append("declaration axioms, class and property assertion axioms, and owl:subClassOf, owl:subPropertyOf, \n");
        jTextArea.append("owl:equivalentClass, owl:equivalentProperty, owl:sameAs, owl:differentFrom, and owl:allDifferent axioms.\n");
        jTextArea.append("As a result, the rule engine inferencing mechanisms do not know about the remaining OWL axioms.\n");
        jTextArea.append("To ensure consistency, a reasoner should be run on an OWL knowledge base before SWRL rules and OWL\n");
        jTextArea.append("knowledge are transferred to a rule engine. Also, if inferred knowledge from rule engine is inserted back into an OWL\n");
        jTextArea.append("ontology, a reasoner should again be executed to ensure that the new knowledge does not\n");
        jTextArea.append("conflict with OWL axioms in that knowledge base.\n\n");
        jTextArea.append("cf. http://protege.cim3.net/cgi-bin/wiki.pl?SWRLRuleEngineBridgeFAQ#nid6QL for more details.\n");
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(160, 30));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea(10, 80);
        jTextArea.setLineWrap(true);
        jTextArea.setBackground(Color.WHITE);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    private class ExportActionListener
    extends ListenerBase
    implements ActionListener {
        public ExportActionListener(SWRLRuleEngine sWRLRuleEngine, JTextArea jTextArea, ControlPanel controlPanel2) {
            super(sWRLRuleEngine, jTextArea, controlPanel2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                long l = System.currentTimeMillis();
                this.ruleEngine.writeInferredKnowledge2OWL();
                this.textArea.setText("");
                this.textArea.append("Successfully transferred inferred facts to OWL model.\n");
                if (this.ruleEngine.getNumberOfInjectedOWLIndividuals() != 0) {
                    this.textArea.append("Number of individual declarations injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLIndividuals() + "\n");
                }
                if (this.ruleEngine.getNumberOfInjectedOWLClasses() != 0) {
                    this.textArea.append("Number of classe declarations injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLClasses() + "\n");
                }
                if (this.ruleEngine.getNumberOfInjectedOWLAxioms() != 0) {
                    this.textArea.append("Number of axioms injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLAxioms() + "\n");
                }
                this.textArea.append("Number of axioms inferred: " + this.ruleEngine.getNumberOfInferredOWLAxioms() + "\n");
                this.textArea.append("The process took " + (System.currentTimeMillis() - l) + " millisecond(s).\n");
            }
            catch (SWRLRuleEngineException sWRLRuleEngineException) {
                this.textArea.append("Exception exporting knowledge to OWL: " + sWRLRuleEngineException.toString() + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class RunActionListener
    extends ListenerBase
    implements ActionListener {
        public RunActionListener(SWRLRuleEngine sWRLRuleEngine, JTextArea jTextArea, ControlPanel controlPanel2) {
            super(sWRLRuleEngine, jTextArea, controlPanel2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                long l = System.currentTimeMillis();
                this.ruleEngine.run();
                this.textArea.setText("");
                this.textArea.append("Successful execution of rule engine.\n");
                this.textArea.append("Number of inferred axioms: " + this.ruleEngine.getNumberOfInferredOWLAxioms() + "\n");
                if (this.ruleEngine.getNumberOfInjectedOWLIndividuals() != 0) {
                    this.textArea.append("Number of individual declarations injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLIndividuals() + "\n");
                }
                if (this.ruleEngine.getNumberOfInjectedOWLClasses() != 0) {
                    this.textArea.append("Number of classes declarations injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLClasses() + "\n");
                }
                if (this.ruleEngine.getNumberOfInjectedOWLAxioms() != 0) {
                    this.textArea.append("Number of axioms injected by built-ins: " + this.ruleEngine.getNumberOfInjectedOWLAxioms() + "\n");
                }
                this.textArea.append("The process took " + (System.currentTimeMillis() - l) + " millisecond(s).\n");
                this.textArea.append("Look at the \"Inferred Axioms\" tab to see the inferred axioms.\n");
                this.textArea.append("Press the \"Jess->OWL\" button to translate the asserted facts to OWL knowledge.\n");
            }
            catch (SWRLRuleEngineException sWRLRuleEngineException) {
                this.textArea.append("Exception running rule engine: " + sWRLRuleEngineException.getMessage() + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class ImportActionListener
    extends ListenerBase
    implements ActionListener {
        public ImportActionListener(SWRLRuleEngine sWRLRuleEngine, JTextArea jTextArea, ControlPanel controlPanel2) {
            super(sWRLRuleEngine, jTextArea, controlPanel2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                long l = System.currentTimeMillis();
                this.ruleEngine.reset();
                this.ruleEngine.importSWRLRulesAndOWLKnowledge();
                this.textArea.setText("");
                this.textArea.append("SWRL rule and relevant OWL knowledge successfully converted to rule engine knowledge.\n");
                this.textArea.append("Number of SWRL rules exported to rule engine: " + this.ruleEngine.getNumberOfImportedSWRLRules() + "\n");
                this.textArea.append("Number of OWL class declarations exported to rule engine: " + this.ruleEngine.getNumberOfImportedOWLClasses() + "\n");
                this.textArea.append("Number of OWL individual declarations exported to rule engine: " + this.ruleEngine.getNumberOfImportedOWLIndividuals() + "\n");
                this.textArea.append("Number of other OWL axioms exported to rule engine: " + this.ruleEngine.getNumberOfImportedOWLAxioms() + "\n");
                this.textArea.append("The transfer took " + (System.currentTimeMillis() - l) + " millisecond(s).\n");
                this.textArea.append("Press the \"Run " + ControlPanel.this.ruleEngineName + "\" button to run the rule engine.\n");
            }
            catch (SWRLRuleEngineException sWRLRuleEngineException) {
                this.textArea.append("Exception importing SWRL rules and OWL knowledge: " + sWRLRuleEngineException.toString() + "\n");
            }
            this.controlPanel.getParent().validate();
        }
    }

    private class ListenerBase {
        protected SWRLRuleEngine ruleEngine;
        protected JTextArea textArea;
        protected ControlPanel controlPanel;

        public ListenerBase(SWRLRuleEngine sWRLRuleEngine, JTextArea jTextArea, ControlPanel controlPanel2) {
            this.ruleEngine = sWRLRuleEngine;
            this.textArea = jTextArea;
            this.controlPanel = controlPanel2;
        }
    }
}

