/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SWRLTextField
extends SymbolTextField {
    private static final char[][] charMap = new char[][]{{'^', '\u2227'}, {'.', '\u02da'}};

    public SWRLTextField(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        super(oWLModel, symbolErrorDisplay, new SWRLResourceNameMatcher(), new SWRLSyntaxConverter(oWLModel));
        SWRLTextField.initKeymap(this);
    }

    protected void checkUniCodeExpression(String string) throws Throwable {
        SWRLParser sWRLParser = new SWRLParser(this.getOWLModel());
        if (this.isInSaveTestMode()) {
            sWRLParser.parse(string);
        } else {
            try {
                sWRLParser.parse(string);
            }
            catch (SWRLIncompleteRuleException sWRLIncompleteRuleException) {
                // empty catch block
            }
        }
    }

    public static void initKeymap(JTextComponent jTextComponent) {
        jTextComponent.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                for (int i = 0; i < charMap.length; ++i) {
                    char[] cArray = charMap[i];
                    if (cArray[0] != c) continue;
                    JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                    try {
                        String string = jTextComponent.getDocument().getText(0, jTextComponent.getCaretPosition()).trim();
                        if (string.length() == 0 || string.endsWith(")")) {
                            jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), "" + cArray[1], null);
                        } else {
                            jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), "" + c, null);
                        }
                        keyEvent.consume();
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

