/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSyntaxConverter;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextArea;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import javax.swing.UIManager;

public class SWRLTextArea
extends SymbolTextArea {
    private SWRLParser parser;
    private SWRLSymbolPanel symbolPanel;

    public SWRLTextArea(OWLModel oWLModel, SWRLSymbolPanel sWRLSymbolPanel) {
        super(oWLModel, sWRLSymbolPanel, new SWRLResourceNameMatcher(), new SWRLSyntaxConverter(oWLModel));
        this.symbolPanel = sWRLSymbolPanel;
        this.parser = new SWRLParser(oWLModel);
        this.setFont(UIManager.getFont("TextArea.font"));
        SWRLTextField.initKeymap(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.symbolPanel.setEnabled(bl);
    }

    protected void checkUniCodeExpression(String string) throws Throwable {
        try {
            this.parser.parse(string);
        }
        catch (SWRLIncompleteRuleException sWRLIncompleteRuleException) {
            // empty catch block
        }
    }

    public void reformatText() {
        String string = this.getText();
        string = SWRLTextArea.reformatText(string);
        this.setText(string);
    }

    public static String reformatText(String string) {
        return string;
    }

    protected void acceptSelectedFrame() {
        int n;
        String string = this.getText();
        int n2 = this.getCaretPosition();
        for (n = n2 - 1; n >= 0 && (SymbolTextField.isIdChar(string.charAt(n)) || string.charAt(n) == '?'); --n) {
        }
        String string2 = string.substring(n + 1, n2);
        this.extendPartialName(string2, ((Frame)this.getComboBox().getSelectedItem()).getBrowserText());
        this.updateErrorDisplay();
        this.closeComboBox();
    }
}

