/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLSymbolPanel
extends SymbolPanel {
    private Action andAction;
    private ResourceSelectionAction builtinAction;
    private Action createVariableAction;
    private Action datatypeAction;
    private Action differentFromAction;
    private Action impAction;
    private Action insertVariableAction;
    private JButton insertVariableButton;
    private JButton createVariableButton;
    private JButton insertXMLSchemaButton;
    private JButton insertAndButton;
    private JButton insertImpButton;
    private JButton insertOpenParenthesisButton;
    private JButton insertCloseParenthesisButton;
    private JButton insertOpenBracketsButton;
    private JButton insertCloseBracketsButton;
    private JButton insertSameAsButton;
    private JButton insertDifferentFromButton;
    private JButton insertBuiltInButton;
    private Action openBracketsAction;
    private Action closeBracketsAction;
    private Action openParenthesisAction;
    private Action closeParenthesisAction;
    private Action sameAsAction;

    public SWRLSymbolPanel(OWLModel oWLModel, boolean bl, boolean bl2) {
        super(oWLModel, bl, bl2, true);
    }

    @Override
    protected String getDisplayErrorMessage(Throwable throwable) {
        if (throwable instanceof SWRLParseException) {
            return ((SWRLParseException)throwable).getMessage();
        }
        return "" + throwable;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(500, dimension.height);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.insertVariableButton.setEnabled(bl);
        this.createVariableButton.setEnabled(bl);
        this.insertXMLSchemaButton.setEnabled(bl);
        this.insertAndButton.setEnabled(bl);
        this.insertImpButton.setEnabled(bl);
        this.insertOpenParenthesisButton.setEnabled(bl);
        this.insertCloseParenthesisButton.setEnabled(bl);
        this.insertOpenBracketsButton.setEnabled(bl);
        this.insertCloseBracketsButton.setEnabled(bl);
        this.insertSameAsButton.setEnabled(bl);
        this.insertDifferentFromButton.setEnabled(bl);
        this.insertBuiltInButton.setEnabled(bl);
    }

    private Collection<String> getUsedVariableNames() {
        String string = this.getSymbolEditor().getText();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            if (string.charAt(i) != '?' || (string2 = this.getVariableName(string, i)).length() <= 0) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    private String getVariableName(String string, int n) {
        int n2;
        for (n2 = n + 1; n2 < string.length() && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
        }
        return string.substring(n + 1, n2);
    }

    @Override
    protected void initMiddleBar(JToolBar jToolBar) {
        this.datatypeAction = new InsertXMLSchemaDatatypeAction();
        this.insertXMLSchemaButton = this.addButton(jToolBar, this.datatypeAction);
        this.andAction = new AbstractAction("Insert conjunction (\u2227)", SWRLIcons.getInsertAndIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("  \u2227  ");
            }
        };
        this.insertAndButton = this.addButton(jToolBar, this.andAction);
        this.impAction = new AbstractAction("Insert implication (\u2192)", SWRLIcons.getInsertImpIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("  \u2192  ");
            }
        };
        this.insertImpButton = this.addButton(jToolBar, this.impAction);
        jToolBar.addSeparator();
        this.openParenthesisAction = new AbstractAction("Insert open parenthesis: (", SWRLIcons.getOpenParenthesis()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("(", 1);
            }
        };
        this.insertOpenParenthesisButton = this.addButton(jToolBar, this.openParenthesisAction);
        this.closeParenthesisAction = new AbstractAction("Insert close parenthesis: )", SWRLIcons.getCloseParenthesis()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText(")", 1);
            }
        };
        this.insertCloseParenthesisButton = this.addButton(jToolBar, this.closeParenthesisAction);
        jToolBar.addSeparator();
        this.openBracketsAction = new AbstractAction("Insert open brackets: [", SWRLIcons.getOpenBrackets()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("[", 1);
            }
        };
        this.insertOpenBracketsButton = this.addButton(jToolBar, this.openBracketsAction);
        this.closeBracketsAction = new AbstractAction("Insert close brackets: ]", SWRLIcons.getCloseBrackets()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("]", 1);
            }
        };
        this.insertCloseBracketsButton = this.addButton(jToolBar, this.closeBracketsAction);
    }

    @Override
    protected void initTopBar(JToolBar jToolBar) {
        this.classAction.activateComboBox(this.addButton(jToolBar, this.classAction));
        this.propertyAction.activateComboBox(this.addButton(jToolBar, this.propertyAction));
        this.individiualAction.activateComboBox(this.addButton(jToolBar, this.individiualAction));
        jToolBar.addSeparator();
        this.createVariableAction = new CreateVariableAction();
        this.createVariableButton = this.addButton(jToolBar, this.createVariableAction);
        this.insertVariableAction = new InsertVariableAction();
        this.insertVariableButton = this.addButton(jToolBar, this.insertVariableAction);
        jToolBar.addSeparator();
        this.builtinAction = new InsertBuiltinAction();
        this.insertBuiltInButton = this.addButton(jToolBar, this.builtinAction);
        this.builtinAction.activateComboBox(this.insertBuiltInButton);
        this.differentFromAction = new AbstractAction("Insert differentFrom", SWRLIcons.getDifferentFromIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("differentFrom(", 14);
            }
        };
        this.insertDifferentFromButton = this.addButton(jToolBar, this.differentFromAction);
        this.sameAsAction = new AbstractAction("Insert sameAs", SWRLIcons.getSameAsIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("sameAs(", 7);
            }
        };
        this.insertSameAsButton = this.addButton(jToolBar, this.sameAsAction);
        jToolBar.addSeparator();
    }

    private void insertVariable(ActionEvent actionEvent) {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>(this.getUsedVariableNames());
        Collection collection = this.getOWLModel().getRDFSNamedClass(SWRLNames.Cls.VARIABLE).getInstances(true);
        for (Object object2 : collection) {
            hashSet.add(object2.getName());
        }
        Object[] objectArray = hashSet.toArray(new String[0]);
        Arrays.sort(objectArray);
        object2 = new JPopupMenu();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object3 = objectArray[i];
            final JMenuItem jMenuItem = new JMenuItem((String)object3, SWRLIcons.getVariableIcon());
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jMenuItem.getText();
                    SWRLSymbolPanel.this.getSymbolEditor().insertText("?" + string);
                }
            });
            ((JPopupMenu)object2).add(jMenuItem);
        }
        if (((Container)object2).getComponentCount() > 0) {
            ((JPopupMenu)object2).show(this.insertVariableButton, 0, this.insertVariableButton.getHeight());
        }
    }

    private class InsertXMLSchemaDatatypeAction
    extends AbstractAction {
        InsertXMLSchemaDatatypeAction() {
            super("Insert XML Schema datatype", OWLIcons.getImageIcon("XSDDatatype"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OWLModel oWLModel = SWRLSymbolPanel.this.getOWLModel();
            Collection<RDFSDatatype> collection = oWLModel.getRDFSDatatypes();
            RDFResource rDFResource = ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SWRLSymbolPanel.this, oWLModel, collection, "Select the XML Schema datatype to insert");
            if (rDFResource != null) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText(rDFResource.getLocalName());
            }
        }
    }

    private class InsertVariableAction
    extends AbstractAction {
        InsertVariableAction() {
            super("Insert existing variable...", OWLIcons.getAddIcon("SWRLVariable", SWRLIcons.class));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWRLSymbolPanel.this.insertVariable(actionEvent);
        }
    }

    private class CreateVariableAction
    extends AbstractAction {
        CreateVariableAction() {
            super("Insert new variable", OWLIcons.getCreateIcon("SWRLVariable", SWRLIcons.class));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getNextVariableName();
            if (string != null) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("?" + string);
            }
        }

        private String getNextVariableName() {
            Collection collection = SWRLSymbolPanel.this.getUsedVariableNames();
            ArrayList<String> arrayList = new ArrayList<String>();
            OWLModel oWLModel = SWRLSymbolPanel.this.getOWLModel();
            SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
            Collection<SWRLVariable> collection2 = sWRLFactory.getVariables();
            for (SWRLVariable sWRLVariable : collection2) {
                arrayList.add(sWRLVariable.getName());
            }
            String string = "xyzabcdefghijklmnopqrstuvwXYZABCDEFGHIJKLMNOPQRSTUVW";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                String string2 = "" + c;
                if (collection.contains(string2) || oWLModel.getRDFResource(string2) != null && !(oWLModel.getRDFResource(string2) instanceof SWRLVariable)) continue;
                return string2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InsertBuiltinAction
    extends ResourceSelectionAction {
        InsertBuiltinAction() {
            super("Insert builtin...", SWRLIcons.getBuiltinIcon());
        }

        @Override
        public void resourceSelected(RDFResource rDFResource) {
            String string = rDFResource.getBrowserText() + "(";
            SWRLSymbolPanel.this.getSymbolEditor().insertText(string);
        }

        @Override
        public Collection<?> getSelectableResources() {
            ArrayList<SWRLBuiltin> arrayList = new ArrayList<SWRLBuiltin>(new SWRLFactory(SWRLSymbolPanel.this.getOWLModel()).getBuiltins());
            Collections.sort(arrayList, new FrameComparator());
            return arrayList;
        }

        @Override
        public RDFResource pickResource() {
            Collection<?> collection = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SWRLSymbolPanel.this, SWRLSymbolPanel.this.getOWLModel(), collection, "Select the builtin to insert");
        }
    }
}

