/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.ui.code.OWLResourceNameMatcher;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLResourceNameMatcher
extends OWLResourceNameMatcher {
    @Override
    public String getInsertString(RDFResource rDFResource) {
        if (rDFResource instanceof SWRLVariable) {
            return "?" + rDFResource.getPrefixedName();
        }
        return super.getInsertString(rDFResource);
    }

    @Override
    public Set<RDFResource> getMatchingResources(String string, String string2, OWLModel oWLModel) {
        if (string2.endsWith("?")) {
            HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
            for (SWRLVariable sWRLVariable : oWLModel.getOWLNamedClass(SWRLNames.Cls.VARIABLE).getInstances(true)) {
                if (!sWRLVariable.getName().startsWith(string)) continue;
                hashSet.add(sWRLVariable);
            }
            return hashSet;
        }
        return super.getMatchingResources(string, string2, oWLModel);
    }

    @Override
    protected boolean couldBeClass(OWLModel oWLModel, String string) {
        return true;
    }

    @Override
    protected boolean couldBeProperty(OWLModel oWLModel, String string) {
        return true;
    }

    @Override
    protected boolean couldBeIndividual(OWLModel oWLModel, String string) {
        return true;
    }

    @Override
    protected boolean couldBeDatatype(OWLModel oWLModel, String string) {
        return true;
    }
}

