/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.ui;

import edu.stanford.smi.protegex.owl.swrl.sqwrl.ClassValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.IndividualValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.PropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLQueryEngine;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ui.SQWRLQueryControlPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;

public class SQWRLQueryResultPanel
extends JPanel {
    private String queryName;
    private JTable table;
    private SQWRLQueryEngine queryEngine;
    private SQWRLResult result = null;
    private SQWRLQueryControlPanel controlPanel;
    private SQWRLQueryResultModel swrlQueryResultModel;
    private static File currentDirectory = null;

    public SQWRLQueryResultPanel(SQWRLQueryEngine sQWRLQueryEngine, String string, SQWRLResult sQWRLResult, SQWRLQueryControlPanel sQWRLQueryControlPanel) {
        this.queryEngine = sQWRLQueryEngine;
        this.queryName = string;
        this.result = sQWRLResult;
        this.controlPanel = sQWRLQueryControlPanel;
        this.swrlQueryResultModel = new SQWRLQueryResultModel();
        this.table = new JTable(this.swrlQueryResultModel);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = this.createButton("Save as CSV...", "Save the result as a CSV file...", new SaveResultActionListener());
        jPanel.add(jButton);
        JButton jButton2 = this.createButton("Rerun", "Rerun this SQWRL query", new RunQueriesActionListener());
        jPanel.add(jButton2);
        JButton jButton3 = this.createButton("Close", "Close the tab for this query", new CloseTabActionListener());
        jPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.add("Center", jScrollPane);
        this.add("South", jPanel);
    }

    public void validate() {
        this.swrlQueryResultModel.fireTableStructureChanged();
        super.validate();
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(160, 30));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private class SQWRLQueryResultModel
    extends AbstractTableModel {
        private SQWRLQueryResultModel() {
        }

        public int getRowCount() {
            int n = 0;
            try {
                n = SQWRLQueryResultPanel.this.result == null ? 0 : SQWRLQueryResultPanel.this.result.getNumberOfRows();
            }
            catch (SQWRLException sQWRLException) {
                // empty catch block
            }
            return n;
        }

        public int getColumnCount() {
            int n = 0;
            try {
                n = SQWRLQueryResultPanel.this.result == null ? 0 : SQWRLQueryResultPanel.this.result.getNumberOfColumns();
            }
            catch (SQWRLException sQWRLException) {
                // empty catch block
            }
            return n;
        }

        public String getColumnName(int n) {
            String string = "";
            try {
                string = SQWRLQueryResultPanel.this.result == null ? "" : SQWRLQueryResultPanel.this.result.getColumnName(n);
            }
            catch (SQWRLException sQWRLException) {
                // empty catch block
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            try {
                SQWRLResultValue sQWRLResultValue;
                SQWRLResultValue sQWRLResultValue2 = sQWRLResultValue = SQWRLQueryResultPanel.this.result == null ? null : SQWRLQueryResultPanel.this.result.getValue(n2, n);
                if (sQWRLResultValue instanceof IndividualValue) {
                    IndividualValue individualValue = (IndividualValue)sQWRLResultValue;
                    string = string + SQWRLQueryResultPanel.this.queryEngine.uri2PrefixedName(individualValue.getURI());
                } else if (sQWRLResultValue instanceof DataValue) {
                    DataValue dataValue = (DataValue)sQWRLResultValue;
                    string = string + ((Object)dataValue).toString();
                } else if (sQWRLResultValue instanceof ClassValue) {
                    ClassValue classValue = (ClassValue)sQWRLResultValue;
                    string = string + SQWRLQueryResultPanel.this.queryEngine.uri2PrefixedName(classValue.getURI());
                } else if (sQWRLResultValue instanceof PropertyValue) {
                    PropertyValue propertyValue = (PropertyValue)sQWRLResultValue;
                    string = string + SQWRLQueryResultPanel.this.queryEngine.uri2PrefixedName(propertyValue.getURI());
                }
            }
            catch (SQWRLException sQWRLException) {
                // empty catch block
            }
            return string;
        }
    }

    private class SaveResultActionListener
    implements ActionListener {
        private JFileChooser chooser = new JFileChooser();

        public SaveResultActionListener() {
            this.chooser.setCurrentDirectory(currentDirectory);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.saveResults();
        }

        private void saveResults() {
            int n = this.chooser.showOpenDialog(SQWRLQueryResultPanel.this.controlPanel);
            File file = null;
            FileWriter fileWriter = null;
            try {
                if (n == 0) {
                    file = this.chooser.getSelectedFile();
                    currentDirectory = this.chooser.getCurrentDirectory();
                    fileWriter = new FileWriter(file);
                    SQWRLQueryResultPanel.this.result = SQWRLQueryResultPanel.this.queryEngine.getSQWRLResult(SQWRLQueryResultPanel.this.queryName);
                    if (SQWRLQueryResultPanel.this.result != null) {
                        int n2;
                        int n3 = SQWRLQueryResultPanel.this.result.getNumberOfColumns();
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (n2 != 0) {
                                fileWriter.write(", ");
                            }
                            fileWriter.write(SQWRLQueryResultPanel.this.result.getColumnName(n2));
                        }
                        fileWriter.write("\n");
                        while (SQWRLQueryResultPanel.this.result.hasNext()) {
                            for (n2 = 0; n2 < n3; ++n2) {
                                SQWRLResultValue sQWRLResultValue = SQWRLQueryResultPanel.this.result.getValue(n2);
                                if (n2 != 0) {
                                    fileWriter.write(", ");
                                }
                                if (sQWRLResultValue instanceof DataValue && ((DataValue)sQWRLResultValue).isString()) {
                                    fileWriter.write("\"" + sQWRLResultValue + "\"");
                                    continue;
                                }
                                fileWriter.write("" + sQWRLResultValue);
                            }
                            fileWriter.write("\n");
                            SQWRLQueryResultPanel.this.result.next();
                        }
                        SQWRLQueryResultPanel.this.result.reset();
                        fileWriter.close();
                        SQWRLQueryResultPanel.this.controlPanel.appendText("Sucessfully saved results of query " + SQWRLQueryResultPanel.this.queryName + " to CSV file " + file.getPath() + ".\n");
                    }
                }
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(null, "Error saving file " + file.getPath() + ": " + throwable.getMessage(), "Error saving file", 0);
            }
        }
    }

    private class CloseTabActionListener
    implements ActionListener {
        private CloseTabActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SQWRLQueryResultPanel.this.controlPanel.removeResultPanel(SQWRLQueryResultPanel.this.queryName);
            SQWRLQueryResultPanel.this.controlPanel.appendText("'" + SQWRLQueryResultPanel.this.queryName + "' tab closed.\n");
        }
    }

    private class RunQueriesActionListener
    implements ActionListener {
        private RunQueriesActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SQWRLQueryResultPanel.this.result = null;
            try {
                SQWRLQueryResultPanel.this.result = SQWRLQueryResultPanel.this.queryEngine.runSQWRLQuery(SQWRLQueryResultPanel.this.queryName);
                if (SQWRLQueryResultPanel.this.result == null || SQWRLQueryResultPanel.this.result.getNumberOfRows() == 0) {
                    SQWRLQueryResultPanel.this.controlPanel.appendText("No result returned for SQWRL query '" + SQWRLQueryResultPanel.this.queryName + "' - closing tab.\n");
                    SQWRLQueryResultPanel.this.controlPanel.removeResultPanel(SQWRLQueryResultPanel.this.queryName);
                } else {
                    SQWRLQueryResultPanel.this.validate();
                }
            }
            catch (InvalidQueryNameException invalidQueryNameException) {
                SQWRLQueryResultPanel.this.controlPanel.appendText("Invalid query name '" + SQWRLQueryResultPanel.this.queryName + "'.\n");
            }
            catch (SQWRLException sQWRLException) {
                SQWRLQueryResultPanel.this.controlPanel.appendText("Exception running SQWRL query '" + SQWRLQueryResultPanel.this.queryName + "': " + sQWRLException.getMessage() + "\n");
            }
        }
    }
}

