/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.impl;

import edu.stanford.smi.protegex.owl.swrl.sqwrl.ClassValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.IndividualValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.PropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultGenerator;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidAggregateFunctionNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnIndexException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnTypeException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidRowIndexException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.ResultStateException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.DataValueImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQWRLResultImpl
implements SQWRLResult,
SQWRLResultGenerator,
Serializable {
    private List<String> allColumnNames;
    private List<String> columnDisplayNames;
    private List<Integer> selectedColumnIndexes;
    private List<Integer> orderByColumnIndexes;
    private Map<Integer, String> aggregateColumnIndexes;
    private List<List<SQWRLResultValue>> rows;
    private List<SQWRLResultValue> rowData;
    private Map<String, List<SQWRLResultValue>> columnVectorMap;
    private int numberOfColumns;
    private int rowIndex;
    private int rowDataColumnIndex;
    private boolean isConfigured;
    private boolean isPrepared;
    private boolean isRowOpen;
    private boolean isOrdered;
    private boolean isAscending;
    private boolean isDistinct;
    private boolean hasAggregates;
    private int limit = -1;
    private int nth = -1;
    private int firstN = -1;
    private int lastN = -1;
    private int sliceSize = -1;
    private boolean notNthSelection = false;
    private boolean firstSelection = false;
    private boolean lastSelection = false;
    private boolean notFirstSelection = false;
    private boolean notLastSelection = false;
    private boolean nthSliceSelection = false;
    private boolean notNthSliceSelection = false;
    private boolean nthLastSliceSelection = false;
    private boolean notNthLastSliceSelection = false;

    public SQWRLResultImpl() {
        this.initialize();
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public boolean isRowOpen() {
        return this.isRowOpen;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public void addColumns(List<String> list) throws SQWRLException {
        for (String string : list) {
            this.addColumn(string);
        }
    }

    @Override
    public void addColumn(String string) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        this.selectedColumnIndexes.add(this.numberOfColumns);
        this.allColumnNames.add(string);
        ++this.numberOfColumns;
    }

    @Override
    public void addAggregateColumn(String string, String string2) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        SQWRLNames.checkAggregateFunctionName(string2);
        this.aggregateColumnIndexes.put(this.numberOfColumns, string2);
        this.allColumnNames.add(string);
        ++this.numberOfColumns;
    }

    @Override
    public void addOrderByColumn(int n, boolean bl) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (n < 0 || n >= this.allColumnNames.size()) {
            throw new SQWRLException("ordered column index " + n + " out of range");
        }
        if (this.isOrdered && this.isAscending != bl) {
            if (this.isAscending) {
                throw new SQWRLException("attempt to order column " + this.allColumnNames.get(n) + " ascending when descending was previously selected");
            }
            throw new SQWRLException("attempt to order column " + this.allColumnNames.get(n) + " descending when ascending was previously selected");
        }
        this.isOrdered = true;
        this.isAscending = bl;
        this.orderByColumnIndexes.add(n);
    }

    @Override
    public void addColumnDisplayName(String string) throws SQWRLException {
        if (string.length() == 0 || string.indexOf(44) != -1) {
            throw new SQWRLException("invalid column name " + string + " - no commas or empty names allowed");
        }
        this.columnDisplayNames.add(string);
    }

    @Override
    public void configured() throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (this.containsOneOf(this.selectedColumnIndexes, this.aggregateColumnIndexes.keySet())) {
            throw new InvalidQueryException("aggregate columns cannot also be selected columns");
        }
        this.hasAggregates = !this.aggregateColumnIndexes.isEmpty();
        this.isConfigured = true;
    }

    @Override
    public void setIsDistinct() {
        this.isDistinct = true;
    }

    @Override
    public int getNumberOfColumns() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        return this.numberOfColumns;
    }

    @Override
    public List<String> getColumnNames() throws SQWRLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.throwExceptionIfNotConfigured();
        if (this.columnDisplayNames.size() < this.getNumberOfColumns()) {
            arrayList.addAll(this.columnDisplayNames);
            arrayList.addAll(this.allColumnNames.subList(this.columnDisplayNames.size(), this.allColumnNames.size()));
        } else {
            arrayList.addAll(this.columnDisplayNames);
        }
        return arrayList;
    }

    @Override
    public String getColumnName(int n) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.checkColumnIndex(n);
        if (n < this.columnDisplayNames.size()) {
            return this.columnDisplayNames.get(n);
        }
        return this.allColumnNames.get(n);
    }

    @Override
    public void addRow(List<SQWRLResultValue> list) throws SQWRLException {
        if (list.size() != this.getNumberOfColumns()) {
            throw new SQWRLException("addRow expecting " + this.getNumberOfColumns() + ", got " + list.size() + " values");
        }
        this.openRow();
        for (SQWRLResultValue sQWRLResultValue : list) {
            this.addRowData(sQWRLResultValue);
        }
        this.closeRow();
    }

    @Override
    public void openRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowOpen();
        this.rowDataColumnIndex = 0;
        this.rowData = new ArrayList<SQWRLResultValue>();
        this.isRowOpen = true;
    }

    @Override
    public void addRowData(SQWRLResultValue sQWRLResultValue) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowNotOpen();
        if (this.rowDataColumnIndex == this.getNumberOfColumns()) {
            throw new ResultStateException("attempt to add data beyond the end of a row");
        }
        if (this.aggregateColumnIndexes.containsKey(this.rowDataColumnIndex) && !this.aggregateColumnIndexes.get(this.rowDataColumnIndex).equals("count") && !this.aggregateColumnIndexes.get(this.rowDataColumnIndex).equals("countDistinct") && !this.isNumericValue(sQWRLResultValue)) {
            throw new SQWRLException("attempt to add non numeric value " + sQWRLResultValue + " to min, max, sum, or avg aggregate column " + this.allColumnNames.get(this.rowDataColumnIndex));
        }
        this.rowData.add(sQWRLResultValue);
        ++this.rowDataColumnIndex;
        if (this.rowDataColumnIndex == this.getNumberOfColumns()) {
            this.closeRow();
        }
    }

    @Override
    public void closeRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.isRowOpen) {
            this.rows.add(this.rowData);
        }
        this.isRowOpen = false;
    }

    @Override
    public void prepared() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.rowDataColumnIndex != 0) {
            this.throwExceptionIfRowOpen();
        }
        this.isPrepared = true;
        this.isRowOpen = false;
        this.rowDataColumnIndex = 0;
        this.rowIndex = this.getNumberOfRows() > 0 ? 0 : -1;
        if (this.hasAggregates) {
            this.rows = this.aggregate(this.rows, this.allColumnNames, this.aggregateColumnIndexes);
        } else if (this.isDistinct) {
            this.rows = this.distinct(this.rows);
        }
        if (this.isOrdered) {
            this.rows = this.orderBy(this.rows, this.allColumnNames, this.orderByColumnIndexes, this.isAscending);
        }
        this.rows = this.processSelectionOperators(this.rows);
        this.prepareColumnVectors();
    }

    @Override
    public int getNumberOfRows() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() throws SQWRLException {
        return this.getNumberOfRows() == 0;
    }

    @Override
    public void reset() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        if (this.getNumberOfRows() > 0) {
            this.rowIndex = 0;
        }
    }

    @Override
    public void next() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        if (this.rowIndex != -1 && this.rowIndex < this.getNumberOfRows()) {
            ++this.rowIndex;
        }
    }

    @Override
    public boolean hasNext() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        return this.rowIndex != -1 && this.rowIndex < this.getNumberOfRows();
    }

    @Override
    public List<SQWRLResultValue> getRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        return this.rows.get(this.rowIndex);
    }

    @Override
    public SQWRLResultValue getValue(String string) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        this.checkColumnName(string);
        int n = this.allColumnNames.indexOf(string);
        List<SQWRLResultValue> list = this.rows.get(this.rowIndex);
        return list.get(n);
    }

    @Override
    public SQWRLResultValue getValue(int n) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        this.checkColumnIndex(n);
        List<SQWRLResultValue> list = this.rows.get(this.rowIndex);
        return list.get(n);
    }

    @Override
    public SQWRLResultValue getValue(int n, int n2) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnIndex(n);
        this.checkRowIndex(n2);
        return this.rows.get(n2).get(n);
    }

    @Override
    public IndividualValue getObjectValue(String string) throws SQWRLException {
        if (!this.hasObjectValue(string)) {
            throw new InvalidColumnTypeException("expecting ObjectValue type for column " + string);
        }
        return (IndividualValue)this.getValue(string);
    }

    @Override
    public IndividualValue getObjectValue(int n) throws SQWRLException {
        return this.getObjectValue(this.getColumnName(n));
    }

    @Override
    public DataValue getDataValue(String string) throws SQWRLException {
        if (!this.hasDataValue(string)) {
            throw new InvalidColumnTypeException("expecting DataValue type for column " + string);
        }
        return (DataValue)this.getValue(string);
    }

    @Override
    public ClassValue getClassValue(String string) throws SQWRLException {
        if (!this.hasClassValue(string)) {
            throw new InvalidColumnTypeException("expecting ClassValue type for column " + string);
        }
        return (ClassValue)this.getValue(string);
    }

    @Override
    public ClassValue getClassValue(int n) throws SQWRLException {
        return this.getClassValue(this.getColumnName(n));
    }

    @Override
    public PropertyValue getPropertyValue(int n) throws SQWRLException {
        return this.getPropertyValue(this.getColumnName(n));
    }

    @Override
    public PropertyValue getPropertyValue(String string) throws SQWRLException {
        if (!this.hasPropertyValue(string)) {
            throw new InvalidColumnTypeException("expecting PropertyValue type for column " + string);
        }
        return (PropertyValue)this.getValue(string);
    }

    @Override
    public DataValue getDataValue(int n) throws SQWRLException {
        return this.getDataValue(this.getColumnName(n));
    }

    @Override
    public List<SQWRLResultValue> getColumn(String string) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnName(string);
        return this.columnVectorMap.get(string);
    }

    @Override
    public List<SQWRLResultValue> getColumn(int n) throws SQWRLException {
        return this.getColumn(this.getColumnName(n));
    }

    @Override
    public boolean hasObjectValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof IndividualValue;
    }

    @Override
    public boolean hasObjectValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof IndividualValue;
    }

    @Override
    public boolean hasDataValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof DataValue;
    }

    @Override
    public boolean hasDataValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof DataValue;
    }

    @Override
    public boolean hasClassValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof ClassValue;
    }

    @Override
    public boolean hasClassValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof ClassValue;
    }

    @Override
    public boolean hasPropertyValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof PropertyValue;
    }

    @Override
    public boolean hasPropertyValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof PropertyValue;
    }

    private List<List<SQWRLResultValue>> processSelectionOperators(List<List<SQWRLResultValue>> list) throws SQWRLException {
        ArrayList<List<SQWRLResultValue>> arrayList = new ArrayList<List<SQWRLResultValue>>();
        boolean bl = false;
        if (this.hasLimit()) {
            int n;
            int n2 = n = this.limit > list.size() ? list.size() : this.limit;
            if (this.limit < 0) {
                this.limit = 0;
            }
            arrayList.addAll(list.subList(0, n));
            bl = true;
        } else {
            if (this.hasNth()) {
                if (this.nth < 1) {
                    this.nth = 1;
                }
                if (this.nth <= list.size()) {
                    arrayList.add(list.get(this.nth - 1));
                }
                bl = true;
            }
            if (this.hasNotNth()) {
                if (this.nth < 1) {
                    this.nth = 1;
                }
                if (this.nth <= list.size()) {
                    ArrayList<List<SQWRLResultValue>> arrayList2 = new ArrayList<List<SQWRLResultValue>>(list);
                    arrayList2.remove(this.nth - 1);
                    arrayList.addAll(arrayList2);
                } else {
                    arrayList.addAll(list);
                }
                bl = true;
            }
            if (this.hasFirstSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= list.size()) {
                    arrayList.addAll(list.subList(0, this.firstN));
                }
                bl = true;
            }
            if (this.hasNotFirstSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= list.size()) {
                    arrayList.addAll(list.subList(this.firstN, list.size()));
                } else {
                    arrayList.addAll(list);
                }
                bl = true;
            }
            if (this.hasLastSelection()) {
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                if (this.lastN <= list.size()) {
                    arrayList.addAll(list.subList(list.size() - this.lastN, list.size()));
                }
                bl = true;
            }
            if (this.hasNotLastSelection()) {
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                if (this.lastN <= list.size()) {
                    arrayList.addAll(list.subList(0, list.size() - this.lastN));
                } else {
                    arrayList.addAll(list);
                }
                bl = true;
            }
            if (this.hasNthSliceSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= list.size()) {
                    int n = this.firstN + this.sliceSize > list.size() ? list.size() : this.firstN + this.sliceSize - 1;
                    arrayList.addAll(list.subList(this.firstN - 1, n));
                }
                bl = true;
            }
            if (this.hasNotNthSliceSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= list.size()) {
                    int n = this.firstN + this.sliceSize > list.size() ? list.size() : this.firstN + this.sliceSize - 1;
                    arrayList.addAll(list.subList(0, this.firstN - 1));
                    if (n <= list.size()) {
                        arrayList.addAll(list.subList(n, list.size()));
                    }
                } else {
                    arrayList.addAll(list);
                }
                bl = true;
            }
            if (this.hasNthLastSliceSelection()) {
                int n;
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                int n3 = n = this.lastN + this.sliceSize > list.size() ? list.size() : this.lastN + this.sliceSize;
                if (this.lastN <= list.size()) {
                    arrayList.addAll(list.subList(this.lastN, n));
                }
                bl = true;
            }
            if (this.hasNotNthLastSliceSelection()) {
                if (this.lastN <= list.size()) {
                    if (this.lastN < 1) {
                        this.lastN = 1;
                    }
                    int n = this.lastN + this.sliceSize > list.size() ? list.size() : this.lastN + this.sliceSize;
                    arrayList.addAll(list.subList(0, this.lastN));
                    if (n <= list.size()) {
                        arrayList.addAll(list.subList(n, list.size()));
                    }
                } else {
                    arrayList.addAll(list);
                }
                bl = true;
            }
        }
        if (bl) {
            return arrayList;
        }
        return list;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setNth(int n) {
        this.nth = n;
    }

    public void setNotNth(int n) {
        this.notNthSelection = true;
        this.nth = n;
    }

    public void setFirst() {
        this.firstSelection = true;
        this.firstN = 1;
    }

    public void setFirst(int n) {
        this.firstSelection = true;
        this.firstN = n;
    }

    public void setLast() {
        this.lastSelection = true;
        this.lastN = 1;
    }

    public void setLast(int n) {
        this.lastSelection = true;
        this.lastN = n;
    }

    public void setNotFirst() {
        this.notFirstSelection = true;
        this.firstN = 1;
    }

    public void setNotFirst(int n) {
        this.notFirstSelection = true;
        this.firstN = n;
    }

    public void setNotLast() {
        this.notLastSelection = true;
        this.lastN = 1;
    }

    public void setNotLast(int n) {
        this.notLastSelection = true;
        this.lastN = n;
    }

    public void setNthSlice(int n, int n2) {
        this.nthSliceSelection = true;
        this.firstN = n;
        this.sliceSize = n2;
    }

    public void setNotNthSlice(int n, int n2) {
        this.notNthSliceSelection = true;
        this.firstN = n;
        this.sliceSize = n2;
    }

    public void setNthLastSlice(int n, int n2) {
        this.nthLastSliceSelection = true;
        this.lastN = n;
        this.sliceSize = n2;
    }

    public void setNotNthLastSlice(int n, int n2) {
        this.notNthLastSliceSelection = true;
        this.lastN = n;
        this.sliceSize = n2;
    }

    private boolean hasLimit() {
        return this.limit != -1;
    }

    private boolean hasNth() {
        return !this.hasNotNth() && this.nth != -1;
    }

    private boolean hasNotNth() {
        return this.notNthSelection;
    }

    private boolean hasFirstSelection() {
        return this.firstSelection;
    }

    private boolean hasLastSelection() {
        return this.lastSelection;
    }

    private boolean hasNotFirstSelection() {
        return this.notFirstSelection;
    }

    private boolean hasNotLastSelection() {
        return this.notLastSelection;
    }

    private boolean hasNthSliceSelection() {
        return this.nthSliceSelection;
    }

    private boolean hasNotNthSliceSelection() {
        return this.notNthSliceSelection;
    }

    private boolean hasNthLastSliceSelection() {
        return this.nthLastSliceSelection;
    }

    private boolean hasNotNthLastSliceSelection() {
        return this.notNthLastSliceSelection;
    }

    private void prepareColumnVectors() throws SQWRLException {
        this.columnVectorMap = new HashMap<String, List<SQWRLResultValue>>();
        if (this.getNumberOfColumns() > 0) {
            int n;
            ArrayList arrayList = new ArrayList(this.getNumberOfColumns());
            for (n = 0; n < this.getNumberOfColumns(); ++n) {
                arrayList.add(new ArrayList(this.getNumberOfRows()));
            }
            for (n = 0; n < this.getNumberOfRows(); ++n) {
                for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                    ((List)arrayList.get(i)).add(this.rows.get(n).get(i));
                }
            }
            for (n = 0; n < this.getNumberOfColumns(); ++n) {
                this.columnVectorMap.put(this.getColumnName(n), (List<SQWRLResultValue>)arrayList.get(n));
            }
        }
    }

    public String toString() {
        String string = "[numberOfColumns: " + this.numberOfColumns + ", isConfigured: " + this.isConfigured + ", isPrepared: " + this.isPrepared + ", isRowOpen: " + this.isRowOpen + ", isOrdered: " + this.isOrdered + ", isAscending " + this.isAscending + ", isDistinct: " + this.isDistinct + ", hasAggregates: " + this.hasAggregates + "]\n";
        string = string + "[columnDisplayNames: ";
        for (String object : this.columnDisplayNames) {
            string = string + "" + object + "";
        }
        string = string + "]\n";
        for (List list : this.rows) {
            for (SQWRLResultValue sQWRLResultValue : list) {
                string = string + "" + sQWRLResultValue + " ";
            }
            string = string + "\n";
        }
        string = string + "--------------------------------------------------------------------------------\n";
        return string;
    }

    private void initialize() {
        this.isConfigured = false;
        this.isPrepared = false;
        this.isRowOpen = false;
        this.allColumnNames = new ArrayList<String>();
        this.aggregateColumnIndexes = new HashMap<Integer, String>();
        this.selectedColumnIndexes = new ArrayList<Integer>();
        this.orderByColumnIndexes = new ArrayList<Integer>();
        this.columnDisplayNames = new ArrayList<String>();
        this.numberOfColumns = 0;
        this.isDistinct = false;
        this.isAscending = false;
        this.isOrdered = false;
        this.rowIndex = -1;
        this.rows = new ArrayList<List<SQWRLResultValue>>();
    }

    private void throwExceptionIfNotConfigured() throws SQWRLException {
        if (!this.isConfigured()) {
            throw new ResultStateException("attempt to add data to unconfigured result");
        }
    }

    private void throwExceptionIfAtEndOfResult() throws SQWRLException {
        if (!this.hasNext()) {
            throw new ResultStateException("attempt to get data after end of result reached");
        }
    }

    private void throwExceptionIfNotPrepared() throws SQWRLException {
        if (!this.isPrepared()) {
            throw new ResultStateException("attempt to process unprepared result");
        }
    }

    private void throwExceptionIfAlreadyConfigured() throws SQWRLException {
        if (this.isConfigured()) {
            throw new ResultStateException("attempt to configure already configured result");
        }
    }

    private void throwExceptionIfAlreadyPrepared() throws SQWRLException {
        if (this.isPrepared()) {
            throw new ResultStateException("attempt to modify prepared result");
        }
    }

    private void checkColumnName(String string) throws InvalidColumnNameException {
        if (!this.allColumnNames.contains(string)) {
            throw new InvalidColumnNameException("invalid column name " + string);
        }
    }

    private void throwExceptionIfRowNotOpen() throws SQWRLException {
        if (!this.isRowOpen) {
            throw new ResultStateException("attempt to add data to an unopened row");
        }
    }

    private void throwExceptionIfRowOpen() throws SQWRLException {
        if (this.isRowOpen) {
            throw new ResultStateException("attempt to process result with a partially prepared row");
        }
    }

    private void checkColumnIndex(int n) throws SQWRLException {
        if (n < 0 || n >= this.getNumberOfColumns()) {
            throw new InvalidColumnIndexException("column index " + n + " out of bounds");
        }
    }

    private void checkRowIndex(int n) throws SQWRLException {
        if (n < 0 || n >= this.getNumberOfRows()) {
            throw new InvalidRowIndexException("row index " + n + " out of bounds");
        }
    }

    private boolean containsOneOf(List<Integer> list, Set<Integer> set) {
        for (Integer n : set) {
            if (!list.contains(n)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumericValue(SQWRLResultValue sQWRLResultValue) {
        return sQWRLResultValue instanceof DataValue && ((DataValue)sQWRLResultValue).isNumeric();
    }

    private List<List<SQWRLResultValue>> distinct(List<List<SQWRLResultValue>> list) {
        ArrayList<List<SQWRLResultValue>> arrayList = new ArrayList<List<SQWRLResultValue>>(list);
        ArrayList<List<SQWRLResultValue>> arrayList2 = new ArrayList<List<SQWRLResultValue>>();
        RowComparator rowComparator = new RowComparator(this.allColumnNames, true);
        Collections.sort(arrayList, rowComparator);
        for (List list2 : arrayList) {
            if (Collections.binarySearch(arrayList2, list2, rowComparator) >= 0) continue;
            arrayList2.add(list2);
        }
        return arrayList2;
    }

    private List<List<SQWRLResultValue>> aggregate(List<List<SQWRLResultValue>> list, List<String> list2, Map<Integer, String> map) throws SQWRLException {
        SQWRLResultValue sQWRLResultValue;
        List<SQWRLResultValue> list3;
        HashMap hashMap;
        int n;
        ArrayList<List<SQWRLResultValue>> arrayList = new ArrayList<List<SQWRLResultValue>>();
        RowComparator rowComparator = new RowComparator(list2, this.selectedColumnIndexes, true);
        HashMap<Integer, HashMap> hashMap2 = new HashMap<Integer, HashMap>();
        for (List<SQWRLResultValue> list4 : list) {
            n = this.findRowIndex(arrayList, list4, rowComparator);
            if (n < 0) {
                hashMap = new HashMap();
                for (Integer n2 : map.keySet()) {
                    list3 = new ArrayList<SQWRLResultValue>();
                    sQWRLResultValue = list4.get(n2);
                    list3.add(sQWRLResultValue);
                    hashMap.put(n2, list3);
                }
                hashMap2.put(arrayList.size(), hashMap);
                arrayList.add(list4);
                continue;
            }
            hashMap = (HashMap)hashMap2.get(n);
            for (Integer n2 : map.keySet()) {
                sQWRLResultValue = list4.get(n2);
                list3 = (List)hashMap.get(n2);
                list3.add(sQWRLResultValue);
            }
        }
        n = 0;
        for (List<SQWRLResultValue> list4 : arrayList) {
            hashMap = (HashMap)hashMap2.get(n);
            for (Integer n2 : map.keySet()) {
                String string = map.get(n2);
                list3 = (List)hashMap.get(n2);
                if (string.equalsIgnoreCase("min")) {
                    sQWRLResultValue = this.min(list3);
                } else if (string.equalsIgnoreCase("max")) {
                    sQWRLResultValue = this.max(list3);
                } else if (string.equalsIgnoreCase("sum")) {
                    sQWRLResultValue = this.sum(list3);
                } else if (string.equalsIgnoreCase("avg")) {
                    sQWRLResultValue = this.avg(list3);
                } else if (string.equalsIgnoreCase("count")) {
                    sQWRLResultValue = this.count(list3);
                } else if (string.equalsIgnoreCase("countDistinct")) {
                    sQWRLResultValue = this.countDistinct(list3);
                } else {
                    throw new InvalidAggregateFunctionNameException("invalid aggregate function " + string);
                }
                list4.set(n2, sQWRLResultValue);
            }
            ++n;
        }
        return arrayList;
    }

    private List<List<SQWRLResultValue>> orderBy(List<List<SQWRLResultValue>> list, List<String> list2, List<Integer> list3, boolean bl) throws SQWRLException {
        ArrayList<List<SQWRLResultValue>> arrayList = new ArrayList<List<SQWRLResultValue>>(list);
        RowComparator rowComparator = new RowComparator(list2, list3, bl);
        Collections.sort(arrayList, rowComparator);
        return arrayList;
    }

    private DataValue min(List<SQWRLResultValue> list) throws SQWRLException {
        DataValue dataValue = null;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for min");
        }
        for (SQWRLResultValue sQWRLResultValue : list) {
            if (!(sQWRLResultValue instanceof DataValue)) {
                throw new SQWRLException("attempt to use min aggregate on non datatype " + sQWRLResultValue);
            }
            DataValue dataValue2 = (DataValue)sQWRLResultValue;
            if (!dataValue2.isNumeric()) {
                throw new SQWRLException("attempt to use min aggregate on non numeric datatype " + dataValue2);
            }
            if (dataValue == null) {
                dataValue = dataValue2;
                continue;
            }
            if (dataValue2.compareTo(dataValue) >= 0) continue;
            dataValue = dataValue2;
        }
        return dataValue;
    }

    private DataValue max(List<SQWRLResultValue> list) throws SQWRLException {
        DataValue dataValue = null;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for max");
        }
        for (SQWRLResultValue sQWRLResultValue : list) {
            if (!(sQWRLResultValue instanceof DataValue)) {
                throw new SQWRLException("attempt to use max aggregate on non datatype " + sQWRLResultValue);
            }
            DataValue dataValue2 = (DataValue)sQWRLResultValue;
            if (!dataValue2.isNumeric()) {
                throw new SQWRLException("attempt to use max aggregate on non numeric datatype " + dataValue2);
            }
            if (dataValue == null) {
                dataValue = dataValue2;
                continue;
            }
            if (dataValue2.compareTo(dataValue) <= 0) continue;
            dataValue = dataValue2;
        }
        return dataValue;
    }

    private DataValue sum(List<SQWRLResultValue> list) throws SQWRLException {
        double d = 0.0;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for sum");
        }
        for (SQWRLResultValue sQWRLResultValue : list) {
            if (!(sQWRLResultValue instanceof DataValue)) {
                throw new SQWRLException("attempt to use sum aggregate on non data value: " + sQWRLResultValue);
            }
            double d2 = ((DataValue)sQWRLResultValue).getDouble();
            d += d2;
        }
        return new DataValueImpl(d);
    }

    private DataValue avg(List<SQWRLResultValue> list) throws SQWRLException {
        double d = 0.0;
        int n = 0;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for function avg");
        }
        for (SQWRLResultValue sQWRLResultValue : list) {
            if (!(sQWRLResultValue instanceof DataValue)) {
                throw new SQWRLException("attempt to use avg aggregate on non data value " + sQWRLResultValue);
            }
            double d2 = ((DataValue)sQWRLResultValue).getDouble();
            ++n;
            d += d2;
        }
        return new DataValueImpl(d / (double)n);
    }

    private DataValue count(List<SQWRLResultValue> list) throws SQWRLException {
        return new DataValueImpl(list.size());
    }

    private DataValue countDistinct(List<SQWRLResultValue> list) throws SQWRLException {
        HashSet<SQWRLResultValue> hashSet = new HashSet<SQWRLResultValue>(list);
        return new DataValueImpl(hashSet.size());
    }

    private int findRowIndex(List<List<SQWRLResultValue>> list, List<SQWRLResultValue> list2, Comparator<List<SQWRLResultValue>> comparator) {
        int n = 0;
        for (List<SQWRLResultValue> list3 : list) {
            if (comparator.compare(list2, list3) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowComparator
    implements Comparator<List<SQWRLResultValue>> {
        private List<Integer> orderByColumnIndexes;
        private boolean ascending;

        public RowComparator(List<String> list, List<Integer> list2, boolean bl) {
            this.ascending = bl;
            this.orderByColumnIndexes = list2;
        }

        public RowComparator(List<String> list, boolean bl) {
            this.ascending = bl;
            this.orderByColumnIndexes = new ArrayList<Integer>();
            for (String string : list) {
                this.orderByColumnIndexes.add(list.indexOf(string));
            }
        }

        @Override
        public int compare(List<SQWRLResultValue> list, List<SQWRLResultValue> list2) {
            for (Integer n : this.orderByColumnIndexes) {
                int n2 = list.get(n).compareTo(list2.get(n));
                if (n2 == 0) continue;
                if (this.ascending) {
                    return n2;
                }
                return -n2;
            }
            return 0;
        }
    }
}

