/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDAnyURI;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDate;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDateTime;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDuration;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDTime;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDType;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.DataValueConversionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DataValueImpl
implements DataValue {
    private Object value;

    public DataValueImpl() {
        this.value = null;
    }

    public DataValueImpl(String string) {
        this.value = string;
    }

    public DataValueImpl(boolean bl) {
        this.value = bl;
    }

    public DataValueImpl(Boolean bl) {
        this.value = bl;
    }

    public DataValueImpl(Byte by) {
        this.value = by;
    }

    public DataValueImpl(int n) {
        this.value = n;
    }

    public DataValueImpl(long l) {
        this.value = l;
    }

    public DataValueImpl(float f) {
        this.value = Float.valueOf(f);
    }

    public DataValueImpl(double d) {
        this.value = d;
    }

    public DataValueImpl(short s) {
        this.value = s;
    }

    public DataValueImpl(XSDType xSDType) {
        this.value = xSDType;
    }

    public DataValueImpl(DataValue dataValue) {
        this.value = dataValue.getValue();
    }

    public DataValueImpl(Object object) throws DataValueConversionException {
        if (!(object instanceof Number || object instanceof String || object instanceof Boolean || object instanceof Byte || object instanceof XSDType)) {
            throw new DataValueConversionException("cannot convert value of type " + object.getClass().getCanonicalName() + " to DataValue");
        }
        this.value = object;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isFloat() {
        return this.value instanceof Float;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public boolean isShort() {
        return this.value instanceof Short;
    }

    public boolean isByte() {
        return this.value instanceof Byte;
    }

    public boolean isXSDType() {
        return this.value instanceof XSDType;
    }

    public boolean isXSDTime() {
        return this.value instanceof XSDTime;
    }

    public boolean isXSDDate() {
        return this.value instanceof XSDDate;
    }

    public boolean isXSDDateTime() {
        return this.value instanceof XSDDateTime;
    }

    public boolean isXSDDuration() {
        return this.value instanceof XSDDuration;
    }

    public boolean isXSDAnyURI() {
        return this.value instanceof XSDAnyURI;
    }

    public boolean isComparable() {
        return this.isNumeric() || this.isString() || this.isXSDTime() || this.isXSDDateTime() || this.isXSDDuration();
    }

    public String getString() throws DataValueConversionException {
        if (!this.isString()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to String");
        }
        return (String)this.value;
    }

    public Number getNumber() throws DataValueConversionException {
        if (!this.isNumeric()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to Number");
        }
        return (Number)this.value;
    }

    public XSDType getXSDType() throws DataValueConversionException {
        if (!this.isXSDType()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to XSDType");
        }
        return (XSDType)this.value;
    }

    public boolean getBoolean() throws DataValueConversionException {
        if (!this.isBoolean()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to boolean");
        }
        return (Boolean)this.value;
    }

    public int getInt() throws DataValueConversionException {
        int n = 0;
        if (this.isInteger()) {
            n = (Integer)this.value;
        } else if (this.isShort()) {
            n = ((Short)this.value).shortValue();
        } else {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to int");
        }
        return n;
    }

    public long getLong() throws DataValueConversionException {
        long l = 0L;
        if (this.isLong()) {
            l = (Long)this.value;
        } else if (this.isInteger()) {
            l = ((Integer)this.value).intValue();
        } else if (this.isShort()) {
            l = ((Short)this.value).shortValue();
        } else {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to long");
        }
        return l;
    }

    public float getFloat() throws DataValueConversionException {
        float f = 0.0f;
        if (this.isFloat()) {
            f = ((Float)this.value).floatValue();
        } else if (this.isInteger()) {
            f = ((Integer)this.value).intValue();
        } else if (this.isLong()) {
            f = ((Long)this.value).longValue();
        } else if (this.isShort()) {
            f = ((Short)this.value).shortValue();
        } else {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to float");
        }
        return f;
    }

    public double getDouble() throws DataValueConversionException {
        double d = 0.0;
        if (this.isDouble()) {
            d = (Double)this.value;
        } else if (this.isFloat()) {
            d = ((Float)this.value).floatValue();
        } else if (this.isInteger()) {
            d = ((Integer)this.value).intValue();
        } else if (this.isLong()) {
            d = ((Long)this.value).longValue();
        } else if (this.isShort()) {
            d = ((Short)this.value).shortValue();
        } else {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to double");
        }
        return d;
    }

    public short getShort() throws DataValueConversionException {
        if (!this.isShort()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to short");
        }
        return (Short)this.value;
    }

    public byte getByte() throws DataValueConversionException {
        if (!this.isByte()) {
            throw new DataValueConversionException("cannot convert value of type " + this.value.getClass().getCanonicalName() + " to byte");
        }
        return (Byte)this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    public String toQuotedString() {
        return "\"" + this.value.toString().replaceAll("[~\\\\]\"", "\\\\\"") + "\"";
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object object) {
        this.value = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DataValueImpl dataValueImpl = (DataValueImpl)object;
        return this.value != null && dataValueImpl.value != null && this.value.equals(dataValueImpl.value);
    }

    public int hashCode() {
        int n = 66;
        return n += null == this.value ? 0 : this.value.toString().hashCode();
    }

    public int compareTo(SQWRLResultValue sQWRLResultValue) {
        return ((Comparable)this.value).compareTo(((DataValueImpl)sQWRLResultValue).getValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setValue(objectInput.readObject());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getValue());
    }
}

