/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.portability.p3;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLBuiltInAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLAtomReference;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P3SWRLBuiltInAtomReference
extends P3SWRLAtomReference
implements SWRLBuiltInAtomReference {
    private String builtInURI;
    private String builtInPrefixedName;
    private List<BuiltInArgument> arguments;
    private int builtInIndex = -1;
    private boolean sqwrlCollectionResultsUsed = false;
    private Set<String> pathVariableNames = new HashSet<String>();

    public P3SWRLBuiltInAtomReference(String string, String string2, List<BuiltInArgument> list) {
        this.builtInURI = string;
        this.builtInPrefixedName = string2;
        this.arguments = list;
    }

    public P3SWRLBuiltInAtomReference(String string, String string2) {
        this.builtInURI = string;
        this.builtInPrefixedName = string2;
        this.arguments = new ArrayList<BuiltInArgument>();
    }

    public void setBuiltInArguments(List<BuiltInArgument> list) {
        this.arguments = list;
    }

    @Override
    public String getPredicate() {
        return this.builtInURI;
    }

    @Override
    public String getBuiltInPrefixedName() {
        return this.builtInPrefixedName;
    }

    @Override
    public List<BuiltInArgument> getArguments() {
        return this.arguments;
    }

    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    @Override
    public int getBuiltInIndex() {
        return this.builtInIndex;
    }

    @Override
    public void setBuiltInIndex(int n) {
        this.builtInIndex = n;
    }

    @Override
    public Set<String> getPathVariableNames() {
        return this.pathVariableNames;
    }

    @Override
    public boolean usesSQWRLCollectionResults() {
        return this.sqwrlCollectionResultsUsed;
    }

    @Override
    public boolean isSQWRLBuiltIn() {
        return SQWRLNames.isSQWRLBuiltIn(this.builtInURI);
    }

    @Override
    public boolean isSQWRLMakeCollection() {
        return SQWRLNames.isSQWRLCollectionMakeBuiltIn(this.builtInURI);
    }

    @Override
    public boolean isSQWRLGroupCollection() {
        return SQWRLNames.isSQWRLCollectionGroupByBuiltIn(this.builtInURI);
    }

    @Override
    public boolean isSQWRLCollectionOperation() {
        return SQWRLNames.isSQWRLCollectionOperationBuiltIn(this.builtInURI);
    }

    @Override
    public boolean isSQWRLCollectionCreateOperation() {
        return SQWRLNames.isSQWRLCollectionCreateOperationBuiltIn(this.builtInURI);
    }

    @Override
    public void setUsesSQWRLCollectionResults() {
        this.sqwrlCollectionResultsUsed = true;
    }

    @Override
    public boolean usesAtLeastOneVariableOf(Set<String> set) throws BuiltInException {
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.retainAll(this.getArgumentsVariableNames());
        return !hashSet.isEmpty();
    }

    @Override
    public boolean isArgumentAVariable(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        return this.arguments.get(n).isVariable();
    }

    @Override
    public boolean isArgumentUnbound(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        return this.arguments.get(n).isUnbound();
    }

    @Override
    public boolean hasUnboundArguments() {
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getUnboundArgumentVariableNames() throws BuiltInException {
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isUnbound()) continue;
            hashSet.add(builtInArgument.getVariableName());
        }
        return hashSet;
    }

    @Override
    public String getArgumentVariableName(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        if (!this.arguments.get(n).isVariable()) {
            throw new BuiltInException("expecting a variable for (0-offset) argument #" + n);
        }
        return this.arguments.get(n).getVariableName();
    }

    @Override
    public List<String> getArgumentsVariableNames() throws BuiltInException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isVariable()) continue;
            arrayList.add(builtInArgument.getVariableName());
        }
        return arrayList;
    }

    @Override
    public List<String> getArgumentsVariableNamesExceptFirst() throws BuiltInException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isVariable() || n++ == 0) continue;
            arrayList.add(builtInArgument.getVariableName());
        }
        return arrayList;
    }

    @Override
    public void addArguments(List<BuiltInArgument> list) {
        this.arguments.addAll(list);
    }

    @Override
    public void setPathVariableNames(Set<String> set) {
        this.pathVariableNames = set;
    }

    private void checkArgumentNumber(int n) throws BuiltInException {
        if (n < 0 || n > this.arguments.size()) {
            throw new BuiltInException("invalid (0-offset) argument #" + n);
        }
    }

    public String toString() {
        String string = this.builtInPrefixedName + "(";
        boolean bl = true;
        for (BuiltInArgument builtInArgument : this.getArguments()) {
            SWRLLiteralArgumentReference sWRLLiteralArgumentReference;
            DataValue dataValue;
            if (!bl) {
                string = string + ", ";
            }
            string = builtInArgument instanceof SWRLLiteralArgumentReference ? ((dataValue = (sWRLLiteralArgumentReference = (SWRLLiteralArgumentReference)builtInArgument).getLiteral()).isString() ? string + "\"" + dataValue + "\"" : string + "" + dataValue) : string + "" + builtInArgument;
            bl = false;
        }
        string = string + ")";
        return string;
    }
}

