/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.portability.p3;

import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P3OWLPropertyReference
implements OWLPropertyReference {
    private String propertyURI;
    private Set<OWLClassReference> domainClasses;
    private Set<OWLClassReference> rangeClasses;
    private Set<OWLPropertyReference> superProperties;
    private Set<OWLPropertyReference> subProperties;
    private Set<OWLPropertyReference> equivalentProperties;

    public P3OWLPropertyReference(String string) {
        this.propertyURI = string;
        this.initialize();
    }

    public void addDomainClass(OWLClassReference oWLClassReference) {
        this.domainClasses.add(oWLClassReference);
    }

    public void addRangeClass(OWLClassReference oWLClassReference) {
        this.rangeClasses.add(oWLClassReference);
    }

    public void addSuperProperty(OWLPropertyReference oWLPropertyReference) {
        this.superProperties.add(oWLPropertyReference);
    }

    public void addSubProperty(OWLPropertyReference oWLPropertyReference) {
        this.subProperties.add(oWLPropertyReference);
    }

    public void addEquivalentProperty(OWLPropertyReference oWLPropertyReference) {
        this.equivalentProperties.add(oWLPropertyReference);
    }

    @Override
    public String getURI() {
        return this.propertyURI;
    }

    @Override
    public Set<OWLClassReference> getDomainClasses() {
        return this.domainClasses;
    }

    @Override
    public Set<OWLClassReference> getRangeClasses() {
        return this.rangeClasses;
    }

    @Override
    public Set<OWLPropertyReference> getSuperProperties() {
        return this.superProperties;
    }

    @Override
    public Set<OWLPropertyReference> getSubProperties() {
        return this.subProperties;
    }

    @Override
    public Set<OWLPropertyReference> getEquivalentProperties() {
        return this.equivalentProperties;
    }

    @Override
    public Set<OWLPropertyReference> getTypes() {
        HashSet<OWLPropertyReference> hashSet = new HashSet<OWLPropertyReference>(this.superProperties);
        hashSet.add(this);
        return hashSet;
    }

    public String toString() {
        return this.getURI();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        P3OWLPropertyReference p3OWLPropertyReference = (P3OWLPropertyReference)object;
        return this.getURI() == p3OWLPropertyReference.getURI() || this.getURI() != null && this.getURI().equals(p3OWLPropertyReference.getURI());
    }

    public int hashCode() {
        int n = 767;
        return n += null == this.getURI() ? 0 : this.getURI().hashCode();
    }

    private void initialize() {
        this.domainClasses = new HashSet<OWLClassReference>();
        this.rangeClasses = new HashSet<OWLClassReference>();
        this.superProperties = new HashSet<OWLPropertyReference>();
        this.subProperties = new HashSet<OWLPropertyReference>();
        this.equivalentProperties = new HashSet<OWLPropertyReference>();
    }
}

