/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.portability.p3;

import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DataPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValueFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.bridge.ObjectPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLConversionFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.OWLDataValueImpl;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.SWRLClassAtomImpl;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDAnyURI;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDate;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDateTime;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDuration;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDTime;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLConceptReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDifferentIndividualsAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLEntityReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLLiteralReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLOntology;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSameIndividualAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSomeValuesFromReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSubClassAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLBuiltInAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLClassAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLDataPropertyAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLDataRangeAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLDifferentIndividualsAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLIndividualArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLObjectPropertyAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLSameIndividualAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLVariableReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLObjectPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLBuiltInAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLDataPropertyAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLDifferentIndividualsAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLObjectPropertyAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3SWRLSameIndividualAtomReference;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.DataValueConversionException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.DataValueImpl;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P3OWLOntology
implements OWLOntology {
    private OWLModel owlModel;
    private SWRLFactory swrlFactory;
    private OWLDataFactory owlFactory;
    private OWLDataValueFactory owlDataValueFactory;
    private ArgumentFactory argumentFactory;
    private Map<String, OWLClassReference> classes;
    private Map<String, OWLObjectPropertyReference> objectProperties;
    private Map<String, OWLDataPropertyReference> dataProperties;
    private Map<String, OWLNamedIndividualReference> individuals;

    public P3OWLOntology(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.owlFactory = new P3OWLDataFactory();
        this.swrlFactory = new SWRLFactory(oWLModel);
        this.argumentFactory = ArgumentFactory.getFactory();
        this.classes = new HashMap<String, OWLClassReference>();
        this.objectProperties = new HashMap<String, OWLObjectPropertyReference>();
        this.dataProperties = new HashMap<String, OWLDataPropertyReference>();
        this.individuals = new HashMap<String, OWLNamedIndividualReference>();
    }

    @Override
    public boolean containsClassInSignature(String string, boolean bl) {
        return SWRLOWLUtil.isOWLClass(this.owlModel, string);
    }

    @Override
    public boolean containsObjectPropertyInSignature(String string, boolean bl) {
        return SWRLOWLUtil.isOWLObjectProperty(this.owlModel, string);
    }

    @Override
    public boolean containsDataPropertyInSignature(String string, boolean bl) {
        return SWRLOWLUtil.isOWLDataProperty(this.owlModel, string);
    }

    @Override
    public boolean containsIndividualInSignature(String string, boolean bl) {
        return SWRLOWLUtil.isOWLIndividual(this.owlModel, string);
    }

    @Override
    public boolean isOWLNamedIndividualOfClass(String string, String string2) {
        return SWRLOWLUtil.isOWLIndividualOfType(this.owlModel, string, string2);
    }

    @Override
    public boolean isSWRLBuiltIn(String string) {
        return SWRLOWLUtil.isSWRLBuiltIn(this.owlModel, string);
    }

    @Override
    public String createNewResourceURI(String string) {
        return SWRLOWLUtil.createNewResourceName(this.owlModel, string);
    }

    @Override
    public Set<SWRLRuleReference> getSWRLRules() throws OWLConversionFactoryException, SQWRLException, BuiltInException {
        Collection<SWRLImp> collection = this.swrlFactory.getImps();
        HashSet<SWRLRuleReference> hashSet = new HashSet<SWRLRuleReference>();
        for (SWRLImp sWRLImp : collection) {
            if (!sWRLImp.isEnabled()) continue;
            SWRLRuleReference sWRLRuleReference = this.getSWRLRule(sWRLImp.getName());
            hashSet.add(sWRLRuleReference);
        }
        return hashSet;
    }

    @Override
    public SWRLRuleReference createSWRLRule(String string, String string2) throws OWLConversionFactoryException, SWRLParseException {
        this.swrlFactory.createImp(string, string2);
        return this.getSWRLRule(string);
    }

    @Override
    public SWRLRuleReference getSWRLRule(String string) throws OWLConversionFactoryException {
        ArrayList<SWRLAtomReference> arrayList = new ArrayList<SWRLAtomReference>();
        ArrayList<SWRLAtomReference> arrayList2 = new ArrayList<SWRLAtomReference>();
        SWRLImp sWRLImp = this.swrlFactory.getImp(string);
        if (sWRLImp == null) {
            throw new OWLConversionFactoryException("invalid rule name: " + string);
        }
        if (sWRLImp.getBody() != null && sWRLImp.getBody().getValues() != null && !sWRLImp.getBody().getValues().isEmpty()) {
            for (SWRLAtom sWRLAtom : sWRLImp.getBody().getValues()) {
                arrayList.add(this.convertSWRLAtom(sWRLAtom));
            }
        }
        if (sWRLImp.getHead() != null && sWRLImp.getHead().getValues() != null && !sWRLImp.getHead().getValues().isEmpty()) {
            for (SWRLAtom sWRLAtom : sWRLImp.getHead().getValues()) {
                arrayList2.add(this.convertSWRLAtom(sWRLAtom));
            }
        }
        return new P3SWRLRuleReference(sWRLImp.getPrefixedName(), arrayList, arrayList2);
    }

    @Override
    public void deleteSWRLRule(String string) throws OWLConversionFactoryException {
        this.swrlFactory.deleteImp(string);
    }

    @Override
    public OWLClassReference createOWLClass() {
        String string = SWRLOWLUtil.getNextAnonymousResourceName(this.owlModel);
        return new P3OWLClassReference(string);
    }

    @Override
    public OWLClassReference getOWLClass(String string) throws OWLConversionFactoryException {
        if (this.classes.containsKey(string)) {
            return this.classes.get(string);
        }
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.createOWLNamedClass(this.owlModel, string);
        P3OWLClassReference p3OWLClassReference = new P3OWLClassReference(string);
        this.classes.put(string, p3OWLClassReference);
        if (!string.equals(OWLNames.Cls.THING)) {
            for (String string2 : SWRLOWLUtil.rdfResources2OWLNamedClassURIs(oWLNamedClass.getNamedSuperclasses(false))) {
                p3OWLClassReference.addSuperClass(this.getOWLClass(string2));
            }
            for (String string2 : SWRLOWLUtil.rdfResources2OWLNamedClassURIs(oWLNamedClass.getNamedSubclasses(false))) {
                p3OWLClassReference.addSubClass(this.getOWLClass(string2));
            }
            for (String string2 : SWRLOWLUtil.rdfResources2OWLNamedClassNames(oWLNamedClass.getEquivalentClasses())) {
                p3OWLClassReference.addEquivalentClass(this.getOWLClass(string2));
            }
        }
        return p3OWLClassReference;
    }

    @Override
    public OWLNamedIndividualReference getOWLIndividual(String string) throws OWLConversionFactoryException {
        if (this.individuals.containsKey(string)) {
            return this.individuals.get(string);
        }
        OWLIndividual oWLIndividual = SWRLOWLUtil.createOWLIndividual(this.owlModel, string);
        P3OWLNamedIndividualReference p3OWLNamedIndividualReference = new P3OWLNamedIndividualReference(string);
        this.individuals.put(string, p3OWLNamedIndividualReference);
        this.buildDefiningClasses(p3OWLNamedIndividualReference, oWLIndividual);
        this.buildSameAsIndividuals(p3OWLNamedIndividualReference, oWLIndividual);
        this.buildDifferentFromIndividuals(p3OWLNamedIndividualReference, oWLIndividual);
        return p3OWLNamedIndividualReference;
    }

    @Override
    public OWLObjectPropertyReference getOWLObjectProperty(String string) throws OWLConversionFactoryException {
        if (this.objectProperties.containsKey(string)) {
            return this.objectProperties.get(string);
        }
        OWLObjectProperty oWLObjectProperty = SWRLOWLUtil.createOWLObjectProperty(this.owlModel, string);
        P3OWLObjectPropertyReference p3OWLObjectPropertyReference = new P3OWLObjectPropertyReference(string);
        this.objectProperties.put(string, p3OWLObjectPropertyReference);
        this.initializeProperty(p3OWLObjectPropertyReference, oWLObjectProperty);
        return p3OWLObjectPropertyReference;
    }

    @Override
    public OWLDataPropertyReference getOWLDataProperty(String string) throws OWLConversionFactoryException {
        if (this.dataProperties.containsKey(string)) {
            return this.dataProperties.get(string);
        }
        OWLDatatypeProperty oWLDatatypeProperty = SWRLOWLUtil.createOWLDatatypeProperty(this.owlModel, string);
        P3OWLDataPropertyReference p3OWLDataPropertyReference = new P3OWLDataPropertyReference(string);
        this.dataProperties.put(string, p3OWLDataPropertyReference);
        this.initializeProperty(p3OWLDataPropertyReference, oWLDatatypeProperty);
        return p3OWLDataPropertyReference;
    }

    @Override
    public void writeOWLClassDeclaration(OWLClassReference oWLClassReference) throws OWLConversionFactoryException {
        String string = oWLClassReference.getURI();
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.isOWLNamedClass(this.owlModel, string) ? SWRLOWLUtil.getOWLNamedClass(this.owlModel, string) : SWRLOWLUtil.getOWLNamedClass(this.owlModel, string);
        for (OWLClassReference oWLClassReference2 : oWLClassReference.getSuperClasses()) {
            String string2 = oWLClassReference2.getURI();
            OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.isOWLNamedClass(this.owlModel, string2) ? SWRLOWLUtil.getOWLNamedClass(this.owlModel, string2) : SWRLOWLUtil.getOWLNamedClass(this.owlModel, string2);
            if (oWLNamedClass.isSubclassOf(oWLNamedClass2)) continue;
            oWLNamedClass.addSuperclass(oWLNamedClass2);
        }
    }

    @Override
    public void writeOWLIndividualDeclaration(OWLNamedIndividualReference oWLNamedIndividualReference) throws OWLConversionFactoryException {
        String string = oWLNamedIndividualReference.getURI();
        OWLIndividual oWLIndividual = SWRLOWLUtil.isIndividual(this.owlModel, string) ? SWRLOWLUtil.getIndividual(this.owlModel, string) : SWRLOWLUtil.createIndividual(this.owlModel, string);
        for (OWLClassReference oWLClassReference : oWLNamedIndividualReference.getTypes()) {
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(this.owlModel, oWLClassReference.getURI());
            if (oWLIndividual.hasRDFType(oWLNamedClass)) continue;
            if (oWLIndividual.hasRDFType(SWRLOWLUtil.getOWLThingClass(this.owlModel))) {
                oWLIndividual.setRDFType(oWLNamedClass);
                continue;
            }
            oWLIndividual.addRDFType(oWLNamedClass);
        }
    }

    @Override
    public void writeOWLAxiom(OWLAxiomReference oWLAxiomReference) throws OWLConversionFactoryException {
        if (oWLAxiomReference instanceof OWLClassAssertionAxiomReference) {
            this.write2OWLModel((OWLClassAssertionAxiomReference)oWLAxiomReference);
        } else if (oWLAxiomReference instanceof OWLClassPropertyAssertionAxiomReference) {
            this.write2OWLModel((OWLClassPropertyAssertionAxiomReference)oWLAxiomReference);
        } else if (oWLAxiomReference instanceof OWLDataPropertyAssertionAxiomReference) {
            this.write2OWLModel((OWLDataPropertyAssertionAxiomReference)oWLAxiomReference);
        } else if (oWLAxiomReference instanceof OWLObjectPropertyAssertionAxiomReference) {
            this.write2OWLModel((OWLObjectPropertyAssertionAxiomReference)oWLAxiomReference);
        } else if (oWLAxiomReference instanceof OWLPropertyPropertyAssertionAxiomReference) {
            this.write2OWLModel((OWLPropertyPropertyAssertionAxiomReference)oWLAxiomReference);
        } else if (oWLAxiomReference instanceof OWLSomeValuesFromReference) {
            this.write2OWLModel((OWLSomeValuesFromReference)((Object)oWLAxiomReference));
        } else if (oWLAxiomReference instanceof OWLSubClassAxiomReference) {
            this.write2OWLModel((OWLSubClassAxiomReference)oWLAxiomReference);
        } else {
            throw new OWLConversionFactoryException("unsupported OWL axiom: " + oWLAxiomReference);
        }
    }

    @Override
    public boolean isValidURI(String string) {
        return SWRLOWLUtil.isValidURI(string);
    }

    @Override
    public Set<OWLNamedIndividualReference> getAllOWLIndividualsOfClass(String string) throws OWLConversionFactoryException {
        RDFSNamedClass rDFSNamedClass = SWRLOWLUtil.getRDFSNamedClass(this.owlModel, string);
        HashSet<OWLNamedIndividualReference> hashSet = new HashSet<OWLNamedIndividualReference>();
        if (rDFSNamedClass != null) {
            for (Object e : rDFSNamedClass.getInstances(true)) {
                if (!(e instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual = (OWLIndividual)e;
                hashSet.add(this.getOWLIndividual(oWLIndividual.getURI()));
            }
        }
        return hashSet;
    }

    @Override
    public boolean isOWLNamedClass(String string) {
        RDFResource rDFResource = SWRLOWLUtil.getRDFResource(this.owlModel, string);
        return rDFResource == null || rDFResource instanceof OWLNamedClass;
    }

    @Override
    public String uri2PrefixedName(String string) {
        return NamespaceUtil.getPrefixedName(this.owlModel, string);
    }

    @Override
    public String prefixedName2URI(String string) {
        return NamespaceUtil.getFullName(this.owlModel, string);
    }

    public static SWRLLiteralArgumentReference convertRDFSLiteral2DataValueArgument(OWLModel oWLModel, RDFSLiteral rDFSLiteral) throws OWLConversionFactoryException {
        P3SWRLLiteralArgumentReference p3SWRLLiteralArgumentReference;
        block15: {
            RDFSDatatype rDFSDatatype = rDFSLiteral.getDatatype();
            p3SWRLLiteralArgumentReference = null;
            try {
                if (rDFSDatatype == oWLModel.getXSDint() || rDFSDatatype == oWLModel.getXSDinteger()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getInt()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDshort()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getShort()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDlong()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getLong()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDboolean()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getBoolean()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDfloat()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getFloat()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdouble()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getDouble()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDstring()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDtime()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(new XSDTime(rDFSLiteral.getString())));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDanyURI()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(new XSDAnyURI(rDFSLiteral.getString())));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDbyte()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(Byte.valueOf(rDFSLiteral.getString())));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDduration()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(new XSDDuration(rDFSLiteral.getString())));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdateTime()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(new XSDDateTime(rDFSLiteral.getString())));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdate()) {
                    p3SWRLLiteralArgumentReference = new P3SWRLLiteralArgumentReference(new DataValueImpl(new XSDDate(rDFSLiteral.getString())));
                    break block15;
                }
                throw new OWLConversionFactoryException("cannot create an OWLDataValue object for RDFS literal " + rDFSLiteral.getString() + " of type " + rDFSDatatype);
            }
            catch (DataValueConversionException dataValueConversionException) {
                throw new OWLConversionFactoryException("error creating an OWLDataValue object for RDFS literal value " + rDFSLiteral.getString() + " with type " + rDFSDatatype.getURI() + ": " + dataValueConversionException.getMessage());
            }
        }
        return p3SWRLLiteralArgumentReference;
    }

    public static OWLLiteralReference convertRDFSLiteral2OWLLiteral(OWLModel oWLModel, RDFSLiteral rDFSLiteral) throws OWLConversionFactoryException {
        OWLDataValueImpl oWLDataValueImpl;
        block15: {
            RDFSDatatype rDFSDatatype = rDFSLiteral.getDatatype();
            oWLDataValueImpl = null;
            try {
                if (rDFSDatatype == oWLModel.getXSDint() || rDFSDatatype == oWLModel.getXSDinteger()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getInt());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDshort()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getShort());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDlong()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getLong());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDboolean()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getBoolean());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDfloat()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getFloat());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdouble()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getDouble());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDstring()) {
                    oWLDataValueImpl = new OWLDataValueImpl(rDFSLiteral.getString());
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDtime()) {
                    oWLDataValueImpl = new OWLDataValueImpl(new XSDTime(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDanyURI()) {
                    oWLDataValueImpl = new OWLDataValueImpl(new XSDAnyURI(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDbyte()) {
                    oWLDataValueImpl = new OWLDataValueImpl(Byte.valueOf(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDduration()) {
                    oWLDataValueImpl = new OWLDataValueImpl(new XSDDuration(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdateTime()) {
                    oWLDataValueImpl = new OWLDataValueImpl(new XSDDateTime(rDFSLiteral.getString()));
                    break block15;
                }
                if (rDFSDatatype == oWLModel.getXSDdate()) {
                    oWLDataValueImpl = new OWLDataValueImpl(new XSDDate(rDFSLiteral.getString()));
                    break block15;
                }
                throw new OWLConversionFactoryException("cannot create an OWLDataValue object for RDFS literal " + rDFSLiteral.getString() + " of type '" + rDFSDatatype);
            }
            catch (DataValueConversionException dataValueConversionException) {
                throw new OWLConversionFactoryException("error creating an OWLDataValue object for RDFS literal value " + rDFSLiteral.getString() + " with type " + rDFSDatatype.getURI() + ": " + dataValueConversionException.getMessage());
            }
        }
        return oWLDataValueImpl;
    }

    private SWRLClassAtomReference convertSWRLClassAtom(SWRLClassAtom sWRLClassAtom) throws OWLConversionFactoryException {
        String string = sWRLClassAtom.getClassPredicate() != null ? sWRLClassAtom.getClassPredicate().getURI() : null;
        SWRLClassAtomImpl sWRLClassAtomImpl = new SWRLClassAtomImpl(string);
        if (string == null) {
            throw new OWLConversionFactoryException("empty class name in SWRLClassAtom: " + sWRLClassAtom.getBrowserText());
        }
        sWRLClassAtomImpl.addReferencedClassURI(string);
        if (sWRLClassAtom.getArgument1() instanceof SWRLVariable) {
            SWRLVariable sWRLVariable = (SWRLVariable)sWRLClassAtom.getArgument1();
            SWRLVariableReference sWRLVariableReference = this.argumentFactory.createVariableArgument(sWRLVariable.getLocalName());
            sWRLClassAtomImpl.setArgument1(sWRLVariableReference);
            sWRLClassAtomImpl.addReferencedVariableName(sWRLVariable.getLocalName());
        } else if (sWRLClassAtom.getArgument1() instanceof OWLIndividual) {
            String string2 = ((OWLIndividual)sWRLClassAtom.getArgument1()).getURI();
            SWRLIndividualArgumentReference sWRLIndividualArgumentReference = this.argumentFactory.createIndividualArgument(string2);
            sWRLClassAtomImpl.setArgument1(sWRLIndividualArgumentReference);
            sWRLClassAtomImpl.addReferencedIndividualURI(sWRLIndividualArgumentReference.getURI());
        } else if (sWRLClassAtom.getArgument1() instanceof OWLNamedClass) {
            String string3 = ((OWLNamedClass)sWRLClassAtom.getArgument1()).getURI();
            ClassArgument classArgument = this.argumentFactory.createClassArgument(string3);
            sWRLClassAtomImpl.setArgument1(classArgument);
            sWRLClassAtomImpl.addReferencedClassURI(string);
        } else if (sWRLClassAtom.getArgument1() instanceof OWLObjectProperty) {
            String string4 = ((OWLObjectProperty)sWRLClassAtom.getArgument1()).getURI();
            ObjectPropertyArgument objectPropertyArgument = this.argumentFactory.createObjectPropertyArgument(string4);
            sWRLClassAtomImpl.setArgument1(objectPropertyArgument);
            sWRLClassAtomImpl.addReferencedPropertyURI(string4);
        } else if (sWRLClassAtom.getArgument1() instanceof OWLDatatypeProperty) {
            String string5 = ((OWLDatatypeProperty)sWRLClassAtom.getArgument1()).getURI();
            DataPropertyArgument dataPropertyArgument = this.argumentFactory.createDataPropertyArgument(string5);
            sWRLClassAtomImpl.setArgument1(dataPropertyArgument);
            sWRLClassAtomImpl.addReferencedPropertyURI(string5);
        } else {
            throw new OWLConversionFactoryException("unexpected argument to class atom " + sWRLClassAtom.getBrowserText() + "; expecting " + "variable or individual, got instance of " + sWRLClassAtom.getArgument1().getClass());
        }
        return sWRLClassAtomImpl;
    }

    private SWRLObjectPropertyAtomReference convertSWRLObjectPropertyAtom(SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom) throws OWLConversionFactoryException {
        SWRLArgumentReference sWRLArgumentReference;
        RDFResource rDFResource;
        String string = sWRLIndividualPropertyAtom.getPropertyPredicate() != null ? sWRLIndividualPropertyAtom.getPropertyPredicate().getURI() : null;
        P3OWLObjectPropertyReference p3OWLObjectPropertyReference = new P3OWLObjectPropertyReference(string);
        P3SWRLObjectPropertyAtomReference p3SWRLObjectPropertyAtomReference = new P3SWRLObjectPropertyAtomReference(p3OWLObjectPropertyReference);
        if (string == null) {
            throw new OWLConversionFactoryException("empty property name in SWRLIndividualPropertyAtom: " + sWRLIndividualPropertyAtom.getBrowserText());
        }
        p3SWRLObjectPropertyAtomReference.addReferencedPropertyURI(string);
        if (sWRLIndividualPropertyAtom.getArgument1() instanceof SWRLVariable) {
            rDFResource = (SWRLVariable)sWRLIndividualPropertyAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(rDFResource.getLocalName());
            p3SWRLObjectPropertyAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedVariableName(rDFResource.getLocalName());
        } else if (sWRLIndividualPropertyAtom.getArgument1() instanceof OWLIndividual) {
            rDFResource = (OWLIndividual)sWRLIndividualPropertyAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(rDFResource.getURI());
            p3SWRLObjectPropertyAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedIndividualURI(sWRLArgumentReference.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected first argument to individual property atom " + sWRLIndividualPropertyAtom.getBrowserText() + " - expecting variable or individual, got instance of " + sWRLIndividualPropertyAtom.getArgument1().getClass());
        }
        if (sWRLIndividualPropertyAtom.getArgument2() instanceof SWRLVariable) {
            rDFResource = (SWRLVariable)sWRLIndividualPropertyAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(rDFResource.getLocalName());
            p3SWRLObjectPropertyAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedVariableName(rDFResource.getLocalName());
        } else if (sWRLIndividualPropertyAtom.getArgument2() instanceof OWLIndividual) {
            rDFResource = (OWLIndividual)sWRLIndividualPropertyAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(rDFResource.getURI());
            p3SWRLObjectPropertyAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedIndividualURI(sWRLArgumentReference.getURI());
        } else if (sWRLIndividualPropertyAtom.getArgument2() instanceof OWLNamedClass) {
            rDFResource = (OWLNamedClass)sWRLIndividualPropertyAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createClassArgument(rDFResource.getURI());
            p3SWRLObjectPropertyAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedClassURI(sWRLArgumentReference.getURI());
        } else if (sWRLIndividualPropertyAtom.getArgument2() instanceof OWLProperty) {
            rDFResource = (OWLProperty)sWRLIndividualPropertyAtom.getArgument2();
            String string2 = ((OWLObjectProperty)rDFResource).getURI();
            sWRLArgumentReference = rDFResource.isObjectProperty() ? this.argumentFactory.createObjectPropertyArgument(string2) : this.argumentFactory.createDataPropertyArgument(string2);
            p3SWRLObjectPropertyAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLObjectPropertyAtomReference.addReferencedPropertyURI(string2);
        } else {
            throw new OWLConversionFactoryException("unexpected second argument to individual property atom " + sWRLIndividualPropertyAtom.getBrowserText() + " - expecting variable or individual, got instance of " + sWRLIndividualPropertyAtom.getArgument2().getClass());
        }
        return p3SWRLObjectPropertyAtomReference;
    }

    private SWRLDataPropertyAtomReference convertSWRLDataPropertyAtom(SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom) throws OWLConversionFactoryException {
        SWRLArgumentReference sWRLArgumentReference;
        Object object;
        String string = sWRLDatavaluedPropertyAtom.getPropertyPredicate() != null ? sWRLDatavaluedPropertyAtom.getPropertyPredicate().getURI() : null;
        P3OWLDataPropertyReference p3OWLDataPropertyReference = new P3OWLDataPropertyReference(string);
        P3SWRLDataPropertyAtomReference p3SWRLDataPropertyAtomReference = new P3SWRLDataPropertyAtomReference(p3OWLDataPropertyReference);
        if (string == null) {
            throw new OWLConversionFactoryException("empty property name in SWRLDatavaluedPropertyAtom: " + sWRLDatavaluedPropertyAtom.getBrowserText());
        }
        p3SWRLDataPropertyAtomReference.addReferencedPropertyURI(string);
        if (sWRLDatavaluedPropertyAtom.getArgument1() instanceof SWRLVariable) {
            object = (SWRLVariable)sWRLDatavaluedPropertyAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(object.getLocalName());
            p3SWRLDataPropertyAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLDataPropertyAtomReference.addReferencedVariableName(object.getLocalName());
        } else if (sWRLDatavaluedPropertyAtom.getArgument1() instanceof OWLIndividual) {
            object = (OWLIndividual)sWRLDatavaluedPropertyAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(object.getURI());
            p3SWRLDataPropertyAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLDataPropertyAtomReference.addReferencedIndividualURI(sWRLArgumentReference.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected argument first to datavalued property atom '" + sWRLDatavaluedPropertyAtom.getBrowserText() + "' - expecting variable or individual, got instance of " + sWRLDatavaluedPropertyAtom.getArgument1().getClass());
        }
        if (sWRLDatavaluedPropertyAtom.getArgument2() instanceof SWRLVariable) {
            object = (SWRLVariable)sWRLDatavaluedPropertyAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(object.getLocalName());
            p3SWRLDataPropertyAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLDataPropertyAtomReference.addReferencedVariableName(object.getLocalName());
        } else if (sWRLDatavaluedPropertyAtom.getArgument2() instanceof RDFSLiteral) {
            object = P3OWLOntology.convertRDFSLiteral2DataValueArgument(this.owlModel, (RDFSLiteral)sWRLDatavaluedPropertyAtom.getArgument2());
            p3SWRLDataPropertyAtomReference.setArgument2((SWRLArgumentReference)object);
        } else {
            throw new OWLConversionFactoryException("unexpected second to datavalued property atom " + sWRLDatavaluedPropertyAtom.getBrowserText() + " - expecting variable or literal, got instance of " + sWRLDatavaluedPropertyAtom.getArgument2().getClass());
        }
        return p3SWRLDataPropertyAtomReference;
    }

    private SWRLSameIndividualAtomReference convertSWRLSameIndividualAtom(SWRLSameIndividualAtom sWRLSameIndividualAtom) throws OWLConversionFactoryException {
        SWRLArgumentReference sWRLArgumentReference;
        OWLIndividual oWLIndividual;
        P3SWRLSameIndividualAtomReference p3SWRLSameIndividualAtomReference = new P3SWRLSameIndividualAtomReference();
        if (sWRLSameIndividualAtom.getArgument1() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLSameIndividualAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(oWLIndividual.getLocalName());
            p3SWRLSameIndividualAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLSameIndividualAtomReference.addReferencedVariableName(oWLIndividual.getLocalName());
        } else if (sWRLSameIndividualAtom.getArgument1() instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)sWRLSameIndividualAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(oWLIndividual.getURI());
            p3SWRLSameIndividualAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLSameIndividualAtomReference.addReferencedIndividualURI(oWLIndividual.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected first argument to atom '" + sWRLSameIndividualAtom.getBrowserText() + "' - expecting variable or individual, got instance of " + sWRLSameIndividualAtom.getArgument1().getClass() + ".");
        }
        if (sWRLSameIndividualAtom.getArgument2() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLSameIndividualAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(oWLIndividual.getLocalName());
            p3SWRLSameIndividualAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLSameIndividualAtomReference.addReferencedVariableName(oWLIndividual.getLocalName());
        } else if (sWRLSameIndividualAtom.getArgument2() instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)sWRLSameIndividualAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(oWLIndividual.getURI());
            p3SWRLSameIndividualAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLSameIndividualAtomReference.addReferencedIndividualURI(oWLIndividual.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected second argument to atom " + sWRLSameIndividualAtom.getBrowserText() + " - expecting variable or individual, got instance of " + sWRLSameIndividualAtom.getArgument2().getClass());
        }
        return p3SWRLSameIndividualAtomReference;
    }

    private SWRLDifferentIndividualsAtomReference convertDifferentIndividualsAtom(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) throws OWLConversionFactoryException {
        SWRLArgumentReference sWRLArgumentReference;
        OWLIndividual oWLIndividual;
        P3SWRLDifferentIndividualsAtomReference p3SWRLDifferentIndividualsAtomReference = new P3SWRLDifferentIndividualsAtomReference();
        if (sWRLDifferentIndividualsAtom.getArgument1() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLDifferentIndividualsAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(oWLIndividual.getLocalName());
            p3SWRLDifferentIndividualsAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLDifferentIndividualsAtomReference.addReferencedVariableName(oWLIndividual.getLocalName());
        } else if (sWRLDifferentIndividualsAtom.getArgument1() instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)sWRLDifferentIndividualsAtom.getArgument1();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(oWLIndividual.getURI());
            p3SWRLDifferentIndividualsAtomReference.setArgument1(sWRLArgumentReference);
            p3SWRLDifferentIndividualsAtomReference.addReferencedIndividualURI(oWLIndividual.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected first argument to atom " + sWRLDifferentIndividualsAtom.getBrowserText() + " - expecting variable or individual, got instance of " + sWRLDifferentIndividualsAtom.getArgument1().getClass());
        }
        if (sWRLDifferentIndividualsAtom.getArgument2() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLDifferentIndividualsAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createVariableArgument(oWLIndividual.getLocalName());
            p3SWRLDifferentIndividualsAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLDifferentIndividualsAtomReference.addReferencedVariableName(oWLIndividual.getLocalName());
        } else if (sWRLDifferentIndividualsAtom.getArgument2() instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)sWRLDifferentIndividualsAtom.getArgument2();
            sWRLArgumentReference = this.argumentFactory.createIndividualArgument(oWLIndividual.getURI());
            p3SWRLDifferentIndividualsAtomReference.setArgument2(sWRLArgumentReference);
            p3SWRLDifferentIndividualsAtomReference.addReferencedIndividualURI(oWLIndividual.getURI());
        } else {
            throw new OWLConversionFactoryException("unexpected second argument to atom " + sWRLDifferentIndividualsAtom.getBrowserText() + " - expecting variable or individual, got instance of " + sWRLDifferentIndividualsAtom.getArgument2().getClass());
        }
        return p3SWRLDifferentIndividualsAtomReference;
    }

    private SWRLBuiltInAtomReference convertSWRLBuiltInAtom(SWRLBuiltinAtom sWRLBuiltinAtom) throws OWLConversionFactoryException {
        String string = sWRLBuiltinAtom.getBuiltin() != null ? sWRLBuiltinAtom.getBuiltin().getURI() : null;
        String string2 = sWRLBuiltinAtom.getBuiltin() != null ? sWRLBuiltinAtom.getBuiltin().getPrefixedName() : null;
        P3SWRLBuiltInAtomReference p3SWRLBuiltInAtomReference = new P3SWRLBuiltInAtomReference(string, string2);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        RDFList rDFList = sWRLBuiltinAtom.getArguments();
        if (string == null) {
            throw new OWLConversionFactoryException("empty built-in name in SWRLBuiltinAtom: " + sWRLBuiltinAtom.getBrowserText());
        }
        for (Object e : rDFList.getValues()) {
            RDFResource rDFResource;
            if (e instanceof SWRLVariable) {
                rDFResource = (SWRLVariable)e;
                arrayList.add(this.argumentFactory.createVariableArgument(rDFResource.getLocalName()));
                p3SWRLBuiltInAtomReference.addReferencedVariableName(rDFResource.getLocalName());
                continue;
            }
            if (e instanceof OWLIndividual) {
                rDFResource = (OWLIndividual)e;
                arrayList.add(this.argumentFactory.createIndividualArgument(rDFResource.getURI()));
                p3SWRLBuiltInAtomReference.addReferencedIndividualURI(rDFResource.getURI());
                continue;
            }
            if (e instanceof OWLNamedClass) {
                rDFResource = (OWLNamedClass)e;
                arrayList.add(this.argumentFactory.createClassArgument(rDFResource.getURI()));
                p3SWRLBuiltInAtomReference.addReferencedClassURI(rDFResource.getURI());
                continue;
            }
            if (e instanceof OWLProperty) {
                rDFResource = (OWLProperty)e;
                String string3 = ((OWLObjectProperty)rDFResource).getURI();
                if (rDFResource.isObjectProperty()) {
                    arrayList.add(this.argumentFactory.createObjectPropertyArgument(string3));
                } else {
                    arrayList.add(this.argumentFactory.createDataPropertyArgument(string3));
                }
                p3SWRLBuiltInAtomReference.addReferencedPropertyURI(string3);
                continue;
            }
            if (e instanceof RDFSLiteral) {
                arrayList.add(P3OWLOntology.convertRDFSLiteral2DataValueArgument(this.owlModel, (RDFSLiteral)e));
                continue;
            }
            try {
                arrayList.add(this.argumentFactory.createDataValueArgument(e));
            }
            catch (DataValueConversionException dataValueConversionException) {
                throw new OWLConversionFactoryException("error converting argument to built-in " + string2 + " with value " + e + " of unknown type " + e.getClass() + ": " + dataValueConversionException.getMessage());
            }
        }
        p3SWRLBuiltInAtomReference.setBuiltInArguments(arrayList);
        return p3SWRLBuiltInAtomReference;
    }

    private void write2OWLModel(OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference) throws OWLConversionFactoryException {
        String string = oWLClassAssertionAxiomReference.getDescription().getURI();
        String string2 = oWLClassAssertionAxiomReference.getIndividual().getURI();
        SWRLOWLUtil.addType(this.owlModel, string2, string);
    }

    private void write2OWLModel(OWLClassPropertyAssertionAxiomReference oWLClassPropertyAssertionAxiomReference) throws OWLConversionFactoryException {
        String string = oWLClassPropertyAssertionAxiomReference.getProperty().getURI();
        String string2 = oWLClassPropertyAssertionAxiomReference.getSubject().getURI();
        String string3 = oWLClassPropertyAssertionAxiomReference.getObject().getURI();
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string);
        OWLNamedClass oWLNamedClass = null;
        if (oWLProperty == null) {
            throw new OWLConversionFactoryException("invalid property name: " + string);
        }
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(this.owlModel, string2);
        if (oWLIndividual == null) {
            throw new OWLConversionFactoryException("invalid individual URI " + string2);
        }
        oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(this.owlModel, string3);
        if (!oWLIndividual.hasPropertyValue(oWLProperty, oWLNamedClass, false)) {
            oWLIndividual.addPropertyValue(oWLProperty, oWLNamedClass);
        }
    }

    private void write2OWLModel(OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference) throws OWLConversionFactoryException {
        OWLDataValue oWLDataValue;
        String string = oWLDataPropertyAssertionAxiomReference.getProperty().getURI();
        String string2 = oWLDataPropertyAssertionAxiomReference.getSubject().getURI();
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string);
        if (oWLProperty == null) {
            throw new OWLConversionFactoryException("invalid property URI " + string);
        }
        RDFSDatatype rDFSDatatype = oWLProperty.getRangeDatatype();
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(this.owlModel, string2);
        if (oWLIndividual == null) {
            throw new OWLConversionFactoryException("invalid individual URI " + string2);
        }
        Object object = rDFSDatatype == null ? ((oWLDataValue = this.owlDataValueFactory.getOWLDataValue(oWLDataPropertyAssertionAxiomReference.getObject())).isString() ? ((Object)oWLDataValue).toString() : oWLDataPropertyAssertionAxiomReference.getObject().toString()) : this.owlModel.createRDFSLiteral(oWLDataPropertyAssertionAxiomReference.getObject().toString(), rDFSDatatype);
        if (!oWLIndividual.hasPropertyValue(oWLProperty, object, false)) {
            oWLIndividual.addPropertyValue(oWLProperty, object);
        }
    }

    private void write2OWLModel(OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference) throws OWLConversionFactoryException {
        String string = oWLObjectPropertyAssertionAxiomReference.getProperty().getURI();
        String string2 = oWLObjectPropertyAssertionAxiomReference.getSubject().getURI();
        String string3 = oWLObjectPropertyAssertionAxiomReference.getObject().getURI();
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string);
        if (oWLProperty == null) {
            throw new OWLConversionFactoryException("invalid property URI" + string);
        }
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(this.owlModel, string2);
        if (oWLIndividual == null) {
            throw new OWLConversionFactoryException("invalid subject individual URI " + string2);
        }
        OWLIndividual oWLIndividual2 = SWRLOWLUtil.getOWLIndividual(this.owlModel, string3);
        if (oWLIndividual2 == null) {
            throw new OWLConversionFactoryException("invalid object individual URI " + string3);
        }
        if (!oWLIndividual.hasPropertyValue(oWLProperty, oWLIndividual2, false)) {
            oWLIndividual.addPropertyValue(oWLProperty, oWLIndividual2);
        }
    }

    private void write2OWLModel(OWLPropertyPropertyAssertionAxiomReference oWLPropertyPropertyAssertionAxiomReference) throws OWLConversionFactoryException {
        String string = oWLPropertyPropertyAssertionAxiomReference.getProperty().getURI();
        String string2 = oWLPropertyPropertyAssertionAxiomReference.getSubject().getURI();
        String string3 = oWLPropertyPropertyAssertionAxiomReference.getObject().getURI();
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string);
        if (oWLProperty == null) {
            throw new OWLConversionFactoryException("invalid property URI " + string);
        }
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(this.owlModel, string2);
        if (oWLIndividual == null) {
            throw new OWLConversionFactoryException("invalid subject individual URI" + string2);
        }
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(this.owlModel, string3);
        if (oWLProperty2 == null) {
            throw new OWLConversionFactoryException("invalid object individual URI" + string3);
        }
        if (!oWLIndividual.hasPropertyValue(oWLProperty, oWLProperty2, false)) {
            oWLIndividual.addPropertyValue(oWLProperty, oWLProperty2);
        }
    }

    private void write2OWLModel(OWLSomeValuesFromReference oWLSomeValuesFromReference) throws OWLConversionFactoryException {
        OWLSomeValuesFrom oWLSomeValuesFrom = SWRLOWLUtil.getOWLSomeValuesFrom(this.owlModel, oWLSomeValuesFromReference.asOWLClass().getURI());
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, oWLSomeValuesFromReference.getProperty().getURI());
        OWLClass oWLClass = SWRLOWLUtil.getClass(this.owlModel, oWLSomeValuesFromReference.getSomeValuesFrom().getURI());
        oWLSomeValuesFrom.setOnProperty(oWLProperty);
        oWLSomeValuesFrom.setFiller(oWLClass);
    }

    private void write2OWLModel(OWLSubClassAxiomReference oWLSubClassAxiomReference) throws OWLConversionFactoryException {
        String string = oWLSubClassAxiomReference.getSubClass().getURI();
        String string2 = oWLSubClassAxiomReference.getSuperClass().getURI();
        SWRLOWLUtil.addOWLSuperClass(this.owlModel, string, string2);
    }

    private SWRLDataRangeAtomReference convertDataRangeAtom(SWRLDataRangeAtom sWRLDataRangeAtom) throws OWLConversionFactoryException {
        throw new OWLConversionFactoryException("SWRL data range atoms not implemented.");
    }

    private SWRLAtomReference convertSWRLAtom(SWRLAtom sWRLAtom) throws OWLConversionFactoryException {
        if (sWRLAtom instanceof SWRLClassAtom) {
            return this.convertSWRLClassAtom((SWRLClassAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLDatavaluedPropertyAtom) {
            return this.convertSWRLDataPropertyAtom((SWRLDatavaluedPropertyAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLIndividualPropertyAtom) {
            return this.convertSWRLObjectPropertyAtom((SWRLIndividualPropertyAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLSameIndividualAtom) {
            return this.convertSWRLSameIndividualAtom((SWRLSameIndividualAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLDifferentIndividualsAtom) {
            return this.convertDifferentIndividualsAtom((SWRLDifferentIndividualsAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLBuiltinAtom) {
            return this.convertSWRLBuiltInAtom((SWRLBuiltinAtom)sWRLAtom);
        }
        if (sWRLAtom instanceof SWRLDataRangeAtom) {
            return this.convertDataRangeAtom((SWRLDataRangeAtom)sWRLAtom);
        }
        throw new OWLConversionFactoryException("invalid SWRL atom: " + sWRLAtom.getBrowserText());
    }

    @Override
    public Set<OWLPropertyAssertionAxiomReference> getOWLPropertyAssertionAxioms(String string) throws OWLConversionFactoryException, DataValueConversionException {
        return this.getOWLPropertyAssertionAxioms(null, string);
    }

    private void calculateTransitiveSubAndEquivalentPropertyClosure(OWLProperty oWLProperty, Set<OWLProperty> set) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        hashSet.add(oWLProperty);
        this.calculateTransitiveSubAndEquivalentPropertyClosure(hashSet, set);
    }

    private void calculateTransitiveSubAndEquivalentPropertyClosure(Set<OWLProperty> set, Set<OWLProperty> set2) {
        for (OWLProperty oWLProperty : set) {
            if (set2.contains(oWLProperty)) continue;
            set2.add(oWLProperty);
            this.calculateTransitiveSubAndEquivalentPropertyClosure(SWRLOWLUtil.getSubPropertiesOf(this.owlModel, oWLProperty), set2);
            this.calculateTransitiveSubAndEquivalentPropertyClosure(SWRLOWLUtil.getEquivalentPropertiesOf(this.owlModel, oWLProperty), set2);
        }
    }

    @Override
    public Set<OWLPropertyAssertionAxiomReference> getOWLPropertyAssertionAxioms(String string, String string2) throws OWLConversionFactoryException, DataValueConversionException {
        HashSet<OWLPropertyAssertionAxiomReference> hashSet = new HashSet<OWLPropertyAssertionAxiomReference>();
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string2);
        OWLIndividual oWLIndividual = string == null ? null : SWRLOWLUtil.getOWLIndividual(this.owlModel, string);
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        HashSet<OWLProperty> hashSet2 = new HashSet<OWLProperty>();
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(string2);
        }
        this.calculateTransitiveSubAndEquivalentPropertyClosure(oWLProperty, hashSet2);
        for (TripleStore object : tripleStoreModel.getTripleStores()) {
            for (OWLProperty oWLProperty2 : hashSet2) {
                Iterator<RDFResource> iterator = object.listSubjects(oWLProperty2);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        for (RDFResource rDFResource : arrayList) {
            if (!(rDFResource instanceof OWLIndividual) || oWLIndividual != null && !rDFResource.getURI().equals(oWLIndividual.getURI())) continue;
            OWLIndividual oWLIndividual2 = (OWLIndividual)rDFResource;
            for (Iterator<RDFResource> iterator : rDFResource.getPropertyValues(oWLProperty, true)) {
                OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference;
                OWLEntityReference oWLEntityReference;
                OWLConceptReference oWLConceptReference;
                RDFObject rDFObject;
                OWLEntityReference oWLEntityReference2;
                if (oWLProperty.hasObjectRange()) {
                    oWLEntityReference2 = this.owlFactory.getOWLObjectProperty(string2);
                    if (iterator instanceof OWLIndividual) {
                        rDFObject = (OWLIndividual)((Object)iterator);
                        oWLConceptReference = this.owlFactory.getOWLIndividual(oWLIndividual2.getURI());
                        oWLEntityReference = this.owlFactory.getOWLIndividual(rDFObject.getURI());
                        oWLPropertyAssertionAxiomReference = this.owlFactory.getOWLObjectPropertyAssertionAxiom((OWLNamedIndividualReference)oWLConceptReference, (OWLPropertyReference)oWLEntityReference2, (OWLNamedIndividualReference)oWLEntityReference);
                        hashSet.add(oWLPropertyAssertionAxiomReference);
                        continue;
                    }
                    if (iterator instanceof OWLNamedClass) {
                        rDFObject = (OWLNamedClass)((Object)iterator);
                        oWLConceptReference = this.owlFactory.getOWLIndividual(oWLIndividual2.getURI());
                        oWLEntityReference = this.owlFactory.getOWLClass(rDFObject.getURI());
                        oWLPropertyAssertionAxiomReference = this.owlFactory.getOWLClassPropertyAssertionAxiom((OWLNamedIndividualReference)oWLConceptReference, (OWLPropertyReference)oWLEntityReference2, (OWLClassReference)oWLEntityReference);
                        hashSet.add(oWLPropertyAssertionAxiomReference);
                        continue;
                    }
                    if (!(iterator instanceof OWLProperty)) continue;
                    rDFObject = (OWLProperty)((Object)iterator);
                    oWLConceptReference = this.owlFactory.getOWLIndividual(oWLIndividual2.getURI());
                    oWLEntityReference = rDFObject.isObjectProperty() ? this.owlFactory.getOWLObjectProperty(rDFObject.getURI()) : this.owlFactory.getOWLDataProperty(rDFObject.getURI());
                    oWLPropertyAssertionAxiomReference = this.owlFactory.getOWLPropertyPropertyAssertionAxiom((OWLNamedIndividualReference)oWLConceptReference, (OWLPropertyReference)oWLEntityReference2, (OWLPropertyReference)oWLEntityReference);
                    hashSet.add(oWLPropertyAssertionAxiomReference);
                    continue;
                }
                oWLEntityReference2 = this.owlFactory.getOWLIndividual(oWLIndividual2.getURI());
                rDFObject = this.owlModel.asRDFSLiteral(iterator);
                oWLConceptReference = P3OWLOntology.convertRDFSLiteral2OWLLiteral(this.owlModel, (RDFSLiteral)rDFObject);
                oWLEntityReference = this.owlFactory.getOWLDataProperty(string2);
                oWLPropertyAssertionAxiomReference = this.owlFactory.getOWLDataPropertyAssertionAxiom((OWLNamedIndividualReference)oWLEntityReference2, (OWLPropertyReference)oWLEntityReference, (OWLLiteralReference)oWLConceptReference);
                hashSet.add(oWLPropertyAssertionAxiomReference);
            }
        }
        return hashSet;
    }

    @Override
    public Set<OWLSameIndividualAxiomReference> getSameIndividualAxioms() throws OWLConversionFactoryException {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLSameAsProperty(this.owlModel);
        HashSet<OWLSameIndividualAxiomReference> hashSet = new HashSet<OWLSameIndividualAxiomReference>();
        Iterator iterator = this.owlModel.listSubjects(rDFProperty);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof OWLIndividual)) continue;
            OWLIndividual oWLIndividual = (OWLIndividual)e;
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e2 : collection) {
                if (!(e2 instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual2 = (OWLIndividual)e2;
                hashSet.add(this.owlFactory.getOWLSameIndividualAxiom(this.owlFactory.getOWLIndividual(oWLIndividual.getURI()), this.owlFactory.getOWLIndividual(oWLIndividual2.getURI())));
            }
        }
        return hashSet;
    }

    @Override
    public Set<OWLDifferentIndividualsAxiomReference> getOWLDifferentIndividualsAxioms() throws OWLConversionFactoryException {
        Object object;
        Object object2;
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLDifferentFromProperty(this.owlModel);
        HashSet<OWLDifferentIndividualsAxiomReference> hashSet = new HashSet<OWLDifferentIndividualsAxiomReference>();
        Collection<OWLIndividual> collection = SWRLOWLUtil.getOWLAllDifferents(this.owlModel);
        Iterator iterator = this.owlModel.listSubjects(rDFProperty);
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            if (!(object3 instanceof OWLIndividual)) continue;
            OWLIndividual oWLIndividual = (OWLIndividual)object3;
            object2 = oWLIndividual.getPropertyValues(rDFProperty);
            object = object2.iterator();
            while (object.hasNext()) {
                Object object4 = object.next();
                if (!(object4 instanceof OWLIndividual)) continue;
                RDFIndividual rDFIndividual = (OWLIndividual)object4;
                hashSet.add(this.owlFactory.getOWLDifferentIndividualsAxiom(this.owlFactory.getOWLIndividual(oWLIndividual.getURI()), this.owlFactory.getOWLIndividual(rDFIndividual.getURI())));
            }
        }
        if (!collection.isEmpty()) {
            for (OWLIndividual oWLIndividual : collection) {
                if (oWLIndividual.getDistinctMembers().size() == 0) continue;
                object = new HashSet();
                for (RDFIndividual rDFIndividual : oWLIndividual.getDistinctMembers()) {
                    if (!(rDFIndividual instanceof OWLIndividual)) continue;
                    String string = rDFIndividual.getURI();
                    OWLNamedIndividualReference oWLNamedIndividualReference = this.owlFactory.getOWLIndividual(string);
                    object.add(oWLNamedIndividualReference);
                }
                object2 = this.owlFactory.getOWLDifferentIndividualsAxiom((Set<OWLNamedIndividualReference>)object);
                hashSet.add((OWLDifferentIndividualsAxiomReference)object2);
            }
        }
        return hashSet;
    }

    private void initializeProperty(P3OWLPropertyReference p3OWLPropertyReference, OWLProperty oWLProperty) throws OWLConversionFactoryException {
        for (String string : SWRLOWLUtil.rdfResources2OWLNamedClassURIs(oWLProperty.getUnionDomain())) {
            p3OWLPropertyReference.addDomainClass(this.getOWLClass(string));
        }
        for (String string : SWRLOWLUtil.rdfResources2OWLNamedClassURIs(oWLProperty.getUnionRangeClasses())) {
            p3OWLPropertyReference.addRangeClass(this.getOWLClass(string));
        }
        for (String string : SWRLOWLUtil.rdfResources2OWLPropertyURIs(oWLProperty.getSuperproperties(false))) {
            if (oWLProperty.isObjectProperty()) {
                p3OWLPropertyReference.addSuperProperty(this.getOWLObjectProperty(string));
                continue;
            }
            p3OWLPropertyReference.addSuperProperty(this.getOWLDataProperty(string));
        }
        for (String string : SWRLOWLUtil.rdfResources2OWLPropertyURIs(oWLProperty.getSubproperties(false))) {
            if (oWLProperty.isObjectProperty()) {
                p3OWLPropertyReference.addSubProperty(this.getOWLObjectProperty(string));
                continue;
            }
            p3OWLPropertyReference.addSubProperty(this.getOWLDataProperty(string));
        }
        for (String string : SWRLOWLUtil.rdfResources2OWLPropertyURIs(oWLProperty.getEquivalentProperties())) {
            if (oWLProperty.isObjectProperty()) {
                p3OWLPropertyReference.addEquivalentProperty(this.getOWLObjectProperty(string));
                continue;
            }
            p3OWLPropertyReference.addEquivalentProperty(this.getOWLDataProperty(string));
        }
    }

    private void buildDefiningClasses(P3OWLNamedIndividualReference p3OWLNamedIndividualReference, OWLIndividual oWLIndividual) throws OWLConversionFactoryException {
        for (Object e : oWLIndividual.getRDFTypes()) {
            RDFSClass rDFSClass = (RDFSClass)e;
            if (rDFSClass.isAnonymous() || !(rDFSClass instanceof OWLNamedClass)) continue;
            String string = ((OWLNamedClass)rDFSClass).getURI();
            p3OWLNamedIndividualReference.addType(this.getOWLClass(string));
        }
    }

    private void buildSameAsIndividuals(P3OWLNamedIndividualReference p3OWLNamedIndividualReference, OWLIndividual oWLIndividual) throws OWLConversionFactoryException {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLSameAsProperty(this.owlModel);
        if (oWLIndividual.hasPropertyValue(rDFProperty)) {
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e : collection) {
                if (!(e instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual2 = (OWLIndividual)e;
                p3OWLNamedIndividualReference.addSameAsIndividual(this.owlFactory.getOWLIndividual(oWLIndividual2.getURI()));
            }
        }
    }

    private void buildDifferentFromIndividuals(P3OWLNamedIndividualReference p3OWLNamedIndividualReference, OWLIndividual oWLIndividual) throws OWLConversionFactoryException {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLDifferentFromProperty(this.owlModel);
        if (oWLIndividual.hasPropertyValue(rDFProperty)) {
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e : collection) {
                if (!(e instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual2 = (OWLIndividual)e;
                p3OWLNamedIndividualReference.addDifferentFromIndividual(this.owlFactory.getOWLIndividual(oWLIndividual2.getURI()));
            }
        }
    }

    @Override
    public OWLModel getOWLModel() {
        return this.owlModel;
    }
}

