/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.parser;

import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLParser {
    public static final char AND_CHAR = '\u2227';
    public static final char IMP_CHAR = '\u2192';
    public static final char RING_CHAR = '\u02da';
    public static final String delimiters = " ?\n\t()[],\"'\u2227\u2192\u02da";
    private OWLModel owlModel;
    private SWRLFactory swrlFactory;
    private boolean parseOnly;
    private Tokenizer tokenizer;
    private Set<String> xmlSchemaSymbols = XMLSchemaDatatypes.getSlotSymbols();
    private Set<String> variables;
    private boolean inHead = false;
    private Map<String, RDFResource> cachedRDFResources;

    public SWRLParser(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.swrlFactory = new SWRLFactory(oWLModel);
        this.parseOnly = true;
        this.variables = new HashSet<String>();
        this.cachedRDFResources = new HashMap<String, RDFResource>();
    }

    public void setParseOnly(boolean bl) {
        this.parseOnly = bl;
    }

    public SWRLImp parse(String string) throws SWRLParseException {
        return this.parse(string, null);
    }

    public SWRLImp parse(String string, SWRLImp sWRLImp) throws SWRLParseException {
        SWRLAtomList sWRLAtomList = null;
        SWRLAtomList sWRLAtomList2 = null;
        SWRLAtom sWRLAtom = null;
        boolean bl = false;
        boolean bl2 = true;
        this.inHead = false;
        this.variables.clear();
        this.tokenizer = new Tokenizer(string.trim());
        if (!this.parseOnly) {
            sWRLAtomList = this.swrlFactory.createAtomList();
            sWRLAtomList.setInHead(true);
            sWRLAtomList2 = this.swrlFactory.createAtomList();
            sWRLAtomList.setInHead(false);
        }
        if (!this.parseOnly && !this.tokenizer.hasMoreTokens()) {
            throw new SWRLParseException("Empty rule.");
        }
        do {
            String string2 = bl2 ? (this.inHead ? "Expecting \u2227" : "Expecting \u2192 or \u2227 or \u02da.") : (this.inHead ? "Expecting atom." : "Expecting atom or \u2192.");
            String string3 = this.getNextNonSpaceToken(string2);
            if (string3.equals("\u2192") || string3.equals("->")) {
                if (this.inHead) {
                    throw new SWRLParseException("Second occurence of \u2192.");
                }
                this.inHead = true;
                bl2 = false;
                continue;
            }
            if (string3.equals("-")) continue;
            if (string3.equals("\u2227") || string3.equals("^")) {
                if (!bl2) {
                    throw new SWRLParseException("\u2227 may occur only after an atom.");
                }
                bl2 = false;
                continue;
            }
            if (string3.equals("\u02da") || string3.equals(".")) {
                if (this.inHead || !bl2) {
                    throw new SWRLParseException("\u02da may occur only in query body.");
                }
                bl2 = false;
                continue;
            }
            sWRLAtom = this.parseAtom(string3);
            bl = true;
            if (!this.parseOnly) {
                if (this.inHead) {
                    sWRLAtomList.append(sWRLAtom);
                } else {
                    sWRLAtomList2.append(sWRLAtom);
                }
            }
            bl2 = true;
        } while (this.tokenizer.hasMoreTokens());
        if (!this.parseOnly) {
            if (!bl) {
                throw new SWRLParseException("Incomplete rule - no antecedent or consequent.");
            }
            if (sWRLImp == null) {
                sWRLImp = this.swrlFactory.createImp(sWRLAtomList, sWRLAtomList2);
            } else {
                sWRLImp.setHead(sWRLAtomList);
                sWRLImp.setBody(sWRLAtomList2);
            }
        } else {
            sWRLImp = null;
        }
        return sWRLImp;
    }

    public boolean isCorrectAndIncomplete(String string) {
        boolean bl;
        boolean bl2;
        block2: {
            bl2 = this.parseOnly;
            bl = false;
            this.setParseOnly(true);
            try {
                this.parse(string);
            }
            catch (SWRLParseException sWRLParseException) {
                if (!(sWRLParseException instanceof SWRLIncompleteRuleException)) break block2;
                bl = true;
            }
        }
        this.setParseOnly(bl2);
        return bl;
    }

    private SWRLAtom parseAtom(String string) throws SWRLParseException {
        SWRLAtom sWRLAtom = null;
        List<RDFObject> list = null;
        boolean bl = false;
        if (string.startsWith("[")) {
            list = this.parseDObjectList();
            bl = true;
        }
        if (bl) {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for data range atom.");
        } else {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for atom " + string + ".");
        }
        if (bl) {
            sWRLAtom = this.parseEnumeratedListParameters(list);
        } else if (this.isSameAs(string)) {
            sWRLAtom = this.parseSameAsAtomParameters();
        } else if (this.isDifferentFrom(string)) {
            sWRLAtom = this.parseDifferentFromAtomParameters();
        } else if (this.isOWLClassName(string)) {
            sWRLAtom = this.parseClassAtomParameters(string);
        } else if (this.isOWLObjectPropertyName(string)) {
            sWRLAtom = this.parseIndividualPropertyAtomParameters(string);
        } else if (this.isOWLDatatypePropertyName(string)) {
            sWRLAtom = this.parseDatavaluedPropertyAtomParameters(string);
        } else if (this.isSWRLBuiltinName(string)) {
            sWRLAtom = this.parseBuiltinParameters(string);
        } else {
            throw new SWRLParseException("Invalid atom name " + string + ".");
        }
        return sWRLAtom;
    }

    private void checkAndSkipToken(String string, String string2) throws SWRLParseException {
        String string3 = this.getNextNonSpaceToken(string2);
        if (!string3.equalsIgnoreCase(string)) {
            throw new SWRLParseException("Expecting " + string + ", got " + string3 + "; " + string2);
        }
    }

    private String getNextStringToken(String string) throws SWRLParseException {
        String string2 = "";
        String string3 = "Incomplete rule. " + string;
        if (!this.tokenizer.hasMoreTokens()) {
            if (this.parseOnly) {
                throw new SWRLIncompleteRuleException(string3);
            }
            throw new SWRLParseException(string3);
        }
        if (this.tokenizer.hasMoreTokens()) {
            string2 = this.tokenizer.nextToken("\"");
            if (string2.equals("\"")) {
                string2 = "";
            } else {
                this.checkAndSkipToken("\"", "Expected \" to close string.");
            }
            return string2;
        }
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(string3);
        }
        throw new SWRLParseException(string3);
    }

    private String getNextNonSpaceToken(String string) throws SWRLParseException {
        String string2 = "";
        String string3 = "Incomplete rule. " + string;
        if (!this.tokenizer.hasMoreTokens()) {
            if (this.parseOnly) {
                throw new SWRLIncompleteRuleException(string3);
            }
            throw new SWRLParseException(string3);
        }
        while (this.tokenizer.hasMoreTokens()) {
            string2 = this.tokenizer.nextToken();
            if (string2.equals(" ") || string2.equals("\n") || string2.equals("\t")) continue;
            return string2;
        }
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(string3);
        }
        throw new SWRLParseException(string3);
    }

    private SWRLAtom parseSameAsAtomParameters() throws SWRLParseException {
        SWRLSameIndividualAtom sWRLSameIndividualAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for SameAsAtom.");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            sWRLSameIndividualAtom = this.swrlFactory.createSameIndividualAtom(rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameters in SameAsAtom");
        return sWRLSameIndividualAtom;
    }

    private SWRLAtom parseDifferentFromAtomParameters() throws SWRLParseException {
        SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameters for DifferentFromAtom");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            sWRLDifferentIndividualsAtom = this.swrlFactory.createDifferentIndividualsAtom(rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Only two parameters allowed for DifferentFromAtom");
        return sWRLDifferentIndividualsAtom;
    }

    private SWRLAtom parseClassAtomParameters(String string) throws SWRLParseException {
        SWRLClassAtom sWRLClassAtom = null;
        RDFResource rDFResource = this.parseIObject();
        if (!this.parseOnly) {
            OWLNamedClass oWLNamedClass = ParserUtils.getOWLClassFromName(this.owlModel, string);
            sWRLClassAtom = this.swrlFactory.createClassAtom(oWLNamedClass, rDFResource);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis for parameter for ClassAtom '" + string + "'.");
        return sWRLClassAtom;
    }

    private SWRLAtom parseIndividualPropertyAtomParameters(String string) throws SWRLParseException {
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for IndividualPropertyAtom '" + string + "'");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            OWLObjectProperty oWLObjectProperty = ParserUtils.getOWLObjectPropertyFromName(this.owlModel, string);
            if (oWLObjectProperty == null) {
                throw new SWRLParseException("no datatype property found for IndividualPropertyAtom: " + string);
            }
            sWRLIndividualPropertyAtom = this.swrlFactory.createIndividualPropertyAtom(oWLObjectProperty, rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of IndividualPropertyAtom '" + string + "'.");
        return sWRLIndividualPropertyAtom;
    }

    private SWRLAtom parseDatavaluedPropertyAtomParameters(String string) throws SWRLParseException {
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = null;
        String string2 = "Expecting literal qualification symbol '#' or closing parenthesis after second parameter of DatavaluedPropertyAtom' ";
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for DatavaluedPropertyAtom '" + string + "'.");
        RDFObject rDFObject = this.parseDObject();
        String string3 = this.getNextNonSpaceToken(string2 + string + "'.");
        if (string3.equals("#")) {
            string3 = this.getNextNonSpaceToken("Expecting XML Schema datatype.");
            if (this.tokenizer.hasMoreTokens() && !this.isXSDDatatype(string3)) {
                throw new SWRLParseException("Invalid XML Schema datatype name: '" + string3 + "'.");
            }
            if (!this.parseOnly) {
                rDFObject = this.owlModel.createRDFSLiteral(rDFObject.getBrowserText(), string3);
            }
            this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of DatavaluedPropertyAtom");
        } else if (!string3.equals(")")) {
            throw new SWRLParseException(string2 + string + "'.");
        }
        if (!this.parseOnly) {
            OWLDatatypeProperty oWLDatatypeProperty = ParserUtils.getOWLDatatypePropertyFromName(this.owlModel, string);
            sWRLDatavaluedPropertyAtom = this.swrlFactory.createDatavaluedPropertyAtom(oWLDatatypeProperty, rDFResource, rDFObject);
        }
        return sWRLDatavaluedPropertyAtom;
    }

    private SWRLAtom parseBuiltinParameters(String string) throws SWRLParseException {
        SWRLBuiltinAtom sWRLBuiltinAtom = null;
        List<RDFObject> list = this.parseObjectList();
        if (!this.parseOnly) {
            SWRLBuiltin sWRLBuiltin = this.swrlFactory.getBuiltin(NamespaceUtil.getFullName(this.owlModel, string));
            sWRLBuiltinAtom = this.swrlFactory.createBuiltinAtom(sWRLBuiltin, list.iterator());
        }
        return sWRLBuiltinAtom;
    }

    private SWRLAtom parseEnumeratedListParameters(List<RDFObject> list) throws SWRLParseException {
        SWRLDataRangeAtom sWRLDataRangeAtom = null;
        RDFObject rDFObject = this.parseDObject();
        if (!this.parseOnly) {
            OWLDataRange oWLDataRange = this.owlModel.createOWLDataRange();
            RDFProperty rDFProperty = this.owlModel.getOWLOneOfProperty();
            for (RDFObject rDFObject2 : list) {
                oWLDataRange.addPropertyValue(rDFProperty, rDFObject2);
            }
            sWRLDataRangeAtom = this.swrlFactory.createDataRangeAtom(oWLDataRange, rDFObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after parameter in DataRangeAtom.");
        return sWRLDataRangeAtom;
    }

    private List<RDFObject> parseDObjectList() throws SWRLParseException {
        ArrayList<RDFObject> arrayList = null;
        if (!this.parseOnly) {
            arrayList = new ArrayList<RDFObject>();
        }
        RDFObject rDFObject = this.parseDObject();
        if (!this.parseOnly) {
            arrayList.add(rDFObject);
        }
        String string = this.getNextNonSpaceToken("Expecting additional comma-separated variables or literals or closing parenthesis.");
        while (string.equals(",")) {
            rDFObject = this.parseDObject();
            if (!this.parseOnly) {
                arrayList.add(rDFObject);
            }
            if ((string = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || string.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + string + "'.");
        }
        return arrayList;
    }

    private List<RDFObject> parseObjectList() throws SWRLParseException {
        ArrayList<RDFObject> arrayList = null;
        if (!this.parseOnly) {
            arrayList = new ArrayList<RDFObject>();
        }
        RDFObject rDFObject = this.parseObject();
        if (!this.parseOnly) {
            arrayList.add(rDFObject);
        }
        String string = this.getNextNonSpaceToken("Expecting additional comma-separated variables, literals or individual names or closing parenthesis.");
        while (string.equals(",")) {
            rDFObject = this.parseObject();
            if (!this.parseOnly) {
                arrayList.add(rDFObject);
            }
            if ((string = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || string.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + string + "'.");
        }
        return arrayList;
    }

    private RDFObject parseObject() throws SWRLParseException {
        RDFObject rDFObject = null;
        String string = this.getNextNonSpaceToken("Expecting variable or individual name or literal.");
        if (string.equals("?")) {
            rDFObject = this.parseVariable();
        } else if (this.isValidIndividualName(string)) {
            if (!this.parseOnly) {
                rDFObject = this.getOWLIndividual(string);
            }
        } else if (this.isValidOWLNamedClassName(string)) {
            if (!this.parseOnly) {
                rDFObject = this.getOWLNamedClass(string);
            }
        } else if (this.isValidOWLPropertyName(string)) {
            if (!this.parseOnly) {
                rDFObject = this.getOWLProperty(string);
            }
        } else {
            rDFObject = this.parseLiteral(string);
        }
        return rDFObject;
    }

    private RDFResource parseIObject() throws SWRLParseException {
        RDFResource rDFResource = null;
        String string = this.getNextNonSpaceToken("Expecting variable or individual name.");
        if (string.equals("?")) {
            rDFResource = this.parseVariable();
        } else if (this.isValidIndividualName(string)) {
            if (!this.parseOnly) {
                rDFResource = this.getOWLIndividual(string);
            }
        } else if (this.isValidOWLNamedClassName(string)) {
            if (!this.parseOnly) {
                rDFResource = this.getOWLNamedClass(string);
            }
        } else if (this.isValidOWLPropertyName(string)) {
            if (!this.parseOnly) {
                rDFResource = this.getOWLProperty(string);
            }
        } else if (this.tokenizer.hasMoreTokens()) {
            throw new SWRLParseException("Invalid entity name: '" + string + "'.");
        }
        return rDFResource;
    }

    private RDFObject parseDObject() throws SWRLParseException {
        RDFObject rDFObject = null;
        String string = this.getNextNonSpaceToken("Expecting variable or literal.");
        rDFObject = string.equals("?") ? this.parseVariable() : this.parseLiteral(string);
        return rDFObject;
    }

    private RDFResource parseVariable() throws SWRLParseException {
        SWRLVariable sWRLVariable = null;
        String string = this.getNextNonSpaceToken("Expected variable name");
        this.checkThatVariableNameIsValid(string);
        if (this.tokenizer.hasMoreTokens()) {
            if (!this.inHead) {
                this.variables.add(string);
            } else if (!this.variables.contains(string)) {
                throw new SWRLParseException("Variable ?" + string + " referred to in consequent is not present in antecedent.");
            }
        }
        if (!this.parseOnly) {
            sWRLVariable = this.getSWRLVariable(string);
        }
        return sWRLVariable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RDFObject parseLiteral(String string) throws SWRLParseException {
        RDFSLiteral rDFSLiteral = null;
        if (string.equals("\"")) {
            String string2 = this.getNextStringToken("Expected a string.");
            if (this.parseOnly) return rDFSLiteral;
            return this.owlModel.createRDFSLiteral(string2, this.owlModel.getXSDstring());
        }
        if (string.startsWith("t") || string.startsWith("T") || string.startsWith("f") || string.startsWith("F")) {
            if (!this.tokenizer.hasMoreTokens()) return rDFSLiteral;
            if (!string.equalsIgnoreCase("true")) {
                if (!string.equalsIgnoreCase("false")) throw new SWRLParseException("Invalid literal " + string + ".");
            }
            if (this.parseOnly) return rDFSLiteral;
            return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDboolean());
        }
        try {
            if (string.contains(".")) {
                Double.parseDouble(string);
                if (this.parseOnly) return rDFSLiteral;
                return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDdouble());
            }
            Long.parseLong(string);
            if (this.parseOnly) return rDFSLiteral;
            return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDlong());
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = "Invalid literal " + string + ".";
            if (!this.parseOnly) throw new SWRLParseException(string3);
            throw new SWRLIncompleteRuleException(string3);
        }
    }

    private boolean isSameAs(String string) throws SWRLParseException {
        return string.equalsIgnoreCase("sameAs");
    }

    private boolean isDifferentFrom(String string) throws SWRLParseException {
        return string.equalsIgnoreCase("differentFrom");
    }

    private boolean isXSDDatatype(String string) throws SWRLParseException {
        return string.startsWith("xsd:") && this.xmlSchemaSymbols.contains(string.substring(4));
    }

    private void checkThatIdentifierIsValid(String string) throws SWRLParseException {
        if (!this.isValidIdentifier(string)) {
            throw new SWRLParseException("Invalid identifier " + string + ".");
        }
    }

    private boolean isValidIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0)) && string.charAt(0) != ':') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == ':' || c == '-' || c == '#' || c == '/' || c == '.') continue;
            return false;
        }
        return true;
    }

    private void checkThatVariableNameIsValid(String string) throws SWRLParseException {
        this.checkThatIdentifierIsValid(string);
        RDFResource rDFResource = this.getRDFResource(string);
        if (rDFResource != null && !(rDFResource instanceof SWRLVariable)) {
            throw new SWRLParseException("Invalid variable name " + string + ". Cannot use name of existing OWL class, property, or individual.");
        }
    }

    private boolean isOWLClassName(String string) throws SWRLParseException {
        return ParserUtils.getOWLClassFromName(this.owlModel, string) != null;
    }

    private boolean isOWLObjectPropertyName(String string) throws SWRLParseException {
        return ParserUtils.getOWLObjectPropertyFromName(this.owlModel, string) != null;
    }

    private boolean isOWLDatatypePropertyName(String string) throws SWRLParseException {
        return ParserUtils.getOWLDatatypePropertyFromName(this.owlModel, string) != null;
    }

    private boolean isSWRLBuiltinName(String string) throws SWRLParseException {
        RDFResource rDFResource = this.getRDFResource(string);
        return rDFResource != null && rDFResource.getProtegeType().getName().equals(SWRLNames.Cls.BUILTIN);
    }

    private boolean isValidIndividualName(String string) throws SWRLParseException {
        try {
            return ParserUtils.getOWLIndividualFromName(this.owlModel, string) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isValidOWLNamedClassName(String string) throws SWRLParseException {
        try {
            RDFResource rDFResource = this.getRDFResource(string);
            if (rDFResource == null) {
                return false;
            }
            return rDFResource instanceof OWLNamedClass;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isValidOWLPropertyName(String string) throws SWRLParseException {
        try {
            RDFResource rDFResource = this.getRDFResource(string);
            if (rDFResource == null) {
                return false;
            }
            return rDFResource instanceof OWLProperty;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private OWLIndividual getOWLIndividual(String string) throws SWRLParseException {
        OWLIndividual oWLIndividual = ParserUtils.getOWLIndividualFromName(this.owlModel, string);
        if (oWLIndividual == null) {
            throw new SWRLParseException(string + " is not a valid individual name");
        }
        return oWLIndividual;
    }

    private OWLNamedClass getOWLNamedClass(String string) throws SWRLParseException {
        OWLNamedClass oWLNamedClass = ParserUtils.getOWLClassFromName(this.owlModel, string);
        if (oWLNamedClass == null) {
            throw new SWRLParseException(string + " is not a valid class name");
        }
        return oWLNamedClass;
    }

    private OWLProperty getOWLProperty(String string) throws SWRLParseException {
        RDFProperty rDFProperty = ParserUtils.getRDFPropertyFromName(this.owlModel, string);
        if (rDFProperty == null || !(rDFProperty instanceof OWLProperty)) {
            throw new SWRLParseException(string + " is not a valid property name");
        }
        return (OWLProperty)rDFProperty;
    }

    private SWRLVariable getSWRLVariable(String string) throws SWRLParseException {
        RDFResource rDFResource = this.owlModel.getRDFResource(NamespaceUtil.getFullName(this.owlModel, string));
        if (rDFResource instanceof SWRLVariable) {
            return (SWRLVariable)rDFResource;
        }
        if (rDFResource == null) {
            return this.swrlFactory.createVariable(NamespaceUtil.getFullName(this.owlModel, string));
        }
        throw new SWRLParseException(string + " cannot be used as a variable name");
    }

    private RDFResource getRDFResource(String string) {
        RDFResource rDFResource;
        if (this.parseOnly) {
            if (this.cachedRDFResources.containsKey(string)) {
                rDFResource = this.cachedRDFResources.get(string);
            } else {
                rDFResource = ParserUtils.getRDFResourceFromName(this.owlModel, string);
                this.cachedRDFResources.put(string, rDFResource);
            }
        } else {
            rDFResource = ParserUtils.getRDFResourceFromName(this.owlModel, string);
        }
        return rDFResource;
    }

    private static class Tokenizer {
        private StringTokenizer internalTokenizer;

        public Tokenizer(String string) {
            this.internalTokenizer = new StringTokenizer(string, SWRLParser.delimiters, true);
        }

        public boolean hasMoreTokens() {
            return this.internalTokenizer.hasMoreTokens();
        }

        public String nextToken(String string) {
            return this.internalTokenizer.nextToken(string);
        }

        public String nextToken() throws NoSuchElementException {
            String string = this.internalTokenizer.nextToken(SWRLParser.delimiters);
            if (!string.equals("'")) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (this.internalTokenizer.hasMoreTokens() && !(string = this.internalTokenizer.nextToken()).equals("'")) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

