/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.impl.AbstractSWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.impl.SWRLUtil;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSWRLImp
extends AbstractSWRLIndividual
implements SWRLImp {
    private transient Logger log = Log.getLogger(DefaultSWRLImp.class);
    public static final String EMPTY_RULE_TEXT = "<EMPTY_RULE>";
    private boolean isRuleEnabled = true;
    private Map<String, Boolean> ruleGroups;

    public DefaultSWRLImp(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultSWRLImp() {
    }

    private void updateEnabledAndGroupInformation() {
        this.isRuleEnabled = this.getIsRuleEnabledAnnotation();
        this.ruleGroups = this.getRuleGroupAnnotations();
    }

    @Override
    public SWRLImp createClone() {
        String string = this.getBrowserText();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        SWRLParser sWRLParser = new SWRLParser(oWLModel);
        sWRLParser.setParseOnly(false);
        try {
            return sWRLParser.parse(string);
        }
        catch (SWRLParseException sWRLParseException) {
            this.log.log(Level.SEVERE, "Shouldn't Happen ", sWRLParseException);
            return null;
        }
    }

    private boolean getIsRuleEnabledAnnotation() {
        OWLDatatypeProperty oWLDatatypeProperty = this.getRuleEnabledProperty();
        if (oWLDatatypeProperty == null) {
            return true;
        }
        Object object = this.getPropertyValue(oWLDatatypeProperty);
        if (object == null) {
            return true;
        }
        if (!(object instanceof Boolean)) {
            return true;
        }
        return (Boolean)object;
    }

    private Map<String, Boolean> getRuleGroupAnnotations() {
        Collection collection;
        OWLObjectProperty oWLObjectProperty = this.getRuleGroupProperty();
        OWLDatatypeProperty oWLDatatypeProperty = this.getRuleGroupEnabledProperty();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (oWLObjectProperty != null && oWLDatatypeProperty != null && (collection = this.getPropertyValues(oWLObjectProperty)) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Boolean bl = Boolean.TRUE;
                OWLIndividual oWLIndividual = (OWLIndividual)iterator.next();
                Object object = oWLIndividual.getPropertyValue(oWLDatatypeProperty);
                if (object != null) {
                    bl = (Boolean)object;
                }
                hashMap.put(oWLIndividual.getLocalName(), bl);
            }
        }
        return hashMap;
    }

    private void deleteHeadAndBody() {
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-INSTANCES");
        Set<RDFResource> set = this.getReferencedInstances();
        for (RDFResource rDFResource : set) {
            SWRLIndividual sWRLIndividual;
            if (!(rDFResource instanceof SWRLIndividual) || rDFResource instanceof SWRLBuiltin || (sWRLIndividual = (SWRLIndividual)rDFResource).isDeleted()) continue;
            Collection collection = this.getKnowledgeBase().getReferences((Object)sWRLIndividual, -1);
            boolean bl = false;
            for (Reference reference : collection) {
                Frame frame;
                if (slot.equals(reference.getSlot()) || set.contains(frame = reference.getFrame()) || this.equals(frame)) continue;
                bl = true;
            }
            if (bl) continue;
            sWRLIndividual.delete();
        }
    }

    @Override
    public void deleteImp() {
        this.deleteHeadAndBody();
        this.delete();
    }

    @Override
    public SWRLAtomList getHead() {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFProperty(SWRLNames.Slot.HEAD));
        SWRLAtomList sWRLAtomList = null;
        if (object instanceof SWRLAtomList) {
            sWRLAtomList = (SWRLAtomList)object;
        } else if (object instanceof RDFList) {
            ((RDFList)object).setRDFType(this.getOWLModel().getSystemFrames().getAtomListCls());
            sWRLAtomList = (SWRLAtomList)this.getOWLModel().getFrame(((RDFList)object).getName());
        }
        if (sWRLAtomList != null) {
            sWRLAtomList.setInHead(true);
        }
        return sWRLAtomList;
    }

    @Override
    public SWRLAtomList getBody() {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFProperty(SWRLNames.Slot.BODY));
        SWRLAtomList sWRLAtomList = null;
        if (object instanceof SWRLAtomList) {
            sWRLAtomList = (SWRLAtomList)object;
        } else if (object instanceof RDFList) {
            ((RDFList)object).setRDFType(this.getOWLModel().getSystemFrames().getAtomListCls());
            sWRLAtomList = (SWRLAtomList)this.getOWLModel().getFrame(((RDFList)object).getName());
            return sWRLAtomList;
        }
        if (sWRLAtomList != null) {
            sWRLAtomList.setInHead(false);
        }
        return sWRLAtomList;
    }

    @Override
    public void setBody(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty(SWRLNames.Slot.BODY), sWRLAtomList);
    }

    @Override
    public void setHead(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty(SWRLNames.Slot.HEAD), sWRLAtomList);
    }

    @Override
    public Icon getIcon() {
        return this.isEditable() ? SWRLIcons.getImpIcon() : OWLIcons.getReadOnlyIcon(SWRLIcons.getImpIcon(), "RoundedBoxFrame");
    }

    @Override
    public Set<RDFResource> getReferencedInstances() {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        this.getReferencedInstances(hashSet);
        return hashSet;
    }

    @Override
    public void getReferencedInstances(Set<RDFResource> set) {
        SWRLAtomList sWRLAtomList;
        SWRLAtomList sWRLAtomList2 = this.getHead();
        if (sWRLAtomList2 != null) {
            set.add(sWRLAtomList2);
            sWRLAtomList2.getReferencedInstances(set);
        }
        if ((sWRLAtomList = this.getBody()) != null) {
            set.add(sWRLAtomList);
            sWRLAtomList.getReferencedInstances(set);
        }
    }

    @Override
    public String getBrowserText() {
        SWRLAtomList sWRLAtomList = this.getBody();
        SWRLAtomList sWRLAtomList2 = this.getHead();
        String string = "";
        if (sWRLAtomList2 == null && sWRLAtomList == null) {
            string = string + EMPTY_RULE_TEXT;
        } else {
            string = string + SWRLUtil.getSWRLBrowserText(sWRLAtomList, "BODY");
            string = string + " \u2192 ";
            string = string + SWRLUtil.getSWRLBrowserText(sWRLAtomList2, "HEAD");
        }
        return string;
    }

    @Override
    public void setExpression(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.getOWLModel());
        sWRLParser.parse(string);
        this.deleteHeadAndBody();
        sWRLParser.setParseOnly(false);
        sWRLParser.parse(string, this);
    }

    @Override
    public boolean isEnabled() {
        this.updateEnabledAndGroupInformation();
        return this.isRuleEnabled;
    }

    @Override
    public void enable() {
        this.enable(new HashSet<String>());
    }

    @Override
    public void enable(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enable(hashSet);
    }

    @Override
    public void enable(Set<String> set) {
        this.updateEnabledAndGroupInformation();
        if (set.isEmpty()) {
            OWLDatatypeProperty oWLDatatypeProperty = this.getRuleEnabledProperty();
            if (oWLDatatypeProperty != null) {
                this.setPropertyValue(oWLDatatypeProperty, Boolean.TRUE);
            }
            this.isRuleEnabled = true;
        } else {
            OWLObjectProperty oWLObjectProperty = this.getRuleGroupProperty();
            OWLDatatypeProperty oWLDatatypeProperty = this.getRuleGroupEnabledProperty();
            for (String string : set) {
                OWLIndividual oWLIndividual = this.getOWLModel().getOWLIndividual(string);
                if (oWLIndividual != null && oWLObjectProperty != null) {
                    this.addPropertyValue(oWLObjectProperty, oWLIndividual);
                    oWLIndividual.addPropertyValue(oWLDatatypeProperty, Boolean.TRUE);
                }
                this.ruleGroups.put(string, Boolean.TRUE);
            }
        }
    }

    @Override
    public void disable() {
        this.disable(new HashSet<String>());
    }

    @Override
    public void disable(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.disable(hashSet);
    }

    @Override
    public void disable(Set<String> set) {
        this.updateEnabledAndGroupInformation();
        if (set.isEmpty()) {
            OWLDatatypeProperty oWLDatatypeProperty = this.getRuleEnabledProperty();
            if (oWLDatatypeProperty != null) {
                this.setPropertyValue(oWLDatatypeProperty, Boolean.FALSE);
            }
            this.isRuleEnabled = false;
        } else {
            OWLObjectProperty oWLObjectProperty = this.getRuleGroupProperty();
            OWLDatatypeProperty oWLDatatypeProperty = this.getRuleGroupEnabledProperty();
            for (String string : set) {
                OWLIndividual oWLIndividual = this.getOWLModel().getOWLIndividual(string);
                if (oWLIndividual != null && oWLObjectProperty != null) {
                    this.addPropertyValue(oWLObjectProperty, oWLIndividual);
                    oWLIndividual.addPropertyValue(oWLDatatypeProperty, Boolean.FALSE);
                }
                this.ruleGroups.put(string, Boolean.FALSE);
            }
        }
    }

    @Override
    public Set<String> getRuleGroupNames() {
        this.updateEnabledAndGroupInformation();
        return this.ruleGroups.keySet();
    }

    @Override
    public boolean isInRuleGroup(String string) {
        this.updateEnabledAndGroupInformation();
        return this.ruleGroups.containsKey(string);
    }

    @Override
    public boolean isInRuleGroups(Set<String> set) {
        this.updateEnabledAndGroupInformation();
        for (String string : set) {
            if (!this.ruleGroups.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRuleGroup(String string) {
        OWLNamedClass oWLNamedClass = this.getRuleGroupClass();
        OWLObjectProperty oWLObjectProperty = this.getRuleGroupProperty();
        OWLDatatypeProperty oWLDatatypeProperty = this.getRuleGroupEnabledProperty();
        this.updateEnabledAndGroupInformation();
        boolean bl = false;
        if (this.isInRuleGroup(string)) {
            return true;
        }
        if (oWLNamedClass != null) {
            OWLIndividual oWLIndividual = this.getOWLModel().getOWLIndividual(string);
            if (oWLIndividual == null) {
                oWLIndividual = oWLNamedClass.createOWLIndividual(string);
            }
            if (oWLIndividual != null && oWLObjectProperty != null) {
                this.addPropertyValue(oWLObjectProperty, oWLIndividual);
                oWLIndividual.addPropertyValue(oWLDatatypeProperty, Boolean.TRUE);
                this.ruleGroups.put(string, Boolean.TRUE);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeRuleGroup(String string) {
        OWLIndividual oWLIndividual;
        OWLNamedClass oWLNamedClass = this.getRuleGroupClass();
        OWLObjectProperty oWLObjectProperty = this.getRuleGroupProperty();
        this.updateEnabledAndGroupInformation();
        boolean bl = false;
        if (!this.isInRuleGroup(string)) {
            return true;
        }
        if (oWLNamedClass != null && (oWLIndividual = this.getOWLModel().getOWLIndividual(string)) != null && oWLObjectProperty != null) {
            this.removePropertyValue(oWLObjectProperty, oWLIndividual);
            this.ruleGroups.remove(string);
            bl = true;
        }
        return bl;
    }

    private OWLDatatypeProperty getRuleEnabledProperty() {
        return this.getOWLModel().getOWLDatatypeProperty(SWRLNames.Annotations.IS_RULE_ENABLED);
    }

    private OWLDatatypeProperty getRuleGroupEnabledProperty() {
        return this.getOWLModel().getOWLDatatypeProperty(SWRLNames.Annotations.IS_RULE_GROUP_ENABLED);
    }

    private OWLObjectProperty getRuleGroupProperty() {
        return this.getOWLModel().getOWLObjectProperty(SWRLNames.Annotations.HAS_RULE_GROUP);
    }

    private OWLNamedClass getRuleGroupClass() {
        return this.getOWLModel().getOWLNamedClass(SWRLNames.Annotations.RULE_GROUP);
    }
}

