/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.impl.SWRLUtil;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSWRLAtomList
extends DefaultRDFList
implements SWRLAtomList {
    private boolean isInHead = false;

    public DefaultSWRLAtomList(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultSWRLAtomList() {
    }

    @Override
    public void setInHead(boolean bl) {
        this.isInHead = bl;
    }

    @Override
    public String getBrowserText() {
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (this.isInHead) {
            string = string + "\n";
        }
        if (this.getValues() != null) {
            for (Instance instance : this.getValues()) {
                String string2 = SWRLUtil.getSWRLBrowserText((RDFObject)instance, "ATOM");
                int n2 = string2.length();
                if (instance instanceof SWRLBuiltinAtom) {
                    SWRLBuiltin sWRLBuiltin = ((SWRLBuiltinAtom)instance).getBuiltin();
                    if (sWRLBuiltin == null) {
                        string = string + "\n<DELETED_BUILTIN>\n";
                        n = 0;
                    } else {
                        String string3 = sWRLBuiltin.getName();
                        if (!this.isInHead && (SQWRLNames.isSQWRLCollectionMakeBuiltIn(string3) || SQWRLNames.isSQWRLCollectionGroupByBuiltIn(string3)) && !bl2) {
                            bl2 = true;
                            if (n + 2 >= 120) {
                                string = string + "\n\u02da  ";
                                n = 2;
                            } else {
                                string = string + " \u02da \n";
                                n = 0;
                            }
                            if (n + n2 >= 120) {
                                string = string + "\n";
                                n = n2;
                            } else {
                                n += n2;
                            }
                            string = string + string2;
                        } else if (!this.isInHead && SQWRLNames.getCollectionOperationBuiltInNames().contains(string3) && !bl3 && bl) {
                            bl3 = true;
                            if (n + 2 >= 120) {
                                string = string + "\n\u02da  ";
                                n = 3;
                            } else {
                                string = string + " \u02da \n";
                                n = 0;
                            }
                            if (n + n2 >= 120) {
                                string = string + "\n";
                                n = n2;
                            } else {
                                n += n2;
                            }
                            string = string + string2;
                        } else {
                            if (bl) {
                                if (n + 2 >= 120) {
                                    string = string + "\n\u2227  ";
                                    n = 2;
                                } else {
                                    string = string + " \u2227 ";
                                    n += 3;
                                }
                            }
                            if (n + n2 >= 120) {
                                string = string + "\n";
                                n = n2;
                            } else {
                                n += n2;
                            }
                            string = string + string2;
                        }
                    }
                } else {
                    if (bl) {
                        if (n + 2 >= 120) {
                            string = string + "\n\u2227  ";
                            n = 2;
                        } else {
                            string = string + " \u2227 ";
                            n += 3;
                        }
                    }
                    if (n + n2 >= 120) {
                        string = string + "\n";
                        n = n2;
                    } else {
                        n += n2;
                    }
                    string = string + string2;
                }
                bl = true;
            }
        } else {
            string = string + "<DELETED_ATOM_LIST>";
        }
        return string;
    }

    @Override
    public void getReferencedInstances(Set<RDFResource> set) {
        OWLModel oWLModel = this.getOWLModel();
        for (RDFList rDFList = this; rDFList != null && !rDFList.equals(oWLModel.getRDFNil()); rDFList = rDFList.getRest()) {
            set.add(rDFList);
            Object object = rDFList.getFirst();
            if (!(object instanceof SWRLIndividual)) continue;
            SWRLIndividual sWRLIndividual = (SWRLIndividual)object;
            set.add(sWRLIndividual);
            sWRLIndividual.getReferencedInstances(set);
        }
    }

    @Override
    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitSWRLAtomListIndividual(this);
    }
}

