/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLFrameTypeId;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLJavaFactory
extends OWLJavaFactory {
    private OWLModel owlModel;
    private HashMap<String, Class<? extends SimpleInstance>> classMap = new HashMap();

    public SWRLJavaFactory(OWLModel oWLModel) {
        super((AbstractOWLModel)oWLModel);
        this.owlModel = oWLModel;
        for (SWRLFrameTypeId sWRLFrameTypeId : SWRLFrameTypeId.values()) {
            this.classMap.put(sWRLFrameTypeId.getProtegeName(), sWRLFrameTypeId.getJavaClass());
        }
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
        Cls cls;
        Class<? extends SimpleInstance> clazz;
        Object[] objectArray = new Object[]{this.owlModel, frameID};
        if (collection.size() == 1 && (clazz = this.getJavaTypeFromSWRLType(cls = (Cls)collection.iterator().next())) != null) {
            try {
                Constructor<? extends SimpleInstance> constructor = clazz.getConstructor(KnowledgeBase.class, FrameID.class);
                return constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                System.err.println("Fatal Error: Could not create SimpleInstance from OWL metaclass " + clazz.getName());
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                return new DefaultSimpleInstance((KnowledgeBase)this.owlModel, frameID);
            }
        }
        return super.createSimpleInstance(frameID, collection);
    }

    private Class<? extends SimpleInstance> getJavaTypeFromSWRLType(Cls cls) {
        String string = cls.getName();
        Class<? extends SimpleInstance> clazz = this.classMap.get(string);
        if (clazz == null) {
            Iterator iterator = cls.getSuperclasses().iterator();
            while (clazz == null && iterator.hasNext()) {
                Frame frame = (Frame)iterator.next();
                clazz = this.classMap.get(frame.getName());
            }
        }
        return clazz;
    }

    @Override
    public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
        for (Object e : collection) {
            if (!(e instanceof Cls) || this.getJavaTypeFromSWRLType((Cls)e) == null) continue;
            return false;
        }
        return super.isCorrectJavaImplementationClass(frameID, collection, clazz);
    }

    @Override
    public Frame createFrameFromClassId(int n, FrameID frameID) {
        if (n >= 42 && n <= SWRLFrameTypeId.SWRL_FRAME_TYPE_ID_END) {
            int n2 = n - 42;
            SWRLFrameTypeId sWRLFrameTypeId = SWRLFrameTypeId.values()[n2];
            Instance instance = this.createInstance(frameID, sWRLFrameTypeId.getJavaClass());
            if (instance != null) {
                return instance;
            }
        }
        return super.createFrameFromClassId(n, frameID);
    }

    @Override
    public int getJavaClassId(Frame frame) {
        for (SWRLFrameTypeId sWRLFrameTypeId : SWRLFrameTypeId.values()) {
            try {
                Class<? extends SimpleInstance> clazz = sWRLFrameTypeId.getJavaClass();
                if (!clazz.isInstance(frame)) continue;
                return sWRLFrameTypeId.getFrameTypeId();
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at getting the Java class Id for: " + frame, exception);
            }
        }
        return super.getJavaClassId(frame);
    }
}

