/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLFactory {
    private OWLModel owlModel;
    private SWRLSystemFrames systemFrames;

    public SWRLFactory(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.systemFrames = oWLModel.getSystemFrames();
    }

    public SWRLImp createImp() {
        String string = this.getNewImpName();
        return (SWRLImp)this.systemFrames.getImpCls().createInstance(string);
    }

    public SWRLImp createImpWithGivenName(String string) {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass(SWRLNames.Cls.IMP);
        return (SWRLImp)rDFSNamedClass.createInstance(string);
    }

    public SWRLImp createImp(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.owlModel);
        sWRLParser.setParseOnly(false);
        return sWRLParser.parse(string);
    }

    public SWRLImp createImp(String string, String string2) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.owlModel);
        SWRLImp sWRLImp = this.createImpWithGivenName(string);
        sWRLParser.setParseOnly(false);
        return sWRLParser.parse(string2, sWRLImp);
    }

    public SWRLImp createImp(SWRLAtom sWRLAtom, List<SWRLAtom> list) {
        SWRLAtomList sWRLAtomList = this.createAtomList(Collections.singleton(sWRLAtom));
        SWRLAtomList sWRLAtomList2 = this.createAtomList(list);
        return this.createImp(sWRLAtomList, sWRLAtomList2);
    }

    public SWRLImp createImp(SWRLAtomList sWRLAtomList, SWRLAtomList sWRLAtomList2) {
        SWRLImp sWRLImp = this.createImp();
        sWRLImp.setHead(sWRLAtomList);
        sWRLImp.setBody(sWRLAtomList2);
        sWRLAtomList.setInHead(true);
        sWRLAtomList.setInHead(false);
        return sWRLImp;
    }

    public SWRLAtomList createAtomList() {
        return (SWRLAtomList)this.systemFrames.getAtomListCls().createAnonymousInstance();
    }

    public SWRLAtomList createAtomList(Collection<SWRLAtom> collection) {
        SWRLAtomList sWRLAtomList = this.createAtomList();
        for (SWRLAtom sWRLAtom : collection) {
            sWRLAtomList.append(sWRLAtom);
        }
        return sWRLAtomList;
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, Iterator<RDFObject> iterator) {
        RDFList rDFList = this.owlModel.createRDFList(iterator);
        return this.createBuiltinAtom(sWRLBuiltin, rDFList);
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, RDFList rDFList) {
        SWRLBuiltinAtom sWRLBuiltinAtom = (SWRLBuiltinAtom)this.systemFrames.getBuiltinAtomCls().createAnonymousInstance();
        sWRLBuiltinAtom.setBuiltin(sWRLBuiltin);
        sWRLBuiltinAtom.setArguments(rDFList);
        return sWRLBuiltinAtom;
    }

    public SWRLClassAtom createClassAtom(RDFSNamedClass rDFSNamedClass, RDFResource rDFResource) {
        SWRLClassAtom sWRLClassAtom = (SWRLClassAtom)this.systemFrames.getClassAtomCls().createAnonymousInstance();
        sWRLClassAtom.setClassPredicate(rDFSNamedClass);
        sWRLClassAtom.setArgument1(rDFResource);
        return sWRLClassAtom;
    }

    public SWRLDataRangeAtom createDataRangeAtom(OWLDataRange oWLDataRange, RDFObject rDFObject) {
        SWRLDataRangeAtom sWRLDataRangeAtom = (SWRLDataRangeAtom)this.systemFrames.getDataRangeAtomCls().createAnonymousInstance();
        sWRLDataRangeAtom.setArgument1(rDFObject);
        sWRLDataRangeAtom.setDataRange(oWLDataRange);
        return sWRLDataRangeAtom;
    }

    public SWRLDatavaluedPropertyAtom createDatavaluedPropertyAtom(OWLDatatypeProperty oWLDatatypeProperty, RDFResource rDFResource, RDFObject rDFObject) {
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = (SWRLDatavaluedPropertyAtom)this.systemFrames.getDataValuedPropertyAtomCls().createAnonymousInstance();
        sWRLDatavaluedPropertyAtom.setPropertyPredicate(oWLDatatypeProperty);
        sWRLDatavaluedPropertyAtom.setArgument1(rDFResource);
        sWRLDatavaluedPropertyAtom.setArgument2(rDFObject);
        return sWRLDatavaluedPropertyAtom;
    }

    public SWRLIndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty oWLObjectProperty, RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = (SWRLIndividualPropertyAtom)this.systemFrames.getIndividualPropertyAtomCls().createAnonymousInstance();
        sWRLIndividualPropertyAtom.setPropertyPredicate(oWLObjectProperty);
        sWRLIndividualPropertyAtom.setArgument1(rDFResource);
        sWRLIndividualPropertyAtom.setArgument2(rDFResource2);
        return sWRLIndividualPropertyAtom;
    }

    public SWRLDifferentIndividualsAtom createDifferentIndividualsAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = (SWRLDifferentIndividualsAtom)this.systemFrames.getDifferentIndividualsAtomCls().createAnonymousInstance();
        sWRLDifferentIndividualsAtom.setArgument1(rDFResource);
        sWRLDifferentIndividualsAtom.setArgument2(rDFResource2);
        return sWRLDifferentIndividualsAtom;
    }

    public SWRLSameIndividualAtom createSameIndividualAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLSameIndividualAtom sWRLSameIndividualAtom = (SWRLSameIndividualAtom)this.systemFrames.getSameIndividualAtomCls().createAnonymousInstance();
        sWRLSameIndividualAtom.setArgument1(rDFResource);
        sWRLSameIndividualAtom.setArgument2(rDFResource2);
        return sWRLSameIndividualAtom;
    }

    public SWRLVariable createVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFSNamedClass(SWRLNames.Cls.VARIABLE).createInstance(string);
    }

    public SWRLBuiltin createBuiltin(String string) {
        return (SWRLBuiltin)this.owlModel.getRDFSNamedClass(SWRLNames.Cls.BUILTIN).createInstance(string);
    }

    public SWRLBuiltin getBuiltin(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource instanceof SWRLBuiltin) {
            return (SWRLBuiltin)rDFResource;
        }
        System.err.println("[SWRLFactory]  Invalid attempt to cast " + string + " into SWRLBuiltin (real type is " + rDFResource.getProtegeType() + ")");
        return null;
    }

    public Collection<SWRLBuiltin> getBuiltins() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass(SWRLNames.Cls.BUILTIN);
        HashSet<SWRLBuiltin> hashSet = new HashSet<SWRLBuiltin>();
        for (Object e : rDFSNamedClass.getInstances(true)) {
            if (!(e instanceof SWRLBuiltin)) continue;
            hashSet.add((SWRLBuiltin)e);
        }
        return hashSet;
    }

    public Collection<SWRLImp> getImps() {
        HashSet<SWRLImp> hashSet = new HashSet<SWRLImp>();
        for (Object e : this.systemFrames.getImpCls().getInstances(true)) {
            if (!(e instanceof SWRLImp)) continue;
            hashSet.add((SWRLImp)e);
        }
        return hashSet;
    }

    public Collection<SWRLImp> getEnabledImps() {
        return this.getImps(new HashSet<String>(), true);
    }

    public Collection<SWRLImp> getEnabledImps(Set<String> set) {
        return this.getImps(set, true);
    }

    public Collection<SWRLImp> getEnabledImps(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.getImps(hashSet, true);
    }

    private Collection<SWRLImp> getImps(Set<String> set, boolean bl) {
        ArrayList<SWRLImp> arrayList = new ArrayList<SWRLImp>();
        Collection<SWRLImp> collection = this.getImps();
        if (collection != null) {
            for (SWRLImp sWRLImp : collection) {
                if (!set.isEmpty() && !sWRLImp.isInRuleGroups(set) || sWRLImp.isEnabled() != bl) continue;
                arrayList.add(sWRLImp);
            }
        }
        return arrayList;
    }

    public void deleteImps() {
        for (SWRLImp sWRLImp : this.getImps()) {
            sWRLImp.deleteImp();
        }
    }

    public void deleteImp(String string) throws SWRLFactoryException {
        this.getImp(string).deleteImp();
    }

    public void replaceImps(OWLModel oWLModel) throws SWRLFactoryException {
        this.deleteImps();
        this.copyImps(oWLModel);
    }

    public void copyImps(OWLModel oWLModel) throws SWRLFactoryException {
        SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
        Iterator<SWRLImp> iterator = sWRLFactory.getImps().iterator();
        while (iterator.hasNext()) {
            SWRLImp sWRLImp;
            SWRLImp sWRLImp2 = sWRLImp = iterator.next();
            String string = sWRLImp2.getLocalName();
            String string2 = sWRLImp2.getBrowserText();
            if (this.hasImp(string)) {
                throw new SWRLFactoryException("attempt to copy rule '" + string + "' that has same name as an existing rule");
            }
            try {
                this.createImp(string, string2);
            }
            catch (SWRLParseException sWRLParseException) {
                throw new SWRLFactoryException("error copying rule '" + string + "': " + sWRLParseException.getMessage());
            }
        }
    }

    public SWRLImp getImp(String string) throws SWRLFactoryException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        SWRLImp sWRLImp = null;
        if (!(rDFResource instanceof SWRLImp) && rDFResource != null) {
            throw new SWRLFactoryException("invalid attempt to cast " + string + " into SWRLImp (real type is " + rDFResource.getProtegeType() + ")");
        }
        sWRLImp = (SWRLImp)rDFResource;
        return sWRLImp;
    }

    public boolean hasImp(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        return rDFResource != null && rDFResource instanceof SWRLImp;
    }

    public String getNewImpName() {
        String string = this.owlModel.getNamespaceManager().getDefaultNamespace();
        String string2 = string + "Rule-";
        int n = Math.max(1, this.systemFrames.getImpCls().getInstances(false).size());
        while (this.owlModel.getRDFResource(string2 + n) != null) {
            ++n;
        }
        return string2 + n;
    }

    public SWRLVariable getVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFResource(string);
    }

    public Collection<SWRLVariable> getVariables() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass(SWRLNames.Cls.VARIABLE);
        HashSet<SWRLVariable> hashSet = new HashSet<SWRLVariable>();
        for (Object e : rDFSNamedClass.getInstances(true)) {
            if (!(e instanceof SWRLVariable)) continue;
            hashSet.add((SWRLVariable)e);
        }
        return hashSet;
    }

    public Collection<SWRLImp> getReferencedImps(RDFResource rDFResource) {
        ArrayList<SWRLImp> arrayList = new ArrayList<SWRLImp>();
        if (rDFResource != null) {
            for (SWRLImp sWRLImp : this.getImps()) {
                Set<RDFResource> set = sWRLImp.getReferencedInstances();
                if (!set.contains(rDFResource) || arrayList.contains(sWRLImp)) continue;
                arrayList.add(sWRLImp);
            }
        }
        return arrayList;
    }

    public void enableAll() {
        this.enableStatusUpdate(new HashSet<String>(), true);
    }

    public void disableAll() {
        this.enableStatusUpdate(new HashSet<String>(), false);
    }

    public void enableAll(Set<String> set) {
        this.enableStatusUpdate(set, true);
    }

    public void disableAll(Set<String> set) {
        this.enableStatusUpdate(set, false);
    }

    public void enableAll(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enableStatusUpdate(hashSet, true);
    }

    public void disableAll(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enableStatusUpdate(hashSet, false);
    }

    public static boolean isSWRLFilteredResource(RDFResource rDFResource) {
        return rDFResource instanceof SWRLAtomList || rDFResource instanceof SWRLBuiltinAtom || rDFResource instanceof SWRLClassAtom || rDFResource instanceof SWRLDataRangeAtom || rDFResource instanceof SWRLDatavaluedPropertyAtom || rDFResource instanceof SWRLDifferentIndividualsAtom || rDFResource instanceof SWRLImp || rDFResource instanceof SWRLIndividualPropertyAtom || rDFResource instanceof SWRLSameIndividualAtom || rDFResource instanceof SWRLAtom || rDFResource instanceof SWRLVariable;
    }

    public static boolean isSWRLResource(RDFResource rDFResource) {
        return rDFResource instanceof SWRLAtomList || rDFResource instanceof SWRLBuiltinAtom || rDFResource instanceof SWRLClassAtom || rDFResource instanceof SWRLDataRangeAtom || rDFResource instanceof SWRLDatavaluedPropertyAtom || rDFResource instanceof SWRLDifferentIndividualsAtom || rDFResource instanceof SWRLImp || rDFResource instanceof SWRLIndividualPropertyAtom || rDFResource instanceof SWRLSameIndividualAtom || rDFResource instanceof SWRLBuiltin || rDFResource instanceof SWRLAtom || rDFResource instanceof SWRLVariable;
    }

    private void enableStatusUpdate(Set<String> set, boolean bl) {
        for (SWRLImp sWRLImp : this.getImps()) {
            if (!set.isEmpty() && !sWRLImp.isInRuleGroups(set)) continue;
            if (bl) {
                sWRLImp.enable();
                continue;
            }
            sWRLImp.disable();
        }
    }

    public Collection<RDFSNamedClass> getSWRLClasses() {
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>();
        arrayList.add(this.systemFrames.getAtomListCls());
        arrayList.add(this.systemFrames.getBuiltinAtomCls());
        arrayList.add(this.systemFrames.getClassAtomCls());
        arrayList.add(this.systemFrames.getDataRangeAtomCls());
        arrayList.add(this.systemFrames.getDataValuedPropertyAtomCls());
        arrayList.add(this.systemFrames.getDifferentIndividualsAtomCls());
        arrayList.add(this.systemFrames.getImpCls());
        arrayList.add(this.systemFrames.getIndividualPropertyAtomCls());
        arrayList.add(this.systemFrames.getSameIndividualAtomCls());
        arrayList.add(this.systemFrames.getBuiltInCls());
        arrayList.add(this.systemFrames.getAtomCls());
        arrayList.add(this.systemFrames.getVariableCls());
        return arrayList;
    }

    public Collection<RDFProperty> getSWRLProperties() {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        arrayList.add(this.systemFrames.getBodyProperty());
        arrayList.add(this.systemFrames.getHeadProperty());
        arrayList.add(this.systemFrames.getArgumentsProperty());
        arrayList.add(this.systemFrames.getBuiltInProperty());
        arrayList.add(this.systemFrames.getArgument1Property());
        arrayList.add(this.systemFrames.getArgument2Property());
        arrayList.add(this.systemFrames.getClassPredicateProperty());
        arrayList.add(this.systemFrames.getPropertyPredicateProperty());
        arrayList.add(this.systemFrames.getDataRangeProperty());
        return arrayList;
    }

    public Collection<RDFProperty> getSWRLBProperties() {
        RDFProperty rDFProperty;
        RDFProperty rDFProperty2;
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        RDFProperty rDFProperty3 = this.owlModel.getRDFProperty(SWRLNames.Slot.ARGS);
        if (rDFProperty3 != null) {
            arrayList.add(rDFProperty3);
        }
        if ((rDFProperty2 = this.owlModel.getRDFProperty(SWRLNames.Slot.MIN_ARGS)) != null) {
            arrayList.add(rDFProperty2);
        }
        if ((rDFProperty = this.owlModel.getRDFProperty(SWRLNames.Slot.MAX_ARGS)) != null) {
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    public boolean areImpsEqual(SWRLImp sWRLImp, SWRLImp sWRLImp2) {
        Iterator<SWRLAtom> iterator;
        Iterator<SWRLAtom> iterator2 = sWRLImp.getBody().getValues().iterator();
        if (!this.areAtomListsEqual(iterator2, iterator = sWRLImp2.getBody().getValues().iterator())) {
            return false;
        }
        iterator2 = sWRLImp.getHead().getValues().iterator();
        iterator = sWRLImp2.getHead().getValues().iterator();
        return this.areAtomListsEqual(iterator2, iterator);
    }

    private boolean areAtomListsEqual(Iterator<SWRLAtom> iterator, Iterator<SWRLAtom> iterator2) {
        while (iterator.hasNext()) {
            SWRLAtom sWRLAtom;
            if (!iterator2.hasNext()) {
                return false;
            }
            SWRLAtom sWRLAtom2 = iterator.next();
            if (this.areAtomsEqual(sWRLAtom2, sWRLAtom = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private boolean areAtomsEqual(SWRLAtom sWRLAtom, SWRLAtom sWRLAtom2) {
        if (sWRLAtom instanceof SWRLBuiltinAtom) {
            return sWRLAtom2 instanceof SWRLBuiltinAtom && this.areBuiltInAtomsEqual((SWRLBuiltinAtom)sWRLAtom, (SWRLBuiltinAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLClassAtom) {
            return sWRLAtom2 instanceof SWRLClassAtom && this.areClassAtomsEqual((SWRLClassAtom)sWRLAtom, (SWRLClassAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLDatavaluedPropertyAtom) {
            return sWRLAtom2 instanceof SWRLDatavaluedPropertyAtom && this.areDatavaluedPropertyAtomsEqual((SWRLDatavaluedPropertyAtom)sWRLAtom, (SWRLDatavaluedPropertyAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLIndividualPropertyAtom) {
            return sWRLAtom2 instanceof SWRLIndividualPropertyAtom && this.areIndividualPropertyAtomsEqual((SWRLIndividualPropertyAtom)sWRLAtom, (SWRLIndividualPropertyAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLDifferentIndividualsAtom) {
            return sWRLAtom2 instanceof SWRLDifferentIndividualsAtom && this.areDifferentIndividualsAtomsEqual((SWRLDifferentIndividualsAtom)sWRLAtom, (SWRLDifferentIndividualsAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLSameIndividualAtom) {
            return sWRLAtom2 instanceof SWRLSameIndividualAtom && this.areSameIndividualAtomsEqual((SWRLSameIndividualAtom)sWRLAtom, (SWRLSameIndividualAtom)sWRLAtom2);
        }
        if (sWRLAtom instanceof SWRLDataRangeAtom) {
            return sWRLAtom2 instanceof SWRLDataRangeAtom && this.areDataRangeAtomsEqual((SWRLDataRangeAtom)sWRLAtom, (SWRLDataRangeAtom)sWRLAtom2);
        }
        throw new RuntimeException("unknowl SWRL atom type " + sWRLAtom.getLocalName());
    }

    private boolean areBuiltInAtomsEqual(SWRLBuiltinAtom sWRLBuiltinAtom, SWRLBuiltinAtom sWRLBuiltinAtom2) {
        if (!sWRLBuiltinAtom.getBuiltin().getURI().equals(sWRLBuiltinAtom2.getBuiltin().getURI())) {
            return false;
        }
        RDFList rDFList = sWRLBuiltinAtom.getArguments();
        RDFList rDFList2 = sWRLBuiltinAtom2.getArguments();
        Iterator iterator = rDFList.getValues().iterator();
        Iterator iterator2 = rDFList2.getValues().iterator();
        while (iterator.hasNext()) {
            Object e;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object e2 = iterator.next();
            if (this.areAtomArgumentsEqual(e2, e = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private boolean areClassAtomsEqual(SWRLClassAtom sWRLClassAtom, SWRLClassAtom sWRLClassAtom2) {
        return sWRLClassAtom.getClassPredicate().getURI().equals(sWRLClassAtom2.getClassPredicate().getURI()) && this.areAtomArgumentsEqual(sWRLClassAtom.getArgument1(), sWRLClassAtom2.getArgument1());
    }

    private boolean areIndividualPropertyAtomsEqual(SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom, SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom2) {
        return sWRLIndividualPropertyAtom.getPropertyPredicate().getURI().equals(sWRLIndividualPropertyAtom2.getPropertyPredicate().getURI()) && this.areAtomArgumentsEqual(sWRLIndividualPropertyAtom.getArgument1(), sWRLIndividualPropertyAtom2.getArgument1()) && this.areAtomArgumentsEqual(sWRLIndividualPropertyAtom.getArgument2(), sWRLIndividualPropertyAtom2.getArgument2());
    }

    private boolean areDatavaluedPropertyAtomsEqual(SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom, SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom2) {
        return sWRLDatavaluedPropertyAtom.getPropertyPredicate().getURI().equals(sWRLDatavaluedPropertyAtom2.getPropertyPredicate().getURI()) && this.areAtomArgumentsEqual(sWRLDatavaluedPropertyAtom.getArgument1(), sWRLDatavaluedPropertyAtom2.getArgument1()) && this.areAtomArgumentsEqual(sWRLDatavaluedPropertyAtom.getArgument2(), sWRLDatavaluedPropertyAtom2.getArgument2());
    }

    private boolean areSameIndividualAtomsEqual(SWRLSameIndividualAtom sWRLSameIndividualAtom, SWRLSameIndividualAtom sWRLSameIndividualAtom2) {
        return this.areAtomArgumentsEqual(sWRLSameIndividualAtom.getArgument1(), sWRLSameIndividualAtom2.getArgument1()) && this.areAtomArgumentsEqual(sWRLSameIndividualAtom.getArgument2(), sWRLSameIndividualAtom2.getArgument2());
    }

    private boolean areDifferentIndividualsAtomsEqual(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom, SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom2) {
        return this.areAtomArgumentsEqual(sWRLDifferentIndividualsAtom.getArgument1(), sWRLDifferentIndividualsAtom2.getArgument1()) && this.areAtomArgumentsEqual(sWRLDifferentIndividualsAtom.getArgument2(), sWRLDifferentIndividualsAtom2.getArgument2());
    }

    private boolean areDataRangeAtomsEqual(SWRLDataRangeAtom sWRLDataRangeAtom, SWRLDataRangeAtom sWRLDataRangeAtom2) {
        throw new RuntimeException("data range atoms not implemented");
    }

    private boolean areAtomArgumentsEqual(Object object, Object object2) {
        if (object instanceof RDFResource) {
            if (!(object2 instanceof RDFResource)) {
                return false;
            }
            RDFResource rDFResource = (RDFResource)object;
            RDFResource rDFResource2 = (RDFResource)object2;
            return rDFResource.getURI().equals(rDFResource2.getURI());
        }
        if (object instanceof RDFSLiteral) {
            if (!(object2 instanceof RDFSLiteral)) {
                return false;
            }
            RDFSLiteral rDFSLiteral = (RDFSLiteral)object;
            RDFSLiteral rDFSLiteral2 = (RDFSLiteral)object2;
            return rDFSLiteral.compareTo(rDFSLiteral2) == 0;
        }
        if (object instanceof String) {
            if (!(object2 instanceof String)) {
                return false;
            }
            String string = (String)object;
            String string2 = (String)object2;
            return string.equals(string2);
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) != 0;
        }
        return false;
    }
}

