/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ddm.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.Mapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValueFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.MapperException;
import edu.stanford.smi.protegex.owl.swrl.ddm.Column;
import edu.stanford.smi.protegex.owl.swrl.ddm.DDMFactory;
import edu.stanford.smi.protegex.owl.swrl.ddm.Database;
import edu.stanford.smi.protegex.owl.swrl.ddm.DatabaseConnection;
import edu.stanford.smi.protegex.owl.swrl.ddm.ForeignKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.MapperGenerator;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLClassMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLDatatypePropertyMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLObjectPropertyMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKeyColumn;
import edu.stanford.smi.protegex.owl.swrl.ddm.Table;
import edu.stanford.smi.protegex.owl.swrl.ddm.exceptions.JDBCException;
import edu.stanford.smi.protegex.owl.swrl.ddm.impl.DatabaseConnectionImpl;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLQueryEngine;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalMapper
implements Mapper,
MapperGenerator {
    private Map<String, OWLClassMap> classMaps = new HashMap<String, OWLClassMap>();
    private Map<String, OWLObjectPropertyMap> objectPropertyMaps = new HashMap<String, OWLObjectPropertyMap>();
    private Map<String, OWLDatatypePropertyMap> datatypePropertyMaps = new HashMap<String, OWLDatatypePropertyMap>();
    private Set<Database> databases = new HashSet<Database>();
    private Map<Database, DatabaseConnection> databaseConnections = new HashMap<Database, DatabaseConnection>();
    private OWLDataFactory owlFactory;
    private OWLDataValueFactory owlDataValueFactory;

    public RelationalMapper(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException {
        this.readMaps(sQWRLQueryEngine);
        this.owlFactory = new P3OWLDataFactory();
        this.owlDataValueFactory = OWLDataValueFactory.create();
    }

    @Override
    public void open() throws MapperException {
        try {
            for (DatabaseConnection databaseConnection : this.databaseConnections.values()) {
                if (databaseConnection.isOpen()) continue;
                databaseConnection.open();
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error opening database connections: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error opening database connections: " + sQLException.getMessage());
        }
    }

    @Override
    public void close() throws MapperException {
        try {
            for (DatabaseConnection databaseConnection : this.databaseConnections.values()) {
                if (!databaseConnection.isOpen()) continue;
                databaseConnection.close();
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error closing database connections: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error closing database connections: " + sQLException.getMessage());
        }
    }

    @Override
    public boolean isMapped(OWLClassReference oWLClassReference) {
        return this.classMaps.containsKey(oWLClassReference.getURI());
    }

    @Override
    public boolean isMapped(OWLPropertyReference oWLPropertyReference) {
        return this.objectPropertyMaps.containsKey(oWLPropertyReference.getURI()) || this.datatypePropertyMaps.containsKey(oWLPropertyReference.getURI());
    }

    @Override
    public void addMap(OWLClassMap oWLClassMap) {
        String string = oWLClassMap.getOWLClass().getURI();
        if (this.classMaps.containsKey(string)) {
            this.classMaps.remove(string);
        }
        this.classMaps.put(string, oWLClassMap);
    }

    @Override
    public void addMap(OWLObjectPropertyMap oWLObjectPropertyMap) {
        String string = oWLObjectPropertyMap.getProperty().getURI();
        if (this.objectPropertyMaps.containsKey(string)) {
            this.objectPropertyMaps.remove(string);
        }
        this.objectPropertyMaps.put(string, oWLObjectPropertyMap);
    }

    @Override
    public void addMap(OWLDatatypePropertyMap oWLDatatypePropertyMap) {
        String string = oWLDatatypePropertyMap.getProperty().getURI();
        if (this.datatypePropertyMaps.containsKey(string)) {
            this.datatypePropertyMaps.remove(string);
        }
        this.datatypePropertyMaps.put(string, oWLDatatypePropertyMap);
    }

    @Override
    public Set<OWLNamedIndividualReference> mapOWLClass(OWLClassReference oWLClassReference) throws MapperException {
        String string = oWLClassReference.getURI();
        OWLClassMap oWLClassMap = this.getOWLClassMap(string);
        PrimaryKey primaryKey = oWLClassMap.getPrimaryKey();
        String string2 = primaryKey.getPrimaryKeyColumns().iterator().next().getColumnName();
        Database database = primaryKey.getBaseTable().getDatabase();
        String string3 = primaryKey.getBaseTable().getTableName();
        HashSet<OWLNamedIndividualReference> hashSet = new HashSet<OWLNamedIndividualReference>();
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        try {
            ResultSet resultSet = databaseConnection.executeQuery("SELECT " + string2 + " FROM " + string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(string2);
                hashSet.add(this.owlFactory.getOWLIndividual(string4));
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping class '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping class '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLNamedIndividualReference> mapOWLClass(OWLClassReference oWLClassReference, OWLNamedIndividualReference oWLNamedIndividualReference) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiomReference> mapOWLObjectProperty(OWLPropertyReference oWLPropertyReference) throws MapperException {
        String string = oWLPropertyReference.getURI();
        OWLObjectPropertyMap oWLObjectPropertyMap = this.getOWLObjectPropertyMap(string);
        ForeignKey foreignKey = oWLObjectPropertyMap.getForeignKey();
        String string2 = foreignKey.getBaseTable().getTableName();
        String string3 = foreignKey.getBaseTable().getPrimaryKey().getPrimaryKeyColumns().iterator().next().getColumnName();
        String string4 = foreignKey.getForeignKeyColumns().iterator().next().getColumnName();
        String string5 = foreignKey.getReferencedTable().getTableName();
        String string6 = foreignKey.getReferencedTable().getPrimaryKey().getPrimaryKeyColumns().iterator().next().getColumnName();
        Database database = foreignKey.getBaseTable().getDatabase();
        HashSet<OWLObjectPropertyAssertionAxiomReference> hashSet = new HashSet<OWLObjectPropertyAssertionAxiomReference>();
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        String string7 = "SELECT S." + string3 + ", S." + string4 + ", O." + string6 + " " + "FROM " + string2 + " AS S, " + string5 + " AS O " + "WHERE " + string4 + " = " + string6;
        try {
            ResultSet resultSet = databaseConnection.executeQuery(string7);
            while (resultSet.next()) {
                OWLNamedIndividualReference oWLNamedIndividualReference = this.owlFactory.getOWLIndividual(resultSet.getString(string3));
                OWLNamedIndividualReference oWLNamedIndividualReference2 = this.owlFactory.getOWLIndividual(resultSet.getString(string6));
                OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference = this.owlFactory.getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference, oWLPropertyReference, oWLNamedIndividualReference2);
                hashSet.add(oWLObjectPropertyAssertionAxiomReference);
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping object property '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping object property '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiomReference> mapOWLObjectProperty(OWLPropertyReference oWLPropertyReference, OWLNamedIndividualReference oWLNamedIndividualReference) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiomReference> mapOWLObjectProperty(OWLPropertyReference oWLPropertyReference, OWLNamedIndividualReference oWLNamedIndividualReference, OWLNamedIndividualReference oWLNamedIndividualReference2) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiomReference> mapOWLDataProperty(OWLPropertyReference oWLPropertyReference, OWLNamedIndividualReference oWLNamedIndividualReference, OWLDataValue oWLDataValue) throws MapperException {
        String string = oWLPropertyReference.getURI();
        OWLDatatypePropertyMap oWLDatatypePropertyMap = this.getOWLDatatypePropertyMap(string);
        PrimaryKey primaryKey = oWLDatatypePropertyMap.getPrimaryKey();
        String string2 = oWLDatatypePropertyMap.getValueColumn().getColumnName();
        String string3 = primaryKey.getPrimaryKeyColumns().iterator().next().getColumnName();
        String string4 = primaryKey.getBaseTable().getTableName();
        Database database = primaryKey.getBaseTable().getDatabase();
        HashSet<OWLDataPropertyAssertionAxiomReference> hashSet = new HashSet<OWLDataPropertyAssertionAxiomReference>();
        boolean bl = oWLNamedIndividualReference != null;
        boolean bl2 = oWLDataValue != null;
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        String string5 = "SELECT " + string3 + ", " + string2 + " FROM " + string4;
        if (bl || bl2) {
            string5 = string5 + " WHERE ";
            if (bl) {
                string5 = string5 + string3 + " = " + oWLNamedIndividualReference.getURI();
            }
            if (bl2) {
                if (bl) {
                    string5 = string5 + " AND ";
                }
                string5 = string5 + string2 + " = ";
                string5 = oWLDataValue.isString() ? string5 + "\"" + ((Object)oWLDataValue).toString() + "\"" : string5 + ((Object)oWLDataValue).toString();
            }
        }
        try {
            ResultSet resultSet = databaseConnection.executeQuery(string5);
            while (resultSet.next()) {
                OWLNamedIndividualReference oWLNamedIndividualReference2 = this.owlFactory.getOWLIndividual(resultSet.getString(string3));
                OWLDataValue oWLDataValue2 = this.owlDataValueFactory.getOWLDataValue(resultSet.getFloat(string2));
                OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference = this.owlFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference2, oWLPropertyReference, oWLDataValue2);
                hashSet.add(oWLDataPropertyAssertionAxiomReference);
            }
            resultSet.close();
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping datatype property '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping datatype property '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiomReference> mapOWLDataProperty(OWLPropertyReference oWLPropertyReference, OWLNamedIndividualReference oWLNamedIndividualReference) throws MapperException {
        return this.mapOWLDataProperty(oWLPropertyReference, oWLNamedIndividualReference, null);
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiomReference> mapOWLDataProperty(OWLPropertyReference oWLPropertyReference, OWLDataValue oWLDataValue) throws MapperException {
        return this.mapOWLDataProperty(oWLPropertyReference, null, oWLDataValue);
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiomReference> mapOWLDataProperty(OWLPropertyReference oWLPropertyReference) throws MapperException {
        return this.mapOWLDataProperty(oWLPropertyReference, null, null);
    }

    private OWLClassMap getOWLClassMap(String string) throws MapperException {
        if (!this.classMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped class '" + string + "'");
        }
        return this.classMaps.get(string);
    }

    private OWLObjectPropertyMap getOWLObjectPropertyMap(String string) throws MapperException {
        if (!this.objectPropertyMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped object property '" + string + "'");
        }
        return this.objectPropertyMaps.get(string);
    }

    private OWLDatatypePropertyMap getOWLDatatypePropertyMap(String string) throws MapperException {
        if (!this.datatypePropertyMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped datatype property '" + string + "'");
        }
        return this.datatypePropertyMaps.get(string);
    }

    private void readMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException {
        try {
            sQWRLQueryEngine.runSQWRLQueries();
            this.readOWLClassMaps(sQWRLQueryEngine);
            this.readOWLObjectPropertyMaps(sQWRLQueryEngine);
            this.readOWLDatatypePropertyMaps(sQWRLQueryEngine);
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error reading mapping information: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error reading mapping information: " + sQLException.getMessage());
        }
        catch (InvalidQueryNameException invalidQueryNameException) {
        }
        catch (SQWRLException sQWRLException) {
            throw new MapperException("SQWRL error reading mapping information: " + sQWRLException.getMessage());
        }
    }

    private void readOWLClassMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException {
    }

    private void readOWLObjectPropertyMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException {
    }

    private void readOWLDatatypePropertyMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException, SQLException, JDBCException {
        SQWRLResult sQWRLResult = sQWRLQueryEngine.getSQWRLResult("ddm:OWLDatatypePropertyMap-Query");
        if (sQWRLResult != null) {
            while (sQWRLResult.hasNext()) {
                String string = sQWRLResult.getPropertyValue("?ddm:owlDatatypeProperty").getURI();
                String string2 = sQWRLResult.getDataValue("?ddm:schemaName").getString();
                String string3 = sQWRLResult.getDataValue("?ddm:tableName").getString();
                String string4 = sQWRLResult.getDataValue("?ddm:keyColumnName").getString();
                String string5 = sQWRLResult.getDataValue("?ddm:valueColumnName").getString();
                String string6 = sQWRLResult.getDataValue("?ddm:jdbcDriverName").getString();
                String string7 = sQWRLResult.getDataValue("?ddm:databaseName").getString();
                String string8 = sQWRLResult.getDataValue("?ddm:serverName").getString();
                int n = sQWRLResult.getDataValue("?ddm:portNumber").getInt();
                OWLDataPropertyReference oWLDataPropertyReference = this.owlFactory.getOWLDataProperty(string);
                Database database = DDMFactory.createDatabase(string6, string8, string7, n);
                if (!this.databases.contains(database)) {
                    this.databases.add(database);
                }
                HashSet<Column> hashSet = new HashSet<Column>();
                HashSet<PrimaryKeyColumn> hashSet2 = new HashSet<PrimaryKeyColumn>();
                PrimaryKeyColumn primaryKeyColumn = DDMFactory.createPrimaryKeyColumn(string4, 999);
                hashSet2.add(primaryKeyColumn);
                hashSet.add(primaryKeyColumn);
                Column column = DDMFactory.createColumn(string5, 999);
                hashSet.add(primaryKeyColumn);
                Table table = DDMFactory.createTable(database, string2, string3, hashSet);
                PrimaryKey primaryKey = DDMFactory.createPrimaryKey(table, hashSet2);
                OWLDatatypePropertyMap oWLDatatypePropertyMap = DDMFactory.createOWLDatatypePropertyMap(oWLDataPropertyReference, primaryKey, column);
                this.datatypePropertyMaps.put(string, oWLDatatypePropertyMap);
                sQWRLResult.next();
            }
        }
    }

    private DatabaseConnection createDatabaseConnection(Database database) throws MapperException {
        DatabaseConnectionImpl databaseConnectionImpl = null;
        try {
            databaseConnectionImpl = new DatabaseConnectionImpl(database, "root", "w0rches");
        }
        catch (SQLException sQLException) {
            throw new MapperException("error creating connection to database '" + database + "': " + sQLException.getMessage());
        }
        return databaseConnectionImpl;
    }

    private DatabaseConnection getDatabaseConnection(Database database) throws MapperException {
        DatabaseConnection databaseConnection = null;
        if (!this.databaseConnections.containsKey(database)) {
            databaseConnection = this.createDatabaseConnection(database);
            this.databaseConnections.put(database, databaseConnection);
        } else {
            databaseConnection = this.databaseConnections.get(database);
        }
        try {
            if (!databaseConnection.isOpen()) {
                databaseConnection.open();
            }
        }
        catch (SQLException sQLException) {
            throw new MapperException("error connecting to database '" + database + "': " + sQLException.getMessage());
        }
        return databaseConnection;
    }
}

