/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ddm.impl;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protegex.owl.swrl.ddm.Column;
import edu.stanford.smi.protegex.owl.swrl.ddm.exceptions.JDBCException;
import edu.stanford.smi.protegex.owl.swrl.ddm.impl.ColumnImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnection {
    private Connection connection;
    private Statement queryStmt;
    private DatabaseMetaData dbmd;

    public JDBCConnection(String string, String string2, String string3) throws SQLException {
        try {
            this.connection = DriverManager.getConnection(string, string2, string3);
            this.queryStmt = this.connection.createStatement();
            this.dbmd = this.connection.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new JDBCException("error creating JDBC connection '" + string + "': " + sQLException.getMessage());
        }
    }

    public static String getConnectionString(String string, String string2, String string3, int n) throws SQLException {
        String string4 = "";
        if (string.equals("SQLServerJDBCDriver2000")) {
            string4 = new String("jdbc:microsoft:sqlserver://" + string2 + ":" + n + ";databaseName=" + string3 + ";");
        } else if (string.equals("SQLServerJDBCDriver2005")) {
            string4 = new String("jdbc:sqlserver://" + string2 + ":" + n + ";instanceName=" + string3 + ";");
        } else if (string.equals("SunJDBCDriver")) {
            string4 = new String("jdbc:odbc:" + string3);
        } else if (string.equals("OracleThin")) {
            string4 = new String("jdbc:oracle:thin:@" + string2 + ":" + n + ":" + string3);
        } else if (string.equals("com.mysql.jdbc.Driver")) {
            string4 = new String("jdbc:mysql://" + string2 + ":" + n + "/" + string3);
        } else {
            if (string.equals("")) {
                throw new JDBCException("no JDBC driver specified");
            }
            throw new JDBCException("unknown JDBC driver '" + string + "'");
        }
        JDBCConnection.loadDrivers(string);
        return string4;
    }

    public static void loadDrivers(String string) throws SQLException {
        if (string.equals("SQLServerJDBCDriver2000")) {
            try {
                PluginUtilities.forName((String)"com.microsoft.jdbc.sqlserver.SQLServerDriver", (boolean)true);
            }
            catch (Exception exception) {
                throw new JDBCException("failed to load Microsoft SQL Server 2000 JDBC driver");
            }
        } else if (string.equals("SQLServerJDBCDriver2005")) {
            try {
                PluginUtilities.forName((String)"com.microsoft.sqlserver.jdbc.SQLServerDriver", (boolean)true);
            }
            catch (Exception exception) {
                throw new JDBCException("failed to load Microsoft SQL Server 2005 JDBC driver");
            }
        } else if (string.equals("SunJDBCDriver")) {
            try {
                PluginUtilities.forName((String)"sun.jdbc.odbc.JdbcOdbcDriver", (boolean)true);
            }
            catch (Exception exception) {
                throw new JDBCException("failed to load Sun JDBC driver");
            }
        } else if (string.equals("OracleThin")) {
            try {
                PluginUtilities.forName((String)"oracle.jdbc.driver.OracleDriver", (boolean)true);
            }
            catch (Exception exception) {
                throw new JDBCException("failed to load Oracle JDBC driver");
            }
        } else if (string.equals("com.mysql.jdbc.Driver")) {
            try {
                PluginUtilities.forName((String)"com.mysql.jdbc.Driver", (boolean)true).newInstance();
            }
            catch (Exception exception) {
                throw new JDBCException("failed to load MySQL JDBC driver");
            }
        } else {
            if (string.equals("")) {
                throw new JDBCException("no JDBC driver specified");
            }
            throw new JDBCException("unknown JDBC driver '" + string + "'");
        }
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        if (this.queryStmt == null) {
            this.queryStmt = this.connection.createStatement();
        }
        resultSet = this.queryStmt.executeQuery(string);
        return resultSet;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        if (this.queryStmt == null) {
            this.queryStmt = this.connection.createStatement();
        }
        int n = this.queryStmt.executeUpdate(string);
        return n;
    }

    public synchronized int getMaxColumnNameLength() throws SQLException {
        return this.dbmd.getMaxColumnNameLength();
    }

    public synchronized int getMaxCatalogNameLength() throws SQLException {
        return this.dbmd.getMaxCatalogNameLength();
    }

    public synchronized int getMaxCharLiteralLength() throws SQLException {
        return this.dbmd.getMaxCharLiteralLength();
    }

    public synchronized String getDatabaseProductName() throws SQLException {
        return this.dbmd.getDatabaseProductName();
    }

    public synchronized int getMaxRowSize() throws SQLException {
        return this.dbmd.getMaxRowSize();
    }

    public synchronized int getMaxTableNameLength() throws SQLException {
        return this.dbmd.getMaxTableNameLength();
    }

    public synchronized int getMaxSchemaNameLength() throws SQLException {
        return this.dbmd.getMaxSchemaNameLength();
    }

    public synchronized String getUserName() throws SQLException {
        return this.dbmd.getUserName();
    }

    public synchronized Set<String> getCatalogs() throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getCatalogs();
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            hashSet.add(string);
        }
        resultSet.close();
        return hashSet;
    }

    public synchronized Set<String> getSchemaNames() throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getSchemas();
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            hashSet.add(string);
        }
        resultSet.close();
        return hashSet;
    }

    public synchronized Set<String> getTableNames(String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getTables(null, string, null, null);
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_NAME");
            hashSet.add(string2);
        }
        resultSet.close();
        return hashSet;
    }

    public synchronized Set<String> getPrimaryKeyColumnNames(String string, String string2) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getPrimaryKeys(null, string, string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString("COLUMN_NAME");
            hashSet.add(string3);
        }
        resultSet.close();
        return hashSet;
    }

    public synchronized Map<String, Map<String, String>> getForeignKeys(String string, String string2) throws SQLException {
        ResultSet resultSet = this.dbmd.getImportedKeys(null, string, string2);
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        int n = -1;
        String string3 = null;
        String string4 = null;
        while (resultSet.next()) {
            String string5 = resultSet.getString("PKTABLE_NAME");
            String string6 = resultSet.getString("PKCOLUMN_NAME");
            String string7 = resultSet.getString("FKTABLE_SCHEM");
            String string8 = resultSet.getString("FKTABLE_NAME");
            String string9 = resultSet.getString("FKCOLUMN_NAME");
            int n2 = resultSet.getInt("KEY_SEQ");
            if (!string5.equalsIgnoreCase(string2)) {
                throw new JDBCException("expecting table '" + string2 + "', got '" + string5 + "' in call to getImportedKeys");
            }
            if (n == -1 || n2 == n) {
                hashMap2.put(string6, string9);
            } else {
                hashMap.put(this.buildSchemaTableName(string7, string8), hashMap2);
                hashMap2 = new HashMap();
            }
            n = n2;
            string4 = string7;
            string3 = string8;
        }
        if (n != -1) {
            hashMap.put(this.buildSchemaTableName(string4, string3), hashMap2);
        }
        resultSet.close();
        return hashMap;
    }

    private String buildSchemaTableName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + "." + string2;
    }

    public synchronized void closeConnection() throws SQLException {
        this.connection.close();
        this.connection = null;
        this.dbmd = null;
    }

    public synchronized void closeStatements() throws SQLException {
        if (this.queryStmt != null) {
            this.queryStmt.close();
        }
        this.queryStmt = null;
    }

    public synchronized String getColumnTypeName(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        ResultSet resultSet = this.dbmd.getColumns(null, string, string2, string3);
        resultSet.next();
        if (resultSet.getString("COLUMN_NAME").equalsIgnoreCase(string3)) {
            string4 = resultSet.getString("TYPE_NAME");
        }
        return string4;
    }

    public synchronized int getColumnType(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet = this.dbmd.getColumns(null, string, string2, string3);
        int n = -1;
        resultSet.next();
        if (resultSet.getString("COLUMN_NAME").equalsIgnoreCase(string3)) {
            n = resultSet.getInt("DATA_TYPE");
        }
        return n;
    }

    public synchronized Set<String> getColumnTypeNames(String string, String string2) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getColumns(null, string, string2, null);
        int n = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            hashSet.add(resultSetMetaData.getColumnTypeName(n++));
        }
        resultSet.close();
        return hashSet;
    }

    public synchronized Set<Column> getColumns(String string, String string2) throws SQLException {
        HashSet<Column> hashSet = new HashSet<Column>();
        for (String string3 : this.getColumnNames(string, string2)) {
            ColumnImpl columnImpl = new ColumnImpl(string3, this.getColumnType(string, string2, string3));
            hashSet.add(columnImpl);
        }
        return hashSet;
    }

    public synchronized Set<String> getColumnNames(String string, String string2) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.dbmd.getColumns(null, string, string2, null);
        while (resultSet.next()) {
            hashSet.add(resultSet.getString("COLUMN_NAME"));
        }
        resultSet.close();
        return hashSet;
    }
}

