/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.xsd;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.axis.types.Duration;
import org.apache.axis.types.Time;

public class XSDTimeUtil {
    private static String xsdDateTimeFormatString = "yyyy-MM-dd'T'hh:mm:ss";
    private static String xsdDateFormatString = "yyyy-MM-dd";
    private static DateFormat xsdDateTimeFormat = new SimpleDateFormat(xsdDateTimeFormatString);
    private static DateFormat xsdDateFormat = new SimpleDateFormat(xsdDateFormatString);
    private static String jdbcDateTimeFormatString = "y-M-d h:m:s.S";
    private static String jdbcDateFormatString = "y-M-d";
    private static DateFormat jdbcDateTimeFormat = new SimpleDateFormat(jdbcDateTimeFormatString);
    private static DateFormat jdbcDateFormat = new SimpleDateFormat(jdbcDateFormatString);

    public static Duration addDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setYears(XSDTimeUtil.getYears(duration) + XSDTimeUtil.getYears(duration2));
        duration3.setMonths(XSDTimeUtil.getMonths(duration) + XSDTimeUtil.getMonths(duration2));
        duration3.setDays(XSDTimeUtil.getDays(duration) + XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) + XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) + XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) + XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration subtractDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setYears(XSDTimeUtil.getYears(duration) - XSDTimeUtil.getYears(duration2));
        duration3.setMonths(XSDTimeUtil.getMonths(duration) - XSDTimeUtil.getMonths(duration2));
        duration3.setDays(XSDTimeUtil.getDays(duration) - XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) - XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) - XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) - XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration multiplyDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setYears(XSDTimeUtil.getYears(duration) * XSDTimeUtil.getYears(duration2));
        duration3.setMonths(XSDTimeUtil.getMonths(duration) * XSDTimeUtil.getMonths(duration2));
        duration3.setDays(XSDTimeUtil.getDays(duration) * XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) * XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) * XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) * XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration divideDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setYears(XSDTimeUtil.getYears(duration) / XSDTimeUtil.getYears(duration2));
        duration3.setMonths(XSDTimeUtil.getMonths(duration) / XSDTimeUtil.getMonths(duration2));
        duration3.setDays(XSDTimeUtil.getDays(duration) / XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) / XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) / XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) / XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration addDayTimeDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getDays(duration) + XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) + XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) + XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) + XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration subtractDayTimeDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getDays(duration) - XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) - XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) - XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) - XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration multiplyDayTimeDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getDays(duration) * XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) * XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) * XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) * XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration divideDayTimeDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getDays(duration) / XSDTimeUtil.getDays(duration2));
        duration3.setHours(XSDTimeUtil.getHours(duration) / XSDTimeUtil.getHours(duration2));
        duration3.setMinutes(XSDTimeUtil.getMinutes(duration) / XSDTimeUtil.getMinutes(duration2));
        duration3.setSeconds(XSDTimeUtil.getSeconds(duration) / XSDTimeUtil.getSeconds(duration2));
        return duration3;
    }

    public static Duration addYearMonthDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getYears(duration) + XSDTimeUtil.getYears(duration2));
        duration3.setHours(XSDTimeUtil.getMonths(duration) + XSDTimeUtil.getMonths(duration2));
        return duration3;
    }

    public static Duration subtractYearMonthDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getYears(duration) - XSDTimeUtil.getYears(duration2));
        duration3.setHours(XSDTimeUtil.getMonths(duration) - XSDTimeUtil.getMonths(duration2));
        return duration3;
    }

    public static Duration multiplyYearMonthDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getYears(duration) * XSDTimeUtil.getYears(duration2));
        duration3.setHours(XSDTimeUtil.getMonths(duration) * XSDTimeUtil.getMonths(duration2));
        return duration3;
    }

    public static Duration divideYearMonthDurations(Duration duration, Duration duration2) {
        Duration duration3 = new Duration();
        duration3.setDays(XSDTimeUtil.getYears(duration) / XSDTimeUtil.getYears(duration2));
        duration3.setHours(XSDTimeUtil.getMonths(duration) / XSDTimeUtil.getMonths(duration2));
        return duration3;
    }

    public static Duration subtractDates(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.setTime(date2);
        int n = gregorianCalendar.get(1) - gregorianCalendar2.get(1);
        int n2 = gregorianCalendar.get(2) - gregorianCalendar2.get(2);
        int n3 = gregorianCalendar.get(5) - gregorianCalendar2.get(5);
        int n4 = gregorianCalendar.get(10) - gregorianCalendar2.get(10);
        int n5 = gregorianCalendar.get(12) - gregorianCalendar2.get(12);
        double d = gregorianCalendar.get(13) - gregorianCalendar2.get(13);
        return new Duration(false, n, n2, n3, n4, n5, d);
    }

    public static Duration subtractTimes(Time time, Time time2) {
        Calendar calendar = time.getAsCalendar();
        Calendar calendar2 = time2.getAsCalendar();
        Duration duration = new Duration();
        int n = calendar.get(10) - calendar2.get(10);
        int n2 = calendar.get(12) - calendar2.get(12);
        double d = calendar.get(13) - calendar2.get(13);
        duration.setHours(n);
        duration.setMinutes(n2);
        duration.setSeconds(d);
        return duration;
    }

    public static Date addYearMonthDurationToDateTime(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1) + XSDTimeUtil.getYears(duration), gregorianCalendar.get(2) + XSDTimeUtil.getMonths(duration), gregorianCalendar.get(5), gregorianCalendar.get(10), gregorianCalendar.get(12), gregorianCalendar.get(13));
        return gregorianCalendar2.getTime();
    }

    public static Date subtractYearMonthDurationFromDateTime(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1) - XSDTimeUtil.getYears(duration), gregorianCalendar.get(2) - XSDTimeUtil.getMonths(duration), gregorianCalendar.get(5), gregorianCalendar.get(10), gregorianCalendar.get(12), gregorianCalendar.get(13));
        return gregorianCalendar2.getTime();
    }

    public static Date addDayTimeDurationToDateTime(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5) + XSDTimeUtil.getDays(duration), gregorianCalendar.get(10) + XSDTimeUtil.getHours(duration), gregorianCalendar.get(12) + XSDTimeUtil.getMinutes(duration), (int)((double)gregorianCalendar.get(13) + XSDTimeUtil.getSeconds(duration)));
        return gregorianCalendar2.getTime();
    }

    public static Date subtractDayTimeDurationFromDateTime(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5) - XSDTimeUtil.getDays(duration), gregorianCalendar.get(10) - XSDTimeUtil.getHours(duration), gregorianCalendar.get(12) - XSDTimeUtil.getMinutes(duration), (int)((double)gregorianCalendar.get(13) - XSDTimeUtil.getSeconds(duration)));
        return gregorianCalendar2.getTime();
    }

    public static Date addYearMonthDurationToDate(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1) + XSDTimeUtil.getYears(duration), gregorianCalendar.get(2) + XSDTimeUtil.getMonths(duration), gregorianCalendar.get(5));
        return gregorianCalendar2.getTime();
    }

    public static Date subtractYearMonthDurationFromDate(Date date, Duration duration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.set(gregorianCalendar.get(1) - XSDTimeUtil.getYears(duration), gregorianCalendar.get(2) - XSDTimeUtil.getMonths(duration), gregorianCalendar.get(5));
        return gregorianCalendar2.getTime();
    }

    public static Time addDayTimeDurationToTime(Time time, Duration duration) {
        Calendar calendar = time.getAsCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(0, calendar.get(5) + XSDTimeUtil.getDays(duration), calendar.get(10) + XSDTimeUtil.getHours(duration), calendar.get(12) + XSDTimeUtil.getMinutes(duration), (int)((double)calendar.get(13) + XSDTimeUtil.getSeconds(duration)));
        return new Time((Calendar)gregorianCalendar);
    }

    public static Time subtractDayTimeDurationFromTime(Time time, Duration duration) {
        Calendar calendar = time.getAsCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(0, calendar.get(5) - XSDTimeUtil.getDays(duration), calendar.get(10) - XSDTimeUtil.getHours(duration), calendar.get(12) - XSDTimeUtil.getMinutes(duration), (int)((double)calendar.get(13) - XSDTimeUtil.getSeconds(duration)));
        return new Time((Calendar)gregorianCalendar);
    }

    public static Duration subtractDateTimesYieldingYearMonthDuration(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.setTime(date2);
        int n = gregorianCalendar.get(1) - gregorianCalendar2.get(1);
        int n2 = gregorianCalendar.get(2) - gregorianCalendar2.get(2);
        return new Duration(false, n, n2, 0, 0, 0, 0.0);
    }

    public static Duration subtractDateTimesYieldingDayTimeDuration(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar2.setTime(date2);
        int n = gregorianCalendar.get(5) - gregorianCalendar2.get(5);
        int n2 = gregorianCalendar.get(10) - gregorianCalendar2.get(10);
        int n3 = gregorianCalendar.get(12) - gregorianCalendar2.get(12);
        double d = gregorianCalendar.get(13) - gregorianCalendar2.get(13);
        return new Duration(false, 0, 0, n, n2, n3, d);
    }

    public static String date2XSDDateTimeString(Date date) {
        return xsdDateTimeFormat.format(date);
    }

    public static String date2XSDDateString(Date date) {
        return xsdDateFormat.format(date);
    }

    public static String date2XSDTimeString(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Time time = new Time((Calendar)gregorianCalendar);
        return time.toString();
    }

    public static Date xsdDateTimeString2Date(String string) throws ParseException {
        return xsdDateTimeFormat.parse(string);
    }

    public static Date xsdDateString2Date(String string) throws ParseException {
        return xsdDateFormat.parse(string);
    }

    public static Date xsdTimeString2Date(String string) throws NumberFormatException {
        Time time = new Time(string);
        return time.getAsCalendar().getTime();
    }

    public static String date2JDBCDateTimeString(Date date) {
        return jdbcDateTimeFormat.format(date);
    }

    public static String date2JDBCDateString(Date date) {
        return jdbcDateFormat.format(date);
    }

    public static Date jdbcDateTimeString2Date(String string) throws ParseException {
        return jdbcDateTimeFormat.parse(string);
    }

    public static Date jdbcDateString2Date(String string) throws ParseException {
        return jdbcDateFormat.parse(string);
    }

    public static boolean isValidXSDDateTime(String string) {
        boolean bl = false;
        try {
            xsdDateTimeFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isValidXSDDate(String string) {
        boolean bl = false;
        try {
            xsdDateFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isValidXSDTime(String string) {
        boolean bl = false;
        try {
            new Time(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isValidXSDDuration(String string) {
        boolean bl = false;
        try {
            new Duration(string);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isValidJDBCDateTime(String string) {
        boolean bl = false;
        try {
            jdbcDateTimeFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return bl;
    }

    public static int addDurationYears(Duration duration, Duration duration2) {
        return XSDTimeUtil.getYears(duration) + XSDTimeUtil.getYears(duration2);
    }

    public static int addDurationMonths(Duration duration, Duration duration2) {
        return XSDTimeUtil.getMonths(duration) + XSDTimeUtil.getMonths(duration2);
    }

    public static int addDurationDays(Duration duration, Duration duration2) {
        return XSDTimeUtil.getDays(duration) + XSDTimeUtil.getDays(duration2);
    }

    public static int addDurationHours(Duration duration, Duration duration2) {
        return XSDTimeUtil.getHours(duration) + XSDTimeUtil.getHours(duration2);
    }

    public static int addDurationMinutes(Duration duration, Duration duration2) {
        return XSDTimeUtil.getMinutes(duration) + XSDTimeUtil.getMinutes(duration2);
    }

    public static double addDurationSeconds(Duration duration, Duration duration2) {
        return XSDTimeUtil.getSeconds(duration) + XSDTimeUtil.getSeconds(duration2);
    }

    public static int subtractDurationYears(Duration duration, Duration duration2) {
        return XSDTimeUtil.getYears(duration) - XSDTimeUtil.getYears(duration2);
    }

    public static int subtractDurationMonths(Duration duration, Duration duration2) {
        return XSDTimeUtil.getMonths(duration) - XSDTimeUtil.getMonths(duration2);
    }

    public static int subtractDurationDays(Duration duration, Duration duration2) {
        return XSDTimeUtil.getDays(duration) - XSDTimeUtil.getDays(duration2);
    }

    public static int subtractDurationHours(Duration duration, Duration duration2) {
        return XSDTimeUtil.getHours(duration) - XSDTimeUtil.getHours(duration2);
    }

    public static int subtractDurationMinutes(Duration duration, Duration duration2) {
        return XSDTimeUtil.getMinutes(duration) - XSDTimeUtil.getMinutes(duration2);
    }

    public static double subtractDurationSeconds(Duration duration, Duration duration2) {
        return XSDTimeUtil.getSeconds(duration) - XSDTimeUtil.getSeconds(duration2);
    }

    public static int getYears(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getYears();
        }
        return duration.getYears();
    }

    public static int getMonths(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getMonths();
        }
        return duration.getMonths();
    }

    public static int getDays(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getDays();
        }
        return duration.getDays();
    }

    public static int getHours(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getHours();
        }
        return duration.getHours();
    }

    public static int getMinutes(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getMinutes();
        }
        return duration.getMinutes();
    }

    public static double getSeconds(Duration duration) {
        if (duration.isNegative()) {
            return -duration.getSeconds();
        }
        return duration.getSeconds();
    }
}

