/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLAxiomProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLConversionFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDeclarationAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDifferentIndividualsAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLOntology;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSameIndividualAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLBuiltInAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLClassAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.DataValueConversionException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.SQWRLResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAxiomProcessorImpl
implements OWLAxiomProcessor {
    private OWLOntology activeOntology;
    private OWLDataFactory dataFactory;
    private HashMap<String, SWRLRuleReference> rules;
    private HashMap<String, SWRLRuleReference> queries;
    private Map<String, Set<String>> relevantOWLClassURIMap;
    private Map<String, Set<String>> relevantOWLPropertyURIMap;
    private Map<String, Set<String>> relevantOWLIndividualURIMap;
    private Map<String, Set<String>> referencedVariableNameMap;
    private Map<String, SQWRLResultImpl> sqwrlResultMap;
    private Map<String, String> ruleGroupNameMap;
    private Map<String, Boolean> hasSQWRLBuiltInsMap;
    private Map<String, Boolean> hasSQWRLCollectionBuiltInsMap;
    private Map<String, Boolean> enabledMap;
    private Map<String, Map<String, List<BuiltInArgument>>> collectionGroupArgumentsMap;
    private HashMap<String, SWRLRuleReference> swrlRules;
    private HashMap<String, OWLDeclarationAxiomReference> relevantOWLDeclarationAxioms;
    private HashMap<String, OWLDeclarationAxiomReference> relevantOWLClassDeclarationAxioms;
    private HashMap<String, OWLDeclarationAxiomReference> relevantOWLPropertyDeclarationAxioms;
    private HashMap<String, OWLDeclarationAxiomReference> relevantOWLIndividualDeclarationAxioms;
    private Set<String> relevantOWLObjectPropertyURIs;
    private Set<String> relevantOWLDataPropertyURIs;
    private Set<OWLAxiomReference> relevantOWLAxioms;
    private Map<String, Map<String, Set<OWLPropertyAssertionAxiomReference>>> allOWLPropertyAssertionAxioms;
    private Map<String, OWLNamedIndividualReference> allOWLIndividuals;

    public OWLAxiomProcessorImpl(OWLOntology oWLOntology) {
        this.activeOntology = oWLOntology;
        this.dataFactory = new P3OWLDataFactory(oWLOntology);
        this.reset();
    }

    @Override
    public void reset() {
        this.rules = new HashMap();
        this.queries = new HashMap();
        this.relevantOWLClassURIMap = new HashMap<String, Set<String>>();
        this.relevantOWLPropertyURIMap = new HashMap<String, Set<String>>();
        this.relevantOWLIndividualURIMap = new HashMap<String, Set<String>>();
        this.referencedVariableNameMap = new HashMap<String, Set<String>>();
        this.sqwrlResultMap = new HashMap<String, SQWRLResultImpl>();
        this.ruleGroupNameMap = new HashMap<String, String>();
        this.hasSQWRLBuiltInsMap = new HashMap<String, Boolean>();
        this.hasSQWRLCollectionBuiltInsMap = new HashMap<String, Boolean>();
        this.enabledMap = new HashMap<String, Boolean>();
        this.collectionGroupArgumentsMap = new HashMap<String, Map<String, List<BuiltInArgument>>>();
        this.swrlRules = new HashMap();
        this.relevantOWLDeclarationAxioms = new HashMap();
        this.relevantOWLClassDeclarationAxioms = new HashMap();
        this.relevantOWLPropertyDeclarationAxioms = new HashMap();
        this.relevantOWLIndividualDeclarationAxioms = new HashMap();
        this.relevantOWLAxioms = new HashSet<OWLAxiomReference>();
        this.relevantOWLObjectPropertyURIs = new HashSet<String>();
        this.relevantOWLDataPropertyURIs = new HashSet<String>();
        this.relevantOWLAxioms = new HashSet<OWLAxiomReference>();
        this.allOWLPropertyAssertionAxioms = new HashMap<String, Map<String, Set<OWLPropertyAssertionAxiomReference>>>();
        this.allOWLIndividuals = new HashMap<String, OWLNamedIndividualReference>();
    }

    @Override
    public void processSWRLRules() throws SWRLRuleEngineException {
        this.reset();
        this.importSWRLRules();
        this.importReferencedOWLKnowledge();
    }

    @Override
    public void processSQWRLQuery(String string) throws SWRLRuleEngineException {
        this.reset();
        this.importSQWRLQuery(string);
        this.importReferencedOWLKnowledge();
    }

    private void importSWRLRuleOrSQWRLQuery(SWRLRuleReference sWRLRuleReference) throws BuiltInException {
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            this.processSWRLAtom(sWRLRuleReference, sWRLAtomReference, false);
        }
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getHeadAtoms()) {
            this.processSWRLAtom(sWRLRuleReference, sWRLAtomReference, true);
        }
        this.buildReferencedVariableNames(sWRLRuleReference);
        this.processUnboundBuiltInArguments(sWRLRuleReference);
        this.processSQWRLBuiltIns(sWRLRuleReference);
        this.processBuiltInArgumentDependencies(sWRLRuleReference);
        if (this.isSQWRLQuery(sWRLRuleReference)) {
            this.queries.put(sWRLRuleReference.getURI(), sWRLRuleReference);
        }
        this.rules.put(sWRLRuleReference.getURI(), sWRLRuleReference);
    }

    public void importReferencedOWLAxioms() throws SWRLRuleEngineException {
        this.importReferencedOWLKnowledge();
    }

    @Override
    public SWRLRuleReference getSQWRLQuery(String string) throws SQWRLException {
        if (!this.queries.containsKey(string)) {
            throw new SQWRLException("invalid query name " + string);
        }
        return this.queries.get(string);
    }

    @Override
    public SWRLRuleReference getSWRLRule(String string) throws SWRLRuleEngineException {
        if (!this.swrlRules.containsKey(string)) {
            throw new SWRLRuleEngineException("invalid rule name " + string);
        }
        return this.swrlRules.get(string);
    }

    @Override
    public int getNumberOfReferencedSWRLRules() {
        return this.swrlRules.values().size();
    }

    public int getNumberOfReferencedOWLDeclarationAxioms() {
        return this.relevantOWLDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfReferencedOWLClassDeclarationAxioms() {
        return this.relevantOWLClassDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfReferencedOWLPropertyDeclarationAxioms() {
        return this.relevantOWLPropertyDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfReferencedOWLIndividualDeclarationAxioms() {
        return this.relevantOWLIndividualDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfReferencedOWLAxioms() {
        return this.relevantOWLAxioms.size();
    }

    @Override
    public Set<SWRLRuleReference> getSWRLRules() {
        return new HashSet<SWRLRuleReference>(this.swrlRules.values());
    }

    @Override
    public Set<OWLDeclarationAxiomReference> getRelevantOWLDeclarationAxioms() {
        return new HashSet<OWLDeclarationAxiomReference>(this.relevantOWLDeclarationAxioms.values());
    }

    @Override
    public Set<OWLDeclarationAxiomReference> getRelevantOWLClassDeclarationsAxioms() {
        return new HashSet<OWLDeclarationAxiomReference>(this.relevantOWLClassDeclarationAxioms.values());
    }

    @Override
    public Set<OWLDeclarationAxiomReference> getRelevantOWLPropertyDeclarationAxioms() {
        return new HashSet<OWLDeclarationAxiomReference>(this.relevantOWLPropertyDeclarationAxioms.values());
    }

    @Override
    public Set<OWLDeclarationAxiomReference> getRelevantOWLIndividualDeclarationAxioms() {
        return new HashSet<OWLDeclarationAxiomReference>(this.relevantOWLIndividualDeclarationAxioms.values());
    }

    @Override
    public Set<OWLAxiomReference> getRelevantOWLAxioms() {
        return new HashSet<OWLAxiomReference>(this.relevantOWLAxioms);
    }

    @Override
    public boolean isRelevantOWLClass(String string) {
        return this.relevantOWLClassDeclarationAxioms.containsKey(string);
    }

    @Override
    public boolean isRelevantOWLIndividual(String string) {
        return this.relevantOWLIndividualDeclarationAxioms.containsKey(string);
    }

    @Override
    public boolean isRelevantOWLObjectProperty(String string) {
        return this.relevantOWLObjectPropertyURIs.contains(string);
    }

    @Override
    public boolean isRelevantOWLDataProperty(String string) {
        return this.relevantOWLDataPropertyURIs.contains(string);
    }

    public Set<OWLNamedIndividualReference> getAllOWLIndividuals() {
        return new HashSet<OWLNamedIndividualReference>(this.allOWLIndividuals.values());
    }

    @Override
    public boolean isSQWRLQuery(String string) {
        return this.hasSQWRLBuiltInsMap.containsKey(string) && this.hasSQWRLBuiltInsMap.get(string) != false || this.hasSQWRLCollectionBuiltInsMap.containsKey(string) && this.hasSQWRLCollectionBuiltInsMap.get(string) != false;
    }

    @Override
    public boolean usesSQWRLCollections(SWRLRuleReference sWRLRuleReference) {
        String string = sWRLRuleReference.getURI();
        return this.hasSQWRLCollectionBuiltInsMap.containsKey(string) && this.hasSQWRLCollectionBuiltInsMap.get(string) != false;
    }

    @Override
    public String getRuleGroupName(String string) {
        if (this.ruleGroupNameMap.containsKey(string)) {
            return this.ruleGroupNameMap.get(string);
        }
        return "";
    }

    @Override
    public void setRuleGroupName(String string, String string2) {
        this.ruleGroupNameMap.put(string, string2);
    }

    @Override
    public boolean isEnabled(String string) {
        return this.enabledMap.containsKey(string) && this.enabledMap.get(string) != false;
    }

    @Override
    public void setEnabled(String string, boolean bl) {
        this.enabledMap.put(string, bl);
    }

    @Override
    public Set<String> getRelevantOWLClassURIs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : this.relevantOWLClassURIMap.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public Set<String> getRelevantOWLPropertyURIs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : this.relevantOWLPropertyURIMap.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public void addReferencedIndividualURI(String string) {
        if (this.relevantOWLIndividualURIMap.containsKey("")) {
            this.relevantOWLIndividualURIMap.get("").add(string);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.relevantOWLIndividualURIMap.put("", hashSet);
        }
    }

    @Override
    public Set<String> getRelevantOWLIndividualURIs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : this.relevantOWLIndividualURIMap.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public Set<String> getRelevantOWLClassURIs(SWRLRuleReference sWRLRuleReference) {
        return this.relevantOWLClassURIMap.get(sWRLRuleReference.getURI());
    }

    @Override
    public Set<String> getRelevantOWLPropertyURIs(SWRLRuleReference sWRLRuleReference) {
        return this.relevantOWLPropertyURIMap.get(sWRLRuleReference.getURI());
    }

    @Override
    public Set<String> getRelevantOWLIndividualURIs(SWRLRuleReference sWRLRuleReference) {
        return this.relevantOWLIndividualURIMap.get(sWRLRuleReference.getURI());
    }

    @Override
    public SQWRLResultImpl getSQWRLResult(String string) throws SQWRLException {
        if (!this.queries.containsKey(string)) {
            throw new InvalidQueryNameException(string);
        }
        SQWRLResultImpl sQWRLResultImpl = this.sqwrlResultMap.get(string);
        if (!sQWRLResultImpl.isPrepared()) {
            sQWRLResultImpl.prepared();
        }
        return sQWRLResultImpl;
    }

    @Override
    public SQWRLResultImpl getSQWRLUnpreparedResult(String string) throws SQWRLException {
        if (!this.queries.containsKey(string)) {
            throw new InvalidQueryNameException(string);
        }
        return this.sqwrlResultMap.get(string);
    }

    public boolean isSQWRLQuery(SWRLRuleReference sWRLRuleReference) {
        return !this.getBuiltInAtomsFromHead(sWRLRuleReference, SQWRLNames.getSQWRLBuiltInNames()).isEmpty() || !this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getSQWRLBuiltInNames()).isEmpty();
    }

    public boolean hasSQWRLCollectionBuiltIns(SWRLRuleReference sWRLRuleReference) {
        return !this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getCollectionMakeBuiltInNames()).isEmpty();
    }

    @Override
    public List<SWRLAtomReference> getSQWRLPhase1BodyAtoms(SWRLRuleReference sWRLRuleReference) {
        ArrayList<SWRLAtomReference> arrayList = new ArrayList<SWRLAtomReference>();
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            SWRLBuiltInAtomReference sWRLBuiltInAtomReference;
            if (sWRLAtomReference instanceof SWRLBuiltInAtomReference && ((sWRLBuiltInAtomReference = (SWRLBuiltInAtomReference)sWRLAtomReference).usesSQWRLCollectionResults() || sWRLBuiltInAtomReference.isSQWRLGroupCollection())) continue;
            arrayList.add(sWRLAtomReference);
        }
        return arrayList;
    }

    @Override
    public List<SWRLAtomReference> getSQWRLPhase2BodyAtoms(SWRLRuleReference sWRLRuleReference) {
        ArrayList<SWRLAtomReference> arrayList = new ArrayList<SWRLAtomReference>();
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            SWRLBuiltInAtomReference sWRLBuiltInAtomReference;
            if (sWRLAtomReference instanceof SWRLBuiltInAtomReference && ((sWRLBuiltInAtomReference = (SWRLBuiltInAtomReference)sWRLAtomReference).isSQWRLMakeCollection() || sWRLBuiltInAtomReference.isSQWRLGroupCollection())) continue;
            arrayList.add(sWRLAtomReference);
        }
        return arrayList;
    }

    @Override
    public Set<SWRLRuleReference> getSQWRLQueries() throws SQWRLException {
        HashSet<SWRLRuleReference> hashSet = new HashSet<SWRLRuleReference>();
        try {
            for (SWRLRuleReference sWRLRuleReference : this.dataFactory.getSWRLRules()) {
                if (!this.isSQWRLQuery(sWRLRuleReference)) continue;
                hashSet.add(sWRLRuleReference);
            }
        }
        catch (OWLFactoryException oWLFactoryException) {
            throw new SQWRLException("factory error importing SQWRL queries: " + oWLFactoryException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<String> getSQWRLQueryNames() throws SQWRLException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            for (SWRLRuleReference sWRLRuleReference : this.dataFactory.getSWRLRules()) {
                if (!this.isSQWRLQuery(sWRLRuleReference)) continue;
                hashSet.add(sWRLRuleReference.getURI());
            }
        }
        catch (OWLFactoryException oWLFactoryException) {
            throw new SQWRLException("factory error importing SQWRL queries: " + oWLFactoryException.getMessage());
        }
        return hashSet;
    }

    private void importSWRLRules() throws SWRLRuleEngineException {
        try {
            for (SWRLRuleReference sWRLRuleReference : this.dataFactory.getSWRLRules()) {
                if (this.isSQWRLQuery(sWRLRuleReference)) continue;
                this.importSWRLRule(sWRLRuleReference);
            }
        }
        catch (OWLFactoryException oWLFactoryException) {
            throw new SWRLRuleEngineBridgeException("factory error importing rules: " + oWLFactoryException.getMessage());
        }
    }

    private void importSWRLRule(SWRLRuleReference sWRLRuleReference) throws SWRLRuleEngineBridgeException {
        try {
            this.swrlRules.put(sWRLRuleReference.getURI(), sWRLRuleReference);
            this.importSWRLRuleOrSQWRLQuery(sWRLRuleReference);
        }
        catch (SQWRLException sQWRLException) {
            throw new SWRLRuleEngineBridgeException("SQWRL error importing rules: " + sQWRLException.getMessage());
        }
        catch (BuiltInException builtInException) {
            throw new SWRLRuleEngineBridgeException("built-in error importing rules: " + builtInException.getMessage());
        }
    }

    private void importSQWRLQuery(String string) throws SWRLRuleEngineException {
        try {
            for (SWRLRuleReference sWRLRuleReference : this.dataFactory.getSWRLRules()) {
                if (this.isSQWRLQuery(sWRLRuleReference) && !sWRLRuleReference.getURI().equals(string)) continue;
                this.importSWRLRule(sWRLRuleReference);
            }
        }
        catch (OWLFactoryException oWLFactoryException) {
            throw new SWRLRuleEngineBridgeException("factory error importing rule " + string + ": " + oWLFactoryException.getMessage());
        }
    }

    private void importReferencedOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.importOWLClassDeclarationAxiomsByName(this.getRelevantOWLClassURIs());
        this.importOWLPropertyAssertionAxiomsByName(this.getRelevantOWLPropertyURIs());
        this.importOWLIndividualsByName(this.getRelevantOWLIndividualURIs());
        this.importAllOWLIndividualsOfClassesByName(this.getRelevantOWLClassURIs());
        this.importOWLAxioms();
    }

    private void processUnboundBuiltInArguments(SWRLRuleReference sWRLRuleReference) {
        ArrayList<SWRLBuiltInAtomReference> arrayList = new ArrayList<SWRLBuiltInAtomReference>();
        ArrayList<SWRLAtomReference> arrayList2 = new ArrayList<SWRLAtomReference>();
        ArrayList<SWRLAtomReference> arrayList3 = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            if (sWRLAtomReference instanceof SWRLBuiltInAtomReference) {
                arrayList.add((SWRLBuiltInAtomReference)sWRLAtomReference);
                continue;
            }
            arrayList2.add(sWRLAtomReference);
            hashSet.addAll(sWRLAtomReference.getReferencedVariableNames());
        }
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : arrayList) {
            for (BuiltInArgument builtInArgument : sWRLBuiltInAtomReference.getArguments()) {
                String string;
                if (!builtInArgument.isVariable() || hashSet.contains(string = builtInArgument.getVariableName()) || hashSet2.contains(string)) continue;
                builtInArgument.setUnbound();
                hashSet2.add(string);
            }
        }
        arrayList3 = this.processBodyNonBuiltInAtoms(arrayList2);
        sWRLRuleReference.setBodyAtoms(arrayList3);
        arrayList3.addAll(arrayList);
    }

    private void processBuiltInArgumentDependencies(SWRLRuleReference sWRLRuleReference) throws BuiltInException {
        HashMap<String, Set<Set<String>>> hashMap = new HashMap<String, Set<Set<String>>>();
        HashSet<String> hashSet = new HashSet<String>();
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            SWRLBuiltInAtomReference sWRLBuiltInAtomReference;
            HashSet<String> hashSet2 = new HashSet<String>(sWRLAtomReference.getReferencedVariableNames());
            this.buildPaths(sWRLAtomReference, hashSet, hashMap);
            if (!(sWRLAtomReference instanceof SWRLBuiltInAtomReference) || (sWRLBuiltInAtomReference = (SWRLBuiltInAtomReference)sWRLAtomReference).isSQWRLGroupCollection()) continue;
            if (sWRLBuiltInAtomReference.isSQWRLCollectionOperation()) break;
            if (!sWRLBuiltInAtomReference.hasReferencedVariables()) continue;
            HashSet<String> hashSet3 = new HashSet<String>();
            for (String string : hashMap.keySet()) {
                for (Set set : (Set)hashMap.get(string)) {
                    if (Collections.disjoint(set, hashSet2)) continue;
                    hashSet3.addAll(set);
                    hashSet3.add(string);
                }
            }
            if (hashSet3.isEmpty()) continue;
            hashSet3.removeAll(hashSet2);
            sWRLBuiltInAtomReference.setPathVariableNames(hashSet3);
        }
    }

    private void buildPaths(SWRLAtomReference sWRLAtomReference, Set<String> set, Map<String, Set<Set<String>>> map) {
        block15: {
            Set<String> set2;
            block14: {
                set2 = sWRLAtomReference.getReferencedVariableNames();
                if (set2.size() != 1) break block14;
                String string = set2.iterator().next();
                if (!this.getMatchingPaths(map, string).isEmpty() || set.contains(string)) break block15;
                HashSet hashSet = new HashSet();
                map.put(string, hashSet);
                set.add(string);
                break block15;
            }
            if (set2.size() > 1) {
                HashSet<String> hashSet = new HashSet<String>(set2);
                hashSet.retainAll(set);
                if (!hashSet.isEmpty()) {
                    for (String string : hashSet) {
                        HashSet<String> hashSet2 = new HashSet<String>(set2);
                        hashSet2.remove(string);
                        Set<String> set3 = this.getMatchingRootVariableNames(map, hashSet2);
                        if (!set3.isEmpty()) {
                            for (String string2 : set3) {
                                Set<Set<String>> set4 = map.get(string2);
                                HashSet<Set<String>> hashSet3 = new HashSet<Set<String>>();
                                for (Set<String> set5 : set4) {
                                    if (Collections.disjoint(set5, hashSet2)) continue;
                                    hashSet3.add(set5);
                                }
                                for (Set<String> set5 : hashSet3) {
                                    HashSet<String> hashSet4 = new HashSet<String>(set5);
                                    hashSet4.addAll(hashSet2);
                                    set4.remove(set5);
                                    set4.add(Collections.unmodifiableSet(hashSet4));
                                }
                            }
                            continue;
                        }
                        Set<Set<String>> set6 = map.get(string);
                        set6.add(Collections.unmodifiableSet(hashSet2));
                    }
                } else {
                    Set<String> set7 = this.getMatchingRootVariableNames(map, set2);
                    if (!set7.isEmpty()) {
                        for (String string : set7) {
                            Set<Set<String>> set8 = map.get(string);
                            HashSet<Set<String>> hashSet5 = new HashSet<Set<String>>();
                            for (Set<String> set9 : set8) {
                                if (Collections.disjoint(set9, set2)) continue;
                                hashSet5.add(set9);
                            }
                            for (Set<String> set9 : hashSet5) {
                                HashSet<String> hashSet6 = new HashSet<String>(set9);
                                hashSet6.addAll(set2);
                                set8.remove(set9);
                                set8.add(Collections.unmodifiableSet(hashSet6));
                            }
                        }
                    } else {
                        for (String string : set2) {
                            HashSet<Set<String>> hashSet7 = new HashSet<Set<String>>();
                            HashSet<String> hashSet8 = new HashSet<String>(set2);
                            hashSet8.remove(string);
                            hashSet7.add(Collections.unmodifiableSet(hashSet8));
                            map.put(string, hashSet7);
                            set.add(string);
                        }
                    }
                }
            }
        }
    }

    private Set<String> getVariableNames(List<BuiltInArgument> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInArgument builtInArgument : list) {
            if (!builtInArgument.isVariable()) continue;
            hashSet.add(builtInArgument.getVariableName());
        }
        return hashSet;
    }

    private Set<String> getMatchingPaths(Map<String, Set<Set<String>>> map, String string) {
        return this.getMatchingRootVariableNames(map, Collections.singleton(string));
    }

    private Set<String> getMatchingRootVariableNames(Map<String, Set<Set<String>>> map, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : map.keySet()) {
            Set<Set<String>> set2 = map.get(string);
            for (Set<String> set3 : set2) {
                if (Collections.disjoint(set3, set)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private List<SWRLAtomReference> processBodyNonBuiltInAtoms(List<SWRLAtomReference> list) {
        ArrayList<SWRLAtomReference> arrayList = new ArrayList<SWRLAtomReference>();
        ArrayList<SWRLAtomReference> arrayList2 = new ArrayList<SWRLAtomReference>();
        ArrayList<SWRLAtomReference> arrayList3 = new ArrayList<SWRLAtomReference>();
        for (SWRLAtomReference sWRLAtomReference : list) {
            if (sWRLAtomReference instanceof SWRLClassAtomReference) {
                arrayList.add(sWRLAtomReference);
                continue;
            }
            arrayList2.add(sWRLAtomReference);
        }
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    private void processSQWRLHeadBuiltIns(SWRLRuleReference sWRLRuleReference) throws DataValueConversionException, SQWRLException, BuiltInException {
        ArrayList<String> arrayList = new ArrayList<String>();
        SQWRLResultImpl sQWRLResultImpl = this.sqwrlResultMap.get(sWRLRuleReference.getURI());
        this.processBuiltInIndexes(sWRLRuleReference);
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromHead(sWRLRuleReference, SQWRLNames.getHeadBuiltInNames())) {
            int n;
            String string = sWRLBuiltInAtomReference.getPredicate();
            this.hasSQWRLBuiltInsMap.put(sWRLRuleReference.getURI(), true);
            for (BuiltInArgument builtInArgument : sWRLBuiltInAtomReference.getArguments()) {
                int n2;
                String string2;
                boolean bl = builtInArgument.isVariable();
                String string3 = null;
                if (!SQWRLNames.isSQWRLHeadSelectionBuiltIn(string) && !SQWRLNames.isSQWRLHeadAggregationBuiltIn(string)) continue;
                if (bl) {
                    string3 = builtInArgument.getVariableName();
                    arrayList.add(string3);
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#select")) {
                    string2 = bl ? "?" + string3 : "[" + builtInArgument + "]";
                    sQWRLResultImpl.addColumn(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#selectDistinct")) {
                    string2 = bl ? "?" + string3 : "[" + builtInArgument + "]";
                    sQWRLResultImpl.addColumn(string2);
                    sQWRLResultImpl.setIsDistinct();
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#count")) {
                    string2 = bl ? "count(?" + string3 + ")" : "[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "count");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#countDistinct")) {
                    string2 = bl ? "countDistinct(?" + string3 + ")" : "[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "countDistinct");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#min")) {
                    string2 = bl ? "min(?" + string3 + ")" : "min[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "min");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#max")) {
                    string2 = bl ? "max(?" + string3 + ")" : "max[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "max");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#sum")) {
                    string2 = bl ? "sum(?" + string3 + ")" : "sum[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "sum");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#median")) {
                    string2 = bl ? "median(?" + string3 + ")" : "median[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "median");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#avg")) {
                    string2 = bl ? "avg(?" + string3 + ")" : "avg[" + builtInArgument + "]";
                    sQWRLResultImpl.addAggregateColumn(string2, "avg");
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#orderBy")) {
                    if (!bl) {
                        throw new SQWRLException("only variables allowed for ordered columns - found " + builtInArgument);
                    }
                    n2 = arrayList.indexOf(string3);
                    if (n2 != -1) {
                        sQWRLResultImpl.addOrderByColumn(n2, true);
                        continue;
                    }
                    throw new SQWRLException("variable ?" + string3 + " must be selected before it can be ordered");
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#orderByDescending")) {
                    if (!bl) {
                        throw new SQWRLException("only variables allowed for ordered columns - found " + builtInArgument);
                    }
                    n2 = arrayList.indexOf(string3);
                    if (n2 != -1) {
                        sQWRLResultImpl.addOrderByColumn(n2, false);
                        continue;
                    }
                    throw new SQWRLException("variable ?" + string3 + " must be selected before it can be ordered");
                }
                if (!string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#columnNames")) continue;
                if (builtInArgument instanceof SWRLLiteralArgumentReference && ((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isString()) {
                    SWRLLiteralArgumentReference sWRLLiteralArgumentReference = (SWRLLiteralArgumentReference)builtInArgument;
                    sQWRLResultImpl.addColumnDisplayName(sWRLLiteralArgumentReference.getLiteral().getString());
                    continue;
                }
                throw new SQWRLException("only string literals allowed as column names - found " + builtInArgument);
            }
            if (!SQWRLNames.isSQWRLHeadSlicingBuiltIn(string)) continue;
            if (!sQWRLResultImpl.isOrdered() && !string.equals("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#limit")) {
                throw new SQWRLException("slicing operator used without an order clause");
            }
            if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#least") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#first")) {
                if (!sWRLBuiltInAtomReference.getArguments().isEmpty()) {
                    throw new SQWRLException("first or least do not accept arguments");
                }
                sQWRLResultImpl.setFirst();
                continue;
            }
            if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notLeast") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notFirst")) {
                if (!sWRLBuiltInAtomReference.getArguments().isEmpty()) {
                    throw new SQWRLException("not first or least do not accept arguments");
                }
                sQWRLResultImpl.setNotFirst();
                continue;
            }
            if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#greatest") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#last")) {
                if (!sWRLBuiltInAtomReference.getArguments().isEmpty()) {
                    throw new SQWRLException("greatest or last do not accept arguments");
                }
                sQWRLResultImpl.setLast();
                continue;
            }
            if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notGreatest") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notLast")) {
                if (!sWRLBuiltInAtomReference.getArguments().isEmpty()) {
                    throw new SQWRLException("not greatest or last do not accept arguments");
                }
                sQWRLResultImpl.setNotLast();
                continue;
            }
            BuiltInArgument builtInArgument = sWRLBuiltInAtomReference.getArguments().get(0);
            if (builtInArgument instanceof SWRLLiteralArgumentReference && ((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isLong()) {
                n = (int)((SWRLLiteralArgumentReference)builtInArgument).getLiteral().getLong();
                if (n < 1) {
                    throw new SQWRLException("nth argument to slicing operator " + string + " must be a positive integer");
                }
            } else {
                throw new SQWRLException("expecing integer to slicing operator " + string);
            }
            if (sWRLBuiltInAtomReference.getArguments().size() == 1) {
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#limit")) {
                    sQWRLResultImpl.setLimit(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#nth")) {
                    sQWRLResultImpl.setNth(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notNth")) {
                    sQWRLResultImpl.setNotNth(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#firstN") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#leastN")) {
                    sQWRLResultImpl.setFirst(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#lastN") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#greatestN")) {
                    sQWRLResultImpl.setLast(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notLastN") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notGreatestN")) {
                    sQWRLResultImpl.setNotLast(n);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notFirstN") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notLeastN")) {
                    sQWRLResultImpl.setNotFirst(n);
                    continue;
                }
                throw new SQWRLException("unknown slicing operator " + string);
            }
            if (sWRLBuiltInAtomReference.getArguments().size() == 2) {
                int n3;
                BuiltInArgument builtInArgument2 = sWRLBuiltInAtomReference.getArguments().get(1);
                if (builtInArgument2 instanceof SWRLLiteralArgumentReference && ((SWRLLiteralArgumentReference)builtInArgument2).getLiteral().isLong()) {
                    n3 = (int)((SWRLLiteralArgumentReference)builtInArgument2).getLiteral().getLong();
                    if (n3 < 1) {
                        throw new SQWRLException("slice size argument to slicing operator " + string + " must be a positive integer");
                    }
                } else {
                    throw new SQWRLException("expecing integer to slicing operator " + string);
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#nthSlice")) {
                    sQWRLResultImpl.setNthSlice(n, n3);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notNthSlice")) {
                    sQWRLResultImpl.setNotNthSlice(n, n3);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#nthLastSlice") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#nthGreatestSlice")) {
                    sQWRLResultImpl.setNthLastSlice(n, n3);
                    continue;
                }
                if (string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notNthLastSlice") || string.equalsIgnoreCase("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#notNthGreatestSlice")) {
                    sQWRLResultImpl.setNotNthLastSlice(n, n3);
                    continue;
                }
                throw new SQWRLException("unknown slicing operator " + string);
            }
            throw new SQWRLException("unknown slicing operator " + string);
        }
    }

    private void processSQWRLBuiltIns(SWRLRuleReference sWRLRuleReference) throws DataValueConversionException, SQWRLException, BuiltInException {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        SQWRLResultImpl sQWRLResultImpl = new SQWRLResultImpl();
        this.sqwrlResultMap.put(sWRLRuleReference.getURI(), sQWRLResultImpl);
        this.processSQWRLHeadBuiltIns(sWRLRuleReference);
        this.processSQWRLCollectionMakeBuiltIns(sWRLRuleReference, hashSet);
        this.processSQWRLCollectionGroupByBuiltIns(sWRLRuleReference, hashSet);
        this.processSQWRLCollectionMakeGroupArguments(sWRLRuleReference, hashSet);
        this.processSQWRLCollectionOperationBuiltIns(sWRLRuleReference, hashSet, hashSet2);
        this.processBuiltInsThatUseSQWRLCollectionOperationResults(sWRLRuleReference, hashSet2);
        sQWRLResultImpl.configured();
        sQWRLResultImpl.openRow();
        if (this.hasSQWRLCollectionBuiltIns(sWRLRuleReference)) {
            sQWRLResultImpl.setIsDistinct();
        }
    }

    private void processSQWRLCollectionMakeBuiltIns(SWRLRuleReference sWRLRuleReference, Set<String> set) throws SQWRLException, BuiltInException {
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getCollectionMakeBuiltInNames())) {
            String string = sWRLBuiltInAtomReference.getArgumentVariableName(0);
            this.hasSQWRLCollectionBuiltInsMap.put(sWRLRuleReference.getURI(), true);
            if (set.contains(string)) continue;
            set.add(string);
        }
    }

    private void processSQWRLCollectionGroupByBuiltIns(SWRLRuleReference sWRLRuleReference, Set<String> set) throws SQWRLException, BuiltInException {
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getCollectionGroupByBuiltInNames())) {
            Map<Object, Object> map;
            String string = sWRLBuiltInAtomReference.getArgumentVariableName(0);
            List<BuiltInArgument> list = sWRLBuiltInAtomReference.getArguments();
            List<BuiltInArgument> list2 = list.subList(1, list.size());
            String string2 = sWRLRuleReference.getURI();
            this.hasSQWRLCollectionBuiltInsMap.put(string2, true);
            if (sWRLBuiltInAtomReference.getArguments().size() < 2) {
                throw new SQWRLException("groupBy must have at least two arguments");
            }
            if (!set.contains(string)) {
                throw new SQWRLException("groupBy applied to undefined collection ?" + string);
            }
            if (this.collectionGroupArgumentsMap.containsKey(string)) {
                throw new SQWRLException("groupBy specified more than once for same collection ?" + string);
            }
            if (this.hasUnboundArgument(list2)) {
                throw new SQWRLException("unbound group argument passed to groupBy for collection ?" + string);
            }
            if (this.collectionGroupArgumentsMap.containsKey(string2)) {
                map = this.collectionGroupArgumentsMap.get(string2);
            } else {
                map = new HashMap();
                this.collectionGroupArgumentsMap.put(string2, map);
            }
            map.put(string, list2);
        }
    }

    private void processSQWRLCollectionMakeGroupArguments(SWRLRuleReference sWRLRuleReference, Set<String> set) throws SQWRLException, BuiltInException {
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getCollectionMakeBuiltInNames())) {
            Map<Object, Object> map;
            String string = sWRLBuiltInAtomReference.getArgumentVariableName(0);
            String string2 = sWRLRuleReference.getURI();
            if (!set.contains(string)) {
                throw new SQWRLException("groupBy applied to undefined collection ?" + string);
            }
            if (this.collectionGroupArgumentsMap.containsKey(string2)) {
                map = this.collectionGroupArgumentsMap.get(string2);
            } else {
                map = new HashMap();
                this.collectionGroupArgumentsMap.put(string2, map);
            }
            if (!map.containsKey(string)) continue;
            sWRLBuiltInAtomReference.addArguments((List)map.get(string));
        }
    }

    private void processSQWRLCollectionOperationBuiltIns(SWRLRuleReference sWRLRuleReference, Set<String> set, Set<String> set2) throws SQWRLException, BuiltInException {
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference, SQWRLNames.getCollectionOperationBuiltInNames())) {
            Map<Object, Object> map;
            Object object;
            ArrayList arrayList = new ArrayList();
            String string = sWRLRuleReference.getURI();
            sWRLBuiltInAtomReference.setUsesSQWRLCollectionResults();
            if (sWRLBuiltInAtomReference.hasUnboundArguments()) {
                object = sWRLBuiltInAtomReference.getUnboundArgumentVariableNames();
                set2.addAll((Collection<String>)object);
            }
            List<String> list = sWRLBuiltInAtomReference.isSQWRLCollectionCreateOperation() ? sWRLBuiltInAtomReference.getArgumentsVariableNamesExceptFirst() : sWRLBuiltInAtomReference.getArgumentsVariableNames();
            if (this.collectionGroupArgumentsMap.containsKey(string)) {
                map = this.collectionGroupArgumentsMap.get(string);
            } else {
                map = new HashMap();
                this.collectionGroupArgumentsMap.put(string, map);
            }
            for (String string2 : list) {
                if (!set.contains(string2) || !map.containsKey(string2)) continue;
                sWRLBuiltInAtomReference.addArguments((List)map.get(string2));
                arrayList.addAll((Collection)map.get(string2));
            }
            if (!sWRLBuiltInAtomReference.isSQWRLCollectionCreateOperation()) continue;
            object = sWRLBuiltInAtomReference.getArgumentVariableName(0);
            if (!set.contains(object)) {
                set.add((String)object);
            }
            if (arrayList.isEmpty()) continue;
            map.put(object, arrayList);
        }
    }

    private void processBuiltInsThatUseSQWRLCollectionOperationResults(SWRLRuleReference sWRLRuleReference, Set<String> set) throws SQWRLException, BuiltInException {
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference)) {
            if (sWRLBuiltInAtomReference.isSQWRLBuiltIn() || !sWRLBuiltInAtomReference.usesAtLeastOneVariableOf(set)) continue;
            sWRLBuiltInAtomReference.setUsesSQWRLCollectionResults();
            if (!sWRLBuiltInAtomReference.hasUnboundArguments()) continue;
            set.addAll(sWRLBuiltInAtomReference.getUnboundArgumentVariableNames());
        }
    }

    private void buildReferencedVariableNames(SWRLRuleReference sWRLRuleReference) {
        String string = sWRLRuleReference.getURI();
        for (SWRLAtomReference sWRLAtomReference : sWRLRuleReference.getBodyAtoms()) {
            if (this.referencedVariableNameMap.containsKey(string)) {
                this.referencedVariableNameMap.get(string).addAll(sWRLAtomReference.getReferencedVariableNames());
                continue;
            }
            this.referencedVariableNameMap.put(string, new HashSet<String>(sWRLAtomReference.getReferencedVariableNames()));
        }
    }

    private void processBuiltInIndexes(SWRLRuleReference sWRLRuleReference) {
        int n = 0;
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromBody(sWRLRuleReference)) {
            sWRLBuiltInAtomReference.setBuiltInIndex(n++);
        }
        for (SWRLBuiltInAtomReference sWRLBuiltInAtomReference : this.getBuiltInAtomsFromHead(sWRLRuleReference)) {
            sWRLBuiltInAtomReference.setBuiltInIndex(n++);
        }
    }

    private boolean hasUnboundArgument(List<BuiltInArgument> list) {
        for (BuiltInArgument builtInArgument : list) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    private void processSWRLAtom(SWRLRuleReference sWRLRuleReference, SWRLAtomReference sWRLAtomReference, boolean bl) {
        String string = sWRLRuleReference.getURI();
        if (sWRLAtomReference.hasReferencedClasses()) {
            if (this.relevantOWLClassURIMap.containsKey(string)) {
                this.relevantOWLClassURIMap.get(string).addAll(sWRLAtomReference.getReferencedClassURIs());
            } else {
                this.relevantOWLClassURIMap.put(string, sWRLAtomReference.getReferencedClassURIs());
            }
        }
        if (sWRLAtomReference.hasReferencedProperties()) {
            if (this.relevantOWLPropertyURIMap.containsKey(string)) {
                this.relevantOWLPropertyURIMap.get(string).addAll(sWRLAtomReference.getReferencedPropertyURIs());
            } else {
                this.relevantOWLPropertyURIMap.put(string, sWRLAtomReference.getReferencedPropertyURIs());
            }
        }
        if (sWRLAtomReference.hasReferencedIndividuals()) {
            if (this.relevantOWLIndividualURIMap.containsKey(string)) {
                this.relevantOWLIndividualURIMap.get(string).addAll(sWRLAtomReference.getReferencedIndividualURIs());
            } else {
                this.relevantOWLIndividualURIMap.put(string, sWRLAtomReference.getReferencedIndividualURIs());
            }
        }
    }

    private List<SWRLBuiltInAtomReference> getBuiltInAtoms(List<SWRLAtomReference> list, Set<String> set) {
        ArrayList<SWRLBuiltInAtomReference> arrayList = new ArrayList<SWRLBuiltInAtomReference>();
        for (SWRLAtomReference sWRLAtomReference : list) {
            SWRLBuiltInAtomReference sWRLBuiltInAtomReference;
            if (!(sWRLAtomReference instanceof SWRLBuiltInAtomReference) || !set.contains((sWRLBuiltInAtomReference = (SWRLBuiltInAtomReference)sWRLAtomReference).getPredicate())) continue;
            arrayList.add(sWRLBuiltInAtomReference);
        }
        return arrayList;
    }

    private List<SWRLBuiltInAtomReference> getBuiltInAtoms(List<SWRLAtomReference> list) {
        ArrayList<SWRLBuiltInAtomReference> arrayList = new ArrayList<SWRLBuiltInAtomReference>();
        for (SWRLAtomReference sWRLAtomReference : list) {
            if (!(sWRLAtomReference instanceof SWRLBuiltInAtomReference)) continue;
            arrayList.add((SWRLBuiltInAtomReference)sWRLAtomReference);
        }
        return arrayList;
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromHead(SWRLRuleReference sWRLRuleReference) {
        return this.getBuiltInAtoms(sWRLRuleReference.getHeadAtoms());
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromHead(SWRLRuleReference sWRLRuleReference, Set<String> set) {
        return this.getBuiltInAtoms(sWRLRuleReference.getHeadAtoms(), set);
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromBody(SWRLRuleReference sWRLRuleReference) {
        return this.getBuiltInAtoms(sWRLRuleReference.getBodyAtoms());
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromBody(SWRLRuleReference sWRLRuleReference, Set<String> set) {
        return this.getBuiltInAtoms(sWRLRuleReference.getBodyAtoms(), set);
    }

    private void importOWLClassDeclarationAxiomsByName(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLClassDeclarationAxiom(string);
        }
    }

    private void importOWLClassDeclarationAxioms(Set<OWLClassReference> set) throws SWRLRuleEngineBridgeException {
        for (OWLClassReference oWLClassReference : set) {
            this.importOWLClassDeclarationAxiom(oWLClassReference.getURI());
        }
    }

    private void importOWLClassDeclarationAxiom(String string) throws SWRLRuleEngineBridgeException {
        try {
            if (this.activeOntology.isOWLNamedClass(string)) {
                OWLClassReference oWLClassReference = this.activeOntology.getOWLClass(string);
                if (!this.relevantOWLClassDeclarationAxioms.containsKey(string)) {
                    OWLDeclarationAxiomReference oWLDeclarationAxiomReference = this.dataFactory.getOWLDeclarationAxiom(oWLClassReference);
                    this.relevantOWLDeclarationAxioms.put(string, oWLDeclarationAxiomReference);
                    this.relevantOWLClassDeclarationAxioms.put(string, oWLDeclarationAxiomReference);
                    this.relevantOWLAxioms.add(oWLDeclarationAxiomReference);
                    this.importOWLClassDeclarationAxioms(oWLClassReference.getSuperClasses());
                    this.importOWLClassDeclarationAxioms(oWLClassReference.getSubClasses());
                    this.importOWLClassDeclarationAxioms(oWLClassReference.getEquivalentClasses());
                }
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SWRLRuleEngineBridgeException("error importing owl class " + string + ": " + oWLConversionFactoryException.getMessage());
        }
    }

    private void importAllOWLIndividualsOfClassesByName(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importAllOWLIndividualsOfClass(string);
        }
    }

    private void importAllOWLIndividualsOfClass(String string) throws SWRLRuleEngineBridgeException {
        try {
            for (OWLNamedIndividualReference oWLNamedIndividualReference : this.activeOntology.getAllOWLIndividualsOfClass(string)) {
                this.importOWLIndividualDeclarationAxiom(oWLNamedIndividualReference.getURI());
                this.importOWLClassAssertionAxiom(string, oWLNamedIndividualReference.getURI());
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SWRLRuleEngineBridgeException("error importing OWL individual declaration axioms: " + oWLConversionFactoryException);
        }
    }

    private void importOWLClassAssertionAxiom(String string, String string2) throws SWRLRuleEngineBridgeException {
        OWLClassReference oWLClassReference = this.dataFactory.getOWLClass(string);
        OWLNamedIndividualReference oWLNamedIndividualReference = this.dataFactory.getOWLIndividual(string2);
        OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference = this.dataFactory.getOWLClassAssertionAxiom(oWLNamedIndividualReference, oWLClassReference);
        this.relevantOWLAxioms.add(oWLClassAssertionAxiomReference);
    }

    private void importOWLPropertyAssertionAxiomsByName(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLPropertyAssertionAxioms(string);
        }
    }

    private void importOWLPropertyAssertionAxioms(Set<OWLPropertyReference> set) throws SWRLRuleEngineBridgeException {
        for (OWLPropertyReference oWLPropertyReference : set) {
            this.importOWLPropertyAssertionAxioms(oWLPropertyReference.getURI());
        }
    }

    private void importOWLPropertyAssertionAxioms(String string) throws SWRLRuleEngineBridgeException {
        if (!this.relevantOWLObjectPropertyURIs.contains(string) && !this.relevantOWLDataPropertyURIs.contains(string)) {
            Set<OWLPropertyAssertionAxiomReference> set = null;
            try {
                if (!this.relevantOWLPropertyDeclarationAxioms.containsKey(string)) {
                    Object object;
                    if (this.activeOntology.containsDataPropertyInSignature(string, true)) {
                        object = this.dataFactory.getOWLDeclarationAxiom(this.activeOntology.getOWLDataProperty(string));
                        this.relevantOWLPropertyDeclarationAxioms.put(string, (OWLDeclarationAxiomReference)object);
                        this.relevantOWLDeclarationAxioms.put(string, (OWLDeclarationAxiomReference)object);
                    } else if (this.activeOntology.containsObjectPropertyInSignature(string, true)) {
                        object = this.dataFactory.getOWLDeclarationAxiom(this.activeOntology.getOWLObjectProperty(string));
                        this.relevantOWLPropertyDeclarationAxioms.put(string, (OWLDeclarationAxiomReference)object);
                        this.relevantOWLDeclarationAxioms.put(string, (OWLDeclarationAxiomReference)object);
                    } else {
                        throw new SWRLRuleEngineBridgeException("referenced property " + string + " not in active ontology");
                    }
                }
                set = this.activeOntology.getOWLPropertyAssertionAxioms(string);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLBuiltInBridgeException("error importing OWL property assertion axiom for property " + string + " :" + oWLConversionFactoryException);
            }
            this.relevantOWLAxioms.addAll(set);
            for (OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference : set) {
                String string2 = oWLPropertyAssertionAxiomReference.getSubject().getURI();
                OWLPropertyReference oWLPropertyReference = oWLPropertyAssertionAxiomReference.getProperty();
                this.cacheOWLPropertyAssertionAxiom(oWLPropertyAssertionAxiomReference);
                this.addReferencedIndividualURI(string2);
                if (oWLPropertyAssertionAxiomReference instanceof OWLObjectPropertyAssertionAxiomReference) {
                    OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference = (OWLObjectPropertyAssertionAxiomReference)oWLPropertyAssertionAxiomReference;
                    String string3 = oWLObjectPropertyAssertionAxiomReference.getObject().getURI();
                    this.addReferencedIndividualURI(string3);
                    this.relevantOWLObjectPropertyURIs.add(string);
                } else {
                    this.relevantOWLDataPropertyURIs.add(string);
                }
                this.importOWLClassDeclarationAxioms(oWLPropertyReference.getDomainClasses());
                this.importOWLClassDeclarationAxioms(oWLPropertyReference.getRangeClasses());
                this.importOWLPropertyAssertionAxioms(oWLPropertyReference.getSuperProperties());
                this.importOWLPropertyAssertionAxioms(oWLPropertyReference.getEquivalentProperties());
            }
        }
    }

    private void cacheOWLPropertyAssertionAxiom(OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference) {
        Set<OWLPropertyAssertionAxiomReference> set;
        Map<Object, Object> map;
        String string = oWLPropertyAssertionAxiomReference.getSubject().getURI();
        String string2 = oWLPropertyAssertionAxiomReference.getProperty().getURI();
        if (this.allOWLPropertyAssertionAxioms.containsKey(string)) {
            map = this.allOWLPropertyAssertionAxioms.get(string);
        } else {
            map = new HashMap();
            this.allOWLPropertyAssertionAxioms.put(string, map);
        }
        if (map.containsKey(string2)) {
            set = (Set)map.get(string2);
        } else {
            set = new HashSet();
            map.put(string2, set);
        }
        set.add(oWLPropertyAssertionAxiomReference);
    }

    private void cacheOWLIndividual(OWLNamedIndividualReference oWLNamedIndividualReference) {
        String string = oWLNamedIndividualReference.getURI();
        if (!this.allOWLIndividuals.containsKey(string)) {
            this.allOWLIndividuals.put(string, oWLNamedIndividualReference);
        }
    }

    private void cacheOWLIndividuals(Set<OWLNamedIndividualReference> set) {
        for (OWLNamedIndividualReference oWLNamedIndividualReference : set) {
            this.cacheOWLIndividual(oWLNamedIndividualReference);
        }
    }

    private void importOWLIndividualsByName(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLIndividualDeclarationAxiom(string);
        }
    }

    private void importOWLIndividualDeclarationAxiom(String string) throws SWRLRuleEngineBridgeException {
        if (!this.relevantOWLIndividualDeclarationAxioms.containsKey(string)) {
            OWLNamedIndividualReference oWLNamedIndividualReference = this.dataFactory.getOWLIndividual(string);
            OWLDeclarationAxiomReference oWLDeclarationAxiomReference = this.dataFactory.getOWLDeclarationAxiom(oWLNamedIndividualReference);
            this.relevantOWLIndividualDeclarationAxioms.put(string, oWLDeclarationAxiomReference);
            this.relevantOWLDeclarationAxioms.put(string, oWLDeclarationAxiomReference);
            this.cacheOWLIndividual(oWLNamedIndividualReference);
            this.importOWLClassDeclarationAxioms(oWLNamedIndividualReference.getTypes());
        }
    }

    private void importOWLAxioms() throws SWRLRuleEngineBridgeException {
        this.importOWLClassDescriptions();
        this.importOWLClassAxioms();
        this.importOWLPropertyAxioms();
        this.importOWLIndividualAxioms();
        this.importOWLDataValuedPropertyAxioms();
        this.importOWLAnnotations();
    }

    private void importOWLClassAxioms() throws SWRLRuleEngineBridgeException {
        this.importOWLSubClassOfAxioms();
        this.importOWLEquivalentClassAxioms();
        this.importOWLDisjointWithAxioms();
    }

    private void importOWLPropertyAxioms() throws SWRLRuleEngineBridgeException {
        this.importOWLEquivalentPropertyAxioms();
        this.importOWLInverseOfAxioms();
        this.importOWLFunctionalPropertyAxioms();
        this.importOWLInverseFunctionalPropertyAxioms();
        this.importOWLTransitivePropertyAxioms();
        this.importOWLSymmetricPropertyAxioms();
    }

    private void importOWLIndividualAxioms() throws SWRLRuleEngineBridgeException {
        this.importOWLSameIndividualAxioms();
        this.importOWLDifferentIndividualsAxioms();
        this.importOWLAllDifferentsAxioms();
    }

    private void importOWLPropertyRestrictions() throws SWRLRuleEngineBridgeException {
        this.importOWLCardinalityRestrictions();
        this.importOWLMinCardinalityRestrictions();
        this.importOWLMaxCardinalityRestrictions();
        this.importOWLAllValuesFromRestrictions();
        this.importOWLSomeValuesFromRestrictions();
        this.importOWLHasValueRestrictions();
    }

    private void importOWLSameIndividualAxioms() throws SWRLRuleEngineBridgeException {
        try {
            for (OWLSameIndividualAxiomReference oWLSameIndividualAxiomReference : this.activeOntology.getSameIndividualAxioms()) {
                this.relevantOWLAxioms.add(oWLSameIndividualAxiomReference);
                this.cacheOWLIndividuals(oWLSameIndividualAxiomReference.getIndividuals());
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SWRLBuiltInBridgeException("error importing OWL same individuals axioms: " + oWLConversionFactoryException);
        }
    }

    private void importOWLDifferentIndividualsAxioms() throws SWRLRuleEngineBridgeException {
        try {
            for (OWLDifferentIndividualsAxiomReference oWLDifferentIndividualsAxiomReference : this.activeOntology.getOWLDifferentIndividualsAxioms()) {
                this.relevantOWLAxioms.add(oWLDifferentIndividualsAxiomReference);
                this.cacheOWLIndividuals(oWLDifferentIndividualsAxiomReference.getIndividuals());
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SWRLBuiltInBridgeException("error importing OWL different individuals axioms: " + oWLConversionFactoryException);
        }
    }

    private void importOWLClassDescriptions() throws SWRLRuleEngineBridgeException {
        this.importOWLClassEnumerationDescriptions();
        this.importOWLPropertyRestrictions();
        this.importOWLIntersectionOfDescriptions();
        this.importOWLUnionOfDescriptions();
        this.importOWLComplementOfDescriptions();
    }

    private void importOWLClassEnumerationDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLMinCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLMaxCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLAllValuesFromRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLSomeValuesFromRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLHasValueRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLIntersectionOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLUnionOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLComplementOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLEquivalentPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLInverseOfAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLFunctionalPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLInverseFunctionalPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLTransitivePropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLSymmetricPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLSubClassOfAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLEquivalentClassAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLDisjointWithAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLAllDifferentsAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLDataValuedPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importOWLAnnotations() throws SWRLRuleEngineBridgeException {
    }
}

