/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLAxiomProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValueFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridgeController;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridgeController;
import edu.stanford.smi.protegex.owl.swrl.bridge.TargetSWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLConversionFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.TargetSWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDeclarationAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLOntology;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.SQWRLResultImpl;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSWRLRuleEngine
implements SWRLRuleEngine {
    private OWLOntology activeOntology;
    private OWLAxiomProcessor owlAxiomProcessor;
    private TargetSWRLRuleEngine targetRuleEngine;
    private SWRLBuiltInBridgeController builtInBridgeController;
    private SWRLRuleEngineBridgeController ruleEngineBridgeController;
    private OWLDataFactory owlDataFactory;
    private OWLDataValueFactory owlDataValueFactory;
    private Set<String> exportedOWLClassURIs;
    private Set<String> exportedOWLPropertyURIs;
    private Set<String> exportedOWLIndividualURIs;

    public DefaultSWRLRuleEngine(OWLOntology oWLOntology, OWLAxiomProcessor oWLAxiomProcessor, TargetSWRLRuleEngine targetSWRLRuleEngine, SWRLRuleEngineBridgeController sWRLRuleEngineBridgeController, SWRLBuiltInBridgeController sWRLBuiltInBridgeController) throws SWRLRuleEngineException {
        this.activeOntology = oWLOntology;
        this.owlAxiomProcessor = oWLAxiomProcessor;
        this.targetRuleEngine = targetSWRLRuleEngine;
        this.builtInBridgeController = sWRLBuiltInBridgeController;
        this.ruleEngineBridgeController = sWRLRuleEngineBridgeController;
        this.owlDataFactory = new P3OWLDataFactory(oWLOntology);
        this.owlDataValueFactory = OWLDataValueFactory.create();
        this.initialize();
    }

    @Override
    public void importSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineException {
        this.owlAxiomProcessor.processSWRLRules();
        this.exportOWLDeclarationAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLDeclarationAxioms());
        this.exportOWLAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLAxioms());
        this.exportSWRLRules2TargetRuleEngine(this.owlAxiomProcessor.getSWRLRules());
    }

    @Override
    public void importSQWRLQueryAndOWLKnowledge(String string) throws SWRLRuleEngineException {
        this.owlAxiomProcessor.processSWRLRules();
        this.owlAxiomProcessor.processSQWRLQuery(string);
        this.exportOWLDeclarationAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLDeclarationAxioms());
        this.exportOWLAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLAxioms());
        this.exportSWRLRules2TargetRuleEngine(this.owlAxiomProcessor.getSWRLRules());
    }

    @Override
    public void run() throws SWRLRuleEngineException {
        this.getRuleEngine().runRuleEngine();
    }

    @Override
    public void reset() throws SWRLRuleEngineException {
        this.getRuleEngine().resetRuleEngine();
        this.builtInBridgeController.reset();
        this.owlAxiomProcessor.reset();
        this.initialize();
    }

    @Override
    public void writeInferredKnowledge2OWL() throws SWRLRuleEngineException {
        this.writeInjectedOWLClassDeclarations2ActiveOntology();
        this.writeInjectedOWLIndividualDeclarations2ActiveOntology();
        this.writeInjectedOWLAxioms2ActiveOntology();
        this.writeInferredOWLIndividualDeclarations2ActiveOntology();
        this.writeInferredOWLAxioms2ActiveOntology();
    }

    @Override
    public void infer() throws SWRLRuleEngineException {
        this.reset();
        this.importSWRLRulesAndOWLKnowledge();
        this.run();
        this.writeInferredKnowledge2OWL();
    }

    @Override
    public SQWRLResult runSQWRLQuery(String string, String string2) throws SQWRLException, SWRLParseException {
        this.createSQWRLQuery(string, string2);
        return this.runSQWRLQuery(string);
    }

    @Override
    public void createSQWRLQuery(String string, String string2) throws SQWRLException, SWRLParseException {
        try {
            this.activeOntology.createSWRLRule(string, string2);
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SQWRLException("error creating SQWRL query: " + oWLConversionFactoryException.getMessage());
        }
    }

    @Override
    public SQWRLResult runSQWRLQuery(String string) throws SQWRLException {
        SQWRLResultImpl sQWRLResultImpl = null;
        try {
            this.reset();
            this.importSQWRLQueryAndOWLKnowledge(string);
            this.run();
            sQWRLResultImpl = this.getSQWRLResult(string);
        }
        catch (SWRLRuleEngineException sWRLRuleEngineException) {
            throw new SQWRLException("error running SQWRL queries: " + sWRLRuleEngineException.getMessage());
        }
        return sQWRLResultImpl;
    }

    @Override
    public SQWRLResult runStandaloneSQWRLQuery(String string) throws SQWRLException {
        SQWRLResultImpl sQWRLResultImpl = null;
        try {
            this.reset();
            this.importSQWRLQuery(string);
            this.run();
            sQWRLResultImpl = this.getSQWRLResult(string);
        }
        catch (SWRLRuleEngineException sWRLRuleEngineException) {
            throw new SQWRLException("error running SQWRL queries: " + sWRLRuleEngineException.getMessage());
        }
        return sQWRLResultImpl;
    }

    @Override
    public void runSQWRLQueries() throws SQWRLException {
        try {
            this.reset();
            this.importSWRLRulesAndOWLKnowledge();
            this.run();
        }
        catch (SWRLRuleEngineException sWRLRuleEngineException) {
            throw new SQWRLException("error running SQWRL queries: " + sWRLRuleEngineException.getMessage());
        }
    }

    @Override
    public SQWRLResultImpl getSQWRLResult(String string) throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLResult(string);
    }

    @Override
    public void deleteSQWRLQuery(String string) throws SQWRLException {
        try {
            this.activeOntology.deleteSWRLRule(string);
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SQWRLException("error deleting SQWRL query " + string);
        }
    }

    @Override
    public Set<SWRLRuleReference> getSQWRLQueries() throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLQueries();
    }

    @Override
    public Set<String> getSQWRLQueryNames() throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLQueryNames();
    }

    public SQWRLResultImpl getSQWRLUnpreparedResult(String string) throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLUnpreparedResult(string);
    }

    public SWRLRuleReference getSWRLRule(String string) throws SWRLRuleEngineException {
        return this.owlAxiomProcessor.getSWRLRule(string);
    }

    @Override
    public int getNumberOfImportedSWRLRules() {
        return this.owlAxiomProcessor.getNumberOfReferencedSWRLRules();
    }

    @Override
    public int getNumberOfImportedOWLClasses() {
        return this.owlAxiomProcessor.getNumberOfReferencedOWLClassDeclarationAxioms();
    }

    @Override
    public int getNumberOfImportedOWLIndividuals() {
        return this.owlAxiomProcessor.getNumberOfReferencedOWLIndividualDeclarationAxioms();
    }

    @Override
    public int getNumberOfImportedOWLAxioms() {
        return this.owlAxiomProcessor.getNumberOfReferencedOWLAxioms();
    }

    @Override
    public int getNumberOfInferredOWLIndividuals() {
        return this.ruleEngineBridgeController.getNumberOfInferredOWLIndividuals();
    }

    @Override
    public int getNumberOfInferredOWLAxioms() {
        return this.ruleEngineBridgeController.getNumberOfInferredOWLAxioms();
    }

    @Override
    public int getNumberOfInjectedOWLClasses() {
        return this.builtInBridgeController.getNumberOfInjectedOWLClassDeclarations();
    }

    @Override
    public int getNumberOfInjectedOWLIndividuals() {
        return this.builtInBridgeController.getNumberOfInjectedOWLIndividualDeclarations();
    }

    @Override
    public int getNumberOfInjectedOWLAxioms() {
        return this.builtInBridgeController.getNumberOfInjectedOWLAxioms();
    }

    public boolean isInjectedOWLClass(String string) {
        return this.builtInBridgeController.isInjectedOWLClass(string);
    }

    public boolean isInjectedOWLIndividual(String string) {
        return this.builtInBridgeController.isInjectedOWLIndividual(string);
    }

    public boolean isInjectedOWLAxiom(OWLAxiomReference oWLAxiomReference) {
        return this.builtInBridgeController.isInjectedOWLAxiom(oWLAxiomReference);
    }

    @Override
    public Set<SWRLRuleReference> getImportedSWRLRules() {
        return this.owlAxiomProcessor.getSWRLRules();
    }

    @Override
    public Set<OWLClassReference> getImportedOWLClasses() {
        HashSet<OWLClassReference> hashSet = new HashSet<OWLClassReference>();
        for (OWLDeclarationAxiomReference oWLDeclarationAxiomReference : this.owlAxiomProcessor.getRelevantOWLClassDeclarationsAxioms()) {
            if (!(oWLDeclarationAxiomReference.getEntity() instanceof OWLClassReference)) continue;
            hashSet.add((OWLClassReference)oWLDeclarationAxiomReference.getEntity());
        }
        return hashSet;
    }

    @Override
    public Set<OWLNamedIndividualReference> getImportedOWLIndividuals() {
        HashSet<OWLNamedIndividualReference> hashSet = new HashSet<OWLNamedIndividualReference>();
        for (OWLDeclarationAxiomReference oWLDeclarationAxiomReference : this.owlAxiomProcessor.getRelevantOWLIndividualDeclarationAxioms()) {
            if (!(oWLDeclarationAxiomReference.getEntity() instanceof OWLNamedIndividualReference)) continue;
            hashSet.add((OWLNamedIndividualReference)oWLDeclarationAxiomReference.getEntity());
        }
        return hashSet;
    }

    @Override
    public Set<OWLAxiomReference> getImportedOWLAxioms() {
        return this.owlAxiomProcessor.getRelevantOWLAxioms();
    }

    @Override
    public Set<OWLNamedIndividualReference> getReclassifiedOWLIndividuals() {
        return this.ruleEngineBridgeController.getInferredOWLIndividuals();
    }

    @Override
    public Set<OWLAxiomReference> getInferredOWLAxioms() {
        return this.ruleEngineBridgeController.getInferredOWLAxioms();
    }

    @Override
    public Set<OWLAxiomReference> getInjectedOWLAxioms() {
        return this.getInjectedOWLAxioms();
    }

    @Override
    public Set<OWLClassReference> getInjectedOWLClasses() {
        return this.builtInBridgeController.getInjectedOWLClassDeclarations();
    }

    @Override
    public Set<OWLNamedIndividualReference> getInjectedOWLIndividuals() {
        return this.builtInBridgeController.getInjectedOWLIndividualDeclarations();
    }

    @Override
    public String uri2PrefixedName(String string) {
        return this.activeOntology.uri2PrefixedName(string);
    }

    @Override
    public String name2URI(String string) {
        return this.activeOntology.prefixedName2URI(string);
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.owlDataFactory;
    }

    @Override
    public OWLDataValueFactory getOWLDataValueFactory() {
        return this.owlDataValueFactory;
    }

    @Override
    public String getTargetRuleEngineName() {
        return this.targetRuleEngine.getName();
    }

    @Override
    public String getTargetRuleEngineVersion() {
        return this.targetRuleEngine.getVersion();
    }

    private void importSQWRLQuery(String string) throws SWRLRuleEngineException {
        this.owlAxiomProcessor.processSQWRLQuery(string);
        this.exportSQWRLQuery2TargetRuleEngine(this.owlAxiomProcessor.getSQWRLQuery(string));
        this.exportOWLDeclarationAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLDeclarationAxioms());
        this.exportOWLAxioms2TargetRuleEngine(this.owlAxiomProcessor.getRelevantOWLAxioms());
    }

    private void exportSWRLRules2TargetRuleEngine(Set<SWRLRuleReference> set) throws SWRLRuleEngineException {
        for (SWRLRuleReference sWRLRuleReference : set) {
            this.exportSWRLRule2TargetRuleEngine(sWRLRuleReference);
        }
    }

    private void exportSWRLRule2TargetRuleEngine(SWRLRuleReference sWRLRuleReference) throws SWRLRuleEngineException {
        this.getRuleEngine().defineOWLAxiom(sWRLRuleReference);
    }

    private void exportSQWRLQuery2TargetRuleEngine(SWRLRuleReference sWRLRuleReference) throws SWRLRuleEngineException {
        this.getRuleEngine().defineOWLAxiom(sWRLRuleReference);
    }

    private void exportOWLDeclarationAxioms2TargetRuleEngine(Set<OWLDeclarationAxiomReference> set) throws SWRLRuleEngineException {
        for (OWLDeclarationAxiomReference oWLDeclarationAxiomReference : set) {
            this.exportOWLDeclarationAxiom2TargetRuleEngine(oWLDeclarationAxiomReference);
        }
    }

    private void exportOWLDeclarationAxiom2TargetRuleEngine(OWLDeclarationAxiomReference oWLDeclarationAxiomReference) throws SWRLRuleEngineException {
        if (oWLDeclarationAxiomReference.getEntity() instanceof OWLClassReference) {
            OWLClassReference oWLClassReference = (OWLClassReference)oWLDeclarationAxiomReference.getEntity();
            String string = oWLClassReference.getURI();
            if (!this.exportedOWLClassURIs.contains(string)) {
                this.exportOWLAxiom2TargetRuleEngine(oWLDeclarationAxiomReference);
                this.exportedOWLClassURIs.add(string);
            }
        } else if (oWLDeclarationAxiomReference.getEntity() instanceof OWLPropertyReference) {
            OWLPropertyReference oWLPropertyReference = (OWLPropertyReference)oWLDeclarationAxiomReference.getEntity();
            String string = oWLPropertyReference.getURI();
            if (!this.exportedOWLPropertyURIs.contains(string)) {
                this.exportOWLAxiom2TargetRuleEngine(oWLDeclarationAxiomReference);
                this.exportedOWLPropertyURIs.add(string);
            }
        } else if (oWLDeclarationAxiomReference.getEntity() instanceof OWLNamedIndividualReference) {
            OWLNamedIndividualReference oWLNamedIndividualReference = (OWLNamedIndividualReference)oWLDeclarationAxiomReference.getEntity();
            String string = oWLNamedIndividualReference.getURI();
            if (!this.exportedOWLIndividualURIs.contains(string)) {
                this.exportOWLAxiom2TargetRuleEngine(oWLDeclarationAxiomReference);
                this.exportedOWLIndividualURIs.add(string);
            }
        } else {
            throw new SWRLRuleEngineException("unknown declaration axiom " + oWLDeclarationAxiomReference);
        }
    }

    private TargetSWRLRuleEngine getRuleEngine() throws SWRLRuleEngineException {
        if (this.targetRuleEngine == null) {
            throw new SWRLRuleEngineException("no target rule engine specified");
        }
        return this.targetRuleEngine;
    }

    private void exportOWLAxioms2TargetRuleEngine(Set<OWLAxiomReference> set) throws SWRLRuleEngineException {
        for (OWLAxiomReference oWLAxiomReference : set) {
            this.exportOWLAxiom2TargetRuleEngine(oWLAxiomReference);
        }
    }

    private void exportOWLAxiom2TargetRuleEngine(OWLAxiomReference oWLAxiomReference) throws SWRLRuleEngineException {
        try {
            this.getRuleEngine().defineOWLAxiom(oWLAxiomReference);
        }
        catch (TargetSWRLRuleEngineException targetSWRLRuleEngineException) {
            throw new SWRLRuleEngineException("error exporting OWL axiom " + oWLAxiomReference + " to rule engine: " + targetSWRLRuleEngineException.getMessage());
        }
    }

    private void writeInferredOWLIndividualDeclarations2ActiveOntology() throws SWRLRuleEngineException {
        for (OWLNamedIndividualReference oWLNamedIndividualReference : this.ruleEngineBridgeController.getInferredOWLIndividuals()) {
            try {
                this.activeOntology.writeOWLIndividualDeclaration(oWLNamedIndividualReference);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLRuleEngineException("error writing inferred individual " + oWLNamedIndividualReference + ": " + oWLConversionFactoryException.getMessage());
            }
        }
    }

    private void writeInferredOWLAxioms2ActiveOntology() throws SWRLRuleEngineException {
        for (OWLAxiomReference oWLAxiomReference : this.ruleEngineBridgeController.getInferredOWLAxioms()) {
            try {
                this.activeOntology.writeOWLAxiom(oWLAxiomReference);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLRuleEngineException("error writing inferred axiom " + oWLAxiomReference + ": " + oWLConversionFactoryException.getMessage());
            }
        }
    }

    private void writeInjectedOWLIndividualDeclarations2ActiveOntology() throws SWRLRuleEngineException {
        for (OWLNamedIndividualReference oWLNamedIndividualReference : this.builtInBridgeController.getInjectedOWLIndividualDeclarations()) {
            try {
                this.activeOntology.writeOWLIndividualDeclaration(oWLNamedIndividualReference);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLRuleEngineException("error writing injected individual " + oWLNamedIndividualReference + ": " + oWLConversionFactoryException.getMessage());
            }
        }
    }

    private void writeInjectedOWLAxioms2ActiveOntology() throws SWRLRuleEngineException {
        for (OWLAxiomReference oWLAxiomReference : this.builtInBridgeController.getInjectedOWLAxioms()) {
            try {
                this.activeOntology.writeOWLAxiom(oWLAxiomReference);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLRuleEngineException("error writing injected axiom " + oWLAxiomReference + ": " + oWLConversionFactoryException.getMessage());
            }
        }
    }

    private void writeInjectedOWLClassDeclarations2ActiveOntology() throws SWRLRuleEngineException {
        for (OWLClassReference oWLClassReference : this.builtInBridgeController.getInjectedOWLClassDeclarations()) {
            try {
                this.activeOntology.writeOWLClassDeclaration(oWLClassReference);
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new SWRLRuleEngineException("error writing injected class " + oWLClassReference + ": " + oWLConversionFactoryException.getMessage());
            }
        }
    }

    private void initialize() {
        this.exportedOWLClassURIs = new HashSet<String>();
        this.exportedOWLPropertyURIs = new HashSet<String>();
        this.exportedOWLIndividualURIs = new HashSet<String>();
    }
}

