/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLAxiomProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValueFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridgeController;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridgeController;
import edu.stanford.smi.protegex.owl.swrl.bridge.TargetSWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.BuiltInLibraryManager;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLConversionFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.TargetSWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDeclarationAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLEntityReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLOntology;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSubClassAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.PrefixManager;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLBuiltInAtomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3PrefixManager;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.DataValueConversionException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.SQWRLResultImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSWRLBridge
implements SWRLRuleEngineBridge,
SWRLBuiltInBridge,
SWRLBuiltInBridgeController,
SWRLRuleEngineBridgeController {
    private OWLOntology activeOntology;
    private TargetSWRLRuleEngine targetRuleEngine;
    private OWLAxiomProcessor owlAxiomProcessor;
    private OWLDataFactory dataFactory;
    private OWLDataFactory injectedOWLFactory;
    private OWLDataValueFactory dataValueFactory;
    private PrefixManager prefixManager;
    private Map<String, OWLNamedIndividualReference> inferredOWLIndividualDeclarations;
    private Set<OWLAxiomReference> inferredOWLAxioms;
    private HashMap<String, OWLClassReference> injectedOWLClassDeclarations;
    private HashMap<String, OWLNamedIndividualReference> injectedOWLIndividualDeclarations;
    private Set<OWLAxiomReference> injectedOWLAxioms;
    private Map<String, Map<String, Set<OWLPropertyAssertionAxiomReference>>> allOWLPropertyAssertionAxioms;
    private Map<String, OWLNamedIndividualReference> allOWLIndividualDeclarations;

    public DefaultSWRLBridge(OWLOntology oWLOntology, OWLAxiomProcessor oWLAxiomProcessor) throws SWRLBuiltInBridgeException {
        this.activeOntology = oWLOntology;
        this.owlAxiomProcessor = oWLAxiomProcessor;
        this.targetRuleEngine = null;
        this.dataFactory = new P3OWLDataFactory(oWLOntology);
        this.injectedOWLFactory = new P3OWLDataFactory();
        this.dataValueFactory = OWLDataValueFactory.create();
        this.prefixManager = new P3PrefixManager(oWLOntology);
        this.initialize();
        this.reset();
    }

    @Override
    public void reset() throws SWRLBuiltInBridgeException {
        BuiltInLibraryManager.invokeAllBuiltInLibrariesResetMethod(this);
    }

    @Override
    public void setTargetRuleEngine(TargetSWRLRuleEngine targetSWRLRuleEngine) {
        this.targetRuleEngine = targetSWRLRuleEngine;
    }

    @Override
    public int getNumberOfInjectedOWLClassDeclarations() {
        return this.injectedOWLClassDeclarations.size();
    }

    @Override
    public int getNumberOfInjectedOWLIndividualDeclarations() {
        return this.injectedOWLIndividualDeclarations.size();
    }

    @Override
    public int getNumberOfInjectedOWLAxioms() {
        return this.injectedOWLAxioms.size();
    }

    @Override
    public boolean isInjectedOWLClass(String string) {
        return this.injectedOWLClassDeclarations.containsKey(string);
    }

    @Override
    public boolean isInjectedOWLIndividual(String string) {
        return this.injectedOWLIndividualDeclarations.containsKey(string);
    }

    @Override
    public boolean isInjectedOWLAxiom(OWLAxiomReference oWLAxiomReference) {
        return this.injectedOWLAxioms.contains(oWLAxiomReference);
    }

    @Override
    public Set<OWLClassReference> getInjectedOWLClassDeclarations() {
        return new HashSet<OWLClassReference>(this.injectedOWLClassDeclarations.values());
    }

    @Override
    public Set<OWLNamedIndividualReference> getInjectedOWLIndividualDeclarations() {
        return new HashSet<OWLNamedIndividualReference>(this.injectedOWLIndividualDeclarations.values());
    }

    @Override
    public Set<OWLAxiomReference> getInjectedOWLAxioms() {
        return this.injectedOWLAxioms;
    }

    @Override
    public Set<OWLAxiomReference> getInferredOWLAxioms() {
        return this.inferredOWLAxioms;
    }

    @Override
    public Set<OWLNamedIndividualReference> getInferredOWLIndividuals() {
        return new HashSet<OWLNamedIndividualReference>(this.inferredOWLIndividualDeclarations.values());
    }

    @Override
    public int getNumberOfInferredOWLAxioms() {
        return this.inferredOWLAxioms.size();
    }

    @Override
    public int getNumberOfInferredOWLIndividuals() {
        return this.inferredOWLIndividualDeclarations.size();
    }

    @Override
    public boolean isSQWRLQuery(SWRLRuleReference sWRLRuleReference) {
        return this.owlAxiomProcessor.isSQWRLQuery(sWRLRuleReference.getURI());
    }

    @Override
    public void inferOWLAxiom(OWLAxiomReference oWLAxiomReference) throws SWRLRuleEngineBridgeException {
        if (!this.inferredOWLAxioms.contains(oWLAxiomReference)) {
            this.inferredOWLAxioms.add(oWLAxiomReference);
            if (oWLAxiomReference instanceof OWLPropertyAssertionAxiomReference) {
                this.cacheOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiomReference)oWLAxiomReference);
            } else if (oWLAxiomReference instanceof OWLClassAssertionAxiomReference) {
                OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference = (OWLClassAssertionAxiomReference)oWLAxiomReference;
                this.inferOWLIndividual(oWLClassAssertionAxiomReference.getIndividual(), oWLClassAssertionAxiomReference.getDescription());
            }
        }
    }

    private void inferOWLIndividual(OWLNamedIndividualReference oWLNamedIndividualReference, OWLClassReference oWLClassReference) throws SWRLRuleEngineBridgeException {
        String string = oWLNamedIndividualReference.getURI();
        if (this.inferredOWLIndividualDeclarations.containsKey(string)) {
            this.inferredOWLIndividualDeclarations.get(string).addType(oWLClassReference);
        } else if (this.injectedOWLIndividualDeclarations.containsKey(string)) {
            this.injectedOWLIndividualDeclarations.get(string).addType(oWLClassReference);
        } else {
            this.inferredOWLIndividualDeclarations.put(string, oWLNamedIndividualReference);
            this.cacheOWLIndividual(oWLNamedIndividualReference);
        }
    }

    @Override
    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    @Override
    public boolean invokeSWRLBuiltIn(String string, String string2, int n, boolean bl, List<BuiltInArgument> list) throws BuiltInException {
        return BuiltInLibraryManager.invokeSWRLBuiltIn(this.targetRuleEngine, this, string, string2, n, bl, list);
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromBody(SWRLRuleReference sWRLRuleReference, Set<String> set) {
        return this.owlAxiomProcessor.getBuiltInAtomsFromBody(sWRLRuleReference, set);
    }

    @Override
    public List<SWRLBuiltInAtomReference> getBuiltInAtomsFromHead(SWRLRuleReference sWRLRuleReference, Set<String> set) {
        return this.owlAxiomProcessor.getBuiltInAtomsFromHead(sWRLRuleReference, set);
    }

    @Override
    public void injectOWLAxiom(OWLAxiomReference oWLAxiomReference) throws SWRLBuiltInBridgeException {
        if (!this.injectedOWLAxioms.contains(oWLAxiomReference)) {
            this.injectedOWLAxioms.add(oWLAxiomReference);
            if (oWLAxiomReference instanceof OWLPropertyAssertionAxiomReference) {
                this.cacheOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiomReference)oWLAxiomReference);
            } else if (oWLAxiomReference instanceof OWLDeclarationAxiomReference) {
                this.injectOWLDeclarationAxiom((OWLDeclarationAxiomReference)oWLAxiomReference);
            } else if (oWLAxiomReference instanceof OWLSubClassAxiomReference) {
                this.injectOWLSubClassAxiom((OWLSubClassAxiomReference)oWLAxiomReference);
            }
            this.exportOWLAxiom(oWLAxiomReference);
        }
    }

    @Override
    public String uri2PrefixedName(String string) {
        return this.activeOntology.uri2PrefixedName(string);
    }

    @Override
    public String name2URI(String string) {
        return this.activeOntology.prefixedName2URI(string);
    }

    private void injectOWLDeclarationAxiom(OWLDeclarationAxiomReference oWLDeclarationAxiomReference) throws SWRLBuiltInBridgeException {
        OWLEntityReference oWLEntityReference = oWLDeclarationAxiomReference.getEntity();
        if (oWLEntityReference instanceof OWLClassReference) {
            this.injectOWLClassDeclaration(oWLEntityReference.getURI());
        } else if (oWLEntityReference instanceof OWLNamedIndividualReference) {
            this.injectOWLIndividualDeclaration((OWLNamedIndividualReference)oWLEntityReference);
        } else {
            throw new SWRLBuiltInBridgeException("error injecting OWLDeclarationAxiom - unknown entity type: " + oWLEntityReference.getClass());
        }
    }

    @Override
    public OWLClassReference injectOWLClassDeclaration() throws SWRLBuiltInBridgeException {
        OWLClassReference oWLClassReference = this.activeOntology.createOWLClass();
        String string = oWLClassReference.getURI();
        if (!this.injectedOWLClassDeclarations.containsKey(string)) {
            this.injectedOWLClassDeclarations.put(string, oWLClassReference);
            this.exportOWLClassDeclaration(oWLClassReference);
        }
        return oWLClassReference;
    }

    @Override
    public void injectOWLClassDeclaration(String string) throws SWRLBuiltInBridgeException {
        this.checkOWLClassURI(string);
        if (!this.injectedOWLClassDeclarations.containsKey(string)) {
            OWLClassReference oWLClassReference = this.injectedOWLFactory.getOWLClass(string);
            this.injectedOWLClassDeclarations.put(string, oWLClassReference);
            this.exportOWLClassDeclaration(oWLClassReference);
        }
    }

    private void injectOWLSubClassAxiom(OWLSubClassAxiomReference oWLSubClassAxiomReference) throws SWRLBuiltInBridgeException {
        String string = oWLSubClassAxiomReference.getSubClass().getURI();
        String string2 = oWLSubClassAxiomReference.getSuperClass().getURI();
        this.injectedOWLFactory.getOWLClass(string);
        this.injectedOWLFactory.getOWLClass(string2);
        this.injectedOWLClassDeclarations.put(string, oWLSubClassAxiomReference.getSubClass());
        this.injectedOWLClassDeclarations.put(string2, oWLSubClassAxiomReference.getSuperClass());
    }

    @Override
    public OWLNamedIndividualReference injectOWLIndividualDeclaration() throws SWRLBuiltInBridgeException {
        String string = this.activeOntology.createNewResourceURI("SWRLInjected");
        OWLClassReference oWLClassReference = this.injectedOWLFactory.getOWLClass(OWLNames.Cls.THING);
        OWLNamedIndividualReference oWLNamedIndividualReference = this.injectedOWLFactory.getOWLIndividual(string);
        oWLNamedIndividualReference.addType(oWLClassReference);
        this.injectOWLIndividualDeclaration(oWLNamedIndividualReference);
        return oWLNamedIndividualReference;
    }

    @Override
    public void injectOWLIndividualDeclaration(OWLNamedIndividualReference oWLNamedIndividualReference) throws SWRLBuiltInBridgeException {
        if (!this.injectedOWLIndividualDeclarations.containsKey(oWLNamedIndividualReference.getURI())) {
            this.injectedOWLIndividualDeclarations.put(oWLNamedIndividualReference.getURI(), oWLNamedIndividualReference);
            this.cacheOWLIndividual(oWLNamedIndividualReference);
            this.exportOWLIndividualDeclaration(oWLNamedIndividualReference);
        }
    }

    @Override
    public OWLNamedIndividualReference injectOWLIndividualDeclaration(OWLClassReference oWLClassReference) throws SWRLBuiltInBridgeException {
        String string = this.activeOntology.createNewResourceURI("SWRLInjected");
        OWLNamedIndividualReference oWLNamedIndividualReference = this.injectedOWLFactory.getOWLIndividual(string);
        oWLNamedIndividualReference.addType(oWLClassReference);
        if (!this.owlAxiomProcessor.isRelevantOWLClass(oWLClassReference.getURI())) {
            this.exportOWLClassDeclaration(oWLClassReference);
        }
        this.injectedOWLIndividualDeclarations.put(string, oWLNamedIndividualReference);
        this.cacheOWLIndividual(oWLNamedIndividualReference);
        this.exportOWLIndividualDeclaration(oWLNamedIndividualReference);
        return oWLNamedIndividualReference;
    }

    public OWLDataPropertyAssertionAxiomReference injectOWLDataPropertyAssertionAxiom(OWLNamedIndividualReference oWLNamedIndividualReference, OWLPropertyReference oWLPropertyReference, OWLDataValue oWLDataValue) throws SWRLBuiltInBridgeException {
        OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference = this.injectedOWLFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference, oWLPropertyReference, oWLDataValue);
        this.injectOWLDatatypePropertyAssertionAxiom(oWLDataPropertyAssertionAxiomReference);
        return oWLDataPropertyAssertionAxiomReference;
    }

    public void injectOWLDatatypePropertyAssertionAxiom(OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference) throws SWRLBuiltInBridgeException {
        if (!this.injectedOWLAxioms.contains(oWLDataPropertyAssertionAxiomReference)) {
            this.injectedOWLAxioms.add(oWLDataPropertyAssertionAxiomReference);
            this.cacheOWLPropertyAssertionAxiom(oWLDataPropertyAssertionAxiomReference);
        }
        this.exportOWLAxiom(oWLDataPropertyAssertionAxiomReference);
    }

    public void injectOWLDataPropertyAssertionAxioms(Set<OWLDataPropertyAssertionAxiomReference> set) throws SWRLBuiltInBridgeException {
        for (OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference : set) {
            this.injectOWLDatatypePropertyAssertionAxiom(oWLDataPropertyAssertionAxiomReference);
        }
    }

    public void injectOWLObjectPropertyAssertionAxiom(OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference) throws SWRLBuiltInBridgeException {
        if (!this.injectedOWLAxioms.contains(oWLObjectPropertyAssertionAxiomReference)) {
            this.injectedOWLAxioms.add(oWLObjectPropertyAssertionAxiomReference);
            this.cacheOWLPropertyAssertionAxiom(oWLObjectPropertyAssertionAxiomReference);
        }
        this.exportOWLAxiom(oWLObjectPropertyAssertionAxiomReference);
    }

    @Override
    public boolean isOWLClass(String string) {
        return this.owlAxiomProcessor.isRelevantOWLClass(string) || this.injectedOWLClassDeclarations.containsKey(string) || this.activeOntology.containsClassInSignature(string, true);
    }

    @Override
    public boolean isOWLObjectProperty(String string) {
        return this.owlAxiomProcessor.isRelevantOWLObjectProperty(string) || this.activeOntology.containsObjectPropertyInSignature(string, true);
    }

    @Override
    public boolean isOWLDataProperty(String string) {
        return this.owlAxiomProcessor.isRelevantOWLDataProperty(string) || this.activeOntology.containsDataPropertyInSignature(string, true);
    }

    @Override
    public boolean isOWLIndividual(String string) {
        return this.owlAxiomProcessor.isRelevantOWLIndividual(string) || this.activeOntology.containsIndividualInSignature(string, true);
    }

    @Override
    public boolean isOWLIndividualOfClass(String string, String string2) {
        boolean bl = false;
        if (this.allOWLIndividualDeclarations.containsKey(string)) {
            OWLNamedIndividualReference oWLNamedIndividualReference = this.allOWLIndividualDeclarations.get(string);
            bl = oWLNamedIndividualReference.hasType(string2);
        }
        if (!bl) {
            bl = this.activeOntology.isOWLNamedIndividualOfClass(string, string2);
        }
        return bl;
    }

    @Override
    public Set<OWLNamedIndividualReference> getOWLIndividuals() {
        return new HashSet<OWLNamedIndividualReference>(this.allOWLIndividualDeclarations.values());
    }

    @Override
    public Set<OWLPropertyAssertionAxiomReference> getOWLPropertyAssertionAxioms(String string, String string2) throws SWRLBuiltInBridgeException {
        if (this.allOWLPropertyAssertionAxioms.containsKey(string)) {
            Map<String, Set<OWLPropertyAssertionAxiomReference>> map = this.allOWLPropertyAssertionAxioms.get(string);
            if (map.containsKey(string2)) {
                return map.get(string2);
            }
            return new HashSet<OWLPropertyAssertionAxiomReference>();
        }
        Set<OWLPropertyAssertionAxiomReference> set = null;
        try {
            set = this.activeOntology.getOWLPropertyAssertionAxioms(string, string2);
        }
        catch (DataValueConversionException dataValueConversionException) {
            throw new SWRLBuiltInBridgeException("error getting property assertion axiom for individual " + string + ", property " + string2 + ": " + dataValueConversionException.getMessage(), dataValueConversionException);
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new SWRLBuiltInBridgeException("error getting property assertion axiom for individual " + string + ", property " + string2 + ": " + oWLConversionFactoryException.getMessage(), oWLConversionFactoryException);
        }
        return set;
    }

    @Override
    public OWLOntology getActiveOntology() {
        return this.activeOntology;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public OWLDataValueFactory getOWLDataValueFactory() {
        return this.dataValueFactory;
    }

    public boolean isSQWRLQuery(String string) {
        return this.owlAxiomProcessor.isSQWRLQuery(string);
    }

    public SQWRLResultImpl getSQWRLResult(String string) throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLResult(string);
    }

    @Override
    public SQWRLResultImpl getSQWRLUnpreparedResult(String string) throws SQWRLException {
        return this.owlAxiomProcessor.getSQWRLUnpreparedResult(string);
    }

    @Override
    public List<SWRLAtomReference> getSQWRLPhase1BodyAtoms(SWRLRuleReference sWRLRuleReference) {
        return this.owlAxiomProcessor.getSQWRLPhase1BodyAtoms(sWRLRuleReference);
    }

    @Override
    public List<SWRLAtomReference> getSQWRLPhase2BodyAtoms(SWRLRuleReference sWRLRuleReference) {
        return this.owlAxiomProcessor.getSQWRLPhase2BodyAtoms(sWRLRuleReference);
    }

    @Override
    public boolean usesSQWRLCollections(SWRLRuleReference sWRLRuleReference) {
        return this.owlAxiomProcessor.usesSQWRLCollections(sWRLRuleReference);
    }

    private void initialize() {
        this.inferredOWLIndividualDeclarations = new HashMap<String, OWLNamedIndividualReference>();
        this.inferredOWLAxioms = new HashSet<OWLAxiomReference>();
        this.allOWLPropertyAssertionAxioms = new HashMap<String, Map<String, Set<OWLPropertyAssertionAxiomReference>>>();
        this.allOWLIndividualDeclarations = new HashMap<String, OWLNamedIndividualReference>();
        this.injectedOWLClassDeclarations = new HashMap();
        this.injectedOWLIndividualDeclarations = new HashMap();
        this.injectedOWLAxioms = new HashSet<OWLAxiomReference>();
    }

    private void cacheOWLPropertyAssertionAxiom(OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference) {
        Set<OWLPropertyAssertionAxiomReference> set;
        Map<Object, Object> map;
        String string = oWLPropertyAssertionAxiomReference.getSubject().getURI();
        String string2 = oWLPropertyAssertionAxiomReference.getProperty().getURI();
        if (this.allOWLPropertyAssertionAxioms.containsKey(string)) {
            map = this.allOWLPropertyAssertionAxioms.get(string);
        } else {
            map = new HashMap();
            this.allOWLPropertyAssertionAxioms.put(string, map);
        }
        if (map.containsKey(string2)) {
            set = (Set)map.get(string2);
        } else {
            set = new HashSet();
            map.put(string2, set);
        }
        set.add(oWLPropertyAssertionAxiomReference);
    }

    public void cacheOWLIndividual(OWLNamedIndividualReference oWLNamedIndividualReference) {
        String string = oWLNamedIndividualReference.getURI();
        if (!this.allOWLIndividualDeclarations.containsKey(string)) {
            this.allOWLIndividualDeclarations.put(string, oWLNamedIndividualReference);
        }
    }

    public void cacheOWLIndividuals(Set<OWLNamedIndividualReference> set) {
        for (OWLNamedIndividualReference oWLNamedIndividualReference : set) {
            this.cacheOWLIndividual(oWLNamedIndividualReference);
        }
    }

    private void checkOWLClassURI(String string) throws SWRLBuiltInBridgeException {
        if (!this.activeOntology.isValidURI(string)) {
            throw new SWRLBuiltInBridgeException("attempt to inject class with invalid URI " + string);
        }
    }

    private void exportOWLClassDeclaration(OWLClassReference oWLClassReference) throws SWRLBuiltInBridgeException {
        OWLDeclarationAxiomReference oWLDeclarationAxiomReference = this.dataFactory.getOWLDeclarationAxiom(oWLClassReference);
        this.exportOWLAxiom(oWLDeclarationAxiomReference);
    }

    private void exportOWLIndividualDeclaration(OWLNamedIndividualReference oWLNamedIndividualReference) throws SWRLBuiltInBridgeException {
        OWLDeclarationAxiomReference oWLDeclarationAxiomReference = this.dataFactory.getOWLDeclarationAxiom(oWLNamedIndividualReference);
        this.exportOWLAxiom(oWLDeclarationAxiomReference);
    }

    private void exportOWLAxiom(OWLAxiomReference oWLAxiomReference) throws SWRLBuiltInBridgeException {
        try {
            this.targetRuleEngine.defineOWLAxiom(oWLAxiomReference);
        }
        catch (TargetSWRLRuleEngineException targetSWRLRuleEngineException) {
            throw new SWRLBuiltInBridgeException("error exporting OWL axiom to target rule engine " + oWLAxiomReference + ": " + targetSWRLRuleEngineException.getMessage());
        }
    }
}

