/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.DatetimeStringProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class Temporal {
    public static final int MILLISECONDS = 6;
    public static final int SECONDS = 5;
    public static final int MINUTES = 4;
    public static final int HOURS = 3;
    public static final int DAYS = 2;
    public static final int MONTHS = 1;
    public static final int YEARS = 0;
    public static final int FINEST = 6;
    public static final int COARSEST = 0;
    public static final int NUMBER_OF_GRANULARITIES = 7;
    private long nowGranuleCountInMillis = -1L;
    private DatetimeStringProcessor datetimeStringProcessor = null;
    public static final long millisecondsTo1970 = 62167363200000L;
    public static final long millisecondsToGregorianChangeDate = 12219292800000L;
    public static final long millisecondsInGregorianDiscontinuity = 864000000L;
    public static final long daylightSavingsTimeOffsetInMillis = 3600000L;
    private static final long[][] conversion_table = new long[][]{{1L, 12L, 365L, 8760L, 525600L, 31536000L, 31536000000L}, {0L, 1L, 0L, 0L, 0L, 0L, 0L}, {365L, 0L, 1L, 24L, 1440L, 86400L, 86400000L}, {8760L, 0L, 24L, 1L, 60L, 3600L, 3600000L}, {525600L, 0L, 1440L, 60L, 1L, 60L, 60000L}, {31536000L, 0L, 86400L, 3600L, 60L, 1L, 1000L}, {31536000000L, 0L, 86400000L, 3600000L, 60000L, 1000L, 1L}};
    private static final String[] stringGranularityRepresentation = new String[]{"years", "months", "days", "hours", "minutes", "seconds", "milliseconds"};
    private static final long[] days_in_month = new long[]{31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
    private static final long[] days_to_month = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};

    public Temporal(DatetimeStringProcessor datetimeStringProcessor) {
        this.datetimeStringProcessor = datetimeStringProcessor;
    }

    public void setNow(String string) throws TemporalException {
        this.nowGranuleCountInMillis = this.datetimeString2GranuleCount(string, 6);
    }

    public void setNow() throws TemporalException {
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        this.nowGranuleCountInMillis = this.timestamp2GranuleCount(timestamp, 6);
    }

    public void checkGranularity(String string) throws TemporalException {
        Temporal.getIntegerGranularityRepresentation(string);
    }

    public static void checkMonthCount(long l) throws TemporalException {
        if (l < 1L || l > 12L) {
            throw new TemporalException("invalid month count #" + l);
        }
    }

    public static int getIntegerGranularityRepresentation(String string) throws TemporalException {
        if (string.equals("") || string.equalsIgnoreCase("finest")) {
            return 6;
        }
        if (string.equalsIgnoreCase("coarsest")) {
            return 0;
        }
        for (int i = 0; i < stringGranularityRepresentation.length; ++i) {
            if (!stringGranularityRepresentation[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new TemporalException("invalid granularity '" + string + "'");
    }

    public static boolean isValidGranularityString(String string) {
        boolean bl = false;
        for (int i = 0; i < stringGranularityRepresentation.length && !bl; ++i) {
            if (!stringGranularityRepresentation[i].equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    public static String getStringGranularityRepresentation(int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return stringGranularityRepresentation[n];
    }

    public static Timestamp granuleCount2Timestamp(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.convertGranuleCount(l, n, 6);
        if (l2 > 12219292800000L) {
            l2 -= 864000000L;
        }
        return new Timestamp(l2 -= 62167363200000L);
    }

    public long timestamp2GranuleCount(Timestamp timestamp, int n) throws TemporalException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Temporal.checkGranularity(n);
        gregorianCalendar.setTime(timestamp);
        long l = gregorianCalendar.get(1);
        long l2 = gregorianCalendar.get(2);
        long l3 = gregorianCalendar.get(5) - 1;
        long l4 = gregorianCalendar.get(11);
        long l5 = gregorianCalendar.get(12);
        long l6 = gregorianCalendar.get(13);
        long l7 = gregorianCalendar.get(14);
        long l8 = Temporal.convertGranuleCount(l, 0, n) + Temporal.convertGranuleCount(l2, 1, n) + Temporal.convertGranuleCount(l3, 2, n) + Temporal.convertGranuleCount(l4, 3, n) + Temporal.convertGranuleCount(l5, 4, n) + Temporal.convertGranuleCount(l6, 5, n) + Temporal.convertGranuleCount(l7, 6, n);
        if (l2 > 1L && Temporal.isLeapYear(l)) {
            l8 += conversion_table[n][2];
        }
        return l8;
    }

    public long datetimeString2GranuleCount(String string, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l = this.datetimeStringProcessor.getYears(string);
        if (l < 1L) {
            throw new TemporalException("years must be 1 or greater in datetime: " + string);
        }
        long l2 = this.datetimeStringProcessor.getMonths(string) - 1L;
        if (l2 < 0L) {
            throw new TemporalException("months must be 1 or greater in datetime: " + string);
        }
        long l3 = this.datetimeStringProcessor.getDays(string) - 1L;
        if (l3 < 0L) {
            throw new TemporalException("days must be 1 or greater in datetime: " + string);
        }
        long l4 = this.datetimeStringProcessor.getHours(string);
        if (l4 < 0L) {
            throw new TemporalException("hours must be 0 or greater in datetime: " + string);
        }
        long l5 = this.datetimeStringProcessor.getMinutes(string);
        if (l5 < 0L) {
            throw new TemporalException("minutes must be 0 or greater in datetime: " + string);
        }
        long l6 = this.datetimeStringProcessor.getSeconds(string);
        if (l6 < 0L) {
            throw new TemporalException("seconds must be 0 or greater in datetime: " + string);
        }
        long l7 = this.datetimeStringProcessor.getMilliseconds(string);
        if (l7 < 0L) {
            throw new TemporalException("milliseconds must be 0 or greater in datetime: " + string);
        }
        long l8 = Temporal.convertGranuleCount(l, 0, n) + Temporal.convertGranuleCount(l2, 1, n) + Temporal.convertGranuleCount(l3, 2, n) + Temporal.convertGranuleCount(l4, 3, n) + Temporal.convertGranuleCount(l5, 4, n) + Temporal.convertGranuleCount(l6, 5, n) + Temporal.convertGranuleCount(l7, 6, n);
        if (l2 > 1L && Temporal.isLeapYear(l)) {
            l8 += conversion_table[n][2];
        }
        return l8;
    }

    public static long convertGranuleCount(long l, int n, int n2) throws TemporalException {
        long l2 = 0L;
        Temporal.checkGranularity(n);
        Temporal.checkGranularity(n2);
        if (n == n2) {
            return l;
        }
        long l3 = l;
        if (n >= 2 && n2 <= 1) {
            l2 = -Temporal.leapYearsUpToGranuleCount(l3, n) * conversion_table[2][n];
            l3 += l2;
        }
        long l4 = n == 1 ? Temporal.convertMonthCount2GranuleCount(l3, n2) : (n2 == 1 ? Temporal.convertGranuleCount2MonthCount(l3, n) : (n > n2 ? l3 / conversion_table[n][n2] : (n < n2 ? l3 * conversion_table[n][n2] : l3)));
        if (n <= 1 && n2 >= 2) {
            l2 = n == 0 ? Temporal.leapGranulesUpToYear(l, n2) : Temporal.leapGranulesUpToMonth(l, n2);
            l4 += l2;
        }
        return l4;
    }

    public static long getDaysInMonth(long l) throws TemporalException {
        Temporal.checkMonthCount(l);
        return days_in_month[(int)l - 1];
    }

    public static boolean isLeapYear(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return gregorianCalendar.isLeapYear((int)l);
    }

    public static long convertGranuleCount2MonthCount(long l, int n) throws TemporalException {
        long l2;
        if (n == 0) {
            l2 = l * conversion_table[0][1];
        } else if (n == 1) {
            l2 = l;
        } else {
            long l3 = l / conversion_table[n][2];
            long l4 = l3 / 365L;
            l2 = l4 * 12L;
            long l5 = l3 % 365L;
            int n2 = 1;
            while (days_to_month[n2] <= l5) {
                ++l2;
                ++n2;
            }
        }
        return l2;
    }

    public static Date sqlDate2UtilDate(java.sql.Date date, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return Temporal.granuleCount2UtilDate(Temporal.sqlDate2GranuleCount(date, n), n);
    }

    public static Date sqlDate2UtilDate(java.sql.Date date) throws TemporalException {
        return Temporal.sqlDate2UtilDate(date, 6);
    }

    public static long sqlDate2GranuleCount(java.sql.Date date, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return Temporal.utilDate2GranuleCount(Temporal.sqlDate2UtilDate(date, n), n);
    }

    public static long utilDate2GranuleCount(Date date, int n) throws TemporalException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l = 0L;
        long l2 = 0L;
        Temporal.checkGranularity(n);
        if (date.compareTo(gregorianCalendar.getGregorianChange()) > 0) {
            l += 864000000L;
        }
        l += 62167363200000L;
        l += l2;
        return Temporal.convertGranuleCount(l += date.getTime(), 6, n);
    }

    public java.sql.Date utilDate2SQLDate(Date date) throws TemporalException {
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        return this.datetimeString2SQLDate(this.utilDate2DatetimeString(date));
    }

    public static Date addGranuleCount(Date date, long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.utilDate2GranuleCount(date, n) + l;
        return Temporal.granuleCount2UtilDate(l2, n);
    }

    public static Date subtractGranuleCount(Date date, long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.utilDate2GranuleCount(date, n) - l;
        return Temporal.granuleCount2UtilDate(l2, n);
    }

    public java.sql.Date getNowSQLDate() throws TemporalException {
        return java.sql.Date.valueOf(this.getNowDatetimeString());
    }

    public Date getNowUtilDate() throws TemporalException {
        return Temporal.granuleCount2UtilDate(this.nowGranuleCountInMillis, 6);
    }

    public long getNowGranuleCount(int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return Temporal.convertGranuleCount(this.nowGranuleCountInMillis, 6, n);
    }

    public static Date granuleCount2UtilDate(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.convertGranuleCount(l, n, 6);
        if (l2 > 12219292800000L) {
            l2 -= 864000000L;
        }
        return new Date(l2 -= 62167363200000L);
    }

    public static java.sql.Date granuleCount2SQLDate(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.convertGranuleCount(l, n, 6);
        if (l2 > 12219292800000L) {
            l2 -= 864000000L;
        }
        return new java.sql.Date(l2 -= 62167363200000L);
    }

    public String getNowDatetimeString() throws TemporalException {
        return this.granuleCount2DatetimeString(this.nowGranuleCountInMillis, 6);
    }

    public String normalizeDatetimeString(String string, int n, boolean bl) throws TemporalException {
        return this.datetimeStringProcessor.normalizeDatetimeString(string, n, bl);
    }

    public String normalizeDatetimeString(String string, int n) throws TemporalException {
        return this.normalizeDatetimeString(string, n, false);
    }

    public String stripDatetimeString(String string, int n) throws TemporalException {
        return this.datetimeStringProcessor.stripDatetimeString(string, n);
    }

    public String expressDatetimeStringAtGranularity(String string, int n, boolean bl) throws TemporalException {
        return this.datetimeStringProcessor.expressDatetimeStringAtGranularity(string, n, bl);
    }

    public String expressDatetimeStringAtGranularity(String string, int n) throws TemporalException {
        return this.expressDatetimeStringAtGranularity(string, n, false);
    }

    public String sqlDate2DatetimeString(java.sql.Date date, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return this.granuleCount2DatetimeString(Temporal.sqlDate2GranuleCount(date, n), n);
    }

    public String sqlDate2DatetimeString(java.sql.Date date) throws TemporalException {
        return this.datetimeStringProcessor.granuleCount2DatetimeString(Temporal.sqlDate2GranuleCount(date, 6), 6);
    }

    public String utilDate2DatetimeString(Date date, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return this.granuleCount2DatetimeString(Temporal.utilDate2GranuleCount(date, n), n);
    }

    public String utilDate2DatetimeString(Date date) throws TemporalException {
        return this.utilDate2DatetimeString(date, 6);
    }

    public java.sql.Date datetimeString2SQLDate(String string, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return Temporal.granuleCount2SQLDate(this.datetimeString2GranuleCount(string, n), n);
    }

    public java.sql.Date datetimeString2SQLDate(String string) throws TemporalException {
        return this.datetimeString2SQLDate(string, 6);
    }

    public Date datetimeString2UtilDate(String string, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        return Temporal.granuleCount2UtilDate(this.datetimeString2GranuleCount(string, n), n);
    }

    public Date datetimeString2UtilDate(String string) throws TemporalException {
        return this.datetimeString2UtilDate(string, 6);
    }

    public String addGranuleCount(String string, long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = this.datetimeString2GranuleCount(string, n) + l;
        return this.granuleCount2DatetimeString(l2, n);
    }

    public String subtractGranuleCount(String string, long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = this.datetimeString2GranuleCount(string, n) - l;
        return this.granuleCount2DatetimeString(l2, n);
    }

    public String granuleCount2DatetimeString(long l, int n) throws TemporalException {
        return this.datetimeStringProcessor.granuleCount2DatetimeString(l, n);
    }

    public static void checkGranularity(int n) throws TemporalException {
        if (n < 0 || n > 6) {
            throw new TemporalException("invalid granularity '" + n + "'");
        }
    }

    public static void throwInvalidDatetimeStringException(String string) throws TemporalException {
        throw new TemporalException("invalid datetime string: '" + string + "'");
    }

    private static long convertMonthCount2GranuleCount(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        if (n == 1) {
            return l;
        }
        long l2 = l / 12L;
        long l3 = days_to_month[(int)l % 12];
        long l4 = l3 + l2 * 365L;
        long l5 = n > 1 ? l4 * conversion_table[2][n] : l4 / conversion_table[2][n];
        return l5;
    }

    private static long leapGranulesUpToYear(long l, int n) throws TemporalException {
        long l2 = 0L;
        Temporal.checkGranularity(n);
        for (long i = 0L; i < l; ++i) {
            if (!Temporal.isLeapYear(i)) continue;
            ++l2;
        }
        return l2 * conversion_table[2][n];
    }

    private static long leapGranulesUpToMonth(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = l / 12L;
        long l3 = Temporal.leapGranulesUpToYear(l2, n);
        if (l2 != 0L) {
            long l4 = l % 12L;
            if (Temporal.isLeapYear(l2) && l4 > 1L) {
                l3 += conversion_table[2][n];
            }
        }
        return l3;
    }

    private static long leapYearsUpToGranuleCount(long l, int n) throws TemporalException {
        long l2 = 0L;
        Temporal.checkGranularity(n);
        if (l == 0L) {
            return 0L;
        }
        if (n == 0) {
            l2 = Temporal.leapGranulesUpToYear(l, 0);
        } else if (l == 1L) {
            l2 = Temporal.leapGranulesUpToMonth(l, 0);
        } else {
            long l3 = 0L;
            long l4 = conversion_table[0][n];
            long l5 = conversion_table[2][n];
            long l6 = 0L;
            do {
                l3 += l4;
                if (!Temporal.isLeapYear(++l6)) continue;
                ++l2;
                l3 += l5;
            } while (l3 < l);
            long l7 = (days_to_month[2] + 1L) * conversion_table[2][n];
            if (Temporal.isLeapYear(l6) && l3 - l > l7) {
                ++l2;
            }
        }
        return l2;
    }
}

