/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Instant;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Period;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Temporal;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.XSDDatetimeStringProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInLibraryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDDateTime;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLLiteralReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    public static final String TemporalLibraryName = "SWRLTemporalBuiltIns";
    public static final String Prefix = "temporal:";
    public static final String Namespace = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#";
    private static String TemporalEquals = "temporal:equals";
    private static String TemporalAfter = "temporal:after";
    private static String TemporalBefore = "temporal:before";
    private static String TemporalMeets = "temporal:meets";
    private static String TemporalMetBy = "temporal:metBy";
    private static String TemporalOverlaps = "temporal:overlaps";
    private static String TemporalOverlappedBy = "temporal:overlappedBy";
    private static String TemporalContains = "temporal:contains";
    private static String TemporalDuring = "temporal:during";
    private static String TemporalStarts = "temporal:starts";
    private static String TemporalStartedBy = "temporal:startedBy";
    private static String TemporalFinishes = "temporal:finishes";
    private static String TemporalFinishedBy = "temporal:finishedBy";
    private static String TemporalIntersects = "temporal:intersects";
    private static String ExtendedPropositionClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ExtendedProposition";
    private static String ValidInstantClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidInstant";
    private static String ValidPeriodClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidPeriod";
    private static String GranularityClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#Granularity";
    private static String HasValidTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasValidTime";
    private static String HasTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasTime";
    private static String HasStartTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasStartTime";
    private static String HasFinishTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasFinishTime";
    private Temporal temporal;

    public SWRLBuiltInLibraryImpl() {
        super(TemporalLibraryName);
    }

    @Override
    public void reset() throws SWRLBuiltInLibraryException {
        XSDDatetimeStringProcessor xSDDatetimeStringProcessor = new XSDDatetimeStringProcessor();
        try {
            this.temporal = new Temporal(xSDDatetimeStringProcessor);
            this.temporal.setNow();
        }
        catch (TemporalException temporalException) {
            throw new SWRLBuiltInLibraryException("error initializing temporal library: " + temporalException.getMessage());
        }
    }

    public boolean equals(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalEquals, list);
    }

    public boolean before(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalBefore, list);
    }

    public boolean after(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalAfter, list);
    }

    public boolean meets(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalMeets, list);
    }

    public boolean metBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalMetBy, list);
    }

    public boolean overlaps(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalOverlaps, list);
    }

    public boolean overlappedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalOverlappedBy, list);
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalContains, list);
    }

    public boolean during(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalDuring, list);
    }

    public boolean starts(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalStarts, list);
    }

    public boolean startedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalStartedBy, list);
    }

    public boolean finishes(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalFinishes, list);
    }

    public boolean finishedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalFinishedBy, list);
    }

    public boolean intersects(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalIntersects, list);
    }

    public boolean notIntersects(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalIntersects, list);
    }

    public boolean notEquals(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalEquals, list);
    }

    public boolean notBefore(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalBefore, list);
    }

    public boolean notAfter(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalAfter, list);
    }

    public boolean notMeets(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalMeets, list);
    }

    public boolean notMetBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalMetBy, list);
    }

    public boolean notOverlaps(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalOverlaps, list);
    }

    public boolean notOverlappedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalOverlappedBy, list);
    }

    public boolean notContains(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalContains, list);
    }

    public boolean notDuring(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalDuring, list);
    }

    public boolean notStarts(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalStarts, list);
    }

    public boolean notStartedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalStartedBy, list);
    }

    public boolean notFinishes(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalFinishes, list);
    }

    public boolean notFinishedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalFinishedBy, list);
    }

    public boolean notDurationLessThan(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationLessThan(list);
    }

    public boolean notDurationLessThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationLessThanOrEqualTo(list);
    }

    public boolean notDurationEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationEqualTo(list);
    }

    public boolean notDurationGreaterThan(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationGreaterThan(list);
    }

    public boolean notDurationGreaterThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationGreaterThanOrEqualTo(list);
    }

    public boolean duration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        int n = list.size();
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundNonFirstArguments(list);
        try {
            long l;
            if (n == 3) {
                int n2 = this.getBuiltInArgumentAsAGranularity(2, list);
                Period period = this.getArgumentAsAPeriod(1, list, n2);
                l = period.duration(n2);
            } else {
                int n3 = this.getBuiltInArgumentAsAGranularity(3, list);
                Instant instant = this.getArgumentAsAnInstant(1, list, n3);
                Instant instant2 = this.getArgumentAsAnInstant(2, list, n3);
                l = instant.duration(instant2, n3);
            }
            if (this.isUnboundArgument(0, list)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument(l));
                bl = true;
            } else {
                long l2 = this.getArgumentAsALong(0, list);
                bl = l2 == l;
            }
        }
        catch (TemporalException temporalException) {
            throw new BuiltInException(temporalException.getMessage());
        }
        return bl;
    }

    public boolean durationLessThan(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = this.copyArguments(list);
        long l = this.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = this.getArgumentAsALong(0, list2);
        return l < l2;
    }

    public boolean durationLessThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = this.copyArguments(list);
        long l = this.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = this.getArgumentAsALong(0, list2);
        return l <= l2;
    }

    public boolean durationEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = this.copyArguments(list);
        long l = this.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = this.getArgumentAsALong(0, list2);
        return l == l2;
    }

    public boolean durationGreaterThan(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = this.copyArguments(list);
        long l = this.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = this.getArgumentAsALong(0, list2);
        return l > l2;
    }

    public boolean durationGreaterThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, list.size());
        this.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = this.copyArguments(list);
        long l = this.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = this.getArgumentAsALong(0, list2);
        return l >= l2;
    }

    public boolean add(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(4, list.size());
        this.checkForUnboundNonFirstArguments(list);
        try {
            long l = this.getArgumentAsAnInteger(2, list);
            int n = this.getBuiltInArgumentAsAGranularity(3, list);
            Instant instant = this.getArgumentAsAnInstant(1, list, n);
            instant.addGranuleCount(l, n);
            if (this.isUnboundArgument(0, list)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument(new XSDDateTime(instant.toString())));
                bl = true;
            } else {
                Instant instant2 = this.getArgumentAsAnInstant(0, list, n);
                bl = instant2.equals(instant, 6);
            }
        }
        catch (TemporalException temporalException) {
            throw new BuiltInException(temporalException.getMessage());
        }
        return bl;
    }

    private boolean temporalOperation(String string, List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        block16: {
            bl = false;
            int n = list.size();
            this.checkNumberOfArgumentsInRange(2, 4, n);
            this.checkForUnboundArguments(list);
            try {
                Period period;
                boolean bl2 = this.isBuiltInArgumentAGranularity(n - 1, list);
                boolean bl3 = bl2 ? n > 3 : n > 2;
                int n2 = bl2 ? this.getBuiltInArgumentAsAGranularity(n - 1, list) : 6;
                Period period2 = this.getArgumentAsAPeriod(0, list, n2);
                Period period3 = period = bl3 ? this.getTwoInstantArgumentsAsAPeriod(1, 2, list, n2) : this.getArgumentAsAPeriod(1, list, n2);
                if (string.equals(TemporalEquals)) {
                    bl = period2.equals(period, n2);
                    break block16;
                }
                if (string.equals(TemporalBefore)) {
                    bl = period2.before(period, n2);
                    break block16;
                }
                if (string.equals(TemporalAfter)) {
                    bl = period2.after(period, n2);
                    break block16;
                }
                if (string.equals(TemporalMeets)) {
                    bl = period2.meets(period, n2);
                    break block16;
                }
                if (string.equals(TemporalMetBy)) {
                    bl = period2.met_by(period, n2);
                    break block16;
                }
                if (string.equals(TemporalOverlaps)) {
                    bl = period2.overlaps(period, n2);
                    break block16;
                }
                if (string.equals(TemporalOverlappedBy)) {
                    bl = period2.overlapped_by(period, n2);
                    break block16;
                }
                if (string.equals(TemporalContains)) {
                    bl = period2.contains(period, n2);
                    break block16;
                }
                if (string.equals(TemporalDuring)) {
                    bl = period2.during(period, n2);
                    break block16;
                }
                if (string.equals(TemporalStarts)) {
                    bl = period2.starts(period, n2);
                    break block16;
                }
                if (string.equals(TemporalStartedBy)) {
                    bl = period2.started_by(period, n2);
                    break block16;
                }
                if (string.equals(TemporalFinishes)) {
                    bl = period2.finishes(period, n2);
                    break block16;
                }
                if (string.equals(TemporalFinishedBy)) {
                    bl = period2.finished_by(period, n2);
                    break block16;
                }
                if (string.equals(TemporalIntersects)) {
                    bl = period2.intersects(period, n2);
                    break block16;
                }
                throw new BuiltInException("internal error - unknown temporal operator '" + string + "'");
            }
            catch (TemporalException temporalException) {
                throw new BuiltInException(temporalException.getMessage());
            }
        }
        return bl;
    }

    private Period getTwoInstantArgumentsAsAPeriod(int n, int n2, List<BuiltInArgument> list, int n3) throws BuiltInException, TemporalException {
        if (n >= list.size()) {
            throw new InvalidBuiltInArgumentException(n, "out of range");
        }
        if (n2 >= list.size()) {
            throw new InvalidBuiltInArgumentException(n2, "out of range");
        }
        Instant instant = this.getArgumentAsAnInstant(n, list, n3);
        Instant instant2 = this.getArgumentAsAnInstant(n2, list, n3);
        Period period = new Period(this.temporal, instant, instant2, n3);
        return period;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Period getArgumentAsAPeriod(int n, List<BuiltInArgument> list, int n2) throws BuiltInException, TemporalException {
        Period period = null;
        if (this.isArgumentADataValue(n, list)) {
            String string = this.getArgumentAsAString(n, list);
            return new Period(this.temporal, string, string, n2);
        }
        if (!this.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting an XSD datetime or " + ValidInstantClassName + " or " + ValidPeriodClassName + " or " + ExtendedPropositionClassName + " individual, got " + list.get(n));
        String string = this.getArgumentAsAnIndividualURI(n, list);
        if (this.getBuiltInBridge().isOWLIndividualOfClass(string, ValidInstantClassName)) {
            Instant instant = this.convertValidInstantIndividual2Instant(string, n2);
            return new Period(this.temporal, instant, n2);
        }
        if (this.getBuiltInBridge().isOWLIndividualOfClass(string, ValidPeriodClassName)) {
            return this.convertValidPeriodIndividual2Period(string, n2);
        }
        if (!this.getBuiltInBridge().isOWLIndividualOfClass(string, ExtendedPropositionClassName)) throw new InvalidBuiltInArgumentException(n, "individual " + string + " is not a " + ValidInstantClassName + " or " + ValidPeriodClassName + " or " + ExtendedPropositionClassName);
        return this.convertExtendedPropositionIndividual2Period(string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Instant getArgumentAsAnInstant(int n, List<BuiltInArgument> list, int n2) throws BuiltInException, TemporalException {
        Instant instant = null;
        if (this.isArgumentADataValue(n, list)) {
            String string = this.getArgumentAsAString(n, list);
            return new Instant(this.temporal, string, n2);
        }
        if (!this.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting an XSD datetime or " + ValidInstantClassName + " or " + ExtendedPropositionClassName + " individual, got " + list.get(n));
        String string = this.getArgumentAsAnIndividualURI(n, list);
        if (this.getBuiltInBridge().isOWLIndividualOfClass(string, ValidInstantClassName)) {
            return this.convertValidInstantIndividual2Instant(string, n2);
        }
        if (!this.getBuiltInBridge().isOWLIndividualOfClass(string, ExtendedPropositionClassName)) throw new InvalidBuiltInArgumentException(n, "individual " + string + " is not a " + ValidInstantClassName + "or an " + ExtendedPropositionClassName);
        return this.convertExtendedPropositionIndividual2Instant(string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBuiltInArgumentAsAGranularity(int n, List<BuiltInArgument> list) throws TemporalException, BuiltInException {
        int n2 = -1;
        if (this.isArgumentADataValue(n, list)) {
            String string = this.getArgumentAsAString(n, list);
            return Temporal.getIntegerGranularityRepresentation(string);
        }
        if (!this.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting a " + GranularityClassName + " individual" + ", got " + list.get(n));
        String string = this.getArgumentAsAnIndividualURI(n, list);
        if (!this.getBuiltInBridge().isOWLIndividualOfClass(string, GranularityClassName)) throw new InvalidBuiltInArgumentException(n, "individual " + string + " is not a " + GranularityClassName);
        int n3 = string.indexOf(35);
        String string2 = n3 == -1 ? string : string.substring(n3 + 1, string.length());
        return Temporal.getIntegerGranularityRepresentation(string2);
    }

    private boolean isBuiltInArgumentAGranularity(int n, List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.isArgumentADataValue(n, list)) {
            String string = this.getArgumentAsAString(n, list);
            bl = Temporal.isValidGranularityString(string);
        } else if (this.isArgumentAnIndividual(n, list)) {
            String string = this.getArgumentAsAnIndividualURI(n, list);
            bl = this.getBuiltInBridge().isOWLIndividualOfClass(string, GranularityClassName);
        }
        return bl;
    }

    private Instant convertValidInstantIndividual2Instant(String string, int n) throws BuiltInException, TemporalException {
        String string2 = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), string, HasTimePropertyName);
        return new Instant(this.temporal, string2, n);
    }

    private Period convertValidPeriodIndividual2Period(String string, int n) throws BuiltInException, TemporalException {
        String string2 = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), string, HasStartTimePropertyName);
        String string3 = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), string, HasFinishTimePropertyName);
        return new Period(this.temporal, string2, string3, n);
    }

    private Period convertExtendedPropositionIndividual2Period(String string, int n) throws BuiltInException, TemporalException {
        String string2 = this.getObjectPropertyValueAsURI(this.getBuiltInBridge(), string, HasValidTimePropertyName);
        Period period = null;
        if (!this.getBuiltInBridge().isOWLIndividualOfClass(string2, ValidPeriodClassName)) {
            throw new BuiltInException("expecting valid period value for extended proposition " + string);
        }
        period = this.convertValidPeriodIndividual2Period(string2, n);
        return period;
    }

    private Instant convertExtendedPropositionIndividual2Instant(String string, int n) throws BuiltInException, TemporalException {
        String string2 = this.getObjectPropertyValueAsURI(this.getBuiltInBridge(), string, HasValidTimePropertyName);
        Instant instant = null;
        if (!this.getBuiltInBridge().isOWLIndividualOfClass(string2, ValidInstantClassName)) {
            throw new BuiltInException("expecting valid instant value for extended proposition " + string);
        }
        instant = this.convertValidInstantIndividual2Instant(string2, n);
        return instant;
    }

    private String getObjectPropertyValueAsURI(SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2) throws BuiltInException {
        Set<OWLPropertyAssertionAxiomReference> set = sWRLBuiltInBridge.getOWLPropertyAssertionAxioms(string, string2);
        OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference = set.toArray(new OWLPropertyAssertionAxiomReference[0])[0];
        if (!(oWLPropertyAssertionAxiomReference instanceof OWLObjectPropertyAssertionAxiomReference)) {
            throw new BuiltInException("property " + string2 + " does not refer to an OWL object property assertion axiom");
        }
        OWLNamedIndividualReference oWLNamedIndividualReference = ((OWLObjectPropertyAssertionAxiomReference)oWLPropertyAssertionAxiomReference).getObject();
        return oWLNamedIndividualReference.getURI();
    }

    private String getDataPropertyValueAsAString(SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2) throws BuiltInException {
        Set<OWLPropertyAssertionAxiomReference> set = sWRLBuiltInBridge.getOWLPropertyAssertionAxioms(string, string2);
        OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference = set.toArray(new OWLPropertyAssertionAxiomReference[0])[0];
        if (!(oWLPropertyAssertionAxiomReference instanceof OWLDataPropertyAssertionAxiomReference)) {
            throw new BuiltInException("property " + string2 + " does not refer to an OWL datavalued property assertion axiom");
        }
        OWLLiteralReference oWLLiteralReference = ((OWLDataPropertyAssertionAxiomReference)oWLPropertyAssertionAxiomReference).getObject();
        return oWLLiteralReference.toString();
    }

    private int getDataPropertyValueAsAnInteger(SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2) throws BuiltInException {
        Set<OWLPropertyAssertionAxiomReference> set = sWRLBuiltInBridge.getOWLPropertyAssertionAxioms(string, string2);
        OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference = set.toArray(new OWLPropertyAssertionAxiomReference[0])[0];
        if (!(oWLPropertyAssertionAxiomReference instanceof OWLDataPropertyAssertionAxiomReference)) {
            throw new BuiltInException("property " + string2 + " does not refer to an OWL datavalued property assertion axiom");
        }
        OWLLiteralReference oWLLiteralReference = ((OWLDataPropertyAssertionAxiomReference)oWLPropertyAssertionAxiomReference).getObject();
        OWLDataValue oWLDataValue = this.getBuiltInBridge().getOWLDataValueFactory().getOWLDataValue(oWLLiteralReference);
        return oWLDataValue.getInt();
    }
}

