/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Instant;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Temporal;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period {
    private Instant startInstant;
    private Instant finishInstant;
    private Temporal temporal;

    public Period(Temporal temporal, long l, long l2, int n) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, l, n);
        this.finishInstant = new Instant(temporal, l2, n);
        this.orderCheck();
    }

    public Period(Temporal temporal, String string, String string2, int n) throws TemporalException {
        this.temporal = temporal;
        this.semanticCheck(string, string2);
        this.startInstant = new Instant(temporal, string, n, false);
        this.finishInstant = new Instant(temporal, string2, n, false);
        this.orderCheck();
    }

    public Period(Temporal temporal, String string, String string2) throws TemporalException {
        this(temporal, string, string2, 6);
    }

    public Period(Temporal temporal, Period period) throws TemporalException {
        this(temporal, period.getStartGranuleCount(period.getGranularity()), period.getFinishGranuleCount(period.getGranularity()), period.getGranularity());
    }

    public Period(Temporal temporal, Instant instant, int n) throws TemporalException {
        this(temporal, instant, instant, n);
    }

    public Period(Temporal temporal, Instant instant) throws TemporalException {
        this(temporal, instant, instant, instant.getGranularity());
    }

    public Period(Temporal temporal, Instant instant, Instant instant2, int n) throws TemporalException {
        this.startInstant = new Instant(temporal, instant);
        this.finishInstant = new Instant(temporal, instant2);
        this.startInstant.setGranularity(n);
        this.finishInstant.setGranularity(n);
        this.orderCheck();
    }

    public Period(Temporal temporal, Instant instant, Instant instant2) throws TemporalException {
        this.startInstant = new Instant(temporal, instant);
        this.finishInstant = new Instant(temporal, instant2);
        int n = instant.getGranularity() > instant2.getGranularity() ? instant.getGranularity() : instant2.getGranularity();
        this.startInstant.setGranularity(n);
        this.finishInstant.setGranularity(n);
        this.orderCheck();
    }

    public Period(Temporal temporal, Timestamp timestamp, Timestamp timestamp2, int n) throws TemporalException {
        this.startInstant = new Instant(temporal, timestamp, n);
        this.finishInstant = new Instant(temporal, timestamp2, n);
        this.orderCheck();
    }

    public Period(Temporal temporal, Timestamp timestamp, Timestamp timestamp2) throws TemporalException {
        this(temporal, timestamp, timestamp2, 6);
    }

    public Period(Temporal temporal, Date date, Date date2, int n) throws TemporalException {
        this.startInstant = new Instant(temporal, date, n);
        this.finishInstant = new Instant(temporal, date2, n);
        this.orderCheck();
    }

    public Period(Temporal temporal, Date date, Date date2) throws TemporalException {
        this(temporal, date, date2, 6);
    }

    public Period(Temporal temporal, java.sql.Date date, java.sql.Date date2, int n) throws TemporalException {
        this.startInstant = new Instant(temporal, date, n);
        this.finishInstant = new Instant(temporal, date2, n);
        this.orderCheck();
    }

    public Period(Temporal temporal, java.sql.Date date, java.sql.Date date2) throws TemporalException {
        this(temporal, date, date2, 6);
    }

    public boolean before(Period period, int n) throws TemporalException {
        return this.getFinishGranuleCount(n) < period.getStartGranuleCount(n);
    }

    public boolean before(Period period) throws TemporalException {
        return this.getFinishGranuleCount(6) < period.getStartGranuleCount(6);
    }

    public boolean starts_before(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) < period.getStartGranuleCount(n);
    }

    public boolean starts_after(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) > period.getFinishGranuleCount(n);
    }

    public boolean starts_after(Period period) throws TemporalException {
        return this.getStartGranuleCount(6) > period.getFinishGranuleCount(6);
    }

    public boolean after(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) > period.getFinishGranuleCount(n);
    }

    public boolean equals(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) == period.getStartGranuleCount(n) && this.getFinishGranuleCount(n) == period.getFinishGranuleCount(n);
    }

    public boolean meets(Period period) throws TemporalException {
        return this.meets(period, 6);
    }

    public boolean meets(Period period, int n) throws TemporalException {
        return this.getFinishGranuleCount(n) + 1L == period.getStartGranuleCount(n);
    }

    public boolean met_by(Period period) throws TemporalException {
        return this.met_by(period, 6);
    }

    public boolean met_by(Period period, int n) throws TemporalException {
        return period.meets(this, n);
    }

    public boolean overlaps(Period period) throws TemporalException {
        return this.overlaps(period, 6);
    }

    public boolean overlaps(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) <= period.getStartGranuleCount(n) && this.getFinishGranuleCount(n) <= period.getFinishGranuleCount(n) && this.getFinishGranuleCount(n) >= period.getStartGranuleCount(n);
    }

    public boolean overlapped_by(Period period) throws TemporalException {
        return this.overlapped_by(period, 6);
    }

    public boolean overlapped_by(Period period, int n) throws TemporalException {
        return period.overlaps(this, n);
    }

    public boolean during(Period period) throws TemporalException {
        return this.during(period, 6);
    }

    public boolean during(Period period, int n) throws TemporalException {
        return period.contains(this, n) && !period.equals(this, n);
    }

    public boolean contains(Period period) throws TemporalException {
        return this.contains(period, 6);
    }

    public boolean contains(Period period, int n) throws TemporalException {
        return !(period.getStartGranuleCount(n) <= this.getStartGranuleCount(n) && period.getStartGranuleCount(n) != this.getStartGranuleCount(n) || period.getFinishGranuleCount(n) >= this.getFinishGranuleCount(n) && period.getFinishGranuleCount(n) != this.getFinishGranuleCount(n));
    }

    public boolean starts(Period period) throws TemporalException {
        return this.starts(period, 6);
    }

    public boolean starts(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) == period.getStartGranuleCount(n) && this.getFinishGranuleCount(n) < period.getFinishGranuleCount(n);
    }

    public boolean started_by(Period period) throws TemporalException {
        return this.started_by(period, 6);
    }

    public boolean started_by(Period period, int n) throws TemporalException {
        return period.starts(this, n);
    }

    public boolean finishes(Period period) throws TemporalException {
        return this.finishes(period, 6);
    }

    public boolean finishes(Period period, int n) throws TemporalException {
        return this.getStartGranuleCount(n) < period.getStartGranuleCount(n) && this.getFinishGranuleCount(n) == period.getFinishGranuleCount(n);
    }

    public boolean finished_by(Period period) throws TemporalException {
        return this.finished_by(period, 6);
    }

    public boolean finished_by(Period period, int n) throws TemporalException {
        return period.finishes(this, n);
    }

    public boolean adjacent(Period period) throws TemporalException {
        return this.adjacent(period, 6);
    }

    public boolean adjacent(Period period, int n) throws TemporalException {
        return this.meets(period, n) || this.met_by(period, n);
    }

    public boolean intersects(Period period) throws TemporalException {
        return this.intersects(period, 6);
    }

    public boolean intersects(Period period, int n) throws TemporalException {
        return this.intersection(period, n) != null;
    }

    public Period intersection(Period period) throws TemporalException {
        return this.intersection(period, 6);
    }

    public Period intersection(Period period, int n) throws TemporalException {
        Period period2 = this.startInstant.equals(period.getStartInstant(), n) ? (this.finishInstant.after(period.getFinishInstant(), n) ? new Period(this.temporal, this.startInstant, period.getFinishInstant(), n) : new Period(this.temporal, this.startInstant, this.finishInstant, n)) : (this.startInstant.before(period.getStartInstant(), n) ? (this.finishInstant.after(period.getStartInstant(), n) ? (this.finishInstant.before(period.getFinishInstant(), n) ? new Period(this.temporal, period.getStartInstant(), this.finishInstant, n) : new Period(this.temporal, period.getStartInstant(), period.getFinishInstant(), n)) : null) : (period.getFinishInstant().after(this.startInstant, n) ? (this.finishInstant.before(period.getFinishInstant(), n) ? new Period(this.temporal, this.startInstant, this.finishInstant, n) : new Period(this.temporal, this.startInstant, period.getFinishInstant(), n)) : null));
        return period2;
    }

    public Period merge(Period period) throws TemporalException {
        return this.merge(period, 6);
    }

    public Period merge(Period period, int n) throws TemporalException {
        if (this.intersection(period, n) == null && !this.adjacent(period, n)) {
            throw new TemporalException("start must be before or equal to the finish in a period: ('" + this.toString(n) + "'), ('" + period.toString(n) + "')");
        }
        Instant instant = this.startInstant.before(period.getStartInstant(), n) ? this.startInstant : period.getStartInstant();
        Instant instant2 = this.getFinishInstant().before(period.getFinishInstant(), n) ? period.getFinishInstant() : this.finishInstant;
        Period period2 = new Period(this.temporal, instant, instant2, n);
        return period2;
    }

    private void orderCheck() throws TemporalException {
        if (this.startInstant.after(this.finishInstant, 6)) {
            throw new TemporalException("start must be before or equal to finish in a period: (" + this.startInstant.toString(6) + ", " + this.finishInstant.toString(6) + ")");
        }
    }

    public long duration(int n) throws TemporalException {
        return this.startInstant.duration(this.finishInstant, n);
    }

    public List<Period> coalesce(List<Period> list, int n) throws TemporalException {
        ArrayList<Period> arrayList = new ArrayList<Period>();
        while (!list.isEmpty()) {
            boolean bl;
            Period period = list.get(0);
            list.remove(0);
            do {
                bl = false;
                Iterator<Period> iterator = list.iterator();
                while (!bl && iterator.hasNext()) {
                    Period period2 = iterator.next();
                    if (!period.intersects(period2, n) && !period.adjacent(period2, n)) continue;
                    period = period.merge(period2, n);
                    iterator.remove();
                    bl = true;
                }
            } while (bl);
            arrayList.add(period);
        }
        return arrayList;
    }

    public void addGranuleCount(long l, int n) throws TemporalException {
        this.startInstant.addGranuleCount(l, n);
        this.finishInstant.addGranuleCount(l, n);
    }

    public void subtractGranuleCount(long l, int n) throws TemporalException {
        this.startInstant.subtractGranuleCount(l, n);
        this.finishInstant.subtractGranuleCount(l, n);
    }

    public void addStartGranuleCount(long l, int n) throws TemporalException {
        this.startInstant.addGranuleCount(l, n);
    }

    public void addFinishGranuleCount(long l, int n) throws TemporalException {
        this.finishInstant.addGranuleCount(l, n);
    }

    public void subtractStartGranuleCount(long l, int n) throws TemporalException {
        this.startInstant.subtractGranuleCount(l, n);
    }

    public void subtractFinishGranuleCount(long l, int n) throws TemporalException {
        this.finishInstant.subtractGranuleCount(l, n);
    }

    public Period coalesce(Period period, int n) throws TemporalException {
        Period period2 = null;
        if (this.intersects(period, n) || this.adjacent(period, n)) {
            period2 = this.merge(period, n);
        }
        return period2;
    }

    public void setStartInstant(Instant instant) throws TemporalException {
        this.startInstant = new Instant(this.temporal, instant);
        this.finishInstant.setGranularity(instant.getGranularity());
    }

    public void setFinishInstant(Instant instant) throws TemporalException {
        this.finishInstant = new Instant(this.temporal, instant);
        this.startInstant.setGranularity(instant.getGranularity());
    }

    public String getStartDatetimeString() throws TemporalException {
        return this.startInstant.getDatetimeString();
    }

    public Date getStartDate() throws TemporalException {
        return this.startInstant.getUtilDate();
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    public String getStartDatetimeString(int n) throws TemporalException {
        return this.startInstant.getDatetimeString(n);
    }

    public Date getStartDate(int n) throws TemporalException {
        return this.startInstant.getUtilDate(n);
    }

    public String getFinishDatetime() throws TemporalException {
        return this.finishInstant.getDatetimeString();
    }

    public Date getFinishDate() throws TemporalException {
        return this.finishInstant.getUtilDate();
    }

    public Instant getFinishInstant() {
        return this.finishInstant;
    }

    public String getFinishDatetime(int n) throws TemporalException {
        return this.finishInstant.getDatetimeString(n);
    }

    public Date getFinishDate(int n) throws TemporalException {
        return this.finishInstant.getUtilDate(n);
    }

    public long getStartGranuleCount(int n) throws TemporalException {
        return this.startInstant.getGranuleCount(n);
    }

    public long getFinishGranuleCount(int n) throws TemporalException {
        return this.finishInstant.getGranuleCount(n);
    }

    public boolean couldBeInstant() throws TemporalException {
        return this.startInstant.equals(this.finishInstant, 6);
    }

    public String toString(int n) throws TemporalException {
        return "(" + this.startInstant.toString(n) + ", " + this.finishInstant.toString(n) + ")";
    }

    public String toString() {
        String string = "";
        try {
            return this.toString(6);
        }
        catch (TemporalException temporalException) {
            return string;
        }
    }

    public int getGranularity() {
        return this.startInstant.getGranularity();
    }

    private void semanticCheck(String string, String string2) throws TemporalException {
        if (string.equals("+")) {
            throw new TemporalException("'+' cannot be used at the start of a period");
        }
        if (string2.equals("-")) {
            throw new TemporalException("'-' cannot be used at the end of a period");
        }
    }
}

