/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Temporal;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instant {
    private Temporal temporal;
    private long granuleCount;
    private int granularity;
    private long[] granuleCountArray = new long[7];

    public Instant(Temporal temporal, long l, int n) {
        this.temporal = temporal;
        this.granuleCount = l;
        this.granularity = n;
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, Timestamp timestamp) throws TemporalException {
        this(temporal, timestamp, 6);
    }

    public Instant(Temporal temporal, Timestamp timestamp, int n) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = temporal.timestamp2GranuleCount(timestamp, n);
        this.granularity = n;
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, Date date) throws TemporalException {
        this(temporal, date, 6);
    }

    public Instant(Temporal temporal, Date date, int n) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = Temporal.utilDate2GranuleCount(date, n);
        this.granularity = n;
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, java.sql.Date date) throws TemporalException {
        this(temporal, date, 6);
    }

    public Instant(Temporal temporal, java.sql.Date date, int n) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = Temporal.sqlDate2GranuleCount(date, n);
        this.granularity = n;
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, String string, int n) throws TemporalException {
        this(temporal, string, n, false);
    }

    public Instant(Temporal temporal, String string, int n, boolean bl) throws TemporalException {
        this.initialize(temporal, string, n, bl);
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, String string) throws TemporalException {
        this(temporal, string, false);
    }

    public Instant(Temporal temporal, String string, boolean bl) throws TemporalException {
        this.initialize(temporal, string, 6, bl);
        this.clearGranuleCountArray();
    }

    public Instant(Temporal temporal, Instant instant) throws TemporalException {
        this(temporal, instant.getGranuleCount(instant.getGranularity()), instant.getGranularity());
    }

    public int getGranularity() {
        return this.granularity;
    }

    public void setGranularity(int n) throws TemporalException {
        if (this.granularity == n) {
            return;
        }
        this.granuleCount = Temporal.convertGranuleCount(this.granuleCount, this.granularity, n);
        this.clearGranuleCountArray();
        this.granularity = n;
    }

    public void setGranuleCount(long l, int n) {
        this.granuleCount = l;
        this.granularity = n;
        this.clearGranuleCountArray();
    }

    public long getGranuleCount() throws TemporalException {
        return this.granuleCount;
    }

    public long getGranuleCount(int n) throws TemporalException {
        long l;
        if (this.getGranularity() != n) {
            if (this.granuleCountArray[n] == -1L) {
                this.granuleCountArray[n] = l = Temporal.convertGranuleCount(this.granuleCount, this.getGranularity(), n);
            } else {
                l = this.granuleCountArray[n];
            }
        } else {
            l = this.getGranuleCount();
        }
        return l;
    }

    public String getDatetimeString() throws TemporalException {
        return this.getDatetimeString(6);
    }

    public String getDatetimeString(int n) throws TemporalException {
        long l = this.getGranuleCount(n);
        return this.temporal.stripDatetimeString(this.temporal.granuleCount2DatetimeString(l, n), n);
    }

    public Date getUtilDate() throws TemporalException {
        return this.getUtilDate(this.granularity);
    }

    public Date getUtilDate(int n) throws TemporalException {
        long l = this.granuleCount;
        return Temporal.granuleCount2UtilDate(l, n);
    }

    public java.sql.Date getSQLDate() throws TemporalException {
        return this.getSQLDate(this.granularity);
    }

    public java.sql.Date getSQLDate(int n) throws TemporalException {
        long l = this.granuleCount;
        return Temporal.granuleCount2SQLDate(l, n);
    }

    public boolean isStartOfTime() {
        return this.granuleCount == 0L;
    }

    public String toString(int n) throws TemporalException {
        return this.getDatetimeString(n);
    }

    public String toString() {
        String string = "";
        try {
            return this.toString(6);
        }
        catch (TemporalException temporalException) {
            string = "<INVALID_INSTANT: " + temporalException.toString() + ">";
            return string;
        }
    }

    public void addGranuleCount(long l, int n) throws TemporalException {
        long l2 = Temporal.convertGranuleCount(l, n, this.granularity);
        this.granuleCount = this.getGranuleCount() + l2;
        this.clearGranuleCountArray();
    }

    public void subtractGranuleCount(long l, int n) throws TemporalException {
        long l2 = Temporal.convertGranuleCount(l, n, this.granularity);
        this.granuleCount -= l2;
        this.clearGranuleCountArray();
    }

    public long duration(Instant instant, int n) throws TemporalException {
        return Math.abs(this.getGranuleCount(n) - instant.getGranuleCount(n));
    }

    public boolean before(Instant instant, int n) throws TemporalException {
        return this.getGranuleCount(n) < instant.getGranuleCount(n);
    }

    public boolean after(Instant instant, int n) throws TemporalException {
        return this.getGranuleCount(n) > instant.getGranuleCount(n);
    }

    public boolean equals(Instant instant, int n) throws TemporalException {
        return this.getGranuleCount(n) == instant.getGranuleCount(n);
    }

    public boolean meets(Instant instant, int n) throws TemporalException {
        return this.getGranuleCount(n) + 1L == instant.getGranuleCount(n) || this.getGranuleCount(n) == instant.getGranuleCount(n);
    }

    public boolean met_by(Instant instant, int n) throws TemporalException {
        return instant.meets(this, n);
    }

    public boolean adjacent(Instant instant, int n) throws TemporalException {
        return this.meets(instant, n) || this.met_by(instant, n);
    }

    public boolean overlaps(Instant instant, int n) throws TemporalException {
        return false;
    }

    public boolean overlapped_by(Instant instant, int n) throws TemporalException {
        return instant.overlaps(this, n);
    }

    public boolean contains(Instant instant, int n) throws TemporalException {
        return false;
    }

    public boolean during(Instant instant, int n) throws TemporalException {
        return false;
    }

    public boolean starts(Instant instant, int n) throws TemporalException {
        return false;
    }

    public boolean started_by(Instant instant, int n) throws TemporalException {
        return instant.starts(this, n);
    }

    public boolean finishes(Instant instant, int n) throws TemporalException {
        return false;
    }

    public boolean finished_by(Instant instant, int n) throws TemporalException {
        return instant.finishes(this, n);
    }

    public List<Instant> coalesce(List<Instant> list, int n) throws TemporalException {
        ArrayList<Instant> arrayList = new ArrayList<Instant>();
        while (!list.isEmpty()) {
            Instant instant = list.get(0);
            list.remove(0);
            Iterator<Instant> iterator = list.iterator();
            while (iterator.hasNext()) {
                Instant instant2 = iterator.next();
                if (!instant.equals(instant2, n)) continue;
                iterator.remove();
            }
            arrayList.add(instant);
        }
        return arrayList;
    }

    private void initialize(Temporal temporal, String string, int n, boolean bl) throws TemporalException {
        this.temporal = temporal;
        String string2 = string.equals("now") ? temporal.getNowDatetimeString() : string.trim();
        string2 = temporal.normalizeDatetimeString(string2, n, bl);
        this.granularity = n;
        string2 = temporal.expressDatetimeStringAtGranularity(string2, n);
        this.granuleCount = temporal.datetimeString2GranuleCount(string2, n);
    }

    private void clearGranuleCountArray() {
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }
}

