/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLMapperException;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessorException;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());

    public void generateXMLFile(Document document, String string) throws XMLProcessorException {
        OutputStream outputStream = this.createOutputXMLStream(string);
        if (document == null || !document.hasRootElement()) {
            throw new XMLProcessorException("document is empty");
        }
        try {
            this.serializer.output(document, outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error writing XML file '" + string + "': " + iOException.getMessage());
        }
    }

    public String generateXMLString(Document document) throws XMLProcessorException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (document == null || !document.hasRootElement()) {
            throw new XMLProcessorException("document is empty");
        }
        try {
            this.serializer.output(document, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error writing XML string: " + iOException.getMessage());
        }
        return byteArrayOutputStream.toString();
    }

    public Document processXMLStream(String string) throws XMLProcessorException {
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            InputStream inputStream = this.createInputXMLStream(string);
            document = sAXBuilder.build(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            throw new XMLProcessorException("error opening XML file '" + string + "': " + exception.getMessage());
        }
        return document;
    }

    public Document processXMLString(String string) throws XMLProcessorException {
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new XMLProcessorException("error processing XML string: " + exception.getMessage());
        }
        return document;
    }

    public Element createElement(Document document, Element element, String string) {
        Element element2 = new Element(string);
        if (element == null) {
            document.setRootElement(element2);
        } else {
            element.addContent((Content)element2);
        }
        return element2;
    }

    public void setAttribute(Element element, String string, String string2, String string3, String string4) {
        Attribute attribute = new Attribute(string, string2, Namespace.getNamespace((String)string3, (String)string4));
        element.setAttribute(attribute);
    }

    public List<Attribute> getAttributes(Element element) {
        return new ArrayList<Attribute>(element.getAttributes());
    }

    public List<Element> getSubElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Object e : element.getChildren()) {
            if (!(e instanceof Element)) continue;
            arrayList.add((Element)e);
        }
        return arrayList;
    }

    public boolean isSchema(Element element) {
        return this.hasName(element, "schema");
    }

    public boolean isElement(Element element) {
        return this.hasName(element, "element");
    }

    public boolean isAll(Element element) {
        return this.hasName(element, "all");
    }

    public boolean isComplexType(Element element) {
        return this.hasName(element, "complexType");
    }

    public boolean isSequence(Element element) {
        return this.hasName(element, "sequence");
    }

    public boolean isGroup(Element element) {
        return this.hasName(element, "group");
    }

    public boolean isAttributeGroup(Element element) {
        return this.hasName(element, "attributeGroup");
    }

    public boolean isChoice(Element element) {
        return this.hasName(element, "choice");
    }

    public boolean isAny(Element element) {
        return this.hasName(element, "any");
    }

    public boolean isAnyAttribute(Element element) {
        return this.hasName(element, "anyAttribute");
    }

    public boolean isAttribute(Element element) {
        return this.hasName(element, "attribute");
    }

    public boolean isComplexContent(Element element) {
        return this.hasName(element, "complexContent");
    }

    public boolean isSimpleContent(Element element) {
        return this.hasName(element, "simpleContent");
    }

    public boolean isSimpleContext(Element element) {
        return this.hasName(element, "simpleContext");
    }

    public boolean isSimpleType(Element element) {
        return this.hasName(element, "simpleType");
    }

    public boolean isRefElement(Element element) {
        return this.isElement(element) && this.hasRefAttribute(element);
    }

    public String getNameAttribute(Element element) throws XMLMapperException {
        return this.getNameAttributeValue(element);
    }

    public String getReafAttribute(Element element) throws XMLMapperException {
        return this.getRefAttributeValue(element);
    }

    public String getTypeAttribute(Element element) throws XMLMapperException {
        return this.getTypeAttributeValue(element);
    }

    public String getUseAttribute(Element element) throws XMLMapperException {
        return this.getUseAttributeValue(element);
    }

    public String getMinOccursAttribute(Element element) throws XMLMapperException {
        return this.getMinOccursAttributeValue(element);
    }

    public String getMaxOccursAttribute(Element element) throws XMLMapperException {
        return this.getMaxOccursAttributeValue(element);
    }

    public boolean hasNameAttribute(Element element) {
        return this.hasAttribute(element, "name");
    }

    public boolean hasValueAttribute(Element element) {
        return this.hasAttribute(element, "value");
    }

    public boolean hasBaseAttribute(Element element) {
        return this.hasAttribute(element, "base");
    }

    public boolean hasMixedAttribute(Element element) {
        return this.hasAttribute(element, "mixed");
    }

    public boolean hasTypeAttribute(Element element) {
        return this.hasAttribute(element, "type");
    }

    public boolean hasDefaultAttribute(Element element) {
        return this.hasAttribute(element, "default");
    }

    public boolean hasFixedAttribute(Element element) {
        return this.hasAttribute(element, "fixed");
    }

    public boolean hasRefAttribute(Element element) {
        return this.hasAttribute(element, "ref");
    }

    public boolean hasUseAttribute(Element element) {
        return this.hasAttribute(element, "use");
    }

    public boolean hasMaxOccursAttribute(Element element) {
        return this.hasAttribute(element, "maxOccurs");
    }

    public boolean hasMinOccursAttribute(Element element) {
        return this.hasAttribute(element, "minOccurs");
    }

    public String getNameAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "name");
    }

    public String getValueAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "value");
    }

    public String getMixedAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "mixed");
    }

    public String getBaseAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "base");
    }

    public String getTypeAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "type");
    }

    public String getDefaultAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "default");
    }

    public String getFixedAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "fixed");
    }

    public String getRefAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "ref");
    }

    public String getUseAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "use");
    }

    public String getMaxOccursAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "maxOccurs");
    }

    public String getMinOccursAttributeValue(Element element) throws XMLMapperException {
        return this.getAttributeValue(element, "minOccurs");
    }

    public Element getComplexTypeChild(Element element) throws XMLMapperException {
        if (!this.hasComplexTypeChild(element)) {
            throw new XMLMapperException("expecting complexType child for element " + this.getNameAttributeValue(element));
        }
        return element.getChild("complexType", element.getNamespace());
    }

    public String getAttributeValue(Element element, String string) throws XMLMapperException {
        if (!this.hasAttribute(element, string)) {
            throw new XMLMapperException("no " + string + " attribute found in element " + element.getName());
        }
        return element.getAttributeValue(string);
    }

    public Element getFirstChild(Element element) throws XMLMapperException {
        if (element.getChildren() == null) {
            throw new XMLMapperException("getFirstChild called on non-parent element " + this.getNameAttributeValue(element));
        }
        return (Element)element.getChildren().get(0);
    }

    public boolean hasChildren(Element element) {
        return element.getChildren() != null;
    }

    public boolean hasComplexTypeChild(Element element) {
        return this.isElement(element) && element.getChild("complexType", element.getNamespace()) != null;
    }

    public boolean hasSimpleTypeChild(Element element) {
        return this.isElement(element) && element.getChild("simpleTypeChild", element.getNamespace()) != null;
    }

    private boolean hasName(Element element, String string) {
        return element.getName() != null && element.getName().equals(string);
    }

    private boolean hasAttribute(Element element, String string) {
        return element.getAttributeValue(string) != null;
    }

    private OutputStream createOutputXMLStream(String string) throws XMLProcessorException {
        try {
            return new FileOutputStream(string);
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error creating XML serializer for XML stream '" + string + "': " + iOException.getMessage());
        }
    }

    private InputStream createInputXMLStream(String string) throws XMLProcessorException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("file")) {
                String string3 = uRL.getPath();
                inputStream = new FileInputStream(string3);
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new XMLProcessorException("invalid URL for XML stream '" + string + "': " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("IO error opening XML stream '" + string + "': " + iOException.getMessage());
        }
        return inputStream;
    }
}

