/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLMapperException;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessor;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.Filter;

public class XMLMapper {
    public static final String XMLAlias = "swrlxml:";
    public static final String XMLDocumentOWLClassName = "swrlxml:XMLDocument";
    public static final String XMLDocumentHasRootElementPropertyName = "swrlxml:hasRootElement";
    public static final String XMLDocumentHasElementsPropertyName = "swrlxml:hasElements";
    public static final String XMLElementOWLClassName = "swrlxml:XMLElement";
    public static final String XMLHasNamePropertyName = "swrlxml:hasName";
    public static final String XMLHasNamespacePrefixPropertyName = "swrlxml:hasNamespacePrefix";
    public static final String XMLHasNamespaceURIPropertyName = "swrlxml:hasNamespaceURI";
    public static final String XMLElementHasMappedIndividualsPropertyName = "swrlxml:hasMappedIndividuals";
    public static final String XMLElementHasSubElementsPropertyName = "swrlxml:hasSubElements";
    public static final String XMLElementHasAttributesPropertyName = "swrlxml:hasAttributes";
    public static final String XMLElementHasContentPropertyName = "swrlxml:hasContent";
    public static final String XMLAttributeOWLClassName = "swrlxml:XMLAttribute";
    public static final String XMLAttributeHasValuePropertyName = "swrlxml:hasValue";
    private OWLModel owlModel;
    private XMLProcessor xmlProcessor;
    private OWLProperty rootElementProperty;
    private OWLProperty elementsProperty;
    private OWLProperty subElementsProperty;
    private OWLProperty nameProperty;
    private OWLProperty namespacePrefixProperty;
    private OWLProperty namespaceURIProperty;
    private OWLProperty contentProperty;
    private OWLProperty valueProperty;
    private OWLProperty attributesProperty;

    public XMLMapper(OWLModel oWLModel) throws XMLMapperException {
        this.owlModel = oWLModel;
        this.xmlProcessor = new XMLProcessor();
        try {
            this.rootElementProperty = SWRLOWLUtil.createOWLObjectProperty(oWLModel, XMLDocumentHasRootElementPropertyName);
            this.elementsProperty = SWRLOWLUtil.createOWLObjectProperty(oWLModel, XMLDocumentHasElementsPropertyName);
            this.nameProperty = SWRLOWLUtil.createOWLDatatypeProperty(oWLModel, XMLHasNamePropertyName);
            this.namespacePrefixProperty = SWRLOWLUtil.createOWLDatatypeProperty(oWLModel, XMLHasNamespacePrefixPropertyName);
            this.namespaceURIProperty = SWRLOWLUtil.createOWLDatatypeProperty(oWLModel, XMLHasNamespaceURIPropertyName);
            this.contentProperty = SWRLOWLUtil.createOWLDatatypeProperty(oWLModel, XMLElementHasContentPropertyName);
            this.subElementsProperty = SWRLOWLUtil.createOWLObjectProperty(oWLModel, XMLElementHasSubElementsPropertyName);
            this.valueProperty = SWRLOWLUtil.createOWLDatatypeProperty(oWLModel, XMLAttributeHasValuePropertyName);
            this.attributesProperty = SWRLOWLUtil.createOWLObjectProperty(oWLModel, XMLElementHasAttributesPropertyName);
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new XMLMapperException("error creating properties: " + sWRLOWLUtilException.getMessage());
        }
    }

    public Document owlDocument2Document() throws XMLMapperException {
        OWLIndividual oWLIndividual = null;
        Document document = new Document();
        try {
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(this.owlModel, XMLDocumentOWLClassName);
            OWLIndividual oWLIndividual2 = SWRLOWLUtil.getOWLIndividual(this.owlModel, oWLNamedClass, true, 1);
            RDFResource rDFResource = SWRLOWLUtil.getObjectPropertyValue(this.owlModel, oWLIndividual2, XMLDocumentHasRootElementPropertyName, false);
            if (rDFResource == null) {
                throw new XMLMapperException("no document root element specified");
            }
            if (!(rDFResource instanceof OWLIndividual)) {
                throw new XMLMapperException("invalid document root element " + rDFResource);
            }
            oWLIndividual = (OWLIndividual)rDFResource;
            this.owlElement2Element(document, oWLIndividual, null);
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new XMLMapperException("error mapping OWL XML ontology to Document: " + sWRLOWLUtilException.getMessage());
        }
        return document;
    }

    public OWLIndividual document2OWLDocument(Document document) throws XMLMapperException {
        OWLIndividual oWLIndividual;
        Element element = document.getRootElement();
        if (this.xmlProcessor.isSchema(element)) {
            throw new XMLMapperException("not expecting schema root element");
        }
        this.addSWRLXMLImport();
        try {
            oWLIndividual = SWRLOWLUtil.createIndividualOfClass(this.owlModel, XMLDocumentOWLClassName);
            this.element2OWLElement(document, oWLIndividual, element, null);
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new XMLMapperException("error mapping Document to OWL XML ontology: " + sWRLOWLUtilException.getMessage());
        }
        return oWLIndividual;
    }

    private void owlElement2Element(Document document, OWLIndividual oWLIndividual, Element element) throws XMLMapperException, SWRLOWLUtilException {
        OWLIndividual oWLIndividual2;
        String string = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamePropertyName, true);
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamespacePrefixPropertyName, false, "");
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamespaceURIPropertyName, false, "");
        Set<RDFResource> set = SWRLOWLUtil.getObjectPropertyValues(this.owlModel, oWLIndividual, XMLElementHasAttributesPropertyName, false);
        Set<RDFResource> set2 = SWRLOWLUtil.getObjectPropertyValues(this.owlModel, oWLIndividual, XMLElementHasSubElementsPropertyName, false);
        String string4 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLElementHasContentPropertyName, false, "");
        Element element2 = this.xmlProcessor.createElement(document, element, string);
        element2.setNamespace(Namespace.getNamespace((String)string2, (String)string3));
        if (string4 != null) {
            element2.addContent(string4);
        }
        for (RDFResource rDFResource : set2) {
            if (!(rDFResource instanceof OWLIndividual)) continue;
            oWLIndividual2 = (OWLIndividual)rDFResource;
            this.owlElement2Element(document, oWLIndividual2, element2);
        }
        for (RDFResource rDFResource : set) {
            if (!(rDFResource instanceof OWLIndividual)) continue;
            oWLIndividual2 = (OWLIndividual)rDFResource;
            this.owlAttribute2Attribute(document, oWLIndividual2, element2);
        }
    }

    private void owlAttribute2Attribute(Document document, OWLIndividual oWLIndividual, Element element) throws XMLMapperException, SWRLOWLUtilException {
        String string = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamePropertyName, true);
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLAttributeHasValuePropertyName, true);
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamespacePrefixPropertyName, false, "");
        String string4 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(this.owlModel, oWLIndividual, XMLHasNamespaceURIPropertyName, false, "");
        this.xmlProcessor.setAttribute(element, string, string2, string3, string4);
    }

    private void element2OWLElement(Document document, OWLIndividual oWLIndividual, Element element, OWLIndividual oWLIndividual2) throws XMLMapperException, SWRLOWLUtilException {
        OWLIndividual oWLIndividual3 = SWRLOWLUtil.createIndividualOfClass(this.owlModel, XMLElementOWLClassName);
        String string = element.getName();
        String string2 = element.getNamespace().getPrefix();
        String string3 = element.getNamespace().getURI();
        ContentFilter contentFilter = new ContentFilter(4);
        String string4 = "";
        if (oWLIndividual2 == null) {
            SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual, this.rootElementProperty, oWLIndividual3);
        } else {
            SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual2, this.subElementsProperty, oWLIndividual3);
        }
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual, this.elementsProperty, oWLIndividual3);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual3, this.nameProperty, string);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual3, this.namespacePrefixProperty, string2);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual3, this.namespaceURIProperty, string3);
        for (Object object : element.getContent((Filter)contentFilter)) {
            Text text = (Text)object;
            string4 = string4 + text.getValue();
        }
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual3, this.contentProperty, string4);
        for (Attribute attribute : this.xmlProcessor.getAttributes(element)) {
            this.attribute2OWLAttribute(document, attribute, oWLIndividual3);
        }
        for (Element element2 : this.xmlProcessor.getSubElements(element)) {
            this.element2OWLElement(document, oWLIndividual, element2, oWLIndividual3);
        }
    }

    private void attribute2OWLAttribute(Document document, Attribute attribute, OWLIndividual oWLIndividual) throws XMLMapperException, SWRLOWLUtilException {
        OWLIndividual oWLIndividual2 = SWRLOWLUtil.createIndividualOfClass(this.owlModel, XMLAttributeOWLClassName);
        String string = attribute.getName();
        String string2 = attribute.getValue();
        String string3 = attribute.getNamespace().getPrefix();
        String string4 = attribute.getNamespace().getURI();
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual2, this.nameProperty, string);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual2, this.valueProperty, string2);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual2, this.namespacePrefixProperty, string3);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual2, this.namespaceURIProperty, string4);
        SWRLOWLUtil.addPropertyValue(this.owlModel, oWLIndividual, this.attributesProperty, oWLIndividual2);
    }

    private void addSWRLXMLImport() throws XMLMapperException {
        ImportHelper importHelper = new ImportHelper(this.owlModel);
        try {
            this.owlModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#"), "swrlxml");
            if (this.owlModel.getTripleStoreModel().getTripleStore("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl") == null) {
                importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl"));
            }
            importHelper.importOntologies(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XMLMapperException("error importing SWRLXML ontology: " + uRISyntaxException.getMessage());
        }
        catch (OntologyLoadException ontologyLoadException) {
            throw new XMLMapperException("error loading SWRLXML ontology: " + ontologyLoadException.getMessage());
        }
    }
}

