/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValueFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLBridgeMapperException;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInBridgeException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.Filter;

public class XMLBridgeMapper {
    public static final String SWRLXMLAlias = "swrlxml:";
    public static final String SWRLXMLNamespace = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#";
    public static final String XMLDocumentOWLClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLDocument";
    public static final String XMLDocumentHasRootElementPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasRootElement";
    public static final String XMLDocumentHasElementsPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasElements";
    public static final String XMLElementOWLClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement";
    public static final String XMLHasNamePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasName";
    public static final String XMLHasNamespacePrefixPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasNamespacePrefix";
    public static final String XMLHasNamespaceURIPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasNamespaceURI";
    public static final String XMLElementHasMappedIndividualsPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasMappedIndividuals";
    public static final String XMLElementHasSubElementsPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasSubElements";
    public static final String XMLElementHasAttributesPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasAttributes";
    public static final String XMLElementHasContentPropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasContent";
    public static final String XMLAttributeOWLClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLAttribute";
    public static final String XMLAttributeHasValuePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#hasValue";
    private OWLPropertyReference rootElementProperty;
    private OWLPropertyReference elementsProperty;
    private OWLPropertyReference subElementsProperty;
    private OWLPropertyReference nameProperty;
    private OWLPropertyReference namespacePrefixProperty;
    private OWLPropertyReference namespaceURIProperty;
    private OWLPropertyReference contentProperty;
    private OWLPropertyReference valueProperty;
    private OWLPropertyReference attributesProperty;
    private OWLDataFactory owlDataFactory = new P3OWLDataFactory();
    private OWLDataValueFactory owlDataValueFactory = OWLDataValueFactory.create();
    private XMLProcessor xmlProcessor = new XMLProcessor();

    public XMLBridgeMapper() {
        this.rootElementProperty = this.owlDataFactory.getOWLObjectProperty(XMLDocumentHasRootElementPropertyName);
        this.elementsProperty = this.owlDataFactory.getOWLObjectProperty(XMLDocumentHasElementsPropertyName);
        this.nameProperty = this.owlDataFactory.getOWLDataProperty(XMLHasNamePropertyName);
        this.namespacePrefixProperty = this.owlDataFactory.getOWLDataProperty(XMLHasNamespacePrefixPropertyName);
        this.namespaceURIProperty = this.owlDataFactory.getOWLDataProperty(XMLHasNamespaceURIPropertyName);
        this.contentProperty = this.owlDataFactory.getOWLDataProperty(XMLElementHasContentPropertyName);
        this.subElementsProperty = this.owlDataFactory.getOWLObjectProperty(XMLElementHasSubElementsPropertyName);
        this.valueProperty = this.owlDataFactory.getOWLDataProperty(XMLAttributeHasValuePropertyName);
        this.attributesProperty = this.owlDataFactory.getOWLObjectProperty(XMLElementHasAttributesPropertyName);
    }

    public Document owlDocument2Document(SWRLBuiltInBridge sWRLBuiltInBridge) throws XMLBridgeMapperException {
        OWLIndividual oWLIndividual = null;
        Document document = new Document();
        try {
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), XMLDocumentOWLClassName);
            OWLIndividual oWLIndividual2 = SWRLOWLUtil.getOWLIndividual(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLNamedClass, true, 1);
            RDFResource rDFResource = SWRLOWLUtil.getObjectPropertyValue(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual2, XMLDocumentHasRootElementPropertyName, false);
            if (rDFResource == null) {
                throw new XMLBridgeMapperException("no document root element specified");
            }
            if (!(rDFResource instanceof OWLIndividual)) {
                throw new XMLBridgeMapperException("invalid document root element '" + rDFResource + "'");
            }
            oWLIndividual = (OWLIndividual)rDFResource;
            this.owlElement2Element(document, sWRLBuiltInBridge, oWLIndividual, null);
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new XMLBridgeMapperException("error mapping OWL XML ontology to Document: " + sWRLOWLUtilException.getMessage());
        }
        return document;
    }

    public OWLNamedIndividualReference document2OWLDocument(Document document, SWRLBuiltInBridge sWRLBuiltInBridge) throws XMLBridgeMapperException {
        OWLNamedIndividualReference oWLNamedIndividualReference;
        Element element = document.getRootElement();
        if (this.xmlProcessor.isSchema(element)) {
            throw new XMLBridgeMapperException("not expecting 'schema' root element");
        }
        try {
            oWLNamedIndividualReference = sWRLBuiltInBridge.injectOWLIndividualDeclaration(this.owlDataFactory.getOWLClass(XMLDocumentOWLClassName));
            this.element2OWLElement(document, sWRLBuiltInBridge, oWLNamedIndividualReference, null, element);
        }
        catch (SWRLBuiltInBridgeException sWRLBuiltInBridgeException) {
            throw new XMLBridgeMapperException("bridge error mapping Document to OWL XML ontology: " + sWRLBuiltInBridgeException.getMessage());
        }
        catch (OWLFactoryException oWLFactoryException) {
            throw new XMLBridgeMapperException("OWL factory error mapping Document to OWL XML ontology: " + oWLFactoryException.getMessage());
        }
        return oWLNamedIndividualReference;
    }

    private void owlElement2Element(Document document, SWRLBuiltInBridge sWRLBuiltInBridge, OWLIndividual oWLIndividual, Element element) throws XMLBridgeMapperException, SWRLOWLUtilException {
        OWLIndividual oWLIndividual2;
        String string = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamePropertyName, true);
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamespacePrefixPropertyName, false, "");
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamespaceURIPropertyName, false, "");
        Set<RDFResource> set = SWRLOWLUtil.getObjectPropertyValues(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLElementHasAttributesPropertyName, false);
        Set<RDFResource> set2 = SWRLOWLUtil.getObjectPropertyValues(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLElementHasSubElementsPropertyName, false);
        String string4 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLElementHasContentPropertyName, false, "");
        Element element2 = this.xmlProcessor.createElement(document, element, string);
        element2.setNamespace(Namespace.getNamespace((String)string2, (String)string3));
        if (string4 != null) {
            element2.addContent(string4);
        }
        for (RDFResource rDFResource : set2) {
            if (!(rDFResource instanceof OWLIndividual)) continue;
            oWLIndividual2 = (OWLIndividual)rDFResource;
            this.owlElement2Element(document, sWRLBuiltInBridge, oWLIndividual2, element2);
        }
        for (RDFResource rDFResource : set) {
            if (!(rDFResource instanceof OWLIndividual)) continue;
            oWLIndividual2 = (OWLIndividual)rDFResource;
            this.owlAttribute2Attribute(document, sWRLBuiltInBridge, oWLIndividual2, element2);
        }
    }

    private void owlAttribute2Attribute(Document document, SWRLBuiltInBridge sWRLBuiltInBridge, OWLIndividual oWLIndividual, Element element) throws XMLBridgeMapperException, SWRLOWLUtilException {
        String string = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamePropertyName, true);
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLAttributeHasValuePropertyName, true);
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamespacePrefixPropertyName, false, "");
        String string4 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(sWRLBuiltInBridge.getActiveOntology().getOWLModel(), oWLIndividual, XMLHasNamespaceURIPropertyName, false, "");
        this.xmlProcessor.setAttribute(element, string, string2, string3, string4);
    }

    private void element2OWLElement(Document document, SWRLBuiltInBridge sWRLBuiltInBridge, OWLNamedIndividualReference oWLNamedIndividualReference, OWLNamedIndividualReference oWLNamedIndividualReference2, Element element) throws XMLBridgeMapperException, SWRLBuiltInBridgeException, OWLFactoryException {
        OWLNamedIndividualReference oWLNamedIndividualReference3 = sWRLBuiltInBridge.injectOWLIndividualDeclaration(this.owlDataFactory.getOWLClass(XMLElementOWLClassName));
        String string = element.getName();
        String string2 = element.getNamespace().getPrefix();
        String string3 = element.getNamespace().getURI();
        ContentFilter contentFilter = new ContentFilter(4);
        String string4 = "";
        if (oWLNamedIndividualReference2 == null) {
            sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference, this.rootElementProperty, oWLNamedIndividualReference3));
        } else {
            sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference2, this.subElementsProperty, oWLNamedIndividualReference3));
        }
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference, this.elementsProperty, oWLNamedIndividualReference3));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference3, this.nameProperty, this.owlDataValueFactory.getOWLDataValue(string)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference3, this.namespacePrefixProperty, this.owlDataValueFactory.getOWLDataValue(string2)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference3, this.namespaceURIProperty, this.owlDataValueFactory.getOWLDataValue(string3)));
        for (Object object : element.getContent((Filter)contentFilter)) {
            Text text = (Text)object;
            string4 = string4 + text.getValue();
        }
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference3, this.contentProperty, this.owlDataValueFactory.getOWLDataValue(string4)));
        for (Attribute attribute : this.xmlProcessor.getAttributes(element)) {
            this.attribute2OWLAttribute(document, sWRLBuiltInBridge, oWLNamedIndividualReference3, attribute);
        }
        for (Element element2 : this.xmlProcessor.getSubElements(element)) {
            this.element2OWLElement(document, sWRLBuiltInBridge, oWLNamedIndividualReference, oWLNamedIndividualReference3, element2);
        }
    }

    private void attribute2OWLAttribute(Document document, SWRLBuiltInBridge sWRLBuiltInBridge, OWLNamedIndividualReference oWLNamedIndividualReference, Attribute attribute) throws XMLBridgeMapperException, SWRLBuiltInBridgeException, OWLFactoryException {
        OWLNamedIndividualReference oWLNamedIndividualReference2 = sWRLBuiltInBridge.injectOWLIndividualDeclaration(this.owlDataFactory.getOWLClass(XMLAttributeOWLClassName));
        String string = attribute.getName();
        String string2 = attribute.getValue();
        String string3 = attribute.getNamespace().getPrefix();
        String string4 = attribute.getNamespace().getURI();
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference2, this.nameProperty, this.owlDataValueFactory.getOWLDataValue(string)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference2, this.valueProperty, this.owlDataValueFactory.getOWLDataValue(string2)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference2, this.namespacePrefixProperty, this.owlDataValueFactory.getOWLDataValue(string3)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference2, this.namespaceURIProperty, this.owlDataValueFactory.getOWLDataValue(string4)));
        sWRLBuiltInBridge.injectOWLAxiom(this.owlDataFactory.getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference, this.attributesProperty, oWLNamedIndividualReference2));
    }
}

