/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLBridgeMapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLBridgeMapperException;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessorException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInLibraryException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLXMLLibraryName = "SWRLXMLBuiltIns";
    private OWLClassReference xmlElementOWLClass = null;
    private XMLProcessor xmlProcessor;
    private XMLBridgeMapper xmlMapper;
    private Map<String, OWLNamedIndividualReference> documentMappings;
    private Map<String, Document> documents;
    private Map<String, Set<OWLNamedIndividualReference>> elementMappings;
    private Map<String, Element> elements;

    public SWRLBuiltInLibraryImpl() throws SWRLBuiltInLibraryException {
        super(SWRLXMLLibraryName);
        this.reset();
    }

    @Override
    public void reset() throws SWRLBuiltInLibraryException {
        this.xmlProcessor = new XMLProcessor();
        this.xmlMapper = new XMLBridgeMapper();
        this.documentMappings = new HashMap<String, OWLNamedIndividualReference>();
        this.documents = new HashMap<String, Document>();
        this.elementMappings = new HashMap<String, Set<OWLNamedIndividualReference>>();
        this.elements = new HashMap<String, Element>();
    }

    public boolean makeXMLDocument(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        this.checkForUnboundNonFirstArguments(list);
        if (this.isUnboundArgument(0, list)) {
            String string = this.getArgumentAsAString(1, list);
            OWLNamedIndividualReference oWLNamedIndividualReference = null;
            if (!this.documentMappings.containsKey(string)) {
                try {
                    Document document = this.xmlProcessor.processXMLStream(string);
                    oWLNamedIndividualReference = this.xmlMapper.document2OWLDocument(document, this.getBuiltInBridge());
                    this.documentMappings.put(string, oWLNamedIndividualReference);
                    this.documents.put(oWLNamedIndividualReference.getURI(), document);
                }
                catch (XMLProcessorException xMLProcessorException) {
                    throw new BuiltInException("error processing XML stream " + string + ": " + xMLProcessorException.getMessage());
                }
                catch (XMLBridgeMapperException xMLBridgeMapperException) {
                    throw new BuiltInException("error mapping XML stream " + string + ": " + xMLBridgeMapperException.getMessage());
                }
            } else {
                oWLNamedIndividualReference = this.documentMappings.get(string);
            }
            list.get(0).setBuiltInResult(this.createIndividualArgument(oWLNamedIndividualReference.getURI()));
            bl = true;
        }
        return bl;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean element(List<BuiltInArgument> var1_1) throws BuiltInException {
        var2_2 = false;
        this.checkNumberOfArgumentsEqualTo(3, var1_1.size());
        this.checkForUnboundNonFirstArguments(var1_1);
        if (this.isUnboundArgument(0, var1_1)) {
            var3_3 = this.getArgumentAsADocument(1, var1_1);
            var4_4 = this.getArgumentAsAString(2, var1_1);
            if (!this.elementMappings.containsKey(var4_4)) {
                try {
                    var6_5 = XPath.newInstance((String)var4_4);
                    var7_7 = var6_5.selectNodes((Object)var3_3).iterator();
                    var5_8 = new HashSet<OWLNamedIndividualReference>();
                    while (var7_7.hasNext()) {
                        var8_9 = var7_7.next();
                        var9_10 = this.getBuiltInBridge().injectOWLIndividualDeclaration(this.getXMLElementOWLClass());
                        if (!(var8_9 instanceof Element)) {
                            throw new BuiltInException("path " + var4_4 + " must only refer to XML elements, found " + var8_9.getClass());
                        }
                        var10_11 = (Element)var8_9;
                        this.elements.put(var9_10.getURI(), var10_11);
                        var5_8.add(var9_10);
                    }
                    if (var5_8.isEmpty()) ** GOTO lbl30
                    this.elementMappings.put(var4_4, var5_8);
                }
                catch (JDOMException var6_6) {
                    throw new BuiltInException("JDOM error processing XML path " + var4_4 + ": " + var6_6.getMessage());
                }
            } else {
                var5_8 = this.elementMappings.get(var4_4);
            }
lbl30:
            // 3 sources

            if (var5_8.isEmpty()) {
                var2_2 = false;
            } else if (var5_8.size() == 1) {
                var6_5 = (OWLNamedIndividualReference)var5_8.toArray()[0];
                var1_1.get(0).setBuiltInResult(this.createIndividualArgument(var6_5.getURI()));
                var2_2 = true;
            } else {
                var6_5 = this.createMultiArgument();
                for (Object var8_9 : var5_8) {
                    var6_5.addArgument(this.createIndividualArgument(var8_9.getURI()));
                }
                var2_2 = var6_5.hasNoArguments() == false;
                var1_1.get(0).setBuiltInResult((BuiltInArgument)var6_5);
            }
        }
        return var2_2;
    }

    public boolean subElement(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        this.checkForUnboundNonFirstArguments(list);
        if (this.isUnboundArgument(0, list)) {
            HashSet<OWLNamedIndividualReference> hashSet;
            Object object;
            Element element = this.getArgumentAsAnElement(1, list);
            String string = this.getArgumentAsAString(2, list);
            try {
                object = XPath.newInstance((String)string);
                Iterator iterator = object.selectNodes((Object)element).iterator();
                hashSet = new HashSet<OWLNamedIndividualReference>();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    OWLNamedIndividualReference oWLNamedIndividualReference = this.getBuiltInBridge().injectOWLIndividualDeclaration(this.getXMLElementOWLClass());
                    if (!(object2 instanceof Element)) {
                        throw new BuiltInException("path " + string + " must only refer to XML elements, found " + object2.getClass());
                    }
                    Element element2 = (Element)object2;
                    this.elements.put(oWLNamedIndividualReference.getURI(), element2);
                    hashSet.add(oWLNamedIndividualReference);
                }
            }
            catch (JDOMException jDOMException) {
                throw new BuiltInException("JDOM error processing XML path " + string + ": " + jDOMException.getMessage());
            }
            if (hashSet.isEmpty()) {
                bl = false;
            } else if (hashSet.size() == 1) {
                object = (OWLNamedIndividualReference)hashSet.toArray()[0];
                list.get(0).setBuiltInResult(this.createIndividualArgument(object.getURI()));
                bl = true;
            } else {
                object = this.createMultiArgument();
                for (OWLNamedIndividualReference oWLNamedIndividualReference : hashSet) {
                    object.addArgument(this.createIndividualArgument(oWLNamedIndividualReference.getURI()));
                }
                list.get(0).setBuiltInResult((BuiltInArgument)object);
                bl = !object.hasNoArguments();
            }
        }
        return bl;
    }

    public boolean attributeValue(List<BuiltInArgument> list) throws BuiltInException {
        String string;
        Element element;
        String string2;
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        this.checkForUnboundNonFirstArguments(list);
        if (this.isUnboundArgument(0, list) && (string2 = (element = this.getArgumentAsAnElement(1, list)).getAttributeValue(string = this.getArgumentAsAString(2, list))) != null) {
            list.get(0).setBuiltInResult(this.createDataValueArgument(string2));
            bl = true;
        }
        return bl;
    }

    private Document getArgumentAsADocument(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string;
        Document document = null;
        if (this.isArgumentAnIndividual(n, list)) {
            string = this.getArgumentAsAnIndividualURI(n, list);
            if (!this.getBuiltInBridge().isOWLIndividualOfClass(string, "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLDocument")) {
                throw new InvalidBuiltInArgumentException(n, "individual " + string + " is not a " + "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLDocument");
            }
            if (!this.documents.containsKey(string)) {
                throw new InvalidBuiltInArgumentException(n, "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLDocument individual " + string + " does not refer to a valid document");
            }
        } else {
            throw new InvalidBuiltInArgumentException(n, "expecting a http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLDocument individual, got " + list.get(n));
        }
        document = this.documents.get(string);
        return document;
    }

    private Element getArgumentAsAnElement(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string;
        Element element = null;
        if (this.isArgumentAnIndividual(n, list)) {
            string = this.getArgumentAsAnIndividualURI(n, list);
            if (!this.getBuiltInBridge().isOWLIndividualOfClass(string, "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement")) {
                throw new InvalidBuiltInArgumentException(n, "individual " + string + " is not a " + "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement");
            }
            if (!this.elements.containsKey(string)) {
                throw new InvalidBuiltInArgumentException(n, "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement individual " + string + " does not refer to a valid element");
            }
        } else {
            throw new InvalidBuiltInArgumentException(n, "expecting a http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement individual, got " + list.get(n) + "");
        }
        element = this.elements.get(string);
        return element;
    }

    private OWLClassReference getXMLElementOWLClass() throws BuiltInException {
        if (this.xmlElementOWLClass == null) {
            this.xmlElementOWLClass = this.getBuiltInBridge().getOWLDataFactory().getOWLClass("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#XMLElement");
        }
        return this.xmlElementOWLClass;
    }
}

