/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLMapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessor;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.jdom.Document;

public class MapXML2OWL {
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        XMLProcessor xMLProcessor = new XMLProcessor();
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        } else {
            MapXML2OWL.Usage();
        }
        try {
            Document document = xMLProcessor.processXMLStream(string);
            JenaOWLModel jenaOWLModel = SWRLOWLUtil.createJenaOWLModel();
            jenaOWLModel.setGenerateEventsEnabled(false);
            MapXML2OWL.addSWRLXMLImport(jenaOWLModel);
            XMLMapper xMLMapper = new XMLMapper(jenaOWLModel);
            xMLMapper.document2OWLDocument(document);
            SWRLOWLUtil.writeJenaOWLModel2File(jenaOWLModel, string2);
        }
        catch (Exception exception) {
            System.err.println("error mapping XML document with URI '" + string + "': " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static void Usage() {
        System.err.println("Usage: MapXML2OWL <xmlURI> <owlFilename>");
        System.exit(1);
    }

    private static void addSWRLXMLImport(OWLModel oWLModel) {
        ImportHelper importHelper = new ImportHelper(oWLModel);
        try {
            oWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#"), "swrlxml");
            if (oWLModel.getTripleStoreModel().getTripleStore("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl") == null) {
                importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl"));
            }
            importHelper.importOntologies(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("error importing SWRLXML ontology: " + uRISyntaxException.getMessage());
            System.exit(-1);
        }
        catch (OntologyLoadException ontologyLoadException) {
            System.err.println("error loading SWRLXML ontology: " + ontologyLoadException.getMessage());
            System.exit(-1);
        }
    }
}

