/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlx;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLXLibraryName = "SWRLExtensionsBuiltIns";
    private HashMap<String, OWLClassReference> classInvocationMap;
    private HashMap<String, OWLNamedIndividualReference> individualInvocationMap;

    public SWRLBuiltInLibraryImpl() {
        super(SWRLXLibraryName);
    }

    @Override
    public void reset() {
        this.classInvocationMap = new HashMap();
        this.individualInvocationMap = new HashMap();
    }

    public boolean makeOWLClass(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        if (this.isUnboundArgument(0, list)) {
            OWLClassReference oWLClassReference = null;
            String string = this.createInvocationPattern(this.getBuiltInBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), this.getIsInConsequent(), list.subList(1, list.size()));
            if (this.classInvocationMap.containsKey(string)) {
                oWLClassReference = this.classInvocationMap.get(string);
            } else {
                oWLClassReference = this.getBuiltInBridge().injectOWLClassDeclaration();
                this.classInvocationMap.put(string, oWLClassReference);
            }
            list.get(0).setBuiltInResult(this.createClassArgument(oWLClassReference.getURI()));
        }
        return true;
    }

    public boolean makeOWLIndividual(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        if (this.isUnboundArgument(0, list)) {
            OWLNamedIndividualReference oWLNamedIndividualReference = null;
            String string = this.createInvocationPattern(this.getBuiltInBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), this.getIsInConsequent(), list.subList(1, list.size()));
            if (this.individualInvocationMap.containsKey(string)) {
                oWLNamedIndividualReference = this.individualInvocationMap.get(string);
            } else {
                oWLNamedIndividualReference = this.getBuiltInBridge().injectOWLIndividualDeclaration();
                this.individualInvocationMap.put(string, oWLNamedIndividualReference);
            }
            list.get(0).setBuiltInResult(this.createIndividualArgument(oWLNamedIndividualReference.getURI()));
        }
        return true;
    }

    public boolean makeOWLThing(List<BuiltInArgument> list) throws BuiltInException {
        return this.makeOWLIndividual(list);
    }

    public boolean createOWLThing(List<BuiltInArgument> list) throws BuiltInException {
        return this.makeOWLIndividual(list);
    }

    public boolean invokeSWRLBuiltIn(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        String string = this.getArgumentAsAnIndividualURI(0, list);
        boolean bl = false;
        try {
            bl = this.getBuiltInBridge().invokeSWRLBuiltIn(this.getInvokingRuleName(), string, this.getInvokingBuiltInIndex(), this.getIsInConsequent(), list.subList(1, list.size()));
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            throw new BuiltInException("error invoking built-in '" + string + "' from built-in: " + sWRLRuleEngineBridgeException.getMessage());
        }
        return bl;
    }
}

