/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlm;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import java.util.List;
import org.nfunk.jep.JEP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLMLibraryName = "SWRLTabMathematicalBuiltIns";
    private JEP jep = null;

    public SWRLBuiltInLibraryImpl() {
        super(SWRLMLibraryName);
    }

    @Override
    public void reset() {
        this.jep = null;
    }

    public boolean sqrt(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        double d = this.getArgumentAsADouble(1, list);
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createDataValueArgument(Math.sqrt(d)));
            bl = true;
        } else {
            double d2 = this.getArgumentAsADouble(0, list);
            bl = d2 == Math.sqrt(d);
        }
        return bl;
    }

    public boolean log(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        double d = this.getArgumentAsADouble(1, list);
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createDataValueArgument(Math.log(d)));
            bl = true;
        } else {
            double d2 = this.getArgumentAsADouble(0, list);
            bl = d2 == Math.log(d);
        }
        return bl;
    }

    public boolean eval(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        String string = this.getArgumentAsAString(1, list);
        if (list.size() > 2) {
            List<BuiltInArgument> list2 = list.subList(2, list.size());
            this.checkForUnboundArguments(list2, "unexpected unbound expression argument");
            this.checkForNonVariableArguments(list2, "unexpected non variable argument");
            for (BuiltInArgument builtInArgument : list2) {
                String string2 = builtInArgument.getVariableName();
                double d = this.getArgumentAsADouble(builtInArgument);
                this.getJEP().addVariable(string2, d);
            }
        }
        this.getJEP().parseExpression(string);
        if (this.getJEP().hasError()) {
            throw new BuiltInException("exception parsing expression '" + string + "': " + this.getJEP().getErrorInfo());
        }
        double d = this.getJEP().getValue();
        if (this.getJEP().hasError()) {
            throw new BuiltInException("exception parsing expression '" + string + "': " + this.getJEP().getErrorInfo());
        }
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createDataValueArgument(d));
            bl = true;
        } else {
            bl = d == this.getArgumentAsADouble(0, list);
        }
        return bl;
    }

    private JEP getJEP() {
        if (this.jep == null) {
            this.jep = new JEP();
            this.jep.addStandardFunctions();
            this.jep.addStandardConstants();
            this.jep.setImplicitMul(true);
        }
        return this.jep;
    }
}

