/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlb;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInNotImplementedException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDTimeUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.axis.types.Duration;
import org.apache.axis.types.Time;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLBLibraryName = "SWRLCoreBuiltIns";
    private static String SWRLBPrefix = "swrlb:";
    private DateFormat dateFormat;
    private static String SWRLB_ADD = SWRLBPrefix + "add";
    private static String SWRLB_SUBTRACT = SWRLBPrefix + "subtract";
    private static String SWRLB_MULTIPLY = SWRLBPrefix + "multiply";
    private static String SWRLB_DIVIDE = SWRLBPrefix + "divide";
    private static String SWRLB_INTEGER_DIVIDE = SWRLBPrefix + "integerDivide";
    private static String SWRLB_MOD = SWRLBPrefix + "mod";
    private static String SWRLB_POW = SWRLBPrefix + "pow";
    private static String SWRLB_UNARY_PLUS = SWRLBPrefix + "unaryPlus";
    private static String SWRLB_UNARY_MINUS = SWRLBPrefix + "unaryMinus";
    private static String SWRLB_ABS = SWRLBPrefix + "abs";
    private static String SWRLB_CEILING = SWRLBPrefix + "ceiling";
    private static String SWRLB_FLOOR = SWRLBPrefix + "floor";
    private static String SWRLB_ROUND = SWRLBPrefix + "round";
    private static String SWRLB_ROUND_HALF_TO_EVEN = SWRLBPrefix + "roundHalfToEven";
    private static String SWRLB_SIN = SWRLBPrefix + "sin";
    private static String SWRLB_COS = SWRLBPrefix + "cos";
    private static String SWRLB_TAN = SWRLBPrefix + "tan";

    public SWRLBuiltInLibraryImpl() {
        super(SWRLBLibraryName);
    }

    @Override
    public void reset() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean greaterThan(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        if (this.isArgumentAString(0, list)) {
            String string = this.getArgumentAsAString(0, list);
            if (!this.isArgumentAString(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting string argument for comparison, got " + this.getArgumentAsAString(1, list));
            String string2 = this.getArgumentAsAString(1, list);
            if (string.compareTo(string2) <= 0) return false;
            return true;
        }
        if (!this.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got " + this.getArgumentAsAString(0, list));
        if (!this.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.getArgumentAsAString(1, list));
        if (this.compareTwoNumericArguments(list) <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean lessThan(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        if (this.isArgumentAString(0, list)) {
            String string = this.getArgumentAsAString(0, list);
            if (!this.isArgumentAString(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting string argument for comparison, got " + this.getArgumentAsAString(1, list));
            String string2 = this.getArgumentAsAString(1, list);
            if (string.compareTo(string2) >= 0) return false;
            return true;
        }
        if (!this.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got " + this.getArgumentAsAString(0, list));
        if (!this.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.getArgumentAsAString(1, list));
        if (this.compareTwoNumericArguments(list) >= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equal(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        if (this.hasUnboundArguments(list)) {
            throw new InvalidBuiltInArgumentException(0, "comparison built-ins do not support argument binding");
        }
        if (this.isArgumentABoolean(0, list)) {
            boolean bl2 = this.getArgumentAsABoolean(0, list);
            if (!this.isArgumentABoolean(1, list)) return false;
            boolean bl3 = this.getArgumentAsABoolean(1, list);
            if (bl2 != bl3) return false;
            return true;
        }
        if (this.isArgumentAString(0, list)) {
            String string = this.getArgumentAsAString(0, list);
            if (!this.isArgumentAString(1, list)) return false;
            String string2 = this.getArgumentAsAString(1, list);
            if (string.compareTo(string2) != 0) return false;
            return true;
        }
        if (!this.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string, numeric or boolean argument for comparison, got " + this.getArgumentAsAString(0, list));
        if (!this.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.getArgumentAsAString(1, list));
        if (this.compareTwoNumericArguments(list) != 0) return false;
        return true;
    }

    public boolean notEqual(List<BuiltInArgument> list) throws BuiltInException {
        return !this.equal(list);
    }

    public boolean lessThanOrEqual(List<BuiltInArgument> list) throws BuiltInException {
        return this.equal(list) || this.lessThan(list);
    }

    public boolean greaterThanOrEqual(List<BuiltInArgument> list) throws BuiltInException {
        return this.equal(list) || this.greaterThan(list);
    }

    public boolean add(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        return this.mathOperation(SWRLB_ADD, list);
    }

    public boolean subtract(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_SUBTRACT, list);
    }

    public boolean multiply(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        return this.mathOperation(SWRLB_MULTIPLY, list);
    }

    public boolean divide(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_DIVIDE, list);
    }

    public boolean integerDivide(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_INTEGER_DIVIDE, list);
    }

    public boolean mod(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_MOD, list);
    }

    public boolean pow(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_POW, list);
    }

    public boolean unaryPlus(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_UNARY_PLUS, list);
    }

    public boolean unaryMinus(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_UNARY_MINUS, list);
    }

    public boolean abs(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ABS, list);
    }

    public boolean ceiling(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_CEILING, list);
    }

    public boolean floor(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_FLOOR, list);
    }

    public boolean round(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ROUND, list);
    }

    public boolean roundHalfToEven(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ROUND_HALF_TO_EVEN, list);
    }

    public boolean sin(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_SIN, list);
    }

    public boolean cos(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_COS, list);
    }

    public boolean tan(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_TAN, list);
    }

    public boolean booleanNot(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        this.checkForUnboundNonFirstArguments(list);
        if (this.isUnboundArgument(0, list)) {
            if (!this.areAllArgumentsBooleans(list.subList(1, list.size()))) {
                throw new InvalidBuiltInArgumentException(1, "expecting a Boolean");
            }
            boolean bl2 = !this.getArgumentAsABoolean(1, list);
            list.get(0).setBuiltInResult(this.createDataValueArgument(bl2));
            bl = true;
        } else {
            if (!this.areAllArgumentsBooleans(list)) {
                throw new InvalidBuiltInArgumentException("expecting all Boolean arguments");
            }
            bl = !this.equal(list);
        }
        return bl;
    }

    public boolean stringEqualIgnoreCase(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        this.checkForUnboundArguments(list);
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        return string.equalsIgnoreCase(string2);
    }

    public boolean stringConcat(List<BuiltInArgument> list) throws BuiltInException {
        String string = "";
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        for (int i = 1; i < list.size(); ++i) {
            string = string.concat(((Object)this.getArgumentAsADataValue(i, list)).toString());
        }
        return this.processResultArgument(list, 0, string);
    }

    public boolean substring(List<BuiltInArgument> list) throws BuiltInException {
        String string;
        this.checkNumberOfArgumentsAtLeast(3, list.size());
        this.checkNumberOfArgumentsAtMost(4, list.size());
        String string2 = this.getArgumentAsAString(1, list);
        int n = this.getArgumentAsAnInteger(2, list);
        if (list.size() == 4) {
            int n2 = this.getArgumentAsAnInteger(3, list);
            string = string2.substring(n, n2);
        } else {
            string = string2.substring(n);
        }
        return this.processResultArgument(list, 0, string);
    }

    public boolean stringLength(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(1, list);
        int n = string.length();
        return this.processResultArgument(list, 0, n);
    }

    public boolean upperCase(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = string.toUpperCase();
        return this.processResultArgument(list, 0, string2);
    }

    public boolean lowerCase(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = string.toLowerCase();
        return this.processResultArgument(list, 0, string2);
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        return string.lastIndexOf(string2) != -1;
    }

    public boolean containsIgnoreCase(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        return string.toLowerCase().lastIndexOf(string2.toLowerCase()) != -1;
    }

    public boolean startsWith(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        return string.startsWith(string2);
    }

    public boolean endsWith(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        return string.endsWith(string2);
    }

    public boolean translate(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(4, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = this.getArgumentAsAString(2, list);
        String string3 = this.getArgumentAsAString(3, list);
        String string4 = StringUtils.replaceChars((String)string, (String)string2, (String)string3);
        return this.processResultArgument(list, 0, string4);
    }

    public boolean substringAfter(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = this.getArgumentAsAString(2, list);
        String string3 = StringUtils.substringAfter((String)string, (String)string2);
        return this.processResultArgument(list, 0, string3);
    }

    public boolean substringBefore(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = this.getArgumentAsAString(2, list);
        String string3 = StringUtils.substringBefore((String)string, (String)string2);
        return this.processResultArgument(list, 0, string3);
    }

    public boolean matches(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(0, list);
        String string2 = this.getArgumentAsAString(1, list);
        try {
            bl = Pattern.matches(string2, string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new InvalidBuiltInArgumentException(1, "invalid regular expression '" + string2 + "': " + patternSyntaxException.getMessage());
        }
        return bl;
    }

    public boolean replace(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(4, list.size());
        String string = this.getArgumentAsAString(1, list);
        String string2 = this.getArgumentAsAString(2, list);
        String string3 = this.getArgumentAsAString(3, list);
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        String string4 = matcher.replaceAll(string3);
        return this.processResultArgument(list, 0, string4);
    }

    public boolean normalizeSpace(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAString(1, list);
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll(" ").trim();
        return this.processResultArgument(list, 0, string2);
    }

    public boolean tokenize(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!this.isUnboundArgument(0, list)) {
            throw new InvalidBuiltInArgumentException(0, "unexpected bound argument found");
        }
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        this.checkForUnboundNonFirstArguments(list);
        String string = this.getArgumentAsAString(1, list);
        String string2 = this.getArgumentAsAString(2, list);
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), string2);
        MultiArgument multiArgument = this.createMultiArgument();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            multiArgument.addArgument(this.createDataValueArgument(string3));
        }
        list.get(0).setBuiltInResult(multiArgument);
        bl = !multiArgument.hasNoArguments();
        return bl;
    }

    public boolean yearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        int n = this.getArgumentAsAnInteger(1, list);
        int n2 = this.getArgumentAsAnInteger(2, list);
        Duration duration = new Duration();
        duration.setYears(n);
        duration.setMonths(n2);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean dayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, list.size());
        int n = this.getArgumentAsAnInteger(1, list);
        int n2 = this.getArgumentAsAnInteger(2, list);
        int n3 = this.getArgumentAsAnInteger(3, list);
        int n4 = this.getArgumentAsAnInteger(4, list);
        Duration duration = new Duration();
        duration.setDays(n);
        duration.setHours(n2);
        duration.setMinutes(n3);
        duration.setSeconds(n4);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean dateTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(8, list.size());
        int n = this.getArgumentAsAnInteger(1, list);
        int n2 = this.getArgumentAsAnInteger(2, list);
        int n3 = this.getArgumentAsAnInteger(3, list);
        int n4 = this.getArgumentAsAnInteger(4, list);
        int n5 = this.getArgumentAsAnInteger(5, list);
        int n6 = this.getArgumentAsAnInteger(6, list);
        String string = this.getArgumentAsAString(7, list);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone(string));
        String string2 = "" + gregorianCalendar.get(1) + "-" + gregorianCalendar.get(2) + "-" + gregorianCalendar.get(5) + "T" + gregorianCalendar.get(10) + ":" + gregorianCalendar.get(12) + ":" + gregorianCalendar.get(13) + ((Calendar)gregorianCalendar).getTimeZone().getID();
        return this.processResultArgument(list, 0, string2);
    }

    public boolean date(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, list.size());
        int n = this.getArgumentAsAnInteger(1, list);
        int n2 = this.getArgumentAsAnInteger(2, list);
        int n3 = this.getArgumentAsAnInteger(3, list);
        String string = this.getArgumentAsAString(4, list);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n, n2, n3);
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone(string));
        String string2 = "" + gregorianCalendar.get(1) + "-" + gregorianCalendar.get(2) + "-" + gregorianCalendar.get(5) + ((Calendar)gregorianCalendar).getTimeZone().getID();
        return this.processResultArgument(list, 0, string2);
    }

    public boolean time(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, list.size());
        int n = this.getArgumentAsAnInteger(1, list);
        int n2 = this.getArgumentAsAnInteger(2, list);
        int n3 = this.getArgumentAsAnInteger(3, list);
        String string = this.getArgumentAsAString(4, list);
        String string2 = "" + n + ":" + n2 + ":" + n3 + string;
        return this.processResultArgument(list, 0, string2);
    }

    public boolean addYearMonthDurations(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsAtLeast(3, list.size());
        Duration duration = new Duration();
        for (int i = 1; i < list.size(); ++i) {
            Duration duration2 = this.getArgumentAsADuration(i, list);
            duration = XSDTimeUtil.addYearMonthDurations(duration, duration2);
        }
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean subtractYearMonthDurations(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.subtractYearMonthDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean multiplyYearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.multiplyYearMonthDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean divideYearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.divideYearMonthDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean addDayTimeDurations(List<BuiltInArgument> list) throws BuiltInException {
        Duration duration = new Duration();
        this.checkNumberOfArgumentsAtLeast(3, list.size());
        for (int i = 1; i < list.size(); ++i) {
            Duration duration2 = this.getArgumentAsADuration(i, list);
            duration = XSDTimeUtil.addDayTimeDurations(duration, duration2);
        }
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean subtractDayTimeDurations(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.subtractDayTimeDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean multiplyDayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.multiplyDayTimeDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean divideDayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Duration duration = this.getArgumentAsADuration(1, list);
        Duration duration2 = this.getArgumentAsADuration(2, list);
        Duration duration3 = XSDTimeUtil.divideDayTimeDurations(duration, duration2);
        return this.processResultArgument(list, 0, duration3.toString());
    }

    public boolean subtractDates(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Date date2 = this.getArgumentAsADate(2, list);
        Duration duration = XSDTimeUtil.subtractDates(date, date2);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean subtractTimes(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Time time = this.getArgumentAsATime(1, list);
        Time time2 = this.getArgumentAsATime(2, list);
        Duration duration = XSDTimeUtil.subtractTimes(time, time2);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean addYearMonthDurationToDateTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.addYearMonthDurationToDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean subtractYearMonthDurationFromDateTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.subtractYearMonthDurationFromDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean addDayTimeDurationToDateTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.addDayTimeDurationToDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean subtractDayTimeDurationFromDateTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.subtractDayTimeDurationFromDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean addYearMonthDurationToDate(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.addYearMonthDurationToDate(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean subtractYearMonthDurationFromDate(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.subtractYearMonthDurationFromDate(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean addDayTimeDurationToDate(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.addDayTimeDurationToDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean subtractDayTimeDurationFromDate(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Date date = this.getArgumentAsADate(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Date date2 = XSDTimeUtil.subtractDayTimeDurationFromDateTime(date, duration);
        return this.processResultArgument(list, 0, XSDTimeUtil.date2XSDDateTimeString(date2));
    }

    public boolean addDayTimeDurationToTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Time time = this.getArgumentAsATime(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Time time2 = XSDTimeUtil.addDayTimeDurationToTime(time, duration);
        return this.processResultArgument(list, 0, time2.toString());
    }

    public boolean subtractDayTimeDurationFromTime(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        Time time = this.getArgumentAsATime(1, list);
        Duration duration = this.getArgumentAsADuration(2, list);
        Time time2 = XSDTimeUtil.subtractDayTimeDurationFromTime(time, duration);
        return this.processResultArgument(list, 0, time2.toString());
    }

    public boolean subtractDateTimesYieldingYearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        Date date = this.getArgumentAsADate(1, list);
        Date date2 = this.getArgumentAsADate(2, list);
        Duration duration = XSDTimeUtil.subtractDateTimesYieldingYearMonthDuration(date, date2);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean subtractDateTimesYieldingDayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        Date date = this.getArgumentAsADate(1, list);
        Date date2 = this.getArgumentAsADate(2, list);
        Duration duration = XSDTimeUtil.subtractDateTimesYieldingDayTimeDuration(date, date2);
        return this.processResultArgument(list, 0, duration.toString());
    }

    public boolean resolveURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean anyURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listConcat(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listIntersection(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listSubtraction(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean member(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean length(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean first(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean rest(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean sublist(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean empty(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    private int compareTwoNumericArguments(List<BuiltInArgument> list) throws BuiltInException {
        double d;
        double d2;
        float f;
        float f2;
        long l;
        long l2;
        int n;
        int n2;
        short s;
        short s2;
        int n3 = 0;
        this.checkThatAllArgumentsAreNumeric(list);
        n3 = this.isShortMostPreciseArgument(list) ? ((s2 = this.getArgumentAsAShort(0, list)) < (s = this.getArgumentAsAShort(1, list)) ? -1 : (s2 > s ? 1 : 0)) : (this.isIntegerMostPreciseArgument(list) ? ((n2 = this.getArgumentAsAnInteger(0, list)) < (n = this.getArgumentAsAnInteger(1, list)) ? -1 : (n2 > n ? 1 : 0)) : (this.isLongMostPreciseArgument(list) ? ((l2 = this.getArgumentAsALong(0, list)) < (l = this.getArgumentAsALong(1, list)) ? -1 : (l2 > l ? 1 : 0)) : (this.isFloatMostPreciseArgument(list) ? ((f2 = this.getArgumentAsAFloat(0, list)) < (f = this.getArgumentAsAFloat(1, list)) ? -1 : (f2 > f ? 1 : 0)) : ((d2 = this.getArgumentAsADouble(0, list)) < (d = this.getArgumentAsADouble(1, list)) ? -1 : (d2 > d ? 1 : 0)))));
        return n3;
    }

    private boolean mathOperation(String string, List<BuiltInArgument> list) throws BuiltInException {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        this.checkForUnboundNonFirstArguments(list);
        if (this.isUnboundArgument(0, list)) {
            bl2 = true;
        }
        if (!bl2) {
            d = this.getArgumentAsADouble(0, list);
        }
        double d3 = this.getArgumentAsADouble(1, list);
        if (string.equalsIgnoreCase(SWRLB_ADD)) {
            d2 = 0.0;
            for (int i = 1; i < list.size(); ++i) {
                d2 += this.getArgumentAsADouble(i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_MULTIPLY)) {
            d2 = 1.0;
            for (int i = 1; i < list.size(); ++i) {
                d2 *= this.getArgumentAsADouble(i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_SUBTRACT)) {
            double d4 = this.getArgumentAsADouble(2, list);
            d2 = d3 - d4;
        } else if (string.equalsIgnoreCase(SWRLB_DIVIDE)) {
            double d5 = this.getArgumentAsADouble(2, list);
            d2 = d3 / d5;
        } else if (string.equalsIgnoreCase(SWRLB_INTEGER_DIVIDE)) {
            double d6 = this.getArgumentAsADouble(2, list);
            if (d6 == 0.0) {
                throw new InvalidBuiltInArgumentException(2, "zero passed as divisor");
            }
            d2 = d6 >= 0.0 ? d3 + d6 + 1.0 / d6 : d3 / d6;
        } else if (string.equalsIgnoreCase(SWRLB_MOD)) {
            double d7 = this.getArgumentAsADouble(2, list);
            d2 = d3 % d7;
        } else if (string.equalsIgnoreCase(SWRLB_POW)) {
            double d8 = this.getArgumentAsADouble(2, list);
            d2 = Math.pow(d3, d8);
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_PLUS)) {
            d2 = d3;
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_MINUS)) {
            d2 = -d3;
        } else if (string.equalsIgnoreCase(SWRLB_ABS)) {
            d2 = Math.abs(d3);
        } else if (string.equalsIgnoreCase(SWRLB_CEILING)) {
            d2 = Math.ceil(d3);
        } else if (string.equalsIgnoreCase(SWRLB_FLOOR)) {
            d2 = Math.floor(d3);
        } else if (string.equalsIgnoreCase(SWRLB_ROUND)) {
            d2 = Math.rint(d3);
        } else if (string.equalsIgnoreCase(SWRLB_ROUND_HALF_TO_EVEN)) {
            d2 = Math.rint(d3);
        } else if (string.equalsIgnoreCase(SWRLB_SIN)) {
            d2 = Math.sin(d3);
        } else if (string.equalsIgnoreCase(SWRLB_COS)) {
            d2 = Math.cos(d3);
        } else if (string.equalsIgnoreCase(SWRLB_TAN)) {
            d2 = Math.tan(d3);
        } else {
            throw new InvalidBuiltInNameException(string);
        }
        if (bl2) {
            List<BuiltInArgument> list2 = list.subList(1, list.size());
            if (string.equalsIgnoreCase(SWRLB_SIN) || string.equalsIgnoreCase(SWRLB_COS) || string.equalsIgnoreCase(SWRLB_TAN)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument(d2));
            } else if (this.isShortMostPreciseArgument(list2)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument((short)d2));
            } else if (this.isIntegerMostPreciseArgument(list2)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument((int)d2));
            } else if (this.isFloatMostPreciseArgument(list2)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument((float)d2));
            } else if (this.isLongMostPreciseArgument(list2)) {
                list.get(0).setBuiltInResult(this.createDataValueArgument((long)d2));
            } else {
                list.get(0).setBuiltInResult(this.createDataValueArgument(d2));
            }
            bl = true;
        } else {
            bl = d == d2;
        }
        return bl;
    }

    private Duration getArgumentAsADuration(int n, List<BuiltInArgument> list) throws BuiltInException {
        Duration duration = null;
        String string = "";
        try {
            string = this.getArgumentAsAString(n, list);
            duration = new Duration(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BuiltInException("invalid xsd:duration " + string + ": " + illegalArgumentException.getMessage());
        }
        return duration;
    }

    private Date getArgumentAsADate(int n, List<BuiltInArgument> list) throws BuiltInException {
        Date date = null;
        String string = "";
        try {
            string = this.getArgumentAsAString(n, list);
            date = this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new BuiltInException("invalid xsd:date " + string + ": " + parseException.getMessage());
        }
        return date;
    }

    private Time getArgumentAsATime(int n, List<BuiltInArgument> list) throws BuiltInException {
        Time time = null;
        String string = "";
        try {
            string = this.getArgumentAsAString(n, list);
            time = new Time(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuiltInException("invalid xsd:time " + string + ": " + numberFormatException.getMessage());
        }
        return time;
    }
}

