/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.sqwrl;

import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.CollectionArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DataPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ObjectPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLIndividualArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ClassValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataPropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.IndividualValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ObjectPropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNamedResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResultValueFactory;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.SQWRLResultImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private Map<String, Map<String, Collection<BuiltInArgument>>> collections;
    private Map<String, Integer> collectionGroupElementNumbersMap;
    private Set<String> setNames;
    private Set<String> bagNames;
    private SQWRLResultValueFactory resultValueFactory = new SQWRLResultValueFactory();

    public SWRLBuiltInLibraryImpl() {
        super(SQWRLNames.SQWRLBuiltInLibraryName);
    }

    @Override
    public void reset() {
        this.collections = new HashMap<String, Map<String, Collection<BuiltInArgument>>>();
        this.collectionGroupElementNumbersMap = new HashMap<String, Integer>();
        this.setNames = new HashSet<String>();
        this.bagNames = new HashSet<String>();
    }

    public boolean select(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        this.checkForUnboundArguments(list);
        this.checkNumberOfArgumentsAtLeastOne(list);
        SQWRLResultImpl sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
        if (!sQWRLResultImpl.isRowOpen()) {
            sQWRLResultImpl.openRow();
        }
        int n = 0;
        for (BuiltInArgument builtInArgument : list) {
            SQWRLNamedResultValue sQWRLNamedResultValue;
            Comparable<SQWRLResultValue> comparable;
            if (builtInArgument instanceof SWRLLiteralArgumentReference) {
                comparable = ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
                sQWRLResultImpl.addRowData((SQWRLResultValue)comparable);
            } else if (builtInArgument instanceof SWRLIndividualArgumentReference) {
                comparable = (SWRLIndividualArgumentReference)builtInArgument;
                sQWRLNamedResultValue = this.resultValueFactory.createIndividualValue(comparable.getURI());
                sQWRLResultImpl.addRowData(sQWRLNamedResultValue);
            } else if (builtInArgument instanceof ClassArgument) {
                comparable = (ClassArgument)builtInArgument;
                sQWRLNamedResultValue = this.resultValueFactory.createClassValue(comparable.getURI());
                sQWRLResultImpl.addRowData(sQWRLNamedResultValue);
            } else if (builtInArgument instanceof ObjectPropertyArgument) {
                comparable = (ObjectPropertyArgument)builtInArgument;
                sQWRLNamedResultValue = this.resultValueFactory.createObjectPropertyValue(comparable.getURI());
                sQWRLResultImpl.addRowData(sQWRLNamedResultValue);
            } else if (builtInArgument instanceof DataPropertyArgument) {
                comparable = (DataPropertyArgument)builtInArgument;
                sQWRLNamedResultValue = this.resultValueFactory.createDataPropertyValue(comparable.getURI());
                sQWRLResultImpl.addRowData(sQWRLNamedResultValue);
            } else {
                if (builtInArgument instanceof CollectionArgument) {
                    throw new InvalidBuiltInArgumentException(n, "collections cannot be selected");
                }
                throw new InvalidBuiltInArgumentException(n, "unknown type " + builtInArgument.getClass());
            }
            ++n;
        }
        return false;
    }

    public boolean selectDistinct(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return this.select(list);
    }

    public boolean count(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        this.checkForUnboundArguments(list);
        this.checkNumberOfArgumentsEqualTo(1, list.size());
        SQWRLResultImpl sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
        BuiltInArgument builtInArgument = list.get(0);
        if (!sQWRLResultImpl.isRowOpen()) {
            sQWRLResultImpl.openRow();
        }
        if (builtInArgument instanceof SWRLLiteralArgumentReference) {
            DataValue dataValue = ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
            sQWRLResultImpl.addRowData(dataValue);
        } else if (builtInArgument instanceof SWRLIndividualArgumentReference) {
            SWRLIndividualArgumentReference sWRLIndividualArgumentReference = (SWRLIndividualArgumentReference)builtInArgument;
            IndividualValue individualValue = this.resultValueFactory.createIndividualValue(sWRLIndividualArgumentReference.getURI());
            sQWRLResultImpl.addRowData(individualValue);
        } else if (builtInArgument instanceof ClassArgument) {
            ClassArgument classArgument = (ClassArgument)builtInArgument;
            ClassValue classValue = this.resultValueFactory.createClassValue(classArgument.getURI());
            sQWRLResultImpl.addRowData(classValue);
        } else if (builtInArgument instanceof ObjectPropertyArgument) {
            ObjectPropertyArgument objectPropertyArgument = (ObjectPropertyArgument)builtInArgument;
            ObjectPropertyValue objectPropertyValue = this.resultValueFactory.createObjectPropertyValue(objectPropertyArgument.getURI());
            sQWRLResultImpl.addRowData(objectPropertyValue);
        } else if (builtInArgument instanceof DataPropertyArgument) {
            DataPropertyArgument dataPropertyArgument = (DataPropertyArgument)builtInArgument;
            DataPropertyValue dataPropertyValue = this.resultValueFactory.createDataPropertyValue(dataPropertyArgument.getURI());
            sQWRLResultImpl.addRowData(dataPropertyValue);
        } else {
            if (builtInArgument instanceof CollectionArgument) {
                throw new InvalidBuiltInArgumentException(0, "collections cannot be counted");
            }
            throw new InvalidBuiltInArgumentException(0, "unknown type " + builtInArgument.getClass());
        }
        return false;
    }

    public boolean countDistinct(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return this.count(list);
    }

    public boolean columnNames(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean orderBy(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean orderByDescending(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean limit(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean makeSet(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        this.checkForUnboundNonFirstArguments(list);
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionGroupIDInMake(list);
        BuiltInArgument builtInArgument = list.get(1);
        Collection<BuiltInArgument> collection = this.isCollection(string, string2) ? this.getCollection(string, string2) : this.createSet(string, string2);
        collection.add(builtInArgument);
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string2));
        }
        return true;
    }

    public boolean makeBag(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        this.checkForUnboundNonFirstArguments(list);
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionGroupIDInMake(list);
        BuiltInArgument builtInArgument = list.get(1);
        Collection<BuiltInArgument> collection = this.isCollection(string, string2) ? this.getCollection(string, string2) : this.createBag(string, string2);
        collection.add(builtInArgument);
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string2));
        }
        return true;
    }

    public boolean groupBy(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return true;
    }

    public boolean isEmpty(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 0, 1);
        return collection.size() == 0;
    }

    public boolean notEmpty(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return !this.isEmpty(list);
    }

    public boolean size(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 1, 2);
        return this.processResultArgument(list, 0, collection.size());
    }

    public boolean element(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 1, 2);
        return this.processResultArgument(list, 0, collection);
    }

    public boolean notElement(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return !this.element(list);
    }

    public boolean min(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(list);
            this.checkNumberOfArgumentsEqualTo(1, list.size());
            SQWRLResultImpl sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
            BuiltInArgument builtInArgument = list.get(0);
            if (!sQWRLResultImpl.isRowOpen()) {
                sQWRLResultImpl.openRow();
            }
            if (!(builtInArgument instanceof SWRLLiteralArgumentReference) || !((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isNumeric()) {
                throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got " + builtInArgument);
            }
            DataValue dataValue = ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
            sQWRLResultImpl.addRowData(dataValue);
            bl = true;
        } else {
            bl = this.least(list);
        }
        return bl;
    }

    public boolean max(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(list);
            this.checkNumberOfArgumentsEqualTo(1, list.size());
            SQWRLResultImpl sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
            BuiltInArgument builtInArgument = list.get(0);
            if (!sQWRLResultImpl.isRowOpen()) {
                sQWRLResultImpl.openRow();
            }
            if (!(builtInArgument instanceof SWRLLiteralArgumentReference) || !((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isNumeric()) {
                throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got: " + builtInArgument);
            }
            DataValue dataValue = ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
            sQWRLResultImpl.addRowData(dataValue);
            bl = true;
        } else {
            bl = this.greatest(list);
        }
        return bl;
    }

    public boolean sum(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(list);
            this.checkNumberOfArgumentsEqualTo(1, list.size());
            SQWRLResultImpl sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
            BuiltInArgument builtInArgument = list.get(0);
            if (!sQWRLResultImpl.isRowOpen()) {
                sQWRLResultImpl.openRow();
            }
            if (!(builtInArgument instanceof SWRLLiteralArgumentReference) || !((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isNumeric()) {
                throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got: " + builtInArgument);
            }
            DataValue dataValue = ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
            sQWRLResultImpl.addRowData(dataValue);
            bl = true;
        } else {
            Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 1, 2);
            if (collection.isEmpty()) {
                bl = false;
            } else {
                double d = 0.0;
                for (BuiltInArgument builtInArgument : collection) {
                    this.checkThatElementIsComparable(builtInArgument);
                    double d2 = this.getArgumentAsADouble(builtInArgument);
                    d += d2;
                }
                bl = this.processResultArgument(list, 0, d);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean avg(List<BuiltInArgument> list) throws BuiltInException {
        Argument argument;
        SQWRLResultImpl sQWRLResultImpl;
        boolean bl = false;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(list);
            this.checkNumberOfArgumentsEqualTo(1, list.size());
            sQWRLResultImpl = this.getSQWRLUnpreparedResult(this.getInvokingRuleName());
            argument = list.get(0);
            if (!sQWRLResultImpl.isRowOpen()) {
                sQWRLResultImpl.openRow();
            }
        } else {
            Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 1, 2);
            if (collection.isEmpty()) {
                return false;
            }
            double d = 0.0;
            for (BuiltInArgument builtInArgument : collection) {
                this.checkThatElementIsComparable(builtInArgument);
                double d2 = this.getArgumentAsADouble(builtInArgument);
                d += d2;
            }
            double d3 = d / (double)collection.size();
            return this.processResultArgument(list, 0, d3);
        }
        if (!(argument instanceof SWRLLiteralArgumentReference)) throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got: " + argument);
        if (!((SWRLLiteralArgumentReference)argument).getLiteral().isNumeric()) throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got: " + argument);
        DataValue dataValue = ((SWRLLiteralArgumentReference)argument).getLiteral();
        sQWRLResultImpl.addRowData(dataValue);
        return bl;
    }

    public boolean median(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            throw new BuiltInException("not implemented");
        }
        Collection<BuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(list, 1, 2);
        if (collection.isEmpty()) {
            bl = false;
        } else {
            double[] dArray = new double[collection.size()];
            int n = 0;
            int n2 = collection.size() / 2;
            for (BuiltInArgument builtInArgument : collection) {
                this.checkThatElementIsComparable(builtInArgument);
                double d = this.getArgumentAsADouble(builtInArgument);
                dArray[n++] = d;
            }
            Arrays.sort(dArray);
            double d = collection.size() % 2 == 1 ? dArray[n2] : (dArray[n2 - 1] + dArray[n2]) / 2.0;
            bl = this.processResultArgument(list, 0, d);
        }
        return bl;
    }

    public boolean nth(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            bl = true;
        } else {
            List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
            int n = this.getArgumentAsAPositiveInteger(2, list) - 1;
            if (!list2.isEmpty()) {
                if (n >= 0 && n < list2.size()) {
                    BuiltInArgument builtInArgument = list2.get(n);
                    bl = this.processResultArgument(list, 0, builtInArgument);
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean greatest(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            bl = true;
        } else {
            List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 2);
            if (!list2.isEmpty()) {
                BuiltInArgument builtInArgument = list2.get(list2.size() - 1);
                bl = this.processResultArgument(list, 0, builtInArgument);
            }
        }
        return bl;
    }

    public boolean nthGreatest(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (this.getIsInConsequent()) {
            bl = true;
        } else {
            List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
            int n = this.getArgumentAsAPositiveInteger(2, list);
            if (!list2.isEmpty() && n > 0 && n <= list2.size()) {
                BuiltInArgument builtInArgument = list2.get(list2.size() - n);
                bl = this.processResultArgument(list, 0, builtInArgument);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean least(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        boolean bl = false;
        if (this.getIsInConsequent()) {
            bl = true;
        } else {
            List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 2);
            if (!list2.isEmpty()) {
                BuiltInArgument builtInArgument = list2.get(0);
                bl = this.processResultArgument(list, 0, builtInArgument);
            }
        }
        return bl;
    }

    public boolean notNthGreatest(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        if (!list2.isEmpty() && n > 0 && n <= list2.size()) {
            list2.remove(list2.size() - n);
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, list2);
    }

    public boolean nthSlice(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 4);
        int n = this.getArgumentAsAPositiveInteger(2, list) - 1;
        int n2 = this.getArgumentAsAPositiveInteger(3, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        if (!list2.isEmpty() && n >= 0) {
            int n3 = n;
            int n4 = n + n2 - 1;
            for (int i = n3; i <= n4 && i < list2.size(); ++i) {
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 4, arrayList);
    }

    public boolean notNthSlice(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 4);
        int n = this.getArgumentAsAPositiveInteger(2, list) - 1;
        int n2 = this.getArgumentAsAPositiveInteger(3, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        if (!list2.isEmpty() && n >= 0 && n < list2.size()) {
            int n3 = n;
            int n4 = n + n2 - 1;
            for (int i = 0; i < list2.size(); ++i) {
                if (i >= n3 && i <= n4) continue;
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 4, arrayList);
    }

    public boolean nthGreatestSlice(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 4);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        int n2 = this.getArgumentAsAPositiveInteger(3, list);
        if (!list2.isEmpty() && n > 0) {
            int n3 = list2.size() - n;
            int n4 = n3 + n2 - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            for (int i = n3; i <= n4 && i < list2.size(); ++i) {
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 4, arrayList);
    }

    public boolean notNthGreatestSlice(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 4);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        int n2 = this.getArgumentAsAPositiveInteger(3, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        if (!list2.isEmpty() && n > 0 && n <= list2.size()) {
            int n3 = list2.size() - n;
            int n4 = n3 + n2 - 1;
            for (int i = 0; i < list2.size(); ++i) {
                if (i >= n3 && i <= n4) continue;
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 4, arrayList);
    }

    public boolean notNth(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list) - 1;
        if (!list2.isEmpty() && n >= 0 && n < list2.size()) {
            list2.remove(n);
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, list2);
    }

    public boolean notGreatest(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 2);
        if (!list2.isEmpty()) {
            list2.remove(list2.size() - 1);
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 2, list2);
    }

    public boolean greatestN(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        if (!list2.isEmpty() && n > 0) {
            int n2 = list2.size() - n;
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = n2; i < list2.size(); ++i) {
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, arrayList);
    }

    public boolean notGreatestN(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        if (!list2.isEmpty() && n > 0) {
            int n2 = list2.size() - n;
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = 0; i < n2; ++i) {
                arrayList.add(list2.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, arrayList);
    }

    public boolean notLeast(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 2);
        if (!list2.isEmpty()) {
            list2.remove(0);
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 2, list2);
    }

    public boolean leastN(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list) - 1;
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        for (int i = 0; i <= n && i < list2.size(); ++i) {
            arrayList.add(list2.get(i));
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, arrayList);
    }

    public boolean notLeastN(List<BuiltInArgument> list) throws BuiltInException {
        if (this.getIsInConsequent()) {
            return true;
        }
        List<BuiltInArgument> list2 = this.getSortedListInSingleOperandCollectionOperation(list, 1, 3);
        int n = this.getArgumentAsAPositiveInteger(2, list);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        for (int i = n; i >= 0 && i < list2.size(); ++i) {
            arrayList.add(list2.get(i));
        }
        return this.processSingleOperandCollectionOperationListResult(list, 0, 1, 3, arrayList);
    }

    public boolean intersects(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        int n = this.getNumberOfGroupElements(string);
        int n2 = this.getNumberOfGroupElements(string2);
        String string3 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 2, 0, n);
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 2, n, n2);
        Collection<BuiltInArgument> collection = this.getCollection(string, string3);
        Collection<BuiltInArgument> collection2 = this.getCollection(string2, string4);
        return !Collections.disjoint(collection, collection2);
    }

    public boolean notIntersects(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return !this.intersects(list);
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        int n = this.getNumberOfGroupElements(string);
        int n2 = this.getNumberOfGroupElements(string2);
        String string3 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 2, 0, n);
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 2, n, n2);
        Collection<BuiltInArgument> collection = this.getCollection(string, string3);
        Collection<BuiltInArgument> collection2 = this.getCollection(string2, string4);
        return collection.containsAll(collection2);
    }

    public boolean notContains(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return !this.contains(list);
    }

    public boolean equal(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        int n = this.getNumberOfGroupElements(string);
        int n2 = this.getNumberOfGroupElements(string2);
        String string3 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 2, 0, n);
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 2, n, n2);
        if (string3.equals(string4)) {
            return true;
        }
        Collection<BuiltInArgument> collection = this.getCollection(string, string3);
        Collection<BuiltInArgument> collection2 = this.getCollection(string2, string4);
        return ((Object)collection).equals(collection2);
    }

    public boolean notEqual(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        return !this.equal(list);
    }

    public boolean intersection(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        String string3 = this.getCollectionName(list, 2);
        int n = this.getNumberOfGroupElements(string2);
        int n2 = this.getNumberOfGroupElements(string3);
        int n3 = n + n2;
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 3, 0, n3);
        String string5 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 3, 0, n);
        String string6 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 2, 3, 0 + n, n2);
        Collection<BuiltInArgument> collection = this.getCollection(string2, string5);
        Collection<BuiltInArgument> collection2 = this.getCollection(string3, string6);
        HashSet<BuiltInArgument> hashSet = new HashSet<BuiltInArgument>(collection);
        hashSet.retainAll(collection2);
        if (!this.isCollection(string, string4)) {
            this.recordCollection(string, string4, hashSet);
        }
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string4));
        }
        return true;
    }

    public boolean append(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        String string3 = this.getCollectionName(list, 2);
        int n = this.getNumberOfGroupElements(string2);
        int n2 = this.getNumberOfGroupElements(string3);
        int n3 = n + n2;
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 3, 0, n);
        String string5 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 2, 3, 0 + n, n2);
        String string6 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 3, 0, n3);
        Collection<BuiltInArgument> collection = this.getCollection(string2, string4);
        Collection<BuiltInArgument> collection2 = this.getCollection(string3, string5);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>(collection);
        arrayList.addAll(collection2);
        if (!this.isCollection(string, string6)) {
            this.recordCollection(string, string6, arrayList);
        }
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string6));
        }
        return true;
    }

    public boolean union(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        String string3 = this.getCollectionName(list, 2);
        int n = this.getNumberOfGroupElements(string2);
        int n2 = this.getNumberOfGroupElements(string3);
        int n3 = n + n2;
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 3, 0, n);
        String string5 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 2, 3, 0 + n, n2);
        String string6 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 3, 0, n3);
        Collection<BuiltInArgument> collection = this.getCollection(string2, string4);
        Collection<BuiltInArgument> collection2 = this.getCollection(string3, string5);
        HashSet<BuiltInArgument> hashSet = new HashSet<BuiltInArgument>(collection);
        hashSet.addAll(collection2);
        if (!this.isCollection(string, string6)) {
            this.recordCollection(string, string6, hashSet);
        }
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string6));
        }
        return true;
    }

    public boolean difference(List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatInAntecedent();
        String string = this.getCollectionName(list, 0);
        String string2 = this.getCollectionName(list, 1);
        String string3 = this.getCollectionName(list, 2);
        int n = this.getNumberOfGroupElements(string2);
        int n2 = this.getNumberOfGroupElements(string3);
        int n3 = n + n2;
        String string4 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 0, 3, 0, n3);
        String string5 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 1, 3, 0, n);
        String string6 = this.getCollectionGroupIDInMultiOperandCollectionOperation(list, 2, 3, 0 + n, n2);
        Collection<BuiltInArgument> collection = this.getCollection(string2, string5);
        Collection<BuiltInArgument> collection2 = this.getCollection(string3, string6);
        HashSet<BuiltInArgument> hashSet = new HashSet<BuiltInArgument>(collection);
        hashSet.removeAll(collection2);
        if (!this.isCollection(string, string4)) {
            this.recordCollection(string, string4, hashSet);
        }
        if (this.isUnboundArgument(0, list)) {
            list.get(0).setBuiltInResult(this.createCollectionArgument(string, string4));
        }
        return true;
    }

    public boolean nthLast(List<BuiltInArgument> list) throws BuiltInException {
        return this.nthGreatest(list);
    }

    public boolean notNthLast(List<BuiltInArgument> list) throws BuiltInException {
        return this.notNthGreatest(list);
    }

    public boolean nthLastSlice(List<BuiltInArgument> list) throws BuiltInException {
        return this.nthGreatestSlice(list);
    }

    public boolean notNthLastSlice(List<BuiltInArgument> list) throws BuiltInException {
        return this.notNthGreatestSlice(list);
    }

    public boolean last(List<BuiltInArgument> list) throws BuiltInException {
        return this.greatest(list);
    }

    public boolean notLast(List<BuiltInArgument> list) throws BuiltInException {
        return this.notGreatest(list);
    }

    public boolean lastN(List<BuiltInArgument> list) throws BuiltInException {
        return this.greatestN(list);
    }

    public boolean notLastN(List<BuiltInArgument> list) throws BuiltInException {
        return this.notGreatestN(list);
    }

    public boolean first(List<BuiltInArgument> list) throws BuiltInException {
        return this.least(list);
    }

    public boolean notFirst(List<BuiltInArgument> list) throws BuiltInException {
        return this.notLeast(list);
    }

    public boolean firstN(List<BuiltInArgument> list) throws BuiltInException {
        return this.leastN(list);
    }

    public boolean notFirstN(List<BuiltInArgument> list) throws BuiltInException {
        return this.notLeastN(list);
    }

    private String getCollectionGroupIDInMake(List<BuiltInArgument> list) throws BuiltInException {
        String string;
        this.checkNumberOfArgumentsAtLeast(2, list.size());
        String string2 = this.getInvokingRuleName();
        String string3 = this.getCollectionName(list, 0);
        int n = list.size() - 2;
        boolean bl = n != 0;
        String string4 = string = !bl ? "" : this.createInvocationPattern(this.getBuiltInBridge(), string2, 0, false, list.subList(2, list.size()));
        if (this.isBoundArgument(0, list) && !this.collectionGroupElementNumbersMap.containsKey(string3)) {
            throw new BuiltInException("collection variable ?" + list.get(0).getVariableName() + " already used in non collection context");
        }
        if (bl) {
            if (!this.collectionGroupElementNumbersMap.containsKey(string3)) {
                this.collectionGroupElementNumbersMap.put(string3, n);
            } else if (this.collectionGroupElementNumbersMap.get(string3) != n) {
                throw new BuiltInException("internal error: inconsistent number of group elements for collection " + string3);
            }
            return string;
        }
        if (this.collectionGroupElementNumbersMap.containsKey(string3)) {
            if (this.collectionGroupElementNumbersMap.get(string3) != 0) {
                throw new BuiltInException("internal error: inconsistent number of group elements for collection " + string3);
            }
        } else {
            this.collectionGroupElementNumbersMap.put(string3, 0);
        }
        return "";
    }

    private String getCollectionGroupIDInSingleCollectionOperation(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        String string = this.getInvokingRuleName();
        this.checkThatInAntecedent();
        if (list.size() > n2) {
            return this.createInvocationPattern(this.getBuiltInBridge(), string, 0, false, list.subList(n2, list.size()));
        }
        return "";
    }

    private String getCollectionGroupIDInMultiOperandCollectionOperation(List<BuiltInArgument> list, int n, int n2, int n3, int n4) throws BuiltInException {
        String string = this.getInvokingRuleName();
        String string2 = this.getCollectionName(list, n);
        this.checkThatInAntecedent();
        if (!this.collectionGroupElementNumbersMap.containsKey(string2)) {
            this.collectionGroupElementNumbersMap.put(string2, n4);
        }
        if (n4 != 0) {
            return this.createInvocationPattern(this.getBuiltInBridge(), string, 0, false, list.subList(n2 + n3, n2 + n3 + n4));
        }
        return "";
    }

    private boolean processSingleOperandCollectionOperationListResult(List<BuiltInArgument> list, int n, int n2, int n3, Collection<BuiltInArgument> collection) throws BuiltInException {
        String string;
        String string2 = this.getCollectionName(list, n2);
        String string3 = this.getCollectionName(list, n);
        if (!this.isCollection(string3, string = this.getCollectionGroupIDInSingleCollectionOperation(list, n, n3))) {
            this.recordCollection(string3, string, collection);
        }
        if (!this.collectionGroupElementNumbersMap.containsKey(string3)) {
            this.collectionGroupElementNumbersMap.put(string3, this.getNumberOfGroupElements(string2));
        }
        return this.processListResultArgument(list, n, string3, string, collection);
    }

    private boolean processListResultArgument(List<BuiltInArgument> list, int n, String string, String string2, Collection<BuiltInArgument> collection) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        if (this.isUnboundArgument(n, list)) {
            list.get(n).setBuiltInResult(this.createCollectionArgument(string, string2));
            return true;
        }
        Collection<BuiltInArgument> collection2 = this.getCollection(string, string2);
        return ((Object)collection2).equals(collection);
    }

    private SQWRLResultImpl getSQWRLUnpreparedResult(String string) throws BuiltInException {
        return this.getBuiltInBridge().getSQWRLUnpreparedResult(string);
    }

    private void checkThatElementIsComparable(BuiltInArgument builtInArgument) throws BuiltInException {
        if (!(builtInArgument instanceof SWRLLiteralArgumentReference) || !((SWRLLiteralArgumentReference)builtInArgument).getLiteral().isComparable()) {
            throw new BuiltInException("may only be applied to collections with comparable elements");
        }
    }

    private Collection<BuiltInArgument> getCollectionInSingleCollectionOperation(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        String string = this.getCollectionName(list, n);
        String string2 = this.getCollectionGroupIDInSingleCollectionOperation(list, n, n2);
        return this.getCollection(string, string2);
    }

    private List<BuiltInArgument> getSortedListInSingleOperandCollectionOperation(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        String string = this.getCollectionName(list, n);
        String string2 = this.getCollectionGroupIDInSingleCollectionOperation(list, n, n2);
        return this.getSortedList(string, string2);
    }

    private List<BuiltInArgument> getSortedList(String string, String string2) throws BuiltInException {
        Collection<BuiltInArgument> collection = this.getCollection(string, string2);
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    private List<BuiltInArgument> createBag(String string, String string2) throws BuiltInException {
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        this.recordCollection(string, string2, arrayList);
        this.bagNames.add(string);
        return arrayList;
    }

    private Set<BuiltInArgument> createSet(String string, String string2) throws BuiltInException {
        HashSet<BuiltInArgument> hashSet = new HashSet<BuiltInArgument>();
        this.recordCollection(string, string2, hashSet);
        return hashSet;
    }

    private String getCollectionName(List<BuiltInArgument> list, int n) throws BuiltInException {
        String string = this.getInvokingRuleName();
        String string2 = this.getVariableName(n, list);
        return string + ":" + string2;
    }

    private int getNumberOfGroupElements(String string) throws BuiltInException {
        if (!this.collectionGroupElementNumbersMap.containsKey(string)) {
            throw new BuiltInException("internal error: invalid collection name " + string + "; no group element number found");
        }
        return this.collectionGroupElementNumbersMap.get(string);
    }

    private void recordCollection(String string, String string2, Collection<BuiltInArgument> collection) throws BuiltInException {
        if (!this.isCollection(string)) {
            if (this.isBag(collection)) {
                this.bagNames.add(string);
            } else if (this.isSet(collection)) {
                this.setNames.add(string);
            } else {
                throw new BuiltInException("internal error: collection " + string + " with group ID " + string2 + " is neither a bag or a set");
            }
            this.collections.put(string, new HashMap());
        }
        if (!this.isCollection(string, string2)) {
            if (this.isBag(string) && !this.isBag(collection)) {
                throw new BuiltInException("attempt to add non bag elements to bag " + string + "; group ID=" + string2);
            }
            if (this.isSet(string) && !this.isSet(collection)) {
                throw new BuiltInException("attempt to add non set elements to set " + string + "; group ID=" + string2);
            }
            this.collections.get(string).put(string2, collection);
        }
    }

    private Collection<BuiltInArgument> getCollection(String string, String string2) throws BuiltInException {
        if (!this.isCollection(string, string2)) {
            throw new BuiltInException("argument " + string + " with group ID " + string2 + " does not refer to a collection");
        }
        return this.collections.get(string).get(string2);
    }

    private boolean isCollection(String string, String string2) {
        return this.collections.containsKey(string) && this.collections.get(string).containsKey(string2);
    }

    private boolean isSet(String string) {
        return this.setNames.contains(string);
    }

    private boolean isBag(String string) {
        return this.bagNames.contains(string);
    }

    private boolean isCollection(String string) throws BuiltInException {
        return this.collections.containsKey(string);
    }

    private boolean isBag(Collection<BuiltInArgument> collection) {
        return collection instanceof List;
    }

    private boolean isSet(Collection<BuiltInArgument> collection) {
        return collection instanceof Set;
    }

    private Collection<BuiltInArgument> ungroupCollection(String string) throws BuiltInException {
        if (!this.isCollection(string)) {
            throw new BuiltInException(string + "is not a collection");
        }
        HashSet<BuiltInArgument> hashSet = this.isSet(string) ? new HashSet() : new ArrayList();
        for (String string2 : this.collections.get(string).keySet()) {
            hashSet.addAll(this.collections.get(string).get(string2));
        }
        return hashSet;
    }
}

