/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.abox;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLConversionFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInLibraryException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLIndividualArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLOntology;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLABoxLibraryName = "SWRLABoxBuiltIns";

    public SWRLBuiltInLibraryImpl() {
        super(SWRLABoxLibraryName);
    }

    @Override
    public void reset() {
    }

    public boolean isIndividual(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, list.size());
        boolean bl = this.isUnboundArgument(0, list);
        boolean bl2 = false;
        if (bl) {
            MultiArgument multiArgument = this.createMultiArgument();
            for (OWLNamedIndividualReference oWLNamedIndividualReference : this.getBuiltInBridge().getOWLIndividuals()) {
                SWRLIndividualArgumentReference sWRLIndividualArgumentReference = this.createIndividualArgument(oWLNamedIndividualReference.getURI());
                multiArgument.addArgument(sWRLIndividualArgumentReference);
            }
            list.get(0).setBuiltInResult(multiArgument);
            bl2 = !multiArgument.hasNoArguments();
        } else {
            String string = this.getArgumentAsAnIndividualURI(0, list);
            bl2 = this.getBuiltInBridge().isOWLIndividual(string);
        }
        return bl2;
    }

    public boolean hasValue(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        block16: {
            String string = null;
            Object object = null;
            bl = false;
            this.checkNumberOfArgumentsEqualTo(3, list.size());
            String string2 = this.getArgumentAsAnIndividualURI(0, list);
            string = this.getArgumentAsAPropertyURI(1, list);
            boolean bl2 = !this.isUnboundArgument(2, list);
            try {
                boolean bl3 = this.getBuiltInBridge().isOWLObjectProperty(string);
                if (this.getIsInConsequent()) {
                    OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference;
                    OWLNamedIndividualReference oWLNamedIndividualReference = this.getBuiltInBridge().getOWLDataFactory().getOWLIndividual(string2);
                    if (bl3) {
                        SWRLIndividualArgumentReference sWRLIndividualArgumentReference = this.getArgumentAsAnIndividual(2, list);
                        OWLNamedIndividualReference oWLNamedIndividualReference2 = this.getBuiltInBridge().getOWLDataFactory().getOWLIndividual(sWRLIndividualArgumentReference.getURI());
                        OWLObjectPropertyReference oWLObjectPropertyReference = this.getBuiltInBridge().getOWLDataFactory().getOWLObjectProperty(string);
                        oWLPropertyAssertionAxiomReference = this.getBuiltInBridge().getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(oWLNamedIndividualReference, oWLObjectPropertyReference, oWLNamedIndividualReference2);
                    } else {
                        DataValue dataValue = this.getArgumentAsADataValue(2, list);
                        OWLDataValue oWLDataValue = this.getBuiltInBridge().getOWLDataValueFactory().getOWLDataValue(dataValue);
                        OWLDataPropertyReference oWLDataPropertyReference = this.getBuiltInBridge().getOWLDataFactory().getOWLDataProperty(string);
                        oWLPropertyAssertionAxiomReference = this.getBuiltInBridge().getOWLDataFactory().getOWLDataPropertyAssertionAxiom(oWLNamedIndividualReference, oWLDataPropertyReference, oWLDataValue);
                    }
                    this.getBuiltInBridge().injectOWLAxiom(oWLPropertyAssertionAxiomReference);
                    break block16;
                }
                if (bl2) {
                    object = this.getArgumentAsAPropertyValue(2, list);
                    if (bl3) {
                        RDFResource rDFResource = SWRLOWLUtil.getObjectPropertyValue(this.getOWLModel(), string2, string);
                        bl = object.equals(rDFResource.getURI());
                    } else {
                        bl = SWRLOWLUtil.getDatavaluedPropertyValues(this.getOWLModel(), string2, string).contains(object);
                    }
                    break block16;
                }
                MultiArgument multiArgument = this.createMultiArgument();
                if (bl3) {
                    for (RDFResource rDFResource : SWRLOWLUtil.getObjectPropertyValues(this.getOWLModel(), string2, string)) {
                        RDFResource rDFResource2;
                        if (rDFResource instanceof OWLIndividual) {
                            rDFResource2 = (OWLIndividual)rDFResource;
                            multiArgument.addArgument(this.createIndividualArgument(rDFResource2.getURI()));
                            continue;
                        }
                        if (rDFResource instanceof OWLNamedClass) {
                            rDFResource2 = (OWLNamedClass)rDFResource;
                            multiArgument.addArgument(this.createClassArgument(rDFResource2.getURI()));
                            continue;
                        }
                        if (rDFResource instanceof OWLDatatypeProperty) {
                            rDFResource2 = (OWLDatatypeProperty)rDFResource;
                            multiArgument.addArgument(this.createDataPropertyArgument(rDFResource2.getURI()));
                            continue;
                        }
                        if (!(rDFResource instanceof OWLObjectProperty)) continue;
                        rDFResource2 = (OWLObjectProperty)rDFResource;
                        multiArgument.addArgument(this.createObjectPropertyArgument(rDFResource2.getURI()));
                    }
                } else {
                    for (Object object2 : SWRLOWLUtil.getDatavaluedPropertyValues(this.getOWLModel(), string2, string)) {
                        if (object2 instanceof RDFSLiteral) {
                            RDFSLiteral rDFSLiteral = (RDFSLiteral)object2;
                            multiArgument.addArgument(P3OWLOntology.convertRDFSLiteral2DataValueArgument(this.getOWLModel(), rDFSLiteral));
                            continue;
                        }
                        multiArgument.addArgument(this.createDataValueArgument(object2));
                    }
                }
                list.get(2).setBuiltInResult(multiArgument);
                bl = !multiArgument.hasNoArguments();
            }
            catch (OWLConversionFactoryException oWLConversionFactoryException) {
                throw new BuiltInException(oWLConversionFactoryException.getMessage());
            }
        }
        return bl;
    }

    public boolean hasProperty(List<BuiltInArgument> list) throws BuiltInException {
        String string = null;
        boolean bl = this.isUnboundArgument(1, list);
        boolean bl2 = false;
        this.checkNumberOfArgumentsInRange(2, 3, list.size());
        String string2 = this.getArgumentAsAnIndividualURI(0, list);
        string = this.getArgumentAsAPropertyURI(1, list);
        try {
            if (bl) {
                MultiArgument multiArgument = this.createMultiArgument();
                for (OWLProperty oWLProperty : SWRLOWLUtil.getOWLPropertiesOfIndividual(this.getOWLModel(), string2)) {
                    if (oWLProperty.isObjectProperty()) {
                        multiArgument.addArgument(this.createObjectPropertyArgument(oWLProperty.getURI()));
                        continue;
                    }
                    multiArgument.addArgument(this.createDataPropertyArgument(oWLProperty.getURI()));
                }
                list.get(1).setBuiltInResult(multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                bl2 = SWRLOWLUtil.getNumberOfPropertyValues(this.getOWLModel(), string2, string, true) != 0;
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new BuiltInException(oWLConversionFactoryException.getMessage());
        }
        return bl2;
    }

    public boolean hasIndividual(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = this.isUnboundArgument(1, list);
        boolean bl2 = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        this.checkThatArgumentIsAClass(0, list);
        String string = this.getArgumentAsAClassURI(0, list);
        try {
            if (bl) {
                MultiArgument multiArgument = this.createMultiArgument();
                for (OWLIndividual oWLIndividual : SWRLOWLUtil.getOWLIndividualsOfClass(this.getOWLModel(), string)) {
                    multiArgument.addArgument(this.createIndividualArgument(oWLIndividual.getURI()));
                }
                list.get(1).setBuiltInResult(multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                String string2 = this.getArgumentAsAnIndividualURI(1, list);
                bl2 = this.getBuiltInBridge().isOWLIndividualOfClass(string2, string);
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new BuiltInException(oWLConversionFactoryException.getMessage());
        }
        return bl2;
    }

    public boolean hasURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = this.isUnboundArgument(1, list);
        boolean bl2 = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        this.checkThatArgumentIsAClassPropertyOrIndividual(0, list);
        String string = this.getArgumentAsAURI(0, list);
        try {
            if (bl) {
                String string2 = SWRLOWLUtil.getURI(this.getOWLModel(), string);
                list.get(1).setBuiltInResult(this.createDataValueArgument(string2));
                bl2 = true;
            } else {
                String string3 = this.getArgumentAsAString(1, list);
                bl2 = string3.equals(SWRLOWLUtil.getURI(this.getOWLModel(), string));
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new BuiltInException(oWLConversionFactoryException.getMessage());
        }
        return bl2;
    }

    public boolean hasClass(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = this.isUnboundArgument(1, list);
        boolean bl2 = false;
        this.checkNumberOfArgumentsEqualTo(2, list.size());
        String string = this.getArgumentAsAnIndividualURI(0, list);
        try {
            if (this.getIsInConsequent()) {
                String string2;
                if (this.isArgumentAString(1, list)) {
                    string2 = SWRLOWLUtil.getFullName(this.getOWLModel(), this.getArgumentAsAString(1, list));
                    if (!this.getBuiltInBridge().isOWLClass(string2)) {
                        this.getBuiltInBridge().injectOWLClassDeclaration(string2);
                    }
                } else {
                    string2 = this.getArgumentAsAClassURI(1, list);
                }
                OWLClassReference oWLClassReference = this.getBuiltInBridge().getOWLDataFactory().getOWLClass(string2);
                OWLNamedIndividualReference oWLNamedIndividualReference = this.getBuiltInBridge().getOWLDataFactory().getOWLIndividual(string);
                OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference = this.getBuiltInBridge().getOWLDataFactory().getOWLClassAssertionAxiom(oWLNamedIndividualReference, oWLClassReference);
                this.getBuiltInBridge().injectOWLAxiom(oWLClassAssertionAxiomReference);
            } else if (bl) {
                MultiArgument multiArgument = this.createMultiArgument();
                for (OWLNamedClass oWLNamedClass : SWRLOWLUtil.getOWLClassesOfIndividual(this.getOWLModel(), string)) {
                    multiArgument.addArgument(this.createClassArgument(oWLNamedClass.getURI()));
                }
                list.get(1).setBuiltInResult(multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                String string3 = this.getArgumentAsAClassURI(1, list);
                bl2 = this.getBuiltInBridge().isOWLIndividualOfClass(string, string3);
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new BuiltInException(oWLConversionFactoryException.getMessage());
        }
        return bl2;
    }

    public boolean hasNumberOfPropertyValues(List<BuiltInArgument> list) throws BuiltInException {
        String string = null;
        boolean bl = this.isUnboundArgument(0, list);
        boolean bl2 = false;
        this.checkNumberOfArgumentsEqualTo(3, list.size());
        String string2 = this.getArgumentAsAnIndividualURI(1, list);
        string = this.getArgumentAsAPropertyURI(2, list);
        try {
            if (bl) {
                int n = SWRLOWLUtil.getNumberOfPropertyValues(this.getOWLModel(), string2, string, true);
                list.get(0).setBuiltInResult(this.createDataValueArgument(n));
                bl2 = true;
            } else {
                int n = this.getArgumentAsAnInteger(0, list);
                bl2 = SWRLOWLUtil.getNumberOfPropertyValues(this.getOWLModel(), string2, string, true) == n;
            }
        }
        catch (OWLConversionFactoryException oWLConversionFactoryException) {
            throw new BuiltInException(oWLConversionFactoryException.getMessage());
        }
        return bl2;
    }

    public boolean isLiteral(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, list.size());
        return this.isArgumentADataValue(0, list);
    }

    public boolean notLiteral(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, list.size());
        return !this.isArgumentADataValue(0, list);
    }

    public boolean isNumeric(List<BuiltInArgument> list) throws BuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, list.size());
        return this.isArgumentNumeric(0, list);
    }

    public boolean notNumeric(List<BuiltInArgument> list) throws BuiltInException {
        return !this.isNumeric(list);
    }

    private OWLModel getOWLModel() throws SWRLBuiltInLibraryException {
        return this.getBuiltInBridge().getActiveOntology().getOWLModel();
    }
}

