/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.TargetSWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInLibraryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.TargetSWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInMethodException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuiltInLibraryManager {
    private static String BuiltInLibraryPackageBaseName = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins.";
    private static HashMap<String, SWRLBuiltInLibrary> builtInLibraries = new HashMap();

    public static boolean invokeSWRLBuiltIn(TargetSWRLRuleEngine targetSWRLRuleEngine, SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2, int n, boolean bl, List<BuiltInArgument> list) throws BuiltInException {
        String string3 = BuiltInLibraryManager.getPrefix(sWRLBuiltInBridge, string2);
        String string4 = BuiltInLibraryManager.getBuiltInLibraryImplementationClassName(string3);
        String string5 = BuiltInLibraryManager.getBuiltInMethodName(string2);
        SWRLBuiltInLibrary sWRLBuiltInLibrary = BuiltInLibraryManager.loadBuiltInLibrary(sWRLBuiltInBridge, string, string3, string4);
        Method method = BuiltInLibraryManager.resolveBuiltInMethod(string, sWRLBuiltInLibrary, string3, string5);
        BuiltInLibraryManager.checkBuiltInMethodSignature(string, string3, string5, method);
        boolean bl2 = sWRLBuiltInLibrary.invokeBuiltInMethod(method, sWRLBuiltInBridge, string, string3, string5, n, bl, list);
        if (bl2) {
            if (BuiltInLibraryManager.hasUnboundArguments(list)) {
                throw new BuiltInException("built-in " + string2 + "(index " + n + ") in rule " + string + " returned with unbound arguments");
            }
            for (List<BuiltInArgument> list2 : BuiltInLibraryManager.generateBuiltInArgumentBindings(string, string2, n, list)) {
                try {
                    targetSWRLRuleEngine.defineBuiltInArgumentBinding(string, string2, n, list2);
                }
                catch (TargetSWRLRuleEngineException targetSWRLRuleEngineException) {
                    throw new BuiltInException("error defining argument binding for built-in " + string2 + "(index " + n + ") in rule " + string + ": " + targetSWRLRuleEngineException.getMessage());
                }
            }
        }
        return bl2;
    }

    private static SWRLBuiltInLibrary loadBuiltInLibrary(SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2, String string3) throws SWRLBuiltInLibraryException {
        SWRLBuiltInLibrary sWRLBuiltInLibrary;
        if (builtInLibraries.containsKey(string2)) {
            sWRLBuiltInLibrary = builtInLibraries.get(string2);
        } else {
            sWRLBuiltInLibrary = BuiltInLibraryManager.loadBuiltInLibraryImpl(string, string2, string3);
            builtInLibraries.put(string2, sWRLBuiltInLibrary);
            BuiltInLibraryManager.invokeBuiltInLibraryResetMethod(sWRLBuiltInBridge, sWRLBuiltInLibrary);
        }
        return sWRLBuiltInLibrary;
    }

    private static String getPrefix(SWRLBuiltInBridge sWRLBuiltInBridge, String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            return sWRLBuiltInBridge.getActiveOntology().getOWLModel().getPrefixForResourceName(string);
        }
        return "";
    }

    private static String getBuiltInLibraryImplementationClassName(String string) {
        if (string.equals("")) {
            return BuiltInLibraryPackageBaseName + "SWRLBuiltInLibraryImpl";
        }
        return BuiltInLibraryPackageBaseName + string + ".SWRLBuiltInLibraryImpl";
    }

    private static String getBuiltInMethodName(String string) {
        String string2 = string.indexOf("#") == -1 ? string : string.substring(string.indexOf("#") + 1, string.length());
        return string2;
    }

    private static void invokeBuiltInLibraryResetMethod(SWRLBuiltInBridge sWRLBuiltInBridge, SWRLBuiltInLibrary sWRLBuiltInLibrary) throws SWRLBuiltInLibraryException {
        try {
            sWRLBuiltInLibrary.invokeResetMethod(sWRLBuiltInBridge);
        }
        catch (Exception exception) {
            throw new SWRLBuiltInLibraryException("error calling reset method in built-in library " + sWRLBuiltInLibrary.getClass());
        }
    }

    public static void invokeAllBuiltInLibrariesResetMethod(SWRLBuiltInBridge sWRLBuiltInBridge) throws SWRLBuiltInLibraryException {
        for (SWRLBuiltInLibrary sWRLBuiltInLibrary : builtInLibraries.values()) {
            BuiltInLibraryManager.invokeBuiltInLibraryResetMethod(sWRLBuiltInBridge, sWRLBuiltInLibrary);
        }
    }

    public static Set<List<BuiltInArgument>> generateBuiltInArgumentBindings(String string, String string2, int n, List<BuiltInArgument> list) throws BuiltInException {
        List<Integer> list2 = BuiltInLibraryManager.getMultiArgumentIndexes(list);
        HashSet<List<BuiltInArgument>> hashSet = new HashSet<List<BuiltInArgument>>();
        if (list2.isEmpty()) {
            hashSet.add(list);
        } else {
            int n2;
            int n3 = list2.get(0);
            MultiArgument multiArgument = list.get(n3).getBuiltInMultiArgumentResult();
            int n4 = multiArgument.getNumberOfArguments();
            if (n4 < 1) {
                throw new BuiltInException("empty multi-argument for built-in " + string2 + "(index " + n + ") in rule " + string);
            }
            for (n2 = 1; n2 < list2.size(); ++n2) {
                int n5 = list2.get(n2);
                multiArgument = list.get(n5).getBuiltInMultiArgumentResult();
                if (n4 == multiArgument.getNumberOfArguments()) continue;
                throw new BuiltInException("all multi-arguments must have the same number of elements for built-in " + string2 + "(index " + n + ") in rule " + string);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                List<BuiltInArgument> list3 = BuiltInLibraryManager.generateArgumentsPattern(list, n2);
                hashSet.add(list3);
            }
        }
        return hashSet;
    }

    private static List<Integer> getMultiArgumentIndexes(List<BuiltInArgument> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).hasBuiltInMultiArgumentResult()) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static List<BuiltInArgument> generateArgumentsPattern(List<BuiltInArgument> list, int n) throws BuiltInException {
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument.hasBuiltInMultiArgumentResult()) {
                MultiArgument multiArgument = builtInArgument.getBuiltInMultiArgumentResult();
                arrayList.add(multiArgument.getArguments().get(n));
                continue;
            }
            arrayList.add(builtInArgument);
        }
        return arrayList;
    }

    private static Method resolveBuiltInMethod(String string, SWRLBuiltInLibrary sWRLBuiltInLibrary, String string2, String string3) throws UnresolvedBuiltInMethodException {
        Method method;
        try {
            method = sWRLBuiltInLibrary.getClass().getMethod(string3, List.class);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInMethodException(string, string2, string3, exception.getMessage());
        }
        return method;
    }

    private static SWRLBuiltInLibrary loadBuiltInLibraryImpl(String string, String string2, String string3) throws UnresolvedBuiltInClassException, IncompatibleBuiltInClassException, SWRLBuiltInLibraryException {
        SWRLBuiltInLibrary sWRLBuiltInLibrary;
        Class<?> clazz;
        try {
            clazz = Class.forName(string3);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInClassException(string, string2, exception.getMessage());
        }
        BuiltInLibraryManager.checkBuiltInMethodsClassCompatibility(string, string2, clazz);
        try {
            sWRLBuiltInLibrary = (SWRLBuiltInLibrary)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IncompatibleBuiltInClassException(string, string2, string3, instantiationException.getMessage());
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IncompatibleBuiltInClassException(string, string2, string3, exceptionInInitializerError.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IncompatibleBuiltInClassException(string, string2, string3, illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new IncompatibleBuiltInClassException(string, string2, string3, securityException.getMessage());
        }
        return sWRLBuiltInLibrary;
    }

    private static void checkBuiltInMethodSignature(String string, String string2, String string3, Method method) throws IncompatibleBuiltInMethodException {
        if (method.getReturnType() != Boolean.TYPE) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java method must return a boolean");
        }
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray.length != 1 || classArray[0] != BuiltInException.class) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java method must throw a single exception of type BuiltInException");
        }
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != 1 || !(typeArray[0] instanceof ParameterizedType) || ((ParameterizedType)typeArray[0]).getRawType() != List.class || ((ParameterizedType)typeArray[0]).getActualTypeArguments().length != 1 || ((ParameterizedType)typeArray[0]).getActualTypeArguments()[0] != BuiltInArgument.class) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java built-in method implementation must accept a single List of BuiltInArgument objects");
        }
    }

    private static boolean hasUnboundArguments(List<BuiltInArgument> list) {
        for (BuiltInArgument builtInArgument : list) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    private static void checkBuiltInMethodsClassCompatibility(String string, String string2, Class<?> clazz) throws IncompatibleBuiltInClassException {
        if (!SWRLBuiltInLibrary.class.isAssignableFrom(clazz)) {
            throw new IncompatibleBuiltInClassException(string, string2, clazz.getName(), "Java class does not extend SWRLBuiltInLibrary");
        }
    }
}

