/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.CollectionArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DataPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ObjectPropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.PropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLBuiltInBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInMethodRuntimeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentNumberException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLBuiltInLibraryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.XSDType;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLIndividualArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLLiteralArgumentReference;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DataValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.DataValueConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWRLBuiltInLibrary
implements SWRLBuiltInLibrary {
    private String libraryName;
    private SWRLBuiltInBridge invokingBridge;
    private String invokingRuleName = "";
    private int invokingBuiltInIndex = -1;
    private boolean isInConsequent = false;
    private ArgumentFactory argumentFactory;
    private Long invocationPatternID;
    private Map<String, Long> invocationPatternMap;

    public AbstractSWRLBuiltInLibrary(String string) {
        this.libraryName = string;
        this.argumentFactory = ArgumentFactory.getFactory();
        this.invocationPatternID = 0L;
        this.invocationPatternMap = new HashMap<String, Long>();
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public SWRLBuiltInBridge getBuiltInBridge() throws SWRLBuiltInLibraryException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to getInvokingBridge - should only be called from within a built-in");
        }
        return this.invokingBridge;
    }

    @Override
    public String getInvokingRuleName() throws SWRLBuiltInLibraryException {
        if (this.invokingRuleName.equals("")) {
            throw new SWRLBuiltInLibraryException("invalid call to getInvokingRuleName - should only be called from within a built-in");
        }
        return this.invokingRuleName;
    }

    @Override
    public int getInvokingBuiltInIndex() throws SWRLBuiltInLibraryException {
        if (this.invokingBuiltInIndex == -1) {
            throw new SWRLBuiltInLibraryException("invalid call to getInvokingBuiltInIndex - should only be called from within a built-in");
        }
        return this.invokingBuiltInIndex;
    }

    @Override
    public boolean getIsInConsequent() throws SWRLBuiltInLibraryException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to getIsInConsequent - should only be called from within a built-in");
        }
        return this.isInConsequent;
    }

    @Override
    public void checkThatInConsequent() throws BuiltInException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to checkThatInConsequent - should only be called from within a built-in");
        }
        if (!this.isInConsequent) {
            throw new BuiltInException("built-in can only be used in consequent");
        }
    }

    @Override
    public void checkThatInAntecedent() throws BuiltInException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to checkThatInAntecedent - should only be called from within a built-in");
        }
        if (this.isInConsequent) {
            throw new BuiltInException("built-in can only be used in antecedent");
        }
    }

    @Override
    public abstract void reset() throws SWRLBuiltInLibraryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeResetMethod(SWRLBuiltInBridge sWRLBuiltInBridge) throws SWRLBuiltInLibraryException {
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = sWRLBuiltInBridge;
            this.reset();
            this.invocationPatternID = 0L;
            this.invocationPatternMap = new HashMap<String, Long>();
            this.invokingBridge = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeBuiltInMethod(Method method, SWRLBuiltInBridge sWRLBuiltInBridge, String string, String string2, String string3, int n, boolean bl, List<BuiltInArgument> list) throws BuiltInException {
        Boolean bl2 = null;
        String string4 = string2 + ":" + string3;
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = sWRLBuiltInBridge;
            this.invokingRuleName = string;
            this.invokingBuiltInIndex = n;
            this.isInConsequent = bl;
            try {
                bl2 = (Boolean)method.invoke((Object)this, list);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuiltInException) {
                    throw new BuiltInException("exception thrown by built-in " + string4 + " in rule " + string + ": " + throwable.getMessage(), throwable);
                }
                if (throwable instanceof RuntimeException) {
                    throw new BuiltInMethodRuntimeException(string, string4, throwable.getMessage(), throwable);
                }
                throw new BuiltInException("unknown exception thrown by built-in " + string4 + " in rule " + string + ": " + invocationTargetException.toString(), invocationTargetException);
            }
            catch (Throwable throwable) {
                throw new SWRLBuiltInLibraryException("internal built-in library exception when invoking built-in " + string4 + " in rule " + string + ": " + throwable.getMessage(), throwable);
            }
            this.invokingBridge = null;
            this.invokingRuleName = "";
            this.invokingBuiltInIndex = -1;
            this.isInConsequent = false;
        }
        return bl2;
    }

    public void checkNumberOfArgumentsAtLeastOne(List<BuiltInArgument> list) throws BuiltInException {
        if (list.size() < 1) {
            throw new InvalidBuiltInArgumentNumberException(1, 0, "at least");
        }
    }

    @Override
    public void checkNumberOfArgumentsEqualTo(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n != n2) {
            throw new InvalidBuiltInArgumentNumberException(n, n2);
        }
    }

    @Override
    public void checkNumberOfArgumentsAtLeast(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 < n) {
            throw new InvalidBuiltInArgumentNumberException(n, n2, "at least");
        }
    }

    @Override
    public void checkNumberOfArgumentsAtMost(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 > n) {
            throw new InvalidBuiltInArgumentNumberException(n, n2, "at most");
        }
    }

    @Override
    public void checkNumberOfArgumentsInRange(int n, int n2, int n3) throws InvalidBuiltInArgumentNumberException {
        if (n3 > n2 || n3 < n) {
            throw new InvalidBuiltInArgumentNumberException(n2, n3, n + " to");
        }
    }

    @Override
    public void checkThatAllArgumentsAreDataValues(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsADataValue(i, list);
        }
    }

    @Override
    public void checkThatAllArgumentsAreNumeric(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsNumeric(i, list);
        }
    }

    @Override
    public void checkThatAllArgumentsAreIntegers(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsAnInteger(i, list);
        }
    }

    @Override
    public boolean areAllArgumentsShorts(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentAShort(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsIntegers(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentAnInteger(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsLongs(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentALong(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsFloats(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentAFloat(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsDoubles(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isArgumentConvertableToDouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list);
    }

    @Override
    public boolean isArgumentConvertableToFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list) && this.isArgumentAShort(n, list) && this.isArgumentAnInteger(n, list) && this.isArgumentALong(n, list) && this.isArgumentAFloat(n, list);
    }

    @Override
    public boolean isArgumentConvertableToLong(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list) && this.isArgumentAShort(n, list) && this.isArgumentAnInteger(n, list) && this.isArgumentALong(n, list);
    }

    @Override
    public boolean isArgumentConvertableToInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list) && this.isArgumentAShort(n, list) && this.isArgumentAnInteger(n, list);
    }

    @Override
    public boolean isArgumentConvertableToShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list) && this.isArgumentAShort(n, list);
    }

    @Override
    public boolean isShortMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isArgumentAnInteger(i, list) && !this.isArgumentALong(i, list) && !this.isArgumentAFloat(i, list) && !this.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIntegerMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isArgumentALong(i, list) && !this.isArgumentAFloat(i, list) && !this.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLongMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isArgumentADouble(i, list) && !this.isArgumentAFloat(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFloatMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsBooleans(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentABoolean(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentDataValues(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentADataValue(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsNumeric(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentNumeric(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsStrings(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentAString(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsOfAnOrderedType(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.isArgumentOfAnOrderedType(i, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkThatAllArgumentsAreFloats(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsAFloat(i, list);
        }
    }

    @Override
    public void checkThatAllArgumentsAreStrings(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsAString(i, list);
        }
    }

    @Override
    public void checkThatAllArgumentsAreOfAnOrderedType(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            this.checkThatArgumentIsOfAnOrderedType(i, list);
        }
    }

    public void checkThatArgumentIsADataValue(BuiltInArgument builtInArgument) throws BuiltInException {
        if (!(builtInArgument instanceof SWRLLiteralArgumentReference)) {
            throw new InvalidBuiltInArgumentException(this.makeInvalidArgumentTypeMessage(builtInArgument, "data value"));
        }
    }

    @Override
    public void checkThatArgumentIsNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "numeric"));
        }
    }

    @Override
    public void checkThatArgumentIsOfAnOrderedType(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentOfAnOrderedType(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "ordered type"));
        }
    }

    @Override
    public boolean isArgumentOfAnOrderedType(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentNumeric(n, list) || this.isArgumentAString(n, list);
    }

    @Override
    public boolean isArgumentAnIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return list.get(n) instanceof SWRLIndividualArgumentReference;
    }

    public boolean isArgumentADatatypeValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return list.get(n) instanceof SWRLLiteralArgumentReference;
    }

    @Override
    public void checkThatArgumentIsAnIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAnIndividual(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "individual"));
        }
    }

    @Override
    public void checkThatArgumentIsADataValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentADatatypeValue(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "data value"));
        }
    }

    @Override
    public String getArgumentAsAnIndividualURI(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAnIndividual(n, list);
        return ((SWRLIndividualArgumentReference)list.get(n)).getURI();
    }

    @Override
    public SWRLIndividualArgumentReference getArgumentAsAnIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAnIndividual(n, list);
        return (SWRLIndividualArgumentReference)list.get(n);
    }

    @Override
    public String getArgumentAsAClassURI(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAClass(n, list);
        return ((ClassArgument)list.get(n)).getURI();
    }

    @Override
    public ClassArgument getArgumentAsAClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAClass(n, list);
        return (ClassArgument)list.get(n);
    }

    public PropertyArgument getArgumentAsAProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAProperty(n, list);
        return (PropertyArgument)list.get(n);
    }

    @Override
    public ObjectPropertyArgument getArgumentAsAnObjectProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAnObjectProperty(n, list);
        return (ObjectPropertyArgument)list.get(n);
    }

    @Override
    public DataPropertyArgument getArgumentAsADataProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsADataProperty(n, list);
        return (DataPropertyArgument)list.get(n);
    }

    @Override
    public String getArgumentAsAURI(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string = "";
        this.checkThatArgumentIsAClassPropertyOrIndividual(n, list);
        if (this.isArgumentAClass(n, list)) {
            string = ((ClassArgument)list.get(n)).getURI();
        } else if (this.isArgumentAProperty(n, list)) {
            string = ((PropertyArgument)list.get(n)).getURI();
        } else if (this.isArgumentAnIndividual(n, list)) {
            string = ((SWRLIndividualArgumentReference)list.get(n)).getURI();
        }
        return string;
    }

    @Override
    public String getArgumentAsAPropertyURI(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAProperty(n, list);
        return ((PropertyArgument)list.get(n)).getURI();
    }

    @Override
    public void checkArgumentNumber(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (n < 0 || n >= list.size()) {
            throw new BuiltInException("(0-offset) argument number #" + n + " is out of bounds");
        }
    }

    @Override
    public boolean isArgumentNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isNumeric();
        }
        return false;
    }

    @Override
    public boolean isArgumentNonNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return !this.getArgumentAsADataValue(n, list).isNumeric();
        }
        return false;
    }

    @Override
    public void checkThatArgumentIsNonNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentNonNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "non-numeric"));
        }
    }

    @Override
    public void checkThatArgumentIsAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAnInteger(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "integer"));
        }
    }

    @Override
    public boolean isArgumentAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isInteger();
        }
        return false;
    }

    @Override
    public int getArgumentAsAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.getArgumentAsADataValue(n, list).getInt();
    }

    @Override
    public int getArgumentAsAPositiveInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        int n2 = this.getArgumentAsADataValue(n, list).getInt();
        if (n2 < 0) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "expecting positive integer"));
        }
        return n2;
    }

    @Override
    public boolean isArgumentAShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isShort();
        }
        return false;
    }

    @Override
    public short getArgumentAsAShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.getArgumentAsADataValue(n, list).getShort();
    }

    @Override
    public boolean isArgumentADataValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof SWRLLiteralArgumentReference;
    }

    @Override
    public boolean isArgumentAProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof PropertyArgument;
    }

    @Override
    public boolean isArgumentADataProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof DataPropertyArgument;
    }

    @Override
    public boolean isArgumentAnObjectProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof ObjectPropertyArgument;
    }

    @Override
    public void checkThatArgumentIsAProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAProperty(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "property"));
        }
    }

    @Override
    public void checkThatArgumentIsAnObjectProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAnObjectProperty(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "object property"));
        }
    }

    @Override
    public void checkThatArgumentIsADataProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentADataProperty(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "data property"));
        }
    }

    @Override
    public void checkThatArgumentIsAClassPropertyOrIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAClassPropertyOrIndividual(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "class, property, or individual"));
        }
    }

    @Override
    public boolean isArgumentAClassPropertyOrIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.isArgumentAClass(n, list) || this.isArgumentAProperty(n, list) || this.isArgumentAnIndividual(n, list);
    }

    @Override
    public boolean isArgumentAClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof ClassArgument;
    }

    @Override
    public void checkThatArgumentIsAClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAClass(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "class"));
        }
    }

    @Override
    public DataValue getArgumentAsADataValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsADataValue(n, list);
        return ((SWRLLiteralArgumentReference)list.get(n)).getLiteral();
    }

    @Override
    public DataValue getArgumentAsADataValue(BuiltInArgument builtInArgument) throws BuiltInException {
        this.checkThatArgumentIsADataValue(builtInArgument);
        return ((SWRLLiteralArgumentReference)builtInArgument).getLiteral();
    }

    @Override
    public void checkThatArgumentIsALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentALong(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "long"));
        }
    }

    @Override
    public boolean isArgumentALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isLong();
        }
        return false;
    }

    @Override
    public long getArgumentAsALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.getArgumentAsADataValue(n, list).getLong();
    }

    @Override
    public long getArgumentAsAPositiveLong(int n, List<BuiltInArgument> list) throws BuiltInException {
        long l = this.getArgumentAsADataValue(n, list).getLong();
        if (l < 0L) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "expecting positive long"));
        }
        return l;
    }

    @Override
    public void checkThatArgumentIsAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAFloat(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "float"));
        }
    }

    @Override
    public boolean isArgumentAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isFloat();
        }
        return false;
    }

    @Override
    public float getArgumentAsAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        return this.getArgumentAsADataValue(n, list).getFloat();
    }

    @Override
    public float getArgumentAsAFloat(BuiltInArgument builtInArgument) throws BuiltInException {
        return this.getArgumentAsADataValue(builtInArgument).getFloat();
    }

    @Override
    public void checkThatArgumentIsADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentADouble(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "double"));
        }
    }

    @Override
    public boolean isArgumentADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isDouble();
        }
        return false;
    }

    @Override
    public double getArgumentAsADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return this.getArgumentAsADouble(list.get(n));
    }

    @Override
    public double getArgumentAsADouble(BuiltInArgument builtInArgument) throws BuiltInException {
        return this.getArgumentAsADataValue(builtInArgument).getDouble();
    }

    @Override
    public void checkThatArgumentIsABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentABoolean(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "boolean"));
        }
    }

    @Override
    public boolean isArgumentABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isBoolean();
        }
        return false;
    }

    @Override
    public boolean getArgumentAsABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsABoolean(n, list);
        return this.getArgumentAsADataValue(n, list).getBoolean();
    }

    @Override
    public void checkThatArgumentIsAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!this.isArgumentAString(n, list)) {
            throw new InvalidBuiltInArgumentException(n, this.makeInvalidArgumentTypeMessage(list.get(n), "string"));
        }
    }

    @Override
    public boolean isArgumentAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isArgumentADataValue(n, list)) {
            return this.getArgumentAsADataValue(n, list).isString();
        }
        return false;
    }

    @Override
    public String getArgumentAsAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkThatArgumentIsAString(n, list);
        return this.getArgumentAsADataValue(n, list).getString();
    }

    @Override
    public boolean hasUnboundArguments(List<BuiltInArgument> list) throws BuiltInException {
        for (BuiltInArgument builtInArgument : list) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkThatAllArgumentsAreBound(List<BuiltInArgument> list) throws BuiltInException {
        if (this.hasUnboundArguments(list)) {
            throw new BuiltInException("all arguments must be bound");
        }
    }

    @Override
    public void checkThatArgumentIsBound(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (this.isUnboundArgument(n, list)) {
            throw new BuiltInException("not expecting an unbound argument for (0-offset) argument #" + n);
        }
    }

    @Override
    public boolean isUnboundArgument(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return list.get(n).isUnbound();
    }

    public boolean isBoundArgument(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return list.get(n).isBound();
    }

    @Override
    public int getFirstUnboundArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isUnbound()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void checkForUnboundArguments(List<BuiltInArgument> list) throws BuiltInException {
        this.checkForUnboundArguments(list, "built-in does not support variable binding - unbound argument '" + this.getFirstUnboundArgument(list) + "'");
    }

    @Override
    public void checkForUnboundArguments(List<BuiltInArgument> list, String string) throws BuiltInException {
        if (this.hasUnboundArguments(list)) {
            throw new BuiltInException(string + " (0-offset) argument #" + this.getFirstUnboundArgument(list));
        }
    }

    @Override
    public void checkForNonVariableArguments(List<BuiltInArgument> list, String string) throws BuiltInException {
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument.isVariable()) continue;
            throw new BuiltInException(string + " '" + builtInArgument + "'");
        }
    }

    @Override
    public void checkForUnboundNonFirstArguments(List<BuiltInArgument> list) throws BuiltInException {
        if (this.hasUnboundArguments(list.subList(1, list.size()))) {
            throw new BuiltInException("built-in supports variable binding only for the first argument - unbound variables used as other arguments");
        }
    }

    @Override
    public String getVariableName(int n, List<BuiltInArgument> list) throws BuiltInException {
        this.checkArgumentNumber(n, list);
        return list.get(n).getVariableName();
    }

    private String makeInvalidArgumentTypeMessage(BuiltInArgument builtInArgument, String string) throws BuiltInException {
        String string2 = "expecting " + string + ", got ";
        if (builtInArgument.isUnbound()) {
            string2 = string2 + "unbound argument with variable name '" + builtInArgument.getVariableName() + "'";
        } else if (builtInArgument instanceof ClassArgument) {
            ClassArgument classArgument = (ClassArgument)builtInArgument;
            string2 = string2 + "class with URI " + classArgument.getURI();
        } else if (builtInArgument instanceof PropertyArgument) {
            PropertyArgument propertyArgument = (PropertyArgument)builtInArgument;
            string2 = string2 + "property with URI " + propertyArgument.getURI();
        } else if (builtInArgument instanceof SWRLIndividualArgumentReference) {
            SWRLIndividualArgumentReference sWRLIndividualArgumentReference = (SWRLIndividualArgumentReference)builtInArgument;
            string2 = string2 + "individual with URI " + sWRLIndividualArgumentReference.getURI();
        } else if (builtInArgument instanceof SWRLLiteralArgumentReference) {
            SWRLLiteralArgumentReference sWRLLiteralArgumentReference = (SWRLLiteralArgumentReference)builtInArgument;
            string2 = string2 + "data value with value " + sWRLLiteralArgumentReference.toString();
        } else {
            string2 = string2 + "unknown type " + builtInArgument.getClass();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getArgumentAsAPropertyValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string = null;
        this.checkThatArgumentIsBound(n, list);
        BuiltInArgument builtInArgument = list.get(n);
        if (builtInArgument instanceof ClassArgument) {
            ClassArgument classArgument = (ClassArgument)builtInArgument;
            return classArgument.getURI();
        }
        if (builtInArgument instanceof PropertyArgument) {
            PropertyArgument propertyArgument = (PropertyArgument)builtInArgument;
            return propertyArgument.getURI();
        }
        if (builtInArgument instanceof SWRLIndividualArgumentReference) {
            SWRLIndividualArgumentReference sWRLIndividualArgumentReference = (SWRLIndividualArgumentReference)builtInArgument;
            return sWRLIndividualArgumentReference.getURI();
        }
        if (!(builtInArgument instanceof SWRLLiteralArgumentReference)) throw new BuiltInException("argument " + builtInArgument + " of unknown type " + builtInArgument.getClass());
        DataValue dataValue = this.getArgumentAsADataValue(builtInArgument);
        if (dataValue.isNumeric()) {
            return dataValue.getNumber();
        }
        if (!dataValue.isString()) throw new BuiltInException("data value with value " + ((Object)dataValue).toString() + " not supported - strings and number data values only");
        return dataValue.getString();
    }

    @Override
    public String createInvocationPattern(SWRLBuiltInBridge sWRLBuiltInBridge, String string, int n, boolean bl, List<BuiltInArgument> list) throws BuiltInException {
        String string2;
        String string3 = "" + sWRLBuiltInBridge.hashCode() + "." + string + "." + n + "." + bl;
        for (int i = 0; i < list.size(); ++i) {
            string3 = string3 + "." + this.getArgumentAsAPropertyValue(i, list);
        }
        if (this.invocationPatternMap.containsKey(string3)) {
            string2 = this.invocationPatternMap.get(string3).toString();
        } else {
            this.invocationPatternMap.put(string3, this.invocationPatternID);
            string2 = this.invocationPatternID.toString();
            Long l = this.invocationPatternID;
            Long l2 = this.invocationPatternID = Long.valueOf(this.invocationPatternID + 1L);
        }
        return string2;
    }

    @Override
    public void checkForUnboundArguments(String string, String string2, List<BuiltInArgument> list) throws BuiltInException {
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument.isUnbound()) {
                throw new BuiltInException("built-in " + string2 + " in rule " + string + " " + "returned with unbound argument ?" + builtInArgument.getVariableName());
            }
            if (!(builtInArgument instanceof MultiArgument) || !((MultiArgument)builtInArgument).hasNoArguments()) continue;
            throw new BuiltInException("built-in " + string2 + " in rule " + string + " " + "returned with empty multi-argument ?" + builtInArgument.getVariableName());
        }
    }

    @Override
    public List<BuiltInArgument> copyArguments(List<BuiltInArgument> list) throws BuiltInException {
        return new ArrayList<BuiltInArgument>(list);
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, Collection<BuiltInArgument> collection) throws BuiltInException {
        boolean bl = false;
        this.checkArgumentNumber(n, list);
        if (this.isUnboundArgument(n, list)) {
            MultiArgument multiArgument = this.argumentFactory.createMultiArgument();
            for (BuiltInArgument builtInArgument : collection) {
                multiArgument.addArgument(builtInArgument);
            }
            list.get(n).setBuiltInResult(multiArgument);
            bl = !multiArgument.hasNoArguments();
        } else {
            BuiltInArgument builtInArgument = list.get(n);
            bl = collection.contains(builtInArgument);
        }
        return bl;
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, BuiltInArgument builtInArgument) throws BuiltInException {
        boolean bl = false;
        this.checkArgumentNumber(n, list);
        if (this.isUnboundArgument(n, list)) {
            list.get(n).setBuiltInResult(builtInArgument);
            bl = true;
        } else {
            BuiltInArgument builtInArgument2 = list.get(n);
            bl = builtInArgument2.equals(builtInArgument);
        }
        return bl;
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, SWRLLiteralArgumentReference sWRLLiteralArgumentReference) throws BuiltInException {
        boolean bl = false;
        this.checkArgumentNumber(n, list);
        if (this.isUnboundArgument(n, list)) {
            list.get(n).setBuiltInResult(sWRLLiteralArgumentReference);
            bl = true;
        } else {
            DataValue dataValue = this.getArgumentAsADataValue(n, list);
            bl = dataValue.equals(sWRLLiteralArgumentReference.getLiteral());
        }
        return bl;
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, short s) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(s));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(n2));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, long l) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(l));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, float f) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(f));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, double d) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(d));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, byte by) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument((short)by));
    }

    @Override
    public boolean processResultArgument(List<BuiltInArgument> list, int n, String string) throws BuiltInException {
        return this.processResultArgument(list, n, this.argumentFactory.createDataValueArgument(string));
    }

    @Override
    public ClassArgument createClassArgument(String string) {
        return this.argumentFactory.createClassArgument(string);
    }

    @Override
    public SWRLIndividualArgumentReference createIndividualArgument(String string) {
        return this.argumentFactory.createIndividualArgument(string);
    }

    @Override
    public ObjectPropertyArgument createObjectPropertyArgument(String string) {
        return this.argumentFactory.createObjectPropertyArgument(string);
    }

    @Override
    public DataPropertyArgument createDataPropertyArgument(String string) {
        return this.argumentFactory.createDataPropertyArgument(string);
    }

    public SWRLLiteralArgumentReference createDataValueArgument(DataValue dataValue) {
        return this.argumentFactory.createDataValueArgument(dataValue);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(String string) {
        return this.argumentFactory.createDataValueArgument(string);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(boolean bl) {
        return this.argumentFactory.createDataValueArgument(bl);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(int n) {
        return this.argumentFactory.createDataValueArgument(n);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(long l) {
        return this.argumentFactory.createDataValueArgument(l);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(float f) {
        return this.argumentFactory.createDataValueArgument(f);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(double d) {
        return this.argumentFactory.createDataValueArgument(d);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(short s) {
        return this.argumentFactory.createDataValueArgument(s);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(Byte by) {
        return this.argumentFactory.createDataValueArgument(by);
    }

    @Override
    public SWRLLiteralArgumentReference createDataValueArgument(XSDType xSDType) {
        return this.argumentFactory.createDataValueArgument(xSDType);
    }

    public SWRLLiteralArgumentReference createDataValueArgument(Object object) throws DataValueConversionException {
        return this.argumentFactory.createDataValueArgument(object);
    }

    @Override
    public MultiArgument createMultiArgument() {
        return this.argumentFactory.createMultiArgument();
    }

    @Override
    public MultiArgument createMultiArgument(List<BuiltInArgument> list) {
        return this.argumentFactory.createMultiArgument(list);
    }

    public CollectionArgument createCollectionArgument(String string, String string2) {
        return this.argumentFactory.createCollectionArgument(string, string2);
    }
}

