/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.TargetSWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidSWRLRuleEngineNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.NoRegisteredRuleEnginesException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.DefaultSWRLBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.DefaultSWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.OWLAxiomProcessorImpl;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.portability.p3.P3OWLOntology;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLRuleEngineFactory {
    private static final transient Logger log = Log.getLogger(SWRLRuleEngineFactory.class);
    private static HashMap<String, TargetSWRLRuleEngineCreator> registeredSWRLRuleEngines = new HashMap();

    public static void registerRuleEngine(String string, TargetSWRLRuleEngineCreator targetSWRLRuleEngineCreator) {
        if (registeredSWRLRuleEngines.containsKey(string)) {
            registeredSWRLRuleEngines.remove(string);
            registeredSWRLRuleEngines.put(string, targetSWRLRuleEngineCreator);
        } else {
            registeredSWRLRuleEngines.put(string, targetSWRLRuleEngineCreator);
        }
        log.info("Rule engine '" + string + "' registered with the SWRLTab.");
    }

    public static boolean isRuleEngineRegistered(String string) {
        return registeredSWRLRuleEngines.containsKey(string);
    }

    public static Set<String> getRegisteredRuleEngineNames() {
        return registeredSWRLRuleEngines.keySet();
    }

    public static SWRLRuleEngine create(OWLModel oWLModel) throws SWRLRuleEngineException {
        if (!registeredSWRLRuleEngines.isEmpty()) {
            String string = ApplicationProperties.getString((String)"protege.owl.swrl.default_rule_engine", (String)"SWRLJessBridge");
            if (!registeredSWRLRuleEngines.containsKey(string)) {
                return SWRLRuleEngineFactory.create(registeredSWRLRuleEngines.keySet().iterator().next(), oWLModel);
            }
            return SWRLRuleEngineFactory.create(string, oWLModel);
        }
        throw new NoRegisteredRuleEnginesException();
    }

    public static SWRLRuleEngine create(String string, OWLModel oWLModel) throws SWRLRuleEngineException {
        DefaultSWRLRuleEngine defaultSWRLRuleEngine = null;
        DefaultSWRLBridge defaultSWRLBridge = null;
        TargetSWRLRuleEngine targetSWRLRuleEngine = null;
        if (registeredSWRLRuleEngines.containsKey(string)) {
            try {
                P3OWLOntology p3OWLOntology = new P3OWLOntology(oWLModel);
                OWLAxiomProcessorImpl oWLAxiomProcessorImpl = new OWLAxiomProcessorImpl(p3OWLOntology);
                defaultSWRLBridge = new DefaultSWRLBridge(p3OWLOntology, oWLAxiomProcessorImpl);
                targetSWRLRuleEngine = registeredSWRLRuleEngines.get(string).create(defaultSWRLBridge);
                defaultSWRLBridge.setTargetRuleEngine(targetSWRLRuleEngine);
                defaultSWRLRuleEngine = new DefaultSWRLRuleEngine(p3OWLOntology, oWLAxiomProcessorImpl, targetSWRLRuleEngine, defaultSWRLBridge, defaultSWRLBridge);
            }
            catch (Throwable throwable) {
                throw new SWRLRuleEngineException("Error creating rule engine '" + string + "': " + throwable.getMessage());
            }
        } else {
            throw new InvalidSWRLRuleEngineNameException(string);
        }
        return defaultSWRLRuleEngine;
    }

    public static void unregisterSWRLRuleEngine(String string) {
        if (registeredSWRLRuleEngines.containsKey(string)) {
            registeredSWRLRuleEngines.remove(string);
        }
    }

    static {
        Class clazz = PluginUtilities.forName((String)"edu.stanford.smi.protegex.owl.swrl.bridge.jess.JessSWRLRuleEngine", (boolean)true);
        if (clazz == null) {
            System.err.println("SWRLJessBridge load failed - could not find class");
        }
    }

    public static interface TargetSWRLRuleEngineCreator {
        public TargetSWRLRuleEngine create(SWRLRuleEngineBridge var1) throws SWRLRuleEngineBridgeException;
    }
}

