/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.swrl.bridge.DefaultConvertor;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLAxiomConvertor;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.TargetSWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDeclarationAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDifferentIndividualsAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLEntityReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLLiteralReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSameIndividualAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLSubClassAxiomReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultOWLAxiomConvertor
extends DefaultConvertor
implements OWLAxiomConvertor {
    protected abstract void defineOWLClassDeclaration(String var1) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLIndividualDeclaration(String var1) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLPropertyDeclaration(String var1) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLClassAssertionAxiom(String var1, String var2) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLObjectPropertyAssertionAxiom(String var1, String var2, String var3) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLDataPropertyAssertionAxiom(String var1, String var2, OWLLiteralReference var3) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLSameIndividualAxiom(String var1, String var2) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLDifferentIndividualsAxiom(String var1, String var2) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLClassPropertyAssertion(String var1, String var2, String var3) throws TargetSWRLRuleEngineException;

    protected abstract void defineOWLPropertyPropertyAssertion(String var1, String var2, String var3) throws TargetSWRLRuleEngineException;

    public DefaultOWLAxiomConvertor(SWRLRuleEngineBridge sWRLRuleEngineBridge) {
        super(sWRLRuleEngineBridge);
    }

    @Override
    public void generateOWLAxiom(OWLAxiomReference oWLAxiomReference) throws TargetSWRLRuleEngineException {
        if (oWLAxiomReference instanceof OWLDataPropertyAssertionAxiomReference) {
            OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference = (OWLDataPropertyAssertionAxiomReference)oWLAxiomReference;
            this.generateOWLDataPropertyAssertionAxiom(oWLDataPropertyAssertionAxiomReference);
        } else if (oWLAxiomReference instanceof OWLObjectPropertyAssertionAxiomReference) {
            OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference = (OWLObjectPropertyAssertionAxiomReference)oWLAxiomReference;
            this.generateOWLObjectPropertyAssertionAxiom(oWLObjectPropertyAssertionAxiomReference);
        } else if (oWLAxiomReference instanceof OWLClassPropertyAssertionAxiomReference) {
            OWLClassPropertyAssertionAxiomReference oWLClassPropertyAssertionAxiomReference = (OWLClassPropertyAssertionAxiomReference)oWLAxiomReference;
            this.generateOWLClassPropertyAssertionAxiom(oWLClassPropertyAssertionAxiomReference);
        } else if (oWLAxiomReference instanceof OWLPropertyPropertyAssertionAxiomReference) {
            OWLPropertyPropertyAssertionAxiomReference oWLPropertyPropertyAssertionAxiomReference = (OWLPropertyPropertyAssertionAxiomReference)oWLAxiomReference;
            this.generateOWLPropertyPropertyAssertionAxiom(oWLPropertyPropertyAssertionAxiomReference);
        } else if (oWLAxiomReference instanceof OWLSameIndividualAxiomReference) {
            OWLSameIndividualAxiomReference oWLSameIndividualAxiomReference = (OWLSameIndividualAxiomReference)oWLAxiomReference;
            this.generateOWLSameIndividualAxiom(oWLSameIndividualAxiomReference);
        } else if (oWLAxiomReference instanceof OWLDifferentIndividualsAxiomReference) {
            OWLDifferentIndividualsAxiomReference oWLDifferentIndividualsAxiomReference = (OWLDifferentIndividualsAxiomReference)oWLAxiomReference;
            this.generateOWLDifferentIndividualsAxiom(oWLDifferentIndividualsAxiomReference);
        } else if (oWLAxiomReference instanceof OWLClassAssertionAxiomReference) {
            OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference = (OWLClassAssertionAxiomReference)oWLAxiomReference;
            this.generateOWLClassAssertionAxiom(oWLClassAssertionAxiomReference);
        } else if (oWLAxiomReference instanceof OWLDeclarationAxiomReference) {
            OWLDeclarationAxiomReference oWLDeclarationAxiomReference = (OWLDeclarationAxiomReference)oWLAxiomReference;
            this.generateOWLDeclarationAxiom(oWLDeclarationAxiomReference);
        } else if (oWLAxiomReference instanceof OWLSubClassAxiomReference) {
            OWLSubClassAxiomReference oWLSubClassAxiomReference = (OWLSubClassAxiomReference)oWLAxiomReference;
            this.generateOWLSubclassAxiom(oWLSubClassAxiomReference);
        } else {
            throw new TargetSWRLRuleEngineException("OWL axiom " + oWLAxiomReference.getClass() + " not supported");
        }
    }

    public void generateOWLClassDeclaration(OWLClassReference oWLClassReference) throws TargetSWRLRuleEngineException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(oWLClassReference.getURI());
        for (String string : hashSet) {
            this.defineOWLClassDeclaration(string);
        }
    }

    public void generateOWLPropertyDeclaration(OWLPropertyReference oWLPropertyReference) throws TargetSWRLRuleEngineException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(oWLPropertyReference.getURI());
        for (String string : hashSet) {
            this.defineOWLPropertyDeclaration(string);
        }
    }

    public void generateOWLIndividualDeclaration(OWLNamedIndividualReference oWLNamedIndividualReference) throws TargetSWRLRuleEngineException {
        String string = oWLNamedIndividualReference.getURI();
        this.defineOWLIndividualDeclaration(string);
    }

    @Override
    public void generateOWLClassAssertionAxiom(OWLClassAssertionAxiomReference oWLClassAssertionAxiomReference) throws TargetSWRLRuleEngineException {
        HashSet<OWLClassReference> hashSet = new HashSet<OWLClassReference>();
        String string = oWLClassAssertionAxiomReference.getIndividual().getURI();
        hashSet.add(oWLClassAssertionAxiomReference.getDescription());
        this.calculateTransitiveSuperAndEquivalentClassClosure(oWLClassAssertionAxiomReference.getIndividual().getTypes(), hashSet);
        for (OWLClassReference oWLClassReference : hashSet) {
            String string2;
            String string3 = oWLClassReference.getURI();
            this.defineOWLClassAssertionAxiom(string3, string);
            for (OWLNamedIndividualReference oWLNamedIndividualReference : oWLClassAssertionAxiomReference.getIndividual().getSameIndividuals()) {
                string2 = oWLNamedIndividualReference.getURI();
                this.defineOWLSameIndividualAxiom(string, string2);
                this.defineOWLClassAssertionAxiom(string3, string2);
            }
            for (OWLNamedIndividualReference oWLNamedIndividualReference : oWLClassAssertionAxiomReference.getIndividual().getDifferentIndividuals()) {
                string2 = oWLNamedIndividualReference.getURI();
                this.defineOWLDifferentIndividualsAxiom(string, string2);
            }
        }
        this.defineOWLSameIndividualAxiom(string, string);
    }

    @Override
    public void generateOWLDataPropertyAssertionAxiom(OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference) throws TargetSWRLRuleEngineException {
        OWLPropertyReference oWLPropertyReference = oWLDataPropertyAssertionAxiomReference.getProperty();
        HashSet<OWLPropertyReference> hashSet = new HashSet<OWLPropertyReference>();
        OWLNamedIndividualReference oWLNamedIndividualReference = oWLDataPropertyAssertionAxiomReference.getSubject();
        HashSet<OWLNamedIndividualReference> hashSet2 = new HashSet<OWLNamedIndividualReference>();
        OWLLiteralReference oWLLiteralReference = oWLDataPropertyAssertionAxiomReference.getObject();
        hashSet.add(oWLPropertyReference);
        this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getSuperProperties(), hashSet);
        hashSet2.add(oWLNamedIndividualReference);
        hashSet2.addAll(oWLNamedIndividualReference.getSameIndividuals());
        for (OWLPropertyReference oWLPropertyReference2 : hashSet) {
            String string = oWLPropertyReference2.getURI();
            for (OWLNamedIndividualReference oWLNamedIndividualReference2 : hashSet2) {
                String string2 = oWLNamedIndividualReference2.getURI();
                this.defineOWLDataPropertyAssertionAxiom(string, string2, oWLLiteralReference);
            }
        }
    }

    @Override
    public void generateOWLObjectPropertyAssertionAxiom(OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference) throws TargetSWRLRuleEngineException {
        OWLPropertyReference oWLPropertyReference = oWLObjectPropertyAssertionAxiomReference.getProperty();
        HashSet<OWLPropertyReference> hashSet = new HashSet<OWLPropertyReference>();
        OWLNamedIndividualReference oWLNamedIndividualReference = oWLObjectPropertyAssertionAxiomReference.getSubject();
        OWLNamedIndividualReference oWLNamedIndividualReference2 = oWLObjectPropertyAssertionAxiomReference.getObject();
        HashSet<OWLNamedIndividualReference> hashSet2 = new HashSet<OWLNamedIndividualReference>();
        HashSet<OWLNamedIndividualReference> hashSet3 = new HashSet<OWLNamedIndividualReference>();
        hashSet.add(oWLPropertyReference);
        this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getTypes(), hashSet);
        hashSet2.add(oWLNamedIndividualReference);
        hashSet2.addAll(oWLNamedIndividualReference.getSameIndividuals());
        hashSet3.add(oWLNamedIndividualReference2);
        hashSet3.addAll(oWLNamedIndividualReference2.getSameIndividuals());
        for (OWLPropertyReference oWLPropertyReference2 : hashSet) {
            String string = oWLPropertyReference2.getURI();
            for (OWLNamedIndividualReference oWLNamedIndividualReference3 : hashSet2) {
                String string2 = oWLNamedIndividualReference3.getURI();
                for (OWLNamedIndividualReference oWLNamedIndividualReference4 : hashSet3) {
                    String string3 = oWLNamedIndividualReference4.getURI();
                    this.defineOWLObjectPropertyAssertionAxiom(string, string2, string3);
                }
            }
        }
    }

    @Override
    public void generateOWLClassPropertyAssertionAxiom(OWLClassPropertyAssertionAxiomReference oWLClassPropertyAssertionAxiomReference) throws TargetSWRLRuleEngineException {
        OWLPropertyReference oWLPropertyReference = oWLClassPropertyAssertionAxiomReference.getProperty();
        HashSet<OWLPropertyReference> hashSet = new HashSet<OWLPropertyReference>();
        OWLNamedIndividualReference oWLNamedIndividualReference = oWLClassPropertyAssertionAxiomReference.getSubject();
        OWLClassReference oWLClassReference = oWLClassPropertyAssertionAxiomReference.getObject();
        HashSet<OWLNamedIndividualReference> hashSet2 = new HashSet<OWLNamedIndividualReference>();
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet.add(oWLPropertyReference);
        this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getTypes(), hashSet);
        hashSet2.add(oWLNamedIndividualReference);
        hashSet2.addAll(oWLNamedIndividualReference.getSameIndividuals());
        hashSet3.add(oWLClassReference.getURI());
        for (OWLPropertyReference oWLPropertyReference2 : hashSet) {
            String string = oWLPropertyReference2.getURI();
            for (OWLNamedIndividualReference oWLNamedIndividualReference2 : hashSet2) {
                String string2 = oWLNamedIndividualReference2.getURI();
                for (String string3 : hashSet3) {
                    this.defineOWLClassPropertyAssertion(string, string2, string3);
                }
            }
        }
    }

    @Override
    public void generateOWLPropertyPropertyAssertionAxiom(OWLPropertyPropertyAssertionAxiomReference oWLPropertyPropertyAssertionAxiomReference) throws TargetSWRLRuleEngineException {
        OWLPropertyReference oWLPropertyReference = oWLPropertyPropertyAssertionAxiomReference.getProperty();
        HashSet<OWLPropertyReference> hashSet = new HashSet<OWLPropertyReference>();
        OWLNamedIndividualReference oWLNamedIndividualReference = oWLPropertyPropertyAssertionAxiomReference.getSubject();
        OWLPropertyReference oWLPropertyReference2 = oWLPropertyPropertyAssertionAxiomReference.getObject();
        HashSet<OWLNamedIndividualReference> hashSet2 = new HashSet<OWLNamedIndividualReference>();
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet.add(oWLPropertyReference);
        this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getTypes(), hashSet);
        hashSet2.add(oWLNamedIndividualReference);
        hashSet2.addAll(oWLNamedIndividualReference.getSameIndividuals());
        hashSet3.add(oWLPropertyReference2.getURI());
        for (OWLPropertyReference oWLPropertyReference3 : hashSet) {
            String string = oWLPropertyReference3.getURI();
            for (OWLNamedIndividualReference oWLNamedIndividualReference2 : hashSet2) {
                String string2 = oWLNamedIndividualReference2.getURI();
                for (String string3 : hashSet3) {
                    this.defineOWLPropertyPropertyAssertion(string, string2, string3);
                }
            }
        }
    }

    @Override
    public void generateOWLSameIndividualAxiom(OWLSameIndividualAxiomReference oWLSameIndividualAxiomReference) throws TargetSWRLRuleEngineException {
        String string = oWLSameIndividualAxiomReference.getIndividual1().getURI();
        String string2 = oWLSameIndividualAxiomReference.getIndividual2().getURI();
        this.defineOWLSameIndividualAxiom(string, string2);
        this.defineOWLSameIndividualAxiom(string2, string);
        this.defineOWLSameIndividualAxiom(string, string);
    }

    @Override
    public void generateOWLDifferentIndividualsAxiom(OWLDifferentIndividualsAxiomReference oWLDifferentIndividualsAxiomReference) throws TargetSWRLRuleEngineException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OWLNamedIndividualReference oWLNamedIndividualReference : oWLDifferentIndividualsAxiomReference.getIndividuals()) {
            String string = oWLNamedIndividualReference.getURI();
            for (String string2 : arrayList) {
                this.defineOWLDifferentIndividualsAxiom(string, string2);
                this.defineOWLDifferentIndividualsAxiom(string2, string);
            }
            arrayList.add(string);
        }
    }

    @Override
    public void generateOWLDeclarationAxiom(OWLDeclarationAxiomReference oWLDeclarationAxiomReference) throws TargetSWRLRuleEngineException {
        OWLEntityReference oWLEntityReference = oWLDeclarationAxiomReference.getEntity();
        if (oWLEntityReference instanceof OWLClassReference) {
            this.generateOWLClassDeclaration((OWLClassReference)oWLEntityReference);
        } else if (oWLEntityReference instanceof OWLPropertyReference) {
            this.generateOWLPropertyDeclaration((OWLPropertyReference)oWLEntityReference);
        } else if (oWLEntityReference instanceof OWLNamedIndividualReference) {
            this.generateOWLIndividualDeclaration((OWLNamedIndividualReference)oWLEntityReference);
        } else {
            throw new TargetSWRLRuleEngineException("OWL declaration axiom with entity " + oWLEntityReference.getClass() + " not supported");
        }
    }

    @Override
    public void generateOWLSubclassAxiom(OWLSubClassAxiomReference oWLSubClassAxiomReference) throws TargetSWRLRuleEngineException {
        OWLClassReference oWLClassReference = oWLSubClassAxiomReference.getSubClass();
        OWLClassReference oWLClassReference2 = oWLSubClassAxiomReference.getSuperClass();
        this.generateOWLClassDeclaration(oWLClassReference);
        this.generateOWLClassDeclaration(oWLClassReference2);
    }

    private void calculateTransitiveSuperAndEquivalentClassClosure(Set<OWLClassReference> set, Set<OWLClassReference> set2) {
        for (OWLClassReference oWLClassReference : set) {
            if (set2.contains(oWLClassReference)) continue;
            set2.add(oWLClassReference);
            this.calculateTransitiveSuperAndEquivalentClassClosure(oWLClassReference.getSuperClasses(), set2);
            this.calculateTransitiveSuperAndEquivalentClassClosure(oWLClassReference.getEquivalentClasses(), set2);
        }
    }

    private void calculateTransitiveSuperAndEquivalentPropertyClosure(Set<OWLPropertyReference> set, Set<OWLPropertyReference> set2) {
        for (OWLPropertyReference oWLPropertyReference : set) {
            if (set2.contains(oWLPropertyReference)) continue;
            set2.add(oWLPropertyReference);
            this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getSuperProperties(), set2);
            this.calculateTransitiveSuperAndEquivalentPropertyClosure(oWLPropertyReference.getEquivalentProperties(), set2);
        }
    }
}

