/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.OWLSystemFrames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLBuiltin;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLSystemFrames
extends OWLSystemFrames {
    private static final Logger log = Log.getLogger(SWRLSystemFrames.class);
    private OWLNamedClass atomListCls;
    private OWLNamedClass builtinAtomCls;
    private OWLNamedClass classAtomCls;
    private OWLNamedClass dataRangeAtomCls;
    private OWLNamedClass dataValuedPropertyAtomCls;
    private OWLNamedClass differentIndividualsAtomCls;
    private OWLNamedClass impCls;
    private OWLNamedClass individualPropertyAtomCls;
    private OWLNamedClass sameIndividualAtomCls;
    private OWLNamedClass atomCls;
    private OWLNamedClass variableCls;
    private OWLNamedClass builtInCls;
    private OWLObjectProperty bodyProperty;
    private OWLObjectProperty headProperty;
    private OWLObjectProperty argumentsProperty;
    private OWLObjectProperty builtInProperty;
    private OWLObjectProperty argument1Property;
    private OWLObjectProperty classPredicateProperty;
    private OWLObjectProperty propertyPredicateProperty;
    private OWLObjectProperty dataRangeProperty;
    private OWLDatatypeProperty argsProperty;
    private OWLDatatypeProperty minArgsProperty;
    private OWLDatatypeProperty maxArgsProperty;
    private RDFProperty argument2Property;
    private List<SWRLBuiltin> coreSWRLBuiltIns;

    public SWRLSystemFrames(OWLModel oWLModel) {
        super(oWLModel);
        this.createSWRLMetaModel();
    }

    private void createSWRLMetaModel() {
        this.createSWRLClasses();
        this.createSWRLObjectProperties();
        this.createSWRLDatatypeProperties();
        this.createSWRLBuiltIns();
        this.argument2Property = this.createRDFProperty(SWRLNames.Slot.ARGUMENT2);
    }

    private void createSWRLClasses() {
        this.impCls = this.createOWLNamedClass(SWRLNames.Cls.IMP);
        this.variableCls = this.createOWLNamedClass(SWRLNames.Cls.VARIABLE);
        this.builtInCls = this.createOWLNamedClass(SWRLNames.Cls.BUILTIN);
        this.atomListCls = this.createOWLNamedClass(SWRLNames.Cls.ATOM_LIST);
        this.atomCls = this.createOWLNamedClass(SWRLNames.Cls.ATOM);
        this.classAtomCls = this.createOWLNamedClass(SWRLNames.Cls.CLASS_ATOM);
        this.builtinAtomCls = this.createOWLNamedClass(SWRLNames.Cls.BUILTIN_ATOM);
        this.dataRangeAtomCls = this.createOWLNamedClass(SWRLNames.Cls.DATA_RANGE_ATOM);
        this.dataValuedPropertyAtomCls = this.createOWLNamedClass(SWRLNames.Cls.DATAVALUED_PROPERTY_ATOM);
        this.differentIndividualsAtomCls = this.createOWLNamedClass(SWRLNames.Cls.DIFFERENT_INDIVIDUALS_ATOM);
        this.individualPropertyAtomCls = this.createOWLNamedClass(SWRLNames.Cls.INDIVIDUAL_PROPERTY_ATOM);
        this.sameIndividualAtomCls = this.createOWLNamedClass(SWRLNames.Cls.SAME_INDIVIDUAL_ATOM);
    }

    private void createSWRLObjectProperties() {
        this.bodyProperty = this.createOWLObjectProperty(SWRLNames.Slot.BODY);
        this.headProperty = this.createOWLObjectProperty(SWRLNames.Slot.HEAD);
        this.argumentsProperty = this.createOWLObjectProperty(SWRLNames.Slot.ARGUMENTS);
        this.builtInProperty = this.createOWLObjectProperty(SWRLNames.Slot.BUILTIN);
        this.argument1Property = this.createOWLObjectProperty(SWRLNames.Slot.ARGUMENT1);
        this.classPredicateProperty = this.createOWLObjectProperty(SWRLNames.Slot.CLASS_PREDICATE);
        this.propertyPredicateProperty = this.createOWLObjectProperty(SWRLNames.Slot.PROPERTY_PREDICATE);
        this.dataRangeProperty = this.createOWLObjectProperty(SWRLNames.Slot.DATA_RANGE);
    }

    private void createSWRLDatatypeProperties() {
        this.argsProperty = this.createOWLDatatypeProperty(SWRLNames.Slot.ARGS);
        this.minArgsProperty = this.createOWLDatatypeProperty(SWRLNames.Slot.MIN_ARGS);
        this.maxArgsProperty = this.createOWLDatatypeProperty(SWRLNames.Slot.MAX_ARGS);
    }

    private void createSWRLBuiltIns() {
        this.coreSWRLBuiltIns = new ArrayList<SWRLBuiltin>();
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.EQUAL);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.NOT_EQUAL);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.LESS_THAN);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.LESS_THAN_OR_EQUAL);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.GREATER_THAN);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.GREATER_THAN_OR_EQUAL);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.MULTIPLY);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DIVIDE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.INTEGER_DIVIDE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.MOD);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.POW);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.UNARY_PLUS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.UNARY_MINUS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ABS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.CEILING);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.FLOOR);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ROUND);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ROUND_HALF_TO_EVEN);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SIN);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.COS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.TAN);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.BOOLEAN_NOT);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.STRING_EQUAL_IGNORE_CASE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.STRING_CONCAT);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBSTRING);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.STRING_LENGTH);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.NORMALIZE_SPACE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.UPPER_CASE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.LOWER_CASE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.TRANSLATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.CONTAINS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.CONTAINS_IGNORE_CASE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.STARTS_WITH);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ENDS_WITH);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBSTRING_BEFORE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBSTRING_AFTER);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.MATCHES);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.REPLACE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.TOKENIZE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.YEAR_MONTH_DURATION);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DAY_TIME_DURATION);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DATETIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.TIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_YEAR_MONTH_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_YEAR_MONTH_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.MULTIPLY_YEAR_MONTH_DURATION);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DIVIDE_YEAR_MONTH_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_DAY_TIME_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DAY_TIME_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.MULTIPLY_DAY_TIME_DURATIONS);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.DIVIDE_DAY_TIME_DURATION);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DATES);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_TIMES);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_YEAR_MONTH_DURATION_TO_DATETIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_DAY_TIME_DURATION_TO_DATETIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_YEAR_MONTH_DURATION_FROM_DATETIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DAY_TIME_DURATION_FROM_DATETIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_YEAR_MONTH_DURATION_TO_DATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_DAY_TIME_DURATION_TO_DATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_YEAR_MONTH_DURATION_FROM_DATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DAY_TIME_DURATION_FROM_DATE);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.ADD_DAY_TIME_DURATION_TO_TIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DAY_TIME_DURATION_FROM_TIME);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DATETIMES_YIELDING_YEAR_MONTH_DURATION);
        this.createSWRLBuiltin(SWRLNames.CoreBuiltIns.SUBTRACT_DATETIMES_YIELDING_DAY_TIME_DURATION);
    }

    private SWRLBuiltin createSWRLBuiltin(String string) {
        FrameID frameID = new FrameID(string);
        DefaultSWRLBuiltin defaultSWRLBuiltin = new DefaultSWRLBuiltin(this.owlModel, frameID);
        this.coreSWRLBuiltIns.add(defaultSWRLBuiltin);
        this.addFrame(frameID, (Frame)defaultSWRLBuiltin);
        return defaultSWRLBuiltin;
    }

    @Override
    public void addSystemFrames(FrameStore frameStore) {
        long l = System.currentTimeMillis();
        super.addSystemFrames(frameStore);
        SWRLSystemFramesAssertions sWRLSystemFramesAssertions = new SWRLSystemFramesAssertions(frameStore);
        sWRLSystemFramesAssertions.addSWRLHierarchy();
        sWRLSystemFramesAssertions.addPropertyTypes();
        sWRLSystemFramesAssertions.addBuiltInTypes();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding SWRL + OWL system frames took " + (System.currentTimeMillis() - l) + "ms.");
        }
    }

    public OWLNamedClass getAtomListCls() {
        return this.atomListCls;
    }

    public OWLNamedClass getBuiltinAtomCls() {
        return this.builtinAtomCls;
    }

    public OWLNamedClass getClassAtomCls() {
        return this.classAtomCls;
    }

    public OWLNamedClass getDataRangeAtomCls() {
        return this.dataRangeAtomCls;
    }

    public OWLNamedClass getDataValuedPropertyAtomCls() {
        return this.dataValuedPropertyAtomCls;
    }

    public OWLNamedClass getDifferentIndividualsAtomCls() {
        return this.differentIndividualsAtomCls;
    }

    public OWLNamedClass getImpCls() {
        return this.impCls;
    }

    public OWLNamedClass getIndividualPropertyAtomCls() {
        return this.individualPropertyAtomCls;
    }

    public OWLNamedClass getSameIndividualAtomCls() {
        return this.sameIndividualAtomCls;
    }

    public OWLNamedClass getAtomCls() {
        return this.atomCls;
    }

    public OWLNamedClass getVariableCls() {
        return this.variableCls;
    }

    public OWLNamedClass getBuiltInCls() {
        return this.builtInCls;
    }

    public OWLObjectProperty getBodyProperty() {
        return this.bodyProperty;
    }

    public OWLObjectProperty getHeadProperty() {
        return this.headProperty;
    }

    public OWLObjectProperty getArgumentsProperty() {
        return this.argumentsProperty;
    }

    public OWLObjectProperty getBuiltInProperty() {
        return this.builtInProperty;
    }

    public OWLObjectProperty getArgument1Property() {
        return this.argument1Property;
    }

    public OWLObjectProperty getClassPredicateProperty() {
        return this.classPredicateProperty;
    }

    public OWLObjectProperty getPropertyPredicateProperty() {
        return this.propertyPredicateProperty;
    }

    public OWLObjectProperty getDataRangeProperty() {
        return this.dataRangeProperty;
    }

    public OWLDatatypeProperty getArgsProperty() {
        return this.argsProperty;
    }

    public OWLDatatypeProperty getMinArgsProperty() {
        return this.minArgsProperty;
    }

    public OWLDatatypeProperty getMaxArgsProperty() {
        return this.maxArgsProperty;
    }

    public List<SWRLBuiltin> getCoreSWRLBuiltIns() {
        return this.coreSWRLBuiltIns;
    }

    public RDFProperty getArgument2Property() {
        return this.argument2Property;
    }

    protected class SWRLSystemFramesAssertions
    extends OWLSystemFrames.SystemFramesAsserter {
        public SWRLSystemFramesAssertions(FrameStore frameStore) {
            super(frameStore);
        }

        public void addSWRLHierarchy() {
            this.fs.addDirectSuperclass((Cls)SWRLSystemFrames.this.impCls, (Cls)SWRLSystemFrames.this.getRootCls());
            this.assertTypeAndSubclasses(SWRLSystemFrames.this.impCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]);
            this.fs.addDirectSuperclass((Cls)SWRLSystemFrames.this.variableCls, (Cls)SWRLSystemFrames.this.getRootCls());
            this.assertTypeAndSubclasses(SWRLSystemFrames.this.variableCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]);
            this.fs.addDirectSuperclass((Cls)SWRLSystemFrames.this.builtInCls, (Cls)SWRLSystemFrames.this.getRootCls());
            this.assertTypeAndSubclasses(SWRLSystemFrames.this.builtInCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]);
            this.fs.addDirectSuperclass((Cls)SWRLSystemFrames.this.atomListCls, (Cls)SWRLSystemFrames.this.getRdfListClass());
            this.assertTypeAndSubclasses(SWRLSystemFrames.this.atomListCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]);
            this.fs.addDirectSuperclass((Cls)SWRLSystemFrames.this.atomCls, (Cls)SWRLSystemFrames.this.getRootCls());
            this.assertTypeAndSubclasses(SWRLSystemFrames.this.atomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[]{this.assertTypeAndSubclasses(SWRLSystemFrames.this.classAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.builtinAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.dataRangeAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.dataValuedPropertyAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.differentIndividualsAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.individualPropertyAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0]), this.assertTypeAndSubclasses(SWRLSystemFrames.this.sameIndividualAtomCls, SWRLSystemFrames.this.getOwlNamedClassClass(), new Cls[0])});
        }

        public void addPropertyTypes() {
            this.assertTypeAndName(SWRLSystemFrames.this.bodyProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.bodyProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.headProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.headProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.argumentsProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.argumentsProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.builtInProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.builtInProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.argument1Property, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.argument1Property);
            this.assertTypeAndName(SWRLSystemFrames.this.classPredicateProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.classPredicateProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.propertyPredicateProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.propertyPredicateProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.dataRangeProperty, SWRLSystemFrames.this.getOwlObjectPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.dataRangeProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.argsProperty, SWRLSystemFrames.this.getOwlDatatypePropertyClass());
            this.assertDomain(SWRLSystemFrames.this.argsProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.minArgsProperty, SWRLSystemFrames.this.getOwlDatatypePropertyClass());
            this.assertDomain(SWRLSystemFrames.this.minArgsProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.maxArgsProperty, SWRLSystemFrames.this.getOwlDatatypePropertyClass());
            this.assertDomain(SWRLSystemFrames.this.maxArgsProperty);
            this.assertTypeAndName(SWRLSystemFrames.this.argument2Property, SWRLSystemFrames.this.getRdfPropertyClass());
            this.assertDomain(SWRLSystemFrames.this.argument2Property);
        }

        public void addBuiltInTypes() {
            for (SWRLBuiltin sWRLBuiltin : SWRLSystemFrames.this.coreSWRLBuiltIns) {
                this.assertTypeAndName(sWRLBuiltin, SWRLSystemFrames.this.getBuiltInCls());
            }
        }
    }
}

