/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.storage.KnowledgeBaseCopier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWL2OWLCopier
extends KnowledgeBaseCopier {
    public static final transient Logger log = Log.getLogger(OWL2OWLCopier.class);
    private OWLModel source;
    private OWLModel target;

    public OWL2OWLCopier(OWLModel oWLModel, OWLModel oWLModel2) {
        super(oWLModel, oWLModel2);
        this.source = oWLModel;
        this.target = oWLModel2;
        this.doneSlots.add(RDFNames.Slot.TYPE);
        this.doneSlots.add(OWLNames.Slot.ONTOLOGY_PREFIXES);
    }

    public void run() {
        this.copyNamespaces();
        super.run();
    }

    private void copyNamespaces() {
        OWLUtil.renameOntology(this.target, this.target.getDefaultOWLOntology(), this.source.getDefaultOWLOntology().getName());
        NamespaceManager namespaceManager = this.source.getNamespaceManager();
        NamespaceManager namespaceManager2 = this.target.getNamespaceManager();
        for (String string : new ArrayList<String>(namespaceManager2.getPrefixes())) {
            if (!namespaceManager2.isModifiable(string)) continue;
            namespaceManager2.removePrefix(string);
        }
        for (String string : namespaceManager.getPrefixes()) {
            if (!namespaceManager2.isModifiable(string)) continue;
            namespaceManager2.setPrefix(namespaceManager.getNamespaceForPrefix(string), string);
        }
    }

    protected void createClses() {
        for (OWLNamedClass oWLNamedClass : this.source.getUserDefinedOWLNamedClasses()) {
            this.getNewCls(oWLNamedClass);
        }
        super.createClses();
    }

    protected void createFacetOverrides(Cls cls) {
        if (cls instanceof OWLRestriction) {
            super.createFacetOverrides(cls);
        }
    }

    protected Instance getNewInstance(Instance instance) {
        if (instance instanceof OWLOntology && instance.equals(this.source.getDefaultOWLOntology())) {
            return this.target.getDefaultOWLOntology();
        }
        return super.getNewInstance(instance);
    }

    protected void setInitialOwnSlotValues(Instance instance) {
        if (instance instanceof OWLRestriction) {
            OWLRestriction oWLRestriction = (OWLRestriction)instance;
            OWLRestriction oWLRestriction2 = (OWLRestriction)this.getNewInstance(oWLRestriction);
            this.createFacetOverrides(oWLRestriction);
            if (log.isLoggable(Level.FINE)) {
                log.fine("+ Initialized OWLRestriction " + oWLRestriction2.getBrowserText());
            }
        }
    }
}

