/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.server.triplestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.narrowframestore.RemoteClientInvocationHandler;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.UnmodifiableNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleStoreImpl;
import edu.stanford.smi.protegex.owl.server.triplestore.GetPackage;
import edu.stanford.smi.protegex.owl.server.triplestore.Package;
import edu.stanford.smi.protegex.owl.util.OWLFrameStoreUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTripleStoreModel
implements TripleStoreModel {
    private OWLModel owlModel;
    private Map<String, TripleStore> tripleStores = new LinkedHashMap<String, TripleStore>();
    private String activeTripleStoreName;
    private String systemTripleStoreName;

    public ClientTripleStoreModel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.initialize();
    }

    private void initialize() {
        this.initialize(this.getRemoteSession());
    }

    private RemoteSession getRemoteSession() {
        RemoteClientFrameStore remoteClientFrameStore = (RemoteClientFrameStore)this.owlModel.getFrameStoreManager().getFrameStoreFromClass(RemoteClientFrameStore.class);
        return remoteClientFrameStore.getSession();
    }

    private void initialize(RemoteSession remoteSession) {
        Package package_ = (Package)new GetPackage(this.owlModel).execute();
        this.activeTripleStoreName = package_.getActiveTripleStore();
        this.systemTripleStoreName = package_.getSystemTripleStore();
        for (int i = 0; i < package_.getFrameStores().size(); ++i) {
            RemoteServerNarrowFrameStore remoteServerNarrowFrameStore = package_.getFrameStores().get(i);
            NamespaceManager namespaceManager = package_.getNamespaceManagers().get(i);
            namespaceManager = new UnmodifiableNamespaceManager(namespaceManager);
            String string = package_.getTripleStoreNames().get(i);
            NarrowFrameStore narrowFrameStore = new RemoteClientInvocationHandler((KnowledgeBase)this.owlModel, remoteServerNarrowFrameStore, remoteSession).getNarrowFrameStore();
            TripleStoreImpl tripleStoreImpl = new TripleStoreImpl(this.owlModel, narrowFrameStore, this, namespaceManager, string);
            this.tripleStores.put(string, tripleStoreImpl);
        }
    }

    @Override
    public TripleStore createActiveImportedTripleStore(NarrowFrameStore narrowFrameStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteTripleStore(TripleStore tripleStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
    }

    @Override
    public TripleStore getActiveTripleStore() {
        return this.tripleStores.get(this.activeTripleStoreName);
    }

    @Override
    public TripleStore getHomeTripleStore(RDFResource rDFResource) {
        return this.getActiveTripleStore();
    }

    @Override
    public TripleStore getHomeTripleStore(Instance instance, Slot slot, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection getPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty) {
        Collection collection = this.owlModel.getOwnSlotValues((Frame)rDFResource, rDFProperty);
        return OWLFrameStoreUtils.convertValueListToRDFLiterals(this.owlModel, collection);
    }

    @Override
    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.owlModel.getOwnSlotValues((Frame)instance, slot);
    }

    @Override
    public TripleStore getSystemTripleStore() {
        return this.tripleStores.get(this.systemTripleStoreName);
    }

    @Override
    public TripleStore getTopTripleStore() {
        return this.getActiveTripleStore();
    }

    @Override
    public TripleStore getTripleStore(String string) {
        return this.tripleStores.get(string);
    }

    @Override
    public TripleStore getTripleStoreByDefaultNamespace(String string) {
        return this.tripleStores.get(string);
    }

    @Override
    public List<TripleStore> getTripleStores() {
        return new ArrayList<TripleStore>(this.tripleStores.values());
    }

    @Override
    public boolean isActiveTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.getActiveTripleStore().contains(rDFResource, rDFProperty, object);
    }

    @Override
    public boolean isEditableTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.isActiveTriple(rDFResource, rDFProperty, object);
    }

    @Override
    public boolean isEditableTripleStore(TripleStore tripleStore) {
        return tripleStore.equals(this.getActiveTripleStore());
    }

    @Override
    public Iterator<RDFResource> listSubjects(RDFProperty rDFProperty) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Triple> listTriplesWithSubject(RDFResource rDFResource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<TripleStore> listUserTripleStores() {
        List<TripleStore> list = this.getTripleStores();
        Iterator<TripleStore> iterator = list.iterator();
        iterator.next();
        if (list.size() > 1 && list.get(1).getName() == null) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void replaceJavaObject(RDFResource rDFResource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveTripleStore(TripleStore tripleStore) {
        this.activeTripleStoreName = tripleStore.getName();
    }

    @Override
    public void setHomeTripleStore(RDFResource rDFResource, TripleStore tripleStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTopTripleStore(TripleStore tripleStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewActiveOnly(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateEditableResourceState() {
    }
}

