/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.server;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.server.OwlState;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OwlStateMachine
implements ServerCacheStateMachine {
    private static transient Logger log = Log.getLogger(OwlStateMachine.class);
    private FrameStore fs;
    private final OWLModel kb;
    private Map<StateAndSlot, OwlState> transitionMap = new HashMap<StateAndSlot, OwlState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OwlStateMachine(FrameStore frameStore, OWLModel oWLModel) {
        this.fs = frameStore;
        this.kb = oWLModel;
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        OWLModel oWLModel2 = oWLModel;
        synchronized (oWLModel2) {
            this.addTransition(OwlState.Start, sWRLSystemFrames.getDirectSuperclassesSlot(), OwlState.OwlExpr);
            this.addTransition(OwlState.Start, sWRLSystemFrames.getOwlEquivalentClassProperty(), OwlState.OwlExpr);
            this.addTransition(OwlState.OwlExpr, sWRLSystemFrames.getOwlIntersectionOfProperty(), OwlState.RDFList);
            this.addTransition(OwlState.OwlExpr, sWRLSystemFrames.getDirectSuperclassesSlot(), OwlState.End);
            this.addTransition(OwlState.OwlExpr, sWRLSystemFrames.getOwlSomeValuesFromProperty(), OwlState.End);
            this.addTransition(OwlState.RDFList, sWRLSystemFrames.getRdfRestProperty(), OwlState.RDFList);
            this.addTransition(OwlState.RDFList, sWRLSystemFrames.getRdfFirstProperty(), OwlState.OwlExpr);
            this.addTransition(OwlState.Start, sWRLSystemFrames.getDirectInstancesSlot(), OwlState.UserIndividual);
        }
    }

    private void addTransition(OwlState owlState, Slot slot, OwlState owlState2) {
        block2: {
            try {
                this.transitionMap.put(new StateAndSlot(owlState, slot), owlState2);
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.fine("Exception caught creating transition " + (Object)((Object)owlState) + ", " + slot.getFrameID().getName() + " -> " + (Object)((Object)owlState2) + ": " + exception);
                log.log(Level.FINER, "Exception = ", exception);
            }
        }
    }

    public ServerCachedState getInitialState() {
        return OwlState.Start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OwlState nextState(ServerCachedState serverCachedState, Frame frame, Slot slot, Frame frame2) {
        if (!(serverCachedState instanceof OwlState)) {
            return null;
        }
        OwlState owlState = this.transitionMap.get(new StateAndSlot((OwlState)serverCachedState, slot));
        OWLModel oWLModel = this.kb;
        synchronized (oWLModel) {
            if (owlState != null && OwlState.allowTransition(this.fs, (OwlState)serverCachedState, frame, owlState, frame2)) {
                return owlState;
            }
        }
        return null;
    }

    private class StateAndSlot {
        private OwlState state;
        private Slot slot;

        public Slot getSlot() {
            return this.slot;
        }

        public OwlState getState() {
            return this.state;
        }

        public StateAndSlot(OwlState owlState, Slot slot) {
            this.state = owlState;
            this.slot = slot;
        }

        public int hashCode() {
            return this.state.ordinal() + this.slot.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof StateAndSlot)) {
                return false;
            }
            StateAndSlot stateAndSlot = (StateAndSlot)object;
            return stateAndSlot.state.equals((Object)this.state) && stateAndSlot.slot.equals(this.slot);
        }
    }
}

