/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLBaseExtractor {
    private InputStream is;
    private URI xmlBase;
    private String rootElementName;
    private String defaultNamespace;

    public XMLBaseExtractor(InputStream inputStream) {
        this.is = inputStream;
        this.xmlBase = null;
    }

    public static URI getXMLBase(InputStream inputStream) {
        XMLBaseExtractor xMLBaseExtractor = new XMLBaseExtractor(inputStream);
        return xMLBaseExtractor.getXMLBase();
    }

    public static URI getXMLBase(String string) throws MalformedURLException, OntologyLoadException {
        URI uRI = URIUtilities.createURI((String)string);
        InputStream inputStream = ProtegeOWLParser.getInputStream(uRI.toURL());
        return XMLBaseExtractor.getXMLBase(inputStream);
    }

    public URI getXMLBase() {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler((ContentHandler)new MyHandler());
        try {
            sAXParser.parse(new InputSource(this.is));
        }
        catch (Throwable throwable) {
            Log.emptyCatchBlock((Throwable)throwable);
        }
        return this.xmlBase;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private class MyHandler
    implements ContentHandler {
        private boolean startElement;

        private MyHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            if (string == null || string.equals("")) {
                XMLBaseExtractor.this.defaultNamespace = string2;
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.startElement) {
                XMLBaseExtractor.this.rootElementName = string3;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("xml:base")) continue;
                    URI uRI = null;
                    try {
                        uRI = new URI(FactoryUtils.adjustOntologyName(attributes.getValue(i)));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
                    }
                    XMLBaseExtractor.this.xmlBase = uRI;
                }
            } else {
                throw new SAXException("No xml:base");
            }
            this.startElement = true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    }
}

