/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class RepositoryUtil {
    private static final transient Logger log = Log.getLogger(RepositoryUtil.class);
    public static final String FORCE_READ_ONLY_FLAG = "forceReadOnly";

    public static boolean isForcedToBeReadOnly(String string) {
        return RepositoryUtil.getBooleanProperty(FORCE_READ_ONLY_FLAG, string);
    }

    public static boolean getBooleanProperty(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string3.substring(0, string3.indexOf(61));
                String string5 = string3.substring(string3.indexOf(61) + 1, string3.length());
                if (!string4.equals(string)) continue;
                return Boolean.valueOf(string5);
            }
        }
        return false;
    }

    public static boolean createImportLocalCopy(OWLModel oWLModel, URI uRI, File file) throws OntologyLoadException {
        Repository repository = oWLModel.getRepositoryManager().getRepository(uRI);
        if (repository != null && repository instanceof AbstractStreamBasedRepositoryImpl) {
            InputStream inputStream = ((AbstractStreamBasedRepositoryImpl)repository).getInputStream(uRI);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string;
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                while ((string = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string);
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OntologyLoadException((Throwable)fileNotFoundException, "Could not find file " + file);
            }
            catch (IOException iOException) {
                throw new OntologyLoadException((Throwable)iOException, "Could not load file " + file);
            }
            oWLModel.getRepositoryManager().addProjectRepository(0, new LocalFileRepository(file));
            return true;
        }
        if (repository != null) {
            log.warning("Can't write non-stream based repositories yet (though it wouldn't be hard to fix this)");
        }
        return false;
    }

    public static boolean isDublinCoreRedirectedToDLVersion(RepositoryManager repositoryManager) {
        Iterator<Repository> iterator = repositoryManager.getProjectRepositories().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof DublinCoreDLVersionRedirectRepository)) continue;
            return true;
        }
        return false;
    }

    public static void setDublinCoreRedirectedToDLVersion(RepositoryManager repositoryManager, boolean bl) {
        block2: {
            block1: {
                if (!bl) break block1;
                if (RepositoryUtil.isDublinCoreRedirectedToDLVersion(repositoryManager)) break block2;
                repositoryManager.addProjectRepository(0, new DublinCoreDLVersionRedirectRepository());
                break block2;
            }
            for (Repository repository : repositoryManager.getProjectRepositories()) {
                if (!(repository instanceof DublinCoreDLVersionRedirectRepository)) continue;
                repositoryManager.remove(repository);
                break;
            }
        }
    }

    public static URI getURI(URL uRL, String string) throws MalformedURLException, URISyntaxException {
        return new URI(new URL(uRL, string).toString());
    }

    public static File getRepositoryFileFromRelativePath(OWLModel oWLModel, String string) {
        File file = null;
        try {
            Object object;
            URI uRI = oWLModel.getProject().getProjectURI();
            if (uRI == null && oWLModel.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                object = JenaKnowledgeBaseFactory.getOWLFilePath(oWLModel.getProject().getSources());
                uRI = URIUtilities.createURI((String)object);
            }
            if (uRI == null) {
                return null;
            }
            object = new URL(uRI.toURL(), RepositoryUtil.stripQuery(string.trim()));
            file = new File(((URL)object).toURI());
            if (!file.canRead()) break block6;
            if (file.isFile()) {
                return file;
            }
        }
        finally {
            return null;
        }
        {
            block6: {
            }
        }
    }

    public static String stripQuery(String string) {
        int n = string.indexOf(63);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void loadProjectRepositoriesFromURI(OWLModel oWLModel, URI uRI, boolean bl) {
        RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
        if (bl) {
            repositoryManager.removeAllProjectRepositories();
        }
        try {
            String string;
            URL uRL = new URL(uRI.toString());
            InputStream inputStream = ProtegeOWLParser.getInputStream(uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                RepositoryFactory repositoryFactory;
                Repository repository;
                if ((string = string.trim()).length() <= 0 || (repository = (repositoryFactory = RepositoryFactory.getInstance()).createOntRepository(oWLModel, string)) == null) continue;
                repositoryManager.addProjectRepository(repository);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.getLogger().warning("[Repository Manager] Could not find repository file: " + uRI.toString());
        }
        catch (OntologyLoadException ontologyLoadException) {
            Log.getLogger().warning("[Repository Manager] Could not find repository file: " + uRI.toString());
        }
    }
}

