/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.repository.util.InputStreamSource;
import edu.stanford.smi.protegex.owl.repository.util.XMLBaseExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OntologyNameExtractor {
    private static Logger log = Log.getLogger(OntologyNameExtractor.class);
    private InputStreamSource source;
    private URI uri;
    private boolean valid = true;

    public OntologyNameExtractor(InputStreamSource inputStreamSource) throws IOException {
        try {
            this.source = inputStreamSource;
            this.init();
        }
        catch (Throwable throwable) {
            IOException iOException = new IOException(throwable.getMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    private void init() {
        this.searchForOntologyDeclaration();
        if (this.uri == null && this.valid) {
            this.searchForXMLBaseDeclaration();
        }
        if (this.uri == null && this.valid) {
            this.useDocumentLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForOntologyDeclaration() {
        ARP aRP = new ARP();
        ARPHandlers aRPHandlers = aRP.getHandlers();
        aRPHandlers.setStatementHandler(new StatementHandler(){

            public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            }

            public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
                if (aResource2.getURI().equals(RDFNames.Slot.TYPE) && aResource3.getURI().equals(OWLNames.Cls.ONTOLOGY)) {
                    OntologyNameExtractor.this.uri = URI.create(aResource.getURI());
                    throw new OntologyDeclarationFoundException();
                }
            }
        });
        aRPHandlers.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                OntologyNameExtractor.this.valid = false;
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                OntologyNameExtractor.this.valid = false;
            }
        });
        InputStream inputStream = null;
        try {
            inputStream = this.source.getInputStream();
            aRP.load(inputStream);
        }
        catch (OntologyDeclarationFoundException ontologyDeclarationFoundException) {
        }
        catch (Throwable throwable) {
            log.log(Level.WARNING, "Exception caught trying to parse " + this.source.getURL() + " for an ontology declaration", throwable);
            this.valid = false;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Exception found closing ontology", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForXMLBaseDeclaration() {
        InputStream inputStream = null;
        try {
            inputStream = this.source.getInputStream();
            this.uri = XMLBaseExtractor.getXMLBase(inputStream);
        }
        catch (Throwable throwable) {
            this.valid = false;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Exception found closing ontology", iOException);
            }
        }
    }

    private void useDocumentLocation() {
        String string = "Could not find name for ontology.  Even the document location didn't work";
        try {
            this.uri = this.source.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            log.log(Level.WARNING, string, uRISyntaxException);
            return;
        }
    }

    public boolean isPossiblyValidOntology() {
        return this.valid;
    }

    public URI getOntologyName() throws IOException {
        return this.uri;
    }

    public static class OntologyDeclarationFoundException
    extends RuntimeException {
    }
}

