/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class RelativeFileRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (oWLModel.getProject() != null) {
            Object object;
            URI uRI = oWLModel.getProject().getProjectURI();
            if (uRI == null && oWLModel.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                object = JenaKnowledgeBaseFactory.getOWLFilePath(oWLModel.getProject().getSources());
                uRI = URIUtilities.createURI((String)object);
            }
            if (uRI != null) {
                try {
                    object = new URI(string.trim());
                    if (!((URI)object).isAbsolute()) {
                        File file = RepositoryUtil.getRepositoryFileFromRelativePath(oWLModel, RepositoryUtil.stripQuery(string));
                        return file != null;
                    }
                    return false;
                }
                catch (URISyntaxException uRISyntaxException) {
                    return false;
                }
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        Object object;
        URI uRI = oWLModel.getProject().getProjectURI();
        if (uRI == null && oWLModel.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
            object = JenaKnowledgeBaseFactory.getOWLFilePath(oWLModel.getProject().getSources());
            uRI = URIUtilities.createURI((String)object);
        }
        if (uRI == null) {
            return null;
        }
        object = RepositoryUtil.getRepositoryFileFromRelativePath(oWLModel, string);
        if (object != null) {
            try {
                return new RelativeFileRepository((File)object, uRI.toURL(), string.trim());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }
}

