/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class RelativeFileRepository
extends LocalFileRepository {
    private String relativeURL;

    public RelativeFileRepository(File file, URL uRL, String string) throws MalformedURLException, URISyntaxException {
        super(file, RepositoryUtil.isForcedToBeReadOnly(RepositoryUtil.getURI(uRL, string).getQuery()));
        this.relativeURL = RepositoryUtil.stripQuery(string);
    }

    public RelativeFileRepository(File file, String string, boolean bl) throws MalformedURLException, URISyntaxException {
        super(file, bl);
        this.relativeURL = RepositoryUtil.stripQuery(string);
    }

    public String getRepositoryDescriptor() {
        try {
            URI uRI = new URI(this.relativeURL);
            return uRI.toString() + "?" + "forceReadOnly" + "=" + this.isForceReadOnly();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    public String getRepositoryDescription() {
        return "Relative file URL: " + this.relativeURL + "  (" + this.getFile().toString() + ")";
    }
}

